/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.spec;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2;
import java.security.spec.AlgorithmParameterSpec;

public class McElieceCCA2KeyGenParameterSpec
implements AlgorithmParameterSpec {
    public static final String SHA1 = "SHA-1";
    public static final String SHA224 = "SHA-224";
    public static final String SHA256 = "SHA-256";
    public static final String SHA384 = "SHA-384";
    public static final String SHA512 = "SHA-512";
    public static final int DEFAULT_M = 11;
    public static final int DEFAULT_T = 50;
    private final int m;
    private final int t;
    private final int n;
    private int fieldPoly;
    private final String digest;

    public McElieceCCA2KeyGenParameterSpec() {
        this(11, 50, SHA256);
    }

    public McElieceCCA2KeyGenParameterSpec(int n3) {
        this(n3, SHA256);
    }

    public McElieceCCA2KeyGenParameterSpec(int n3, String string2) {
        if (n3 >= 1) {
            int n4 = 0;
            int n5 = 1;
            while (n5 < n3) {
                n5 <<= 1;
                ++n4;
            }
            this.t = (n5 >>> 1) / n4;
            this.m = n4;
            this.n = n5;
            this.fieldPoly = PolynomialRingGF2.getIrreduciblePolynomial(n4);
            this.digest = string2;
            return;
        }
        throw new IllegalArgumentException("key size must be positive");
    }

    public McElieceCCA2KeyGenParameterSpec(int n3, int n4) {
        this(n3, n4, SHA256);
    }

    public McElieceCCA2KeyGenParameterSpec(int n3, int n4, String string2) {
        if (n3 >= 1) {
            if (n3 <= 32) {
                int n5;
                McElieceCCA2KeyGenParameterSpec mcElieceCCA2KeyGenParameterSpec = this;
                mcElieceCCA2KeyGenParameterSpec.m = n3;
                mcElieceCCA2KeyGenParameterSpec.n = n5 = 1 << n3;
                if (n4 >= 0) {
                    if (n4 <= n5) {
                        this.t = n4;
                        this.fieldPoly = PolynomialRingGF2.getIrreduciblePolynomial(n3);
                        this.digest = string2;
                        return;
                    }
                    throw new IllegalArgumentException("t must be less than n = 2^m");
                }
                throw new IllegalArgumentException("t must be positive");
            }
            throw new IllegalArgumentException("m is too large");
        }
        throw new IllegalArgumentException("m must be positive");
    }

    public McElieceCCA2KeyGenParameterSpec(int n3, int n4, int n5) {
        this(n3, n4, n5, SHA256);
    }

    public McElieceCCA2KeyGenParameterSpec(int n3, int n4, int n5, String string2) {
        this.m = n3;
        if (n3 >= 1) {
            if (n3 <= 32) {
                int n6;
                McElieceCCA2KeyGenParameterSpec mcElieceCCA2KeyGenParameterSpec = this;
                mcElieceCCA2KeyGenParameterSpec.n = n6 = 1 << n3;
                mcElieceCCA2KeyGenParameterSpec.t = n4;
                if (n4 >= 0) {
                    if (n4 <= n6) {
                        if (PolynomialRingGF2.degree(n5) == n3 && PolynomialRingGF2.isIrreducible(n5)) {
                            McElieceCCA2KeyGenParameterSpec mcElieceCCA2KeyGenParameterSpec2 = this;
                            mcElieceCCA2KeyGenParameterSpec2.fieldPoly = n5;
                            mcElieceCCA2KeyGenParameterSpec2.digest = string2;
                            return;
                        }
                        throw new IllegalArgumentException("polynomial is not a field polynomial for GF(2^m)");
                    }
                    throw new IllegalArgumentException("t must be less than n = 2^m");
                }
                throw new IllegalArgumentException("t must be positive");
            }
            throw new IllegalArgumentException(" m is too large");
        }
        throw new IllegalArgumentException("m must be positive");
    }

    public int getM() {
        return this.m;
    }

    public int getN() {
        return this.n;
    }

    public int getT() {
        return this.t;
    }

    public int getFieldPoly() {
        return this.fieldPoly;
    }

    public String getDigest() {
        return this.digest;
    }
}

