/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.spec;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2;
import java.security.spec.AlgorithmParameterSpec;

public class McElieceKeyGenParameterSpec
implements AlgorithmParameterSpec {
    public static final int DEFAULT_M = 11;
    public static final int DEFAULT_T = 50;
    private int m;
    private int t;
    private int n;
    private int fieldPoly;

    public McElieceKeyGenParameterSpec() {
        this(11, 50);
    }

    public McElieceKeyGenParameterSpec(int n3) {
        if (n3 >= 1) {
            int n4;
            McElieceKeyGenParameterSpec mcElieceKeyGenParameterSpec = this;
            mcElieceKeyGenParameterSpec.m = 0;
            mcElieceKeyGenParameterSpec.n = 1;
            while ((n4 = this.n) < n3) {
                this.n = n4 << 1;
                ++this.m;
            }
            McElieceKeyGenParameterSpec mcElieceKeyGenParameterSpec2 = this;
            this.t = n3 = n4 >>> 1;
            int n5 = this.m;
            mcElieceKeyGenParameterSpec2.t = n3 / n5;
            mcElieceKeyGenParameterSpec2.fieldPoly = PolynomialRingGF2.getIrreduciblePolynomial(n5);
            return;
        }
        throw new IllegalArgumentException("key size must be positive");
    }

    public McElieceKeyGenParameterSpec(int n3, int n4) {
        if (n3 >= 1) {
            if (n3 <= 32) {
                int n5;
                McElieceKeyGenParameterSpec mcElieceKeyGenParameterSpec = this;
                mcElieceKeyGenParameterSpec.m = n3;
                mcElieceKeyGenParameterSpec.n = n5 = 1 << n3;
                if (n4 >= 0) {
                    if (n4 <= n5) {
                        this.t = n4;
                        this.fieldPoly = PolynomialRingGF2.getIrreduciblePolynomial(n3);
                        return;
                    }
                    throw new IllegalArgumentException("t must be less than n = 2^m");
                }
                throw new IllegalArgumentException("t must be positive");
            }
            throw new IllegalArgumentException("m is too large");
        }
        throw new IllegalArgumentException("m must be positive");
    }

    public McElieceKeyGenParameterSpec(int n3, int n4, int n5) {
        this.m = n3;
        if (n3 >= 1) {
            if (n3 <= 32) {
                int n6;
                McElieceKeyGenParameterSpec mcElieceKeyGenParameterSpec = this;
                mcElieceKeyGenParameterSpec.n = n6 = 1 << n3;
                mcElieceKeyGenParameterSpec.t = n4;
                if (n4 >= 0) {
                    if (n4 <= n6) {
                        if (PolynomialRingGF2.degree(n5) == n3 && PolynomialRingGF2.isIrreducible(n5)) {
                            this.fieldPoly = n5;
                            return;
                        }
                        throw new IllegalArgumentException("polynomial is not a field polynomial for GF(2^m)");
                    }
                    throw new IllegalArgumentException("t must be less than n = 2^m");
                }
                throw new IllegalArgumentException("t must be positive");
            }
            throw new IllegalArgumentException(" m is too large");
        }
        throw new IllegalArgumentException("m must be positive");
    }

    public int getM() {
        return this.m;
    }

    public int getN() {
        return this.n;
    }

    public int getT() {
        return this.t;
    }

    public int getFieldPoly() {
        return this.fieldPoly;
    }
}

