/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;

public final class BigEndianConversions {
    private BigEndianConversions() {
    }

    public static byte[] I2OSP(int n3) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray2[0] = (byte)(n3 >>> 24);
        byArray2[1] = (byte)(n3 >>> 16);
        byArray2[2] = (byte)(n3 >>> 8);
        byArray[3] = (byte)n3;
        return byArray;
    }

    public static byte[] I2OSP(int n3, int n4) {
        if (n3 < 0) {
            return null;
        }
        int n5 = IntegerFunctions.ceilLog256(n3);
        if (n5 <= n4) {
            int n6;
            byte[] byArray = new byte[n4];
            for (int i3 = n6 = (v1388354) - 1; i3 >= n4 - n5; --i3) {
                byArray[i3] = (byte)(n3 >>> (n6 - i3) * 8);
            }
            return byArray;
        }
        throw new ArithmeticException("Cannot encode given integer into specified number of octets.");
    }

    public static void I2OSP(int n3, byte[] byArray, int n4) {
        int n5 = n3;
        int n6 = n3;
        int n7 = n3;
        int n8 = n3;
        n3 = n4 + 1;
        byArray[n4] = (byte)(n8 >>> 24);
        int n9 = n3 + 1;
        byArray[n3] = (byte)(n7 >>> 16);
        n3 = n9 + 1;
        byArray[n9] = (byte)(n6 >>> 8);
        byArray[n3] = (byte)n5;
    }

    public static byte[] I2OSP(long l3) {
        byte[] byArray = new byte[8];
        byte[] byArray2 = byArray;
        byArray2[0] = (byte)(l3 >>> 56);
        byArray2[1] = (byte)(l3 >>> 48);
        byArray2[2] = (byte)(l3 >>> 40);
        byArray2[3] = (byte)(l3 >>> 32);
        byArray2[4] = (byte)(l3 >>> 24);
        byArray2[5] = (byte)(l3 >>> 16);
        byArray2[6] = (byte)(l3 >>> 8);
        byArray[7] = (byte)l3;
        return byArray;
    }

    public static void I2OSP(long l3, byte[] byArray, int n3) {
        int n4 = n3 + 1;
        byArray[n3] = (byte)(l3 >>> 56);
        n3 = n4 + 1;
        byArray[n4] = (byte)(l3 >>> 48);
        n4 = n3 + 1;
        byArray[n3] = (byte)(l3 >>> 40);
        n3 = n4 + 1;
        byArray[n4] = (byte)(l3 >>> 32);
        n4 = n3 + 1;
        byArray[n3] = (byte)(l3 >>> 24);
        n3 = n4 + 1;
        byArray[n4] = (byte)(l3 >>> 16);
        n4 = n3 + 1;
        byArray[n3] = (byte)(l3 >>> 8);
        byArray[n4] = (byte)l3;
    }

    public static void I2OSP(int n3, byte[] byArray, int n4, int n5) {
        for (int i3 = --n5; i3 >= 0; --i3) {
            int n6 = n4 + i3;
            byArray[n6] = (byte)(n3 >>> (n5 - i3) * 8);
        }
    }

    public static int OS2IP(byte[] byArray) {
        if (byArray.length <= 4) {
            if (byArray.length == 0) {
                return 0;
            }
            int n3 = 0;
            for (int i3 = 0; i3 < byArray.length; ++i3) {
                n3 |= (byArray[i3] & 0xFF) << a.a(byArray.length, 1, i3, 8);
            }
            return n3;
        }
        throw new ArithmeticException("invalid input length");
    }

    public static int OS2IP(byte[] byArray, int n3) {
        return (byArray[n3++] & 0xFF) << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3] & 0xFF;
    }

    public static int OS2IP(byte[] byArray, int n3, int n4) {
        if (byArray.length != 0 && byArray.length >= n3 + n4 - 1) {
            int n5 = 0;
            for (int i3 = 0; i3 < n4; ++i3) {
                n5 |= (byArray[n3 + i3] & 0xFF) << a.a(n4, i3, 1, 8);
            }
            return n5;
        }
        return 0;
    }

    public static long OS2LIP(byte[] byArray, int n3) {
        return ((long)byArray[n3++] & 0xFFL) << 56 | ((long)byArray[n3++] & 0xFFL) << 48 | ((long)byArray[n3++] & 0xFFL) << 40 | ((long)byArray[n3++] & 0xFFL) << 32 | ((long)byArray[n3++] & 0xFFL) << 24 | (long)((byArray[n3++] & 0xFF) << 16) | (long)((byArray[n3++] & 0xFF) << 8) | (long)(byArray[n3] & 0xFF);
    }

    public static byte[] toByteArray(int[] nArray) {
        byte[] byArray = new byte[nArray.length << 2];
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            BigEndianConversions.I2OSP(nArray[i3], byArray, i3 << 2);
        }
        return byArray;
    }

    public static byte[] toByteArray(int[] nArray, int n3) {
        int n4 = nArray.length;
        byte[] byArray = new byte[n3];
        int n5 = 0;
        int n6 = 0;
        while (n6 <= n4 - 2) {
            BigEndianConversions.I2OSP(nArray[n6], byArray, n5);
            ++n6;
            n5 += 4;
        }
        BigEndianConversions.I2OSP(nArray[n4 - 1], byArray, n5, n3 - n5);
        return byArray;
    }

    public static int[] toIntArray(byte[] byArray) {
        int n3 = (byArray.length + 3) / 4;
        int n4 = byArray.length & 3;
        int[] nArray = new int[n3];
        int n5 = 0;
        int n6 = 0;
        while (n6 <= n3 - 2) {
            nArray[n6] = BigEndianConversions.OS2IP(byArray, n5);
            ++n6;
            n5 += 4;
        }
        if (n4 != 0) {
            int n7 = n3 - 1;
            nArray[n7] = BigEndianConversions.OS2IP(byArray, n5, n4);
        } else {
            int n8 = n3 - 1;
            nArray[n8] = BigEndianConversions.OS2IP(byArray, n5);
        }
        return nArray;
    }
}

