/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import java.math.BigInteger;

public final class BigIntUtils {
    private BigIntUtils() {
    }

    public static boolean equals(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        int n3 = 0;
        if (bigIntegerArray.length != bigIntegerArray2.length) {
            return false;
        }
        for (int i3 = 0; i3 < bigIntegerArray.length; ++i3) {
            n3 |= bigIntegerArray[i3].compareTo(bigIntegerArray2[i3]);
        }
        return n3 == 0;
    }

    public static void fill(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        for (int i3 = bigIntegerArray.length - 1; i3 >= 0; --i3) {
            bigIntegerArray[i3] = bigInteger;
        }
    }

    public static BigInteger[] subArray(BigInteger[] bigIntegerArray, int n3, int n4) {
        BigInteger[] bigIntegerArray2 = new BigInteger[n4 -= n3];
        System.arraycopy(bigIntegerArray, n3, bigIntegerArray2, 0, n4);
        return bigIntegerArray2;
    }

    public static int[] toIntArray(BigInteger[] bigIntegerArray) {
        int[] nArray = new int[bigIntegerArray.length];
        for (int i3 = 0; i3 < bigIntegerArray.length; ++i3) {
            nArray[i3] = bigIntegerArray[i3].intValue();
        }
        return nArray;
    }

    public static int[] toIntArrayModQ(int n3, BigInteger[] bigIntegerArray) {
        BigInteger bigInteger = BigInteger.valueOf(n3);
        int[] nArray = new int[bigIntegerArray.length];
        for (int i3 = 0; i3 < bigIntegerArray.length; ++i3) {
            nArray[i3] = bigIntegerArray[i3].mod(bigInteger).intValue();
        }
        return nArray;
    }

    public static byte[] toMinimalByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length != 1 && (bigInteger.bitLength() & 7) == 0) {
            int n3 = bigInteger.bitLength() >> 3;
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 1, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }
}

