/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Matrix;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Vector;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class GF2Matrix
extends Matrix {
    private int[][] matrix;
    private int length;

    public GF2Matrix(byte[] byArray) {
        if (byArray.length >= 9) {
            int n3;
            this.numRows = LittleEndianConversions.OS2IP(byArray, 0);
            this.numColumns = n3 = LittleEndianConversions.OS2IP(byArray, 4);
            int n4 = n3 + 7 >>> 3;
            int n5 = this.numRows;
            if (n5 > 0 && (n4 *= n5) == byArray.length - 8) {
                int n6 = n3;
                this.length = n3 = n3 + 31 >>> 5;
                this.matrix = new int[n5][n3];
                n3 = n6 >> 5;
                n4 = n6 & 0x1F;
                n5 = 8;
                for (int i3 = 0; i3 < this.numRows; ++i3) {
                    int n7 = 0;
                    while (n7 < n3) {
                        this.matrix[i3][n7] = LittleEndianConversions.OS2IP(byArray, n5);
                        ++n7;
                        n5 += 4;
                    }
                    for (n7 = 0; n7 < n4; n7 += 8) {
                        int[] nArray = this.matrix[i3];
                        nArray[n3] = nArray[n3] ^ (byArray[n5++] & 0xFF) << n7;
                    }
                }
                return;
            }
            throw new ArithmeticException("given array is not an encoded matrix over GF(2)");
        }
        throw new ArithmeticException("given array is not an encoded matrix over GF(2)");
    }

    public GF2Matrix(int n3, int[][] nArray) {
        int[] nArray2 = nArray[0];
        if (nArray2.length == n3 + 31 >> 5) {
            this.numColumns = n3;
            this.numRows = nArray.length;
            this.length = nArray2.length;
            n3 = (n3 &= 0x1F) == 0 ? -1 : (1 << n3) - 1;
            for (int i3 = 0; i3 < this.numRows; ++i3) {
                int[] nArray3 = nArray[i3];
                int n4 = this.length - 1;
                nArray3[n4] = nArray3[n4] & n3;
            }
            this.matrix = nArray;
            return;
        }
        throw new ArithmeticException("Int array does not match given number of columns.");
    }

    public GF2Matrix(int n3, char c3) {
        SecureRandom secureRandom;
        GF2Matrix gF2Matrix = secureRandom2;
        SecureRandom secureRandom2 = secureRandom;
        secureRandom = new SecureRandom();
        gF2Matrix(n3, c3, secureRandom2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GF2Matrix(int n3, char c3, SecureRandom secureRandom) {
        if (n3 <= 0) throw new ArithmeticException("Size of matrix is non-positive.");
        if (c3 != 'I') {
            if (c3 != 'L') {
                if (c3 != 'R') {
                    if (c3 != 'U') {
                        if (c3 != 'Z') throw new ArithmeticException("Unknown matrix type.");
                        int n4 = n3;
                        this.assignZeroMatrix(n4, n4);
                        return;
                    } else {
                        this.assignRandomUpperTriangularMatrix(n3, secureRandom);
                    }
                    return;
                } else {
                    this.assignRandomRegularMatrix(n3, secureRandom);
                }
                return;
            } else {
                this.assignRandomLowerTriangularMatrix(n3, secureRandom);
            }
            return;
        } else {
            this.assignUnitMatrix(n3);
        }
    }

    public GF2Matrix(GF2Matrix gF2Matrix) {
        this.numColumns = gF2Matrix.getNumColumns();
        this.numRows = gF2Matrix.getNumRows();
        this.length = gF2Matrix.length;
        this.matrix = new int[gF2Matrix.matrix.length][];
        int n3 = 0;
        while (true) {
            int[][] nArray = this.matrix;
            if (n3 >= this.matrix.length) break;
            nArray[n3] = IntUtils.clone(gF2Matrix.matrix[n3]);
            ++n3;
        }
    }

    private GF2Matrix(int n3, int n4) {
        if (n4 > 0 && n3 > 0) {
            this.assignZeroMatrix(n3, n4);
            return;
        }
        throw new ArithmeticException("size of matrix is non-positive");
    }

    private void assignZeroMatrix(int n3, int n4) {
        int n5 = this.numRows = n3;
        this.numColumns = n4;
        this.length = n3 = n4 + 31 >>> 5;
        this.matrix = new int[n5][n3];
        for (n3 = 0; n3 < this.numRows; ++n3) {
            for (n4 = 0; n4 < this.length; ++n4) {
                this.matrix[n3][n4] = 0;
            }
        }
    }

    private void assignUnitMatrix(int n3) {
        int n4;
        int n5 = this.numRows = n3;
        this.numColumns = n3;
        this.length = n3 = n3 + 31 >>> 5;
        this.matrix = new int[n5][n3];
        for (n3 = 0; n3 < this.numRows; ++n3) {
            for (n4 = 0; n4 < this.length; ++n4) {
                this.matrix[n3][n4] = 0;
            }
        }
        for (n3 = 0; n3 < this.numRows; ++n3) {
            n4 = n3 & 0x1F;
            this.matrix[n3][n3 >>> 5] = 1 << n4;
        }
    }

    private void assignRandomLowerTriangularMatrix(int n3, SecureRandom secureRandom) {
        int n4 = this.numRows = n3;
        this.numColumns = n3;
        this.length = n3 = n3 + 31 >>> 5;
        this.matrix = new int[n4][n3];
        for (n3 = 0; n3 < this.numRows; ++n3) {
            int n5 = n3;
            int n6 = n5 >>> 5;
            int n7 = n5 & 0x1F;
            int n8 = 31 - n7;
            n7 = 1 << n7;
            for (int i3 = 0; i3 < n6; ++i3) {
                this.matrix[n3][i3] = secureRandom.nextInt();
            }
            this.matrix[n3][n6] = secureRandom.nextInt() >>> n8 | n7;
            ++n6;
            while (n6 < this.length) {
                this.matrix[n3][n6] = 0;
                ++n6;
            }
        }
    }

    private void assignRandomUpperTriangularMatrix(int n3, SecureRandom secureRandom) {
        int n4 = n3;
        int n5 = this.numRows = n3;
        this.numColumns = n3;
        this.length = n3 = n3 + 31 >>> 5;
        this.matrix = new int[n5][n3];
        n3 = n4 & 0x1F;
        n3 = n3 == 0 ? -1 : (1 << n3) - 1;
        for (int i3 = 0; i3 < this.numRows; ++i3) {
            int n6 = i3;
            int n7 = n6 >>> 5;
            int n8 = n6 & 0x1F;
            int n9 = 1 << n8;
            for (int i4 = 0; i4 < n7; ++i4) {
                this.matrix[i3][i4] = 0;
            }
            this.matrix[i3][n7] = secureRandom.nextInt() << n8 | n9;
            ++n7;
            while (n7 < (n8 = this.length)) {
                this.matrix[i3][n7] = secureRandom.nextInt();
                ++n7;
            }
            int[] nArray = this.matrix[i3];
            n7 = n8 - 1;
            nArray[n7] = nArray[n7] & n3;
        }
    }

    private void assignRandomRegularMatrix(int n3, SecureRandom object) {
        int n4;
        this.numRows = n3;
        this.numColumns = n3;
        this.length = n4 = n3 + 31 >>> 5;
        this.matrix = new int[n3][n4];
        GF2Matrix gF2Matrix = (GF2Matrix)new GF2Matrix(n3, 'L', (SecureRandom)object).rightMultiply(new GF2Matrix(n3, 'U', (SecureRandom)object));
        object = new Permutation(n3, (SecureRandom)object).getVector();
        for (int i3 = 0; i3 < n3; ++i3) {
            GF2Matrix gF2Matrix2 = this;
            int[] nArray = gF2Matrix2.matrix[object[i3]];
            int n5 = gF2Matrix2.length;
            System.arraycopy(gF2Matrix.matrix[i3], 0, nArray, 0, n5);
        }
    }

    public static GF2Matrix[] createRandomRegularMatrixAndItsInverse(int n3, SecureRandom object) {
        GF2Matrix gF2Matrix;
        int n4;
        GF2Matrix gF2Matrix2;
        GF2Matrix gF2Matrix3;
        int n5;
        Permutation permutation;
        GF2Matrix gF2Matrix4;
        GF2Matrix gF2Matrix5;
        int n6 = n3;
        GF2Matrix[] gF2MatrixArray = new GF2Matrix[2];
        int n7 = n6 + 31 >> 5;
        GF2Matrix gF2Matrix6 = gF2Matrix5;
        GF2Matrix gF2Matrix7 = gF2Matrix4;
        GF2Matrix gF2Matrix8 = (GF2Matrix)new GF2Matrix(n3, 'L', (SecureRandom)object).rightMultiply(new GF2Matrix(n3, 'U', (SecureRandom)object));
        Permutation permutation2 = permutation;
        object = new Permutation(n3, (SecureRandom)object).getVector();
        int[][] nArray = new int[n6][n7];
        for (n5 = 0; n5 < n3; ++n5) {
            System.arraycopy(gF2Matrix8.matrix[object[n5]], 0, nArray[n5], 0, n7);
        }
        object = gF2Matrix3;
        gF2Matrix3 = new GF2Matrix(n3, nArray);
        gF2MatrixArray[0] = object;
        object = gF2Matrix2;
        gF2Matrix2 = new GF2Matrix(n3, 'I');
        int n8 = 0;
        while (n8 < n3) {
            int n9 = n8;
            int n10 = n9 & 0x1F;
            n5 = n9 >>> 5;
            n10 = 1 << n10;
            for (int i3 = n4 = n8 + 1; i3 < n3; ++i3) {
                if ((gF2Matrix6.matrix[i3][n5] & n10) == 0) continue;
                for (int i4 = 0; i4 <= n5; ++i4) {
                    int[][] nArray2 = ((GF2Matrix)object).matrix;
                    int[] nArray3 = ((GF2Matrix)object).matrix[i3];
                    nArray3[i4] = nArray3[i4] ^ nArray2[n8][i4];
                }
            }
            n8 = n4;
        }
        gF2Matrix6 = gF2Matrix;
        gF2Matrix = new GF2Matrix(n3, 'I');
        --n3;
        while (n3 >= 0) {
            int n11 = n3;
            n8 = n11 & 0x1F;
            int n12 = n11 >>> 5;
            n8 = 1 << n8;
            for (n5 = (v1390450) - 1; n5 >= 0; --n5) {
                if ((gF2Matrix7.matrix[n5][n12] & n8) == 0) continue;
                for (n4 = n12; n4 < n7; ++n4) {
                    int[][] nArray4 = gF2Matrix6.matrix;
                    int[] nArray5 = gF2Matrix6.matrix[n5];
                    nArray5[n4] = nArray5[n4] ^ nArray4[n3][n4];
                }
            }
            --n3;
        }
        gF2MatrixArray[1] = (GF2Matrix)gF2Matrix6.rightMultiply(((GF2Matrix)object).rightMultiply(permutation2));
        return gF2MatrixArray;
    }

    private static void swapRows(int[][] object, int n3, int n4) {
        int[][] nArray = object;
        int[][] nArray2 = object;
        object = nArray[n3];
        nArray[n3] = nArray2[n4];
        nArray2[n4] = (int[])object;
    }

    private static void addToRow(int[] nArray, int[] nArray2, int n3) {
        for (int i3 = nArray2.length - 1; i3 >= n3; --i3) {
            nArray2[i3] = nArray[i3] ^ nArray2[i3];
        }
    }

    public int[][] getIntArray() {
        return this.matrix;
    }

    public int getLength() {
        return this.length;
    }

    public int[] getRow(int n3) {
        return this.matrix[n3];
    }

    @Override
    public byte[] getEncoded() {
        GF2Matrix gF2Matrix = this;
        int n3 = gF2Matrix.numColumns + 7 >>> 3;
        int n4 = gF2Matrix.numRows;
        byte[] byArray = new byte[n3 * n4 + 8];
        LittleEndianConversions.I2OSP(n4, byArray, 0);
        LittleEndianConversions.I2OSP(gF2Matrix.numColumns, byArray, 4);
        int n5 = gF2Matrix.numColumns;
        int n6 = n5 >>> 5;
        int n7 = n5 & 0x1F;
        int n8 = 8;
        for (int i3 = 0; i3 < this.numRows; ++i3) {
            int n9 = 0;
            while (n9 < n6) {
                LittleEndianConversions.I2OSP(this.matrix[i3][n9], byArray, n8);
                ++n9;
                n8 += 4;
            }
            for (n9 = 0; n9 < n7; n9 += 8) {
                byArray[n8++] = (byte)(this.matrix[i3][n6] >>> n9 & 0xFF);
            }
        }
        return byArray;
    }

    public double getHammingWeight() {
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = this.numColumns & 0x1F;
        int n4 = n3 == 0 ? this.length : this.length - 1;
        for (int i3 = 0; i3 < this.numRows; ++i3) {
            int n5;
            int n6;
            for (n6 = 0; n6 < n4; ++n6) {
                n5 = this.matrix[i3][n6];
                for (int i4 = 0; i4 < 32; ++i4) {
                    d3 += (double)(n5 >>> i4 & 1);
                    d4 += 1.0;
                }
            }
            n6 = this.matrix[i3][this.length - 1];
            for (n5 = 0; n5 < n3; ++n5) {
                d3 += (double)(n6 >>> n5 & 1);
                d4 += 1.0;
            }
        }
        return d3 / d4;
    }

    @Override
    public boolean isZero() {
        for (int i3 = 0; i3 < this.numRows; ++i3) {
            for (int i4 = 0; i4 < this.length; ++i4) {
                if (this.matrix[i3][i4] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public GF2Matrix getLeftSubMatrix() {
        int n3 = this.numRows;
        if (this.numColumns > n3) {
            int n4 = n3;
            int n5 = n4 + 31 >> 5;
            int[][] nArray = new int[n4][n5];
            int n6 = (1 << (n4 & 0x1F)) - 1;
            if (n6 == 0) {
                n6 = -1;
            }
            --n3;
            while (n3 >= 0) {
                System.arraycopy(this.matrix[n3], 0, nArray[n3], 0, n5);
                int[] nArray2 = nArray[n3];
                int n7 = n5 - 1;
                nArray2[n7] = nArray2[n7] & n6;
                --n3;
            }
            return new GF2Matrix(this.numRows, nArray);
        }
        throw new ArithmeticException("empty submatrix");
    }

    public GF2Matrix extendLeftCompactForm() {
        GF2Matrix gF2Matrix;
        GF2Matrix gF2Matrix2 = this;
        int n3 = this.numRows;
        int n4 = gF2Matrix2.numColumns + n3;
        GF2Matrix gF2Matrix3 = gF2Matrix;
        gF2Matrix = new GF2Matrix(n3, n4);
        int n5 = gF2Matrix2.numRows;
        n3 = n5 - 1 + this.numColumns;
        n4 = n5 - 1;
        while (n4 >= 0) {
            int[] nArray = gF2Matrix3.matrix[n4];
            int n6 = this.length;
            System.arraycopy(this.matrix[n4], 0, nArray, 0, n6);
            int[] nArray2 = gF2Matrix3.matrix[n4];
            int n7 = n3 >> 5;
            nArray2[n7] = nArray2[n7] | 1 << (n3 & 0x1F);
            --n4;
            --n3;
        }
        return gF2Matrix3;
    }

    public GF2Matrix getRightSubMatrix() {
        int n3 = this.numColumns;
        int n4 = this.numRows;
        if (n3 > n4) {
            GF2Matrix gF2Matrix;
            int n5 = n4;
            int n6 = n5 >> 5;
            int n7 = n5 & 0x1F;
            GF2Matrix gF2Matrix2 = gF2Matrix;
            gF2Matrix = new GF2Matrix(n4, n3 - n4);
            for (n3 = this.numRows - 1; n3 >= 0; --n3) {
                int n8;
                if (n7 != 0) {
                    int n9;
                    n8 = n6;
                    for (n4 = 0; n4 < (n9 = gF2Matrix2.length) - 1; ++n4) {
                        int[] nArray = this.matrix[n3];
                        gF2Matrix2.matrix[n3][n4] = nArray[n8++] >>> n7 | nArray[n8] << 32 - n7;
                    }
                    int[] nArray = gF2Matrix2.matrix[n3];
                    int n10 = n9 - 1;
                    int[] nArray2 = this.matrix[n3];
                    int n11 = n8 + 1;
                    nArray[n10] = nArray2[n8] >>> n7;
                    if (n11 >= this.length) continue;
                    int n12 = n9 - 1;
                    nArray[n12] = nArray[n12] | nArray2[n11] << 32 - n7;
                    continue;
                }
                GF2Matrix gF2Matrix3 = gF2Matrix2;
                int[] nArray = gF2Matrix3.matrix[n3];
                n8 = gF2Matrix3.length;
                System.arraycopy(this.matrix[n3], n6, nArray, 0, n8);
            }
            return gF2Matrix2;
        }
        throw new ArithmeticException("empty submatrix");
    }

    public GF2Matrix extendRightCompactForm() {
        GF2Matrix gF2Matrix;
        GF2Matrix gF2Matrix2 = gF2Matrix;
        int n3 = this.numRows;
        gF2Matrix = new GF2Matrix(n3, n3 + this.numColumns);
        int n4 = this.numRows;
        int n5 = n4 >> 5;
        int n6 = n4 & 0x1F;
        for (int i3 = (v1390992) - 1; i3 >= 0; --i3) {
            int[] nArray = gF2Matrix2.matrix[i3];
            int[] nArray2 = nArray;
            int n7 = i3 >> 5;
            nArray[n7] = nArray[n7] | 1 << (i3 & 0x1F);
            if (n6 != 0) {
                int n8;
                int n9;
                n7 = n5;
                for (n9 = 0; n9 < (n8 = this.length) - 1; ++n9) {
                    n8 = this.matrix[i3][n9];
                    int[] nArray3 = gF2Matrix2.matrix[i3];
                    int n10 = n7++;
                    nArray3[n7] = nArray3[n10] | n8 << n6;
                    nArray3[n7] = nArray3[n7] | n8 >>> 32 - n6;
                }
                n9 = this.matrix[i3][n8 - 1];
                int[] nArray4 = gF2Matrix2.matrix[i3];
                int n11 = n7 + 1;
                nArray4[n7] = nArray4[n7] | n9 << n6;
                if (n11 >= gF2Matrix2.length) continue;
                nArray4[n11] = nArray4[n11] | n9 >>> 32 - n6;
                continue;
            }
            n7 = this.length;
            System.arraycopy(this.matrix[i3], 0, nArray2, n5, n7);
        }
        return gF2Matrix2;
    }

    public Matrix computeTranspose() {
        int n3;
        int[][] nArray = new int[this.numColumns][this.numRows + 31 >>> 5];
        for (int i3 = 0; i3 < (n3 = this.numRows); ++i3) {
            for (n3 = 0; n3 < this.numColumns; ++n3) {
                int n4 = n3;
                int n5 = n4 >>> 5;
                int n6 = n4 & 0x1F;
                int n7 = this.matrix[i3][n5] >>> n6 & 1;
                int n8 = i3;
                n5 = n8 >>> 5;
                n6 = n8 & 0x1F;
                if (n7 != 1) continue;
                int[] nArray2 = nArray[n3];
                nArray2[n5] = nArray2[n5] | 1 << n6;
            }
        }
        return new GF2Matrix(n3, nArray);
    }

    @Override
    public Matrix computeInverse() {
        int n3 = this.numRows;
        if (n3 == this.numColumns) {
            int n4;
            int n5;
            int[][] nArray = new int[n3][this.length];
            for (int i3 = (v1391202) - 1; i3 >= 0; --i3) {
                nArray[i3] = IntUtils.clone(this.matrix[i3]);
            }
            int n6 = this.numRows;
            int[][] nArray2 = new int[n6][this.length];
            int n7 = n6 - 1;
            while (n7 >= 0) {
                int n8 = n7--;
                n5 = n8 >> 5;
                n4 = n8 & 0x1F;
                nArray2[n8][n5] = 1 << n4;
            }
            for (n7 = 0; n7 < this.numRows; ++n7) {
                int n9;
                int n10 = n7;
                n5 = n10 >> 5;
                n4 = 1 << (n10 & 0x1F);
                if ((nArray[n10][n5] & n4) == 0) {
                    n9 = 0;
                    for (int i4 = n7 + 1; i4 < this.numRows; ++i4) {
                        if ((nArray[i4][n5] & n4) == 0) continue;
                        n9 = 1;
                        GF2Matrix.swapRows(nArray, n7, i4);
                        GF2Matrix.swapRows(nArray2, n7, i4);
                        i4 = this.numRows;
                    }
                    if (n9 == 0) {
                        throw new ArithmeticException("Matrix is not invertible.");
                    }
                }
                for (n9 = this.numRows - 1; n9 >= 0; --n9) {
                    int[] nArray3;
                    if (n9 == n7 || ((nArray3 = nArray[n9])[n5] & n4) == 0) continue;
                    GF2Matrix.addToRow(nArray[n7], nArray3, n5);
                    GF2Matrix.addToRow(nArray2[n7], nArray2[n9], 0);
                }
            }
            return new GF2Matrix(this.numColumns, nArray2);
        }
        throw new ArithmeticException("Matrix is not invertible.");
    }

    public Matrix leftMultiply(Permutation object) {
        int[] nArray = ((Permutation)object).getVector();
        object = nArray;
        int n3 = this.numRows;
        if (nArray.length == n3) {
            int[][] nArrayArray = new int[n3][];
            for (int i3 = (v1391349) - 1; i3 >= 0; --i3) {
                nArrayArray[i3] = IntUtils.clone(this.matrix[object[i3]]);
            }
            return new GF2Matrix(this.numRows, nArrayArray);
        }
        throw new ArithmeticException("length mismatch");
    }

    @Override
    public Vector leftMultiply(Vector object) {
        if (object instanceof GF2Vector) {
            if (((Vector)object).length == this.numRows) {
                int n3;
                int n4;
                GF2Matrix gF2Matrix = this;
                object = ((GF2Vector)object).getVecArray();
                int[] nArray = new int[gF2Matrix.length];
                int n5 = gF2Matrix.numRows;
                int n6 = n5 >> 5;
                int n7 = 1 << (n5 & 0x1F);
                int n8 = 0;
                for (n4 = 0; n4 < n6; ++n4) {
                    n3 = 1;
                    do {
                        if ((object[n4] & n3) != 0) {
                            for (int i3 = 0; i3 < this.length; ++i3) {
                                nArray[i3] = nArray[i3] ^ this.matrix[n8][i3];
                            }
                        }
                        ++n8;
                    } while ((n3 <<= 1) != 0);
                }
                for (n4 = 1; n4 != n7; n4 <<= 1) {
                    if ((object[n6] & n4) != 0) {
                        for (n3 = 0; n3 < this.length; ++n3) {
                            nArray[n3] = nArray[n3] ^ this.matrix[n8][n3];
                        }
                    }
                    ++n8;
                }
                return new GF2Vector(nArray, this.numColumns);
            }
            throw new ArithmeticException("length mismatch");
        }
        throw new ArithmeticException("vector is not defined over GF(2)");
    }

    public Vector leftMultiplyLeftCompactForm(Vector object) {
        if (object instanceof GF2Vector) {
            if (((Vector)object).length == this.numRows) {
                int n3;
                int n4;
                int n5;
                int n6;
                object = ((GF2Vector)object).getVecArray();
                int n7 = this.numRows;
                int[] nArray = new int[n7 + this.numColumns + 31 >>> 5];
                int n8 = n7 >>> 5;
                int n9 = 0;
                for (n6 = 0; n6 < n8; ++n6) {
                    n5 = 1;
                    do {
                        if ((object[n6] & n5) != 0) {
                            for (n4 = 0; n4 < this.length; ++n4) {
                                nArray[n4] = nArray[n4] ^ this.matrix[n9][n4];
                            }
                            int n10 = this.numColumns;
                            n4 = n10 + n9 >>> 5;
                            n3 = n10 + n9 & 0x1F;
                            nArray[n4] = nArray[n4] | 1 << n3;
                        }
                        ++n9;
                    } while ((n5 <<= 1) != 0);
                }
                n6 = 1 << (this.numRows & 0x1F);
                for (n5 = 1; n5 != n6; n5 <<= 1) {
                    if ((object[n8] & n5) != 0) {
                        for (n4 = 0; n4 < this.length; ++n4) {
                            nArray[n4] = nArray[n4] ^ this.matrix[n9][n4];
                        }
                        int n11 = this.numColumns;
                        n4 = n11 + n9 >>> 5;
                        n3 = n11 + n9 & 0x1F;
                        nArray[n4] = nArray[n4] | 1 << n3;
                    }
                    ++n9;
                }
                return new GF2Vector(nArray, this.numRows + this.numColumns);
            }
            throw new ArithmeticException("length mismatch");
        }
        throw new ArithmeticException("vector is not defined over GF(2)");
    }

    @Override
    public Matrix rightMultiply(Matrix matrix) {
        if (matrix instanceof GF2Matrix) {
            if (matrix.numRows == this.numColumns) {
                GF2Matrix gF2Matrix;
                GF2Matrix gF2Matrix2 = (GF2Matrix)matrix;
                GF2Matrix gF2Matrix3 = gF2Matrix;
                int n3 = this.numRows;
                gF2Matrix = new GF2Matrix(n3, matrix.numColumns);
                n3 = this.numColumns & 0x1F;
                int n4 = n3 == 0 ? this.length : this.length - 1;
                for (int i3 = 0; i3 < this.numRows; ++i3) {
                    int n5;
                    int n6;
                    int n7;
                    int n8 = 0;
                    for (n7 = 0; n7 < n4; ++n7) {
                        n6 = this.matrix[i3][n7];
                        for (n5 = 0; n5 < 32; ++n5) {
                            if ((n6 & 1 << n5) != 0) {
                                for (int i4 = 0; i4 < gF2Matrix2.length; ++i4) {
                                    int[] nArray = gF2Matrix3.matrix[i3];
                                    nArray[i4] = nArray[i4] ^ gF2Matrix2.matrix[n8][i4];
                                }
                            }
                            ++n8;
                        }
                    }
                    n7 = this.matrix[i3][this.length - 1];
                    for (n6 = 0; n6 < n3; ++n6) {
                        if ((n7 & 1 << n6) != 0) {
                            for (n5 = 0; n5 < gF2Matrix2.length; ++n5) {
                                int[] nArray = gF2Matrix3.matrix[i3];
                                nArray[n5] = nArray[n5] ^ gF2Matrix2.matrix[n8][n5];
                            }
                        }
                        ++n8;
                    }
                }
                return gF2Matrix3;
            }
            throw new ArithmeticException("length mismatch");
        }
        throw new ArithmeticException("matrix is not defined over GF(2)");
    }

    @Override
    public Matrix rightMultiply(Permutation object) {
        int[] nArray = ((Permutation)object).getVector();
        object = nArray;
        int n3 = this.numColumns;
        if (nArray.length == n3) {
            GF2Matrix gF2Matrix;
            GF2Matrix gF2Matrix2 = gF2Matrix;
            gF2Matrix = new GF2Matrix(this.numRows, n3);
            for (n3 = this.numColumns - 1; n3 >= 0; --n3) {
                int n4 = n3;
                int n5 = n4 >>> 5;
                int n6 = n4 & 0x1F;
                Object object2 = object[n4];
                reference var6_6 = object2 >>> 5;
                int n7 = object2 & 0x1F;
                for (int i3 = this.numRows - 1; i3 >= 0; --i3) {
                    int[] nArray2 = gF2Matrix2.matrix[i3];
                    nArray2[n5] = nArray2[n5] | (this.matrix[i3][var6_6] >>> n7 & 1) << n6;
                }
            }
            return gF2Matrix2;
        }
        throw new ArithmeticException("length mismatch");
    }

    @Override
    public Vector rightMultiply(Vector object) {
        if (object instanceof GF2Vector) {
            if (((Vector)object).length == this.numColumns) {
                int n3;
                object = ((GF2Vector)object).getVecArray();
                int[] nArray = new int[this.numRows + 31 >>> 5];
                for (int i3 = 0; i3 < (n3 = this.numRows); ++i3) {
                    int n4;
                    n3 = 0;
                    for (n4 = 0; n4 < this.length; ++n4) {
                        n3 ^= this.matrix[i3][n4] & object[n4];
                    }
                    n4 = 0;
                    for (int i4 = 0; i4 < 32; ++i4) {
                        n4 ^= n3 >>> i4 & 1;
                    }
                    if (n4 != 1) continue;
                    n3 = i3 >>> 5;
                    nArray[n3] = nArray[n3] | 1 << (i3 & 0x1F);
                }
                return new GF2Vector(nArray, n3);
            }
            throw new ArithmeticException("length mismatch");
        }
        throw new ArithmeticException("vector is not defined over GF(2)");
    }

    public Vector rightMultiplyRightCompactForm(Vector object) {
        if (object instanceof GF2Vector) {
            if (((Vector)object).length == this.numColumns + this.numRows) {
                int n3;
                object = ((GF2Vector)object).getVecArray();
                int n4 = this.numRows;
                int[] nArray = new int[n4 + 31 >>> 5];
                int n5 = n4 >> 5;
                int n6 = n4 & 0x1F;
                for (int i3 = 0; i3 < (n3 = this.numRows); ++i3) {
                    int n7;
                    Object object2;
                    n3 = i3 >> 5;
                    int n8 = i3 & 0x1F;
                    Object object3 = object[n3] >>> n8 & 1;
                    if (n6 != 0) {
                        int n9;
                        object2 = n5;
                        for (n7 = 0; n7 < (n9 = this.length) - 1; ++n7) {
                            Object object4 = object3;
                            int n10 = object2;
                            object3 = n10 + 1;
                            object2 = object[n10] >>> n6 | object[object3] << 32 - n6;
                            object2 = object4 ^ this.matrix[i3][n7] & object2;
                            Object object5 = object3;
                            object3 = object2;
                            object2 = object5;
                        }
                        n7 = object2 + 1;
                        Object object6 = object;
                        object2 = object6[object2] >>> n6;
                        if (n7 < ((Object)object6).length) {
                            object2 |= object[n7] << 32 - n6;
                        }
                        object3 ^= this.matrix[i3][n9 - 1] & object2;
                    } else {
                        object2 = n5;
                        for (n7 = 0; n7 < this.length; ++n7) {
                            Object object7 = object3;
                            int n11 = object2;
                            object3 = n11 + 1;
                            object2 = object7 ^ this.matrix[i3][n7] & object[n11];
                            Object object8 = object2;
                            object2 = object3;
                            object3 = object8;
                        }
                    }
                    n7 = 0;
                    for (object2 = 0; object2 < 32; ++object2) {
                        n7 ^= object3 & 1;
                        object3 >>>= 1;
                    }
                    if (n7 != 1) continue;
                    nArray[n3] = nArray[n3] | 1 << n8;
                }
                return new GF2Vector(nArray, n3);
            }
            throw new ArithmeticException("length mismatch");
        }
        throw new ArithmeticException("vector is not defined over GF(2)");
    }

    public boolean equals(Object object) {
        if (!(object instanceof GF2Matrix)) {
            return false;
        }
        object = (GF2Matrix)object;
        if (this.numRows == ((Matrix)object).numRows && this.numColumns == ((Matrix)object).numColumns && this.length == ((GF2Matrix)object).length) {
            for (int i3 = 0; i3 < this.numRows; ++i3) {
                if (IntUtils.equals(this.matrix[i3], ((GF2Matrix)object).matrix[i3])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n3 = (this.numRows * 31 + this.numColumns) * 31 + this.length;
        for (int i3 = 0; i3 < this.numRows; ++i3) {
            n3 *= 31;
            n3 = Arrays.hashCode(this.matrix[i3]) + n3;
        }
        return n3;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer;
        int n3 = this.numColumns & 0x1F;
        int n4 = n3 == 0 ? this.length : this.length - 1;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        for (int i3 = 0; i3 < this.numRows; ++i3) {
            int n5;
            int n6;
            stringBuffer2.append(i3 + ": ");
            for (n6 = 0; n6 < n4; ++n6) {
                n5 = this.matrix[i3][n6];
                for (int i4 = 0; i4 < 32; ++i4) {
                    if ((n5 >>> i4 & 1) == 0) {
                        stringBuffer2.append('0');
                        continue;
                    }
                    stringBuffer2.append('1');
                }
                stringBuffer2.append(' ');
            }
            n6 = this.matrix[i3][this.length - 1];
            for (n5 = 0; n5 < n3; ++n5) {
                if ((n6 >>> n5 & 1) == 0) {
                    stringBuffer2.append('0');
                    continue;
                }
                stringBuffer2.append('1');
            }
            stringBuffer2.append('\n');
        }
        return stringBuffer2.toString();
    }
}

