/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.RandUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Vector;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class GF2Vector
extends Vector {
    private int[] v;

    public GF2Vector(int n3) {
        if (n3 >= 0) {
            this.length = n3;
            this.v = new int[n3 + 31 >> 5];
            return;
        }
        throw new ArithmeticException("Negative length.");
    }

    public GF2Vector(int n3, SecureRandom secureRandom) {
        int n4;
        this.length = n3;
        this.v = new int[n3 + 31 >> 5];
        for (int i3 = n4 = (v1400958) - 1; i3 >= 0; --i3) {
            this.v[i3] = secureRandom.nextInt();
        }
        if ((n3 &= 0x1F) != 0) {
            this.v[n4] = this.v[n4] & (1 << n3) - 1;
        }
    }

    public GF2Vector(int n3, int n4, SecureRandom secureRandom) {
        if (n4 <= n3) {
            this.length = n3;
            this.v = new int[n3 + 31 >> 5];
            int[] nArray = new int[n3];
            int n5 = 0;
            while (n5 < n3) {
                int n6 = n5++;
                nArray[n6] = n6;
            }
            for (n5 = 0; n5 < n4; ++n5) {
                int n7 = RandUtils.nextInt(secureRandom, n3);
                this.setBit(nArray[n7]);
                nArray[n7] = nArray[n3 += -1];
            }
            return;
        }
        throw new ArithmeticException("The hamming weight is greater than the length of vector.");
    }

    public GF2Vector(int n3, int[] nArray) {
        if (n3 >= 0) {
            ((Vector)object).length = n3;
            int n4 = n3 + 31 >> 5;
            if (nArray.length == n4) {
                GF2Vector gF2Vector = object;
                int[] nArray2 = IntUtils.clone(nArray);
                Object object = nArray2;
                gF2Vector.v = nArray2;
                if ((n3 &= 0x1F) != 0) {
                    Object object2 = object;
                    int n5 = n4 - 1;
                    object2[n5] = object2[n5] & (1 << n3) - 1;
                }
                return;
            }
            throw new ArithmeticException("length mismatch");
        }
        throw new ArithmeticException("negative length");
    }

    public GF2Vector(GF2Vector gF2Vector) {
        this.length = gF2Vector.length;
        this.v = IntUtils.clone(gF2Vector.v);
    }

    public GF2Vector(int[] nArray, int n3) {
        this.v = nArray;
        this.length = n3;
    }

    public static GF2Vector OS2VP(int n3, byte[] byArray) {
        if (n3 >= 0) {
            int n4 = n3 + 7 >> 3;
            if (byArray.length <= n4) {
                return new GF2Vector(n3, LittleEndianConversions.toIntArray(byArray));
            }
            throw new ArithmeticException("length mismatch");
        }
        throw new ArithmeticException("negative length");
    }

    @Override
    public byte[] getEncoded() {
        GF2Vector gF2Vector = this;
        int n3 = gF2Vector.length + 7 >> 3;
        return LittleEndianConversions.toByteArray(gF2Vector.v, n3);
    }

    public int[] getVecArray() {
        return this.v;
    }

    public int getHammingWeight() {
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int[] nArray = this.v;
            if (n4 >= this.v.length) break;
            int n5 = nArray[n4];
            for (int i3 = 0; i3 < 32; ++i3) {
                if ((n5 & 1) != 0) {
                    ++n3;
                }
                n5 >>>= 1;
            }
            ++n4;
        }
        return n3;
    }

    @Override
    public boolean isZero() {
        for (int i3 = this.v.length - 1; i3 >= 0; --i3) {
            if (this.v[i3] == 0) continue;
            return false;
        }
        return true;
    }

    public int getBit(int n3) {
        if (n3 < this.length) {
            int n4 = n3;
            int n5 = n4 >> 5;
            n3 = n4 & 0x1F;
            return (this.v[n5] & 1 << n3) >>> n3;
        }
        throw new IndexOutOfBoundsException();
    }

    public void setBit(int n3) {
        if (n3 < this.length) {
            int n4 = n3 >> 5;
            this.v[n4] = this.v[n4] | 1 << (n3 & 0x1F);
            return;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Vector add(Vector object) {
        if (object instanceof GF2Vector) {
            object = (GF2Vector)object;
            if (this.length == ((Vector)object).length) {
                object = IntUtils.clone(((GF2Vector)object).v);
                for (int i3 = (v1401250).length - 1; i3 >= 0; --i3) {
                    object[i3] = object[i3] ^ this.v[i3];
                }
                return new GF2Vector(this.length, (int[])object);
            }
            throw new ArithmeticException("length mismatch");
        }
        throw new ArithmeticException("vector is not defined over GF(2)");
    }

    @Override
    public Vector multiply(Permutation object) {
        int n3 = this.length;
        if (n3 == ((Object)(object = (Object)((Permutation)object).getVector())).length) {
            GF2Vector gF2Vector;
            GF2Vector gF2Vector2 = gF2Vector;
            gF2Vector = new GF2Vector(n3);
            for (n3 = 0; n3 < ((Object)object).length; ++n3) {
                Object object2 = object[n3];
                if ((this.v[object2 >> 5] & 1 << (object2 & 0x1F)) == 0) continue;
                int n4 = n3 >> 5;
                object2 = n4;
                gF2Vector2.v[object2] = gF2Vector2.v[n4] | 1 << (n3 & 0x1F);
            }
            return gF2Vector2;
        }
        throw new ArithmeticException("length mismatch");
    }

    public GF2Vector extractVector(int[] nArray) {
        int n3 = nArray.length;
        if (nArray[n3 - 1] <= this.length) {
            GF2Vector gF2Vector;
            GF2Vector gF2Vector2 = gF2Vector;
            gF2Vector = new GF2Vector(n3);
            for (int i3 = 0; i3 < n3; ++i3) {
                int n4 = nArray[i3];
                if ((this.v[n4 >> 5] & 1 << (n4 & 0x1F)) == 0) continue;
                n4 = i3 >> 5;
                gF2Vector2.v[n4] = gF2Vector2.v[n4] | 1 << (i3 & 0x1F);
            }
            return gF2Vector2;
        }
        throw new ArithmeticException("invalid index set");
    }

    public GF2Vector extractLeftVector(int n3) {
        int n4 = this.length;
        if (n3 <= n4) {
            GF2Vector gF2Vector;
            if (n3 == n4) {
                return new GF2Vector(this);
            }
            int n5 = n3;
            GF2Vector gF2Vector2 = gF2Vector;
            gF2Vector = new GF2Vector(n3);
            n3 = n5 >> 5;
            int n6 = n5 & 0x1F;
            System.arraycopy(this.v, 0, gF2Vector2.v, 0, n3);
            if (n6 != 0) {
                gF2Vector2.v[n3] = this.v[n3] & (1 << n6) - 1;
            }
            return gF2Vector2;
        }
        throw new ArithmeticException("invalid length");
    }

    public GF2Vector extractRightVector(int n3) {
        int n4 = ((Vector)object).length;
        if (n3 <= n4) {
            GF2Vector gF2Vector;
            if (n3 == n4) {
                return new GF2Vector((GF2Vector)object);
            }
            GF2Vector gF2Vector2 = gF2Vector;
            gF2Vector = new GF2Vector(n3);
            int n5 = ((Vector)object).length;
            int n6 = n5 - n3 >> 5;
            int n7 = n5 - n3 & 0x1F;
            n3 = n3 + 31 >> 5;
            if (n7 != 0) {
                int n8;
                int n9;
                for (n9 = 0; n9 < (n8 = n3 - 1); ++n9) {
                    int[] nArray = ((GF2Vector)object).v;
                    gF2Vector2.v[n9] = ((GF2Vector)object).v[n6++] >>> n7 | nArray[n6] << 32 - n7;
                }
                GF2Vector gF2Vector3 = object;
                Object object = gF2Vector2.v;
                int[] nArray = gF2Vector3.v;
                n9 = n6 + 1;
                n6 = nArray[n6] >>> n7;
                object[n8] = n6;
                if (n9 < nArray.length) {
                    object[n8] = n6 | nArray[n9] << 32 - n7;
                }
            } else {
                System.arraycopy(((GF2Vector)object).v, n6, gF2Vector2.v, 0, n3);
            }
            return gF2Vector2;
        }
        throw new ArithmeticException("invalid length");
    }

    public GF2mVector toExtensionFieldVector(GF2mField gF2mField) {
        int n3 = this.length;
        int n4 = gF2mField.getDegree();
        if (n3 % n4 == 0) {
            int[] nArray = new int[n3 / n4];
            n3 = 0;
            for (int i3 = (v1401586) - 1; i3 >= 0; --i3) {
                for (int i4 = gF2mField.getDegree() - 1; i4 >= 0; --i4) {
                    int n5 = n3;
                    int n6 = n5 >>> 5;
                    int n7 = n5 & 0x1F;
                    if ((this.v[n6] >>> n7 & 1) == 1) {
                        nArray[i3] = nArray[i3] ^ 1 << i4;
                    }
                    ++n3;
                }
            }
            return new GF2mVector(gF2mField, nArray);
        }
        throw new ArithmeticException("conversion is impossible");
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GF2Vector)) {
            return false;
        }
        object = (GF2Vector)object;
        return this.length == ((Vector)object).length && IntUtils.equals(this.v, ((GF2Vector)object).v);
    }

    @Override
    public int hashCode() {
        GF2Vector gF2Vector = this;
        int n3 = gF2Vector.length * 31;
        return Arrays.hashCode(gF2Vector.v) + n3;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        for (int i3 = 0; i3 < this.length; ++i3) {
            if (i3 != 0 && (i3 & 0x1F) == 0) {
                stringBuffer2.append(' ');
            }
            int n3 = i3;
            int n4 = n3 >> 5;
            int n5 = n3 & 0x1F;
            if ((this.v[n4] & 1 << n5) == 0) {
                stringBuffer2.append('0');
                continue;
            }
            stringBuffer2.append('1');
        }
        return stringBuffer2.toString();
    }
}

