/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.RandUtils;
import d.a;
import java.security.SecureRandom;

public class GF2mField {
    private int degree = 0;
    private int polynomial;

    public GF2mField(int n3) {
        if (n3 < 32) {
            if (n3 >= 1) {
                this.degree = n3;
                this.polynomial = PolynomialRingGF2.getIrreduciblePolynomial(n3);
                return;
            }
            throw new IllegalArgumentException(" Error: the degree of field is non-positive ");
        }
        throw new IllegalArgumentException(" Error: the degree of field is too large ");
    }

    public GF2mField(int n3, int n4) {
        if (n3 == PolynomialRingGF2.degree(n4)) {
            if (PolynomialRingGF2.isIrreducible(n4)) {
                GF2mField gF2mField = this;
                gF2mField.degree = n3;
                gF2mField.polynomial = n4;
                return;
            }
            throw new IllegalArgumentException(" Error: given polynomial is reducible");
        }
        throw new IllegalArgumentException(" Error: the degree is not correct");
    }

    public GF2mField(byte[] byArray) {
        if (byArray.length == 4) {
            int n3;
            this.polynomial = n3 = LittleEndianConversions.OS2IP(byArray);
            if (PolynomialRingGF2.isIrreducible(n3)) {
                this.degree = PolynomialRingGF2.degree(this.polynomial);
                return;
            }
            throw new IllegalArgumentException("byte array is not an encoded finite field");
        }
        throw new IllegalArgumentException("byte array is not an encoded finite field");
    }

    public GF2mField(GF2mField gF2mField) {
        this.degree = gF2mField.degree;
        this.polynomial = gF2mField.polynomial;
    }

    private static String polyToString(int n3) {
        String string2;
        String string3 = "";
        if (n3 == 0) {
            string2 = "0";
        } else {
            if ((byte)(n3 & 1) == 1) {
                string3 = "1";
            }
            n3 >>>= 1;
            int n4 = 1;
            while (n3 != 0) {
                if ((byte)(n3 & 1) == 1) {
                    string3 = string3 + "+x^" + n4;
                }
                n3 >>>= 1;
                ++n4;
            }
            string2 = string3;
        }
        return string2;
    }

    public int getDegree() {
        return this.degree;
    }

    public int getPolynomial() {
        return this.polynomial;
    }

    public byte[] getEncoded() {
        return LittleEndianConversions.I2OSP(this.polynomial);
    }

    public int add(int n3, int n4) {
        return n3 ^ n4;
    }

    public int mult(int n3, int n4) {
        return PolynomialRingGF2.modMultiply(n3, n4, this.polynomial);
    }

    public int exp(int n3, int n4) {
        if (n4 == 0) {
            return 1;
        }
        if (n3 == 0) {
            return 0;
        }
        if (n3 == 1) {
            return 1;
        }
        int n5 = 1;
        if (n4 < 0) {
            n3 = this.inverse(n3);
            n4 = -n4;
        }
        while (n4 != 0) {
            if ((n4 & 1) == 1) {
                n5 = this.mult(n5, n3);
            }
            int n6 = n3;
            n3 = this.mult(n6, n6);
            n4 >>>= 1;
        }
        return n5;
    }

    public int inverse(int n3) {
        return this.exp(n3, (1 << this.degree) - 2);
    }

    public int sqRoot(int n3) {
        for (int i3 = 1; i3 < this.degree; ++i3) {
            int n4 = n3;
            n3 = this.mult(n4, n4);
        }
        return n3;
    }

    public int getRandomElement(SecureRandom secureRandom) {
        return RandUtils.nextInt(secureRandom, 1 << this.degree);
    }

    public int getRandomNonZeroElement() {
        return this.getRandomNonZeroElement(CryptoServicesRegistrar.getSecureRandom());
    }

    public int getRandomNonZeroElement(SecureRandom secureRandom) {
        int n3;
        int n4 = 0x100000;
        int n5 = RandUtils.nextInt(secureRandom, 1 << this.degree);
        for (n3 = 0; n5 == 0 && n3 < n4; ++n3) {
            n5 = RandUtils.nextInt(secureRandom, 1 << this.degree);
        }
        if (n3 == n4) {
            n5 = 1;
        }
        return n5;
    }

    public boolean isElementOfThisField(int n3) {
        int n4 = this.degree;
        if (n4 == 31) {
            return n3 >= 0;
        }
        return n3 >= 0 && n3 < 1 << n4;
    }

    public String elementToStr(int n3) {
        String string2 = "";
        for (int i3 = 0; i3 < this.degree; ++i3) {
            string2 = ((byte)n3 & 1) == 0 ? i.a("0", string2) : i.a("1", string2);
            n3 >>>= 1;
        }
        return string2;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof GF2mField) {
            object = (GF2mField)object;
            return this.degree == ((GF2mField)object).degree && this.polynomial == ((GF2mField)object).polynomial;
        }
        return false;
    }

    public int hashCode() {
        return this.polynomial;
    }

    public String toString() {
        return a.a(b.a("Finite Field GF(2^").append(this.degree).append(") = GF(2)[X]/<"), GF2mField.polyToString(this.polynomial), "> ");
    }
}

