/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Matrix;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Vector;

public class GF2mMatrix
extends Matrix {
    public GF2mField field;
    public int[][] matrix;

    public GF2mMatrix(GF2mField gF2mField, byte[] byArray) {
        int n3;
        this.field = gF2mField;
        int n4 = 1;
        for (n3 = 8; gF2mField.getDegree() > n3; n3 += 8) {
            ++n4;
        }
        if (byArray.length >= 5) {
            int n5;
            this.numRows = n5 = (byArray[3] & 0xFF) << 24 ^ (byArray[2] & 0xFF) << 16 ^ (byArray[1] & 0xFF) << 8 ^ byArray[0] & 0xFF;
            if (n5 > 0 && (byArray.length - 4) % (n4 *= n5) == 0) {
                int n6 = n5;
                this.numColumns = n5 = (byArray.length - 4) / n4;
                this.matrix = new int[n6][n5];
                n5 = 4;
                for (n4 = 0; n4 < this.numRows; ++n4) {
                    for (int i3 = 0; i3 < this.numColumns; ++i3) {
                        for (int i4 = 0; i4 < n3; i4 += 8) {
                            int[] nArray = this.matrix[n4];
                            nArray[i3] = nArray[i3] ^ (byArray[n5++] & 0xFF) << i4;
                        }
                        if (this.field.isElementOfThisField(this.matrix[n4][i3])) {
                            continue;
                        }
                        throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
                    }
                }
                return;
            }
            throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
        }
        throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
    }

    public GF2mMatrix(GF2mMatrix gF2mMatrix) {
        int n3;
        GF2mMatrix gF2mMatrix2 = this;
        this.numRows = n3 = gF2mMatrix.numRows;
        this.numColumns = gF2mMatrix.numColumns;
        gF2mMatrix2.field = gF2mMatrix.field;
        gF2mMatrix2.matrix = new int[n3][];
        for (n3 = 0; n3 < this.numRows; ++n3) {
            this.matrix[n3] = IntUtils.clone(gF2mMatrix.matrix[n3]);
        }
    }

    public GF2mMatrix(GF2mField gF2mField, int[][] nArray) {
        this.field = gF2mField;
        this.matrix = nArray;
        this.numRows = nArray.length;
        this.numColumns = nArray[0].length;
    }

    private static void swapColumns(int[][] object, int n3, int n4) {
        int[][] nArray = object;
        int[][] nArray2 = object;
        object = nArray[n3];
        nArray[n3] = nArray2[n4];
        nArray2[n4] = (int[])object;
    }

    private void multRowWithElementThis(int[] nArray, int n3) {
        for (int i3 = nArray.length - 1; i3 >= 0; --i3) {
            nArray[i3] = this.field.mult(nArray[i3], n3);
        }
    }

    private int[] multRowWithElement(int[] nArray, int n3) {
        int[] nArray2 = new int[nArray.length];
        for (int i3 = nArray.length - 1; i3 >= 0; --i3) {
            nArray2[i3] = this.field.mult(nArray[i3], n3);
        }
        return nArray2;
    }

    private void addToRow(int[] nArray, int[] nArray2) {
        for (int i3 = nArray2.length - 1; i3 >= 0; --i3) {
            int n3 = nArray[i3];
            nArray2[i3] = this.field.add(n3, nArray2[i3]);
        }
    }

    @Override
    public byte[] getEncoded() {
        int n3;
        int n4 = 1;
        for (n3 = 8; this.field.getDegree() > n3; n3 += 8) {
            ++n4;
        }
        int n5 = this.numRows;
        byte[] byArray = new byte[n5 * this.numColumns * n4 + 4];
        byte[] byArray2 = byArray;
        byArray2[0] = (byte)(n5 & 0xFF);
        byArray2[1] = (byte)(n5 >>> 8 & 0xFF);
        byArray2[2] = (byte)(n5 >>> 16 & 0xFF);
        byArray[3] = (byte)(n5 >>> 24 & 0xFF);
        n5 = 4;
        for (int i3 = 0; i3 < this.numRows; ++i3) {
            for (int i4 = 0; i4 < this.numColumns; ++i4) {
                for (int i5 = 0; i5 < n3; i5 += 8) {
                    byArray2[n5++] = (byte)(this.matrix[i3][i4] >>> i5);
                }
            }
        }
        return byArray2;
    }

    @Override
    public boolean isZero() {
        for (int i3 = 0; i3 < this.numRows; ++i3) {
            for (int i4 = 0; i4 < this.numColumns; ++i4) {
                if (this.matrix[i3][i4] == 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Matrix computeInverse() {
        int n3 = this.numRows;
        if (n3 == this.numColumns) {
            int n4;
            int n5 = n3;
            int[][] nArray = new int[n5][n5];
            for (int i3 = (v1402362) - 1; i3 >= 0; --i3) {
                nArray[i3] = IntUtils.clone(this.matrix[i3]);
            }
            int n6 = this.numRows;
            int[][] nArray2 = new int[n6][n6];
            for (n4 = (v1402380) - 1; n4 >= 0; --n4) {
                nArray2[n4][n4] = 1;
            }
            for (n4 = 0; n4 < this.numRows; ++n4) {
                int n7;
                int n8;
                if (nArray[n4][n4] == 0) {
                    n8 = 0;
                    for (n7 = n4 + 1; n7 < this.numRows; ++n7) {
                        if (nArray[n7][n4] == 0) continue;
                        n8 = 1;
                        GF2mMatrix.swapColumns(nArray, n4, n7);
                        GF2mMatrix.swapColumns(nArray2, n4, n7);
                        n7 = this.numRows;
                    }
                    if (n8 == 0) {
                        throw new ArithmeticException("Matrix is not invertible.");
                    }
                }
                n8 = nArray[n4][n4];
                n8 = this.field.inverse(n8);
                this.multRowWithElementThis(nArray[n4], n8);
                this.multRowWithElementThis(nArray2[n4], n8);
                for (n8 = 0; n8 < this.numRows; ++n8) {
                    if (n8 == n4 || (n7 = nArray[n8][n4]) == 0) continue;
                    int[] nArray3 = this.multRowWithElement(nArray[n4], n7);
                    int[] nArray4 = this.multRowWithElement(nArray2[n4], n7);
                    this.addToRow(nArray3, nArray[n8]);
                    this.addToRow(nArray4, nArray2[n8]);
                }
            }
            return new GF2mMatrix(this.field, nArray2);
        }
        throw new ArithmeticException("Matrix is not invertible.");
    }

    @Override
    public Matrix rightMultiply(Matrix matrix) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public Matrix rightMultiply(Permutation permutation) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public Vector leftMultiply(Vector vector) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public Vector rightMultiply(Vector vector) {
        throw new RuntimeException("Not implemented.");
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof GF2mMatrix) {
            int n3;
            object = (GF2mMatrix)object;
            if (this.field.equals(((GF2mMatrix)object).field) && ((Matrix)object).numRows == (n3 = this.numColumns) && ((Matrix)object).numColumns == n3) {
                for (n3 = 0; n3 < this.numRows; ++n3) {
                    for (int i3 = 0; i3 < this.numColumns; ++i3) {
                        if (this.matrix[n3][i3] == ((GF2mMatrix)object).matrix[n3][i3]) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int n3 = (this.field.hashCode() * 31 + this.numRows) * 31 + this.numColumns;
        for (int i3 = 0; i3 < this.numRows; ++i3) {
            for (int i4 = 0; i4 < this.numColumns; ++i4) {
                n3 = n3 * 31 + this.matrix[i3][i4];
            }
        }
        return n3;
    }

    @Override
    public String toString() {
        String string2 = this.numRows + " x " + this.numColumns + " Matrix over " + this.field.toString() + ": \n";
        for (int i3 = 0; i3 < this.numRows; ++i3) {
            for (int i4 = 0; i4 < this.numColumns; ++i4) {
                string2 = b.a(string2).append(this.field.elementToStr(this.matrix[i3][i4])).append(" : ").toString();
            }
            string2 = i.a(string2, "\n");
        }
        return string2;
    }
}

