/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Vector;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class GF2mVector
extends Vector {
    private GF2mField field;
    private int[] vector;

    public GF2mVector(GF2mField gF2mField, byte[] byArray) {
        int n3;
        GF2mField gF2mField2;
        GF2mField gF2mField3 = gF2mField2;
        gF2mField2 = new GF2mField(gF2mField);
        this.field = gF2mField3;
        int n4 = 1;
        for (n3 = 8; gF2mField.getDegree() > n3; n3 += 8) {
            ++n4;
        }
        if (byArray.length % n4 == 0) {
            GF2mVector gF2mVector = this;
            gF2mVector.length = n4 = byArray.length / n4;
            gF2mVector.vector = new int[n4];
            n4 = 0;
            for (int i3 = 0; i3 < this.vector.length; ++i3) {
                for (int i4 = 0; i4 < n3; i4 += 8) {
                    this.vector[i3] = this.vector[i3] | (byArray[n4++] & 0xFF) << i4;
                }
                if (gF2mField.isElementOfThisField(this.vector[i3])) {
                    continue;
                }
                throw new IllegalArgumentException("Byte array is not an encoded vector over the given finite field.");
            }
            return;
        }
        throw new IllegalArgumentException("Byte array is not an encoded vector over the given finite field.");
    }

    public GF2mVector(GF2mField gF2mField, int[] nArray) {
        this.field = gF2mField;
        this.length = nArray.length;
        for (int i3 = nArray.length - 1; i3 >= 0; --i3) {
            if (gF2mField.isElementOfThisField(nArray[i3])) {
                continue;
            }
            throw new ArithmeticException("Element array is not specified over the given finite field.");
        }
        this.vector = IntUtils.clone(nArray);
    }

    public GF2mVector(GF2mVector gF2mVector) {
        this.field = new GF2mField(gF2mVector.field);
        this.length = gF2mVector.length;
        this.vector = IntUtils.clone(gF2mVector.vector);
    }

    public GF2mField getField() {
        return this.field;
    }

    public int[] getIntArrayForm() {
        return IntUtils.clone(this.vector);
    }

    @Override
    public byte[] getEncoded() {
        int n3;
        int n4 = 1;
        for (n3 = 8; this.field.getDegree() > n3; n3 += 8) {
            ++n4;
        }
        byte[] byArray = new byte[this.vector.length * n4];
        int n5 = 0;
        for (int i3 = 0; i3 < this.vector.length; ++i3) {
            for (int i4 = 0; i4 < n3; i4 += 8) {
                byArray[n5++] = (byte)(this.vector[i3] >>> i4);
            }
        }
        return byArray;
    }

    @Override
    public boolean isZero() {
        for (int i3 = this.vector.length - 1; i3 >= 0; --i3) {
            if (this.vector[i3] == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Vector add(Vector vector) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Vector multiply(Permutation object) {
        int n3 = this.length;
        if (n3 == ((Object)(object = (Object)((Permutation)object).getVector())).length) {
            int[] nArray = new int[n3];
            for (int i3 = 0; i3 < ((Object)object).length; ++i3) {
                nArray[i3] = this.vector[object[i3]];
            }
            return new GF2mVector(this.field, nArray);
        }
        throw new ArithmeticException("permutation size and vector size mismatch");
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GF2mVector)) {
            return false;
        }
        object = (GF2mVector)object;
        if (!this.field.equals(((GF2mVector)object).field)) {
            return false;
        }
        return IntUtils.equals(this.vector, ((GF2mVector)object).vector);
    }

    @Override
    public int hashCode() {
        GF2mVector gF2mVector = this;
        int n3 = gF2mVector.field.hashCode() * 31;
        return Arrays.hashCode(gF2mVector.vector) + n3;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        for (int i3 = 0; i3 < this.vector.length; ++i3) {
            for (int i4 = 0; i4 < this.field.getDegree(); ++i4) {
                int n3 = 1 << (i4 & 0x1F);
                if ((this.vector[i3] & n3) != 0) {
                    stringBuffer2.append('1');
                    continue;
                }
                stringBuffer2.append('0');
            }
            stringBuffer2.append(' ');
        }
        return stringBuffer2.toString();
    }
}

