/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2Polynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2nONBElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2nONBField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialField;
import java.security.SecureRandom;
import java.util.Vector;

public abstract class GF2nField {
    public final SecureRandom random;
    public int mDegree;
    public GF2Polynomial fieldPolynomial;
    public Vector fields;
    public Vector matrices;

    public GF2nField(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    public final int getDegree() {
        return this.mDegree;
    }

    public final GF2Polynomial getFieldPolynomial() {
        if (this.fieldPolynomial == null) {
            this.computeFieldPolynomial();
        }
        return new GF2Polynomial(this.fieldPolynomial);
    }

    public final boolean equals(Object object) {
        if (object != null && object instanceof GF2nField) {
            object = (GF2nField)object;
            if (((GF2nField)object).mDegree != this.mDegree) {
                return false;
            }
            if (!this.fieldPolynomial.equals(((GF2nField)object).fieldPolynomial)) {
                return false;
            }
            if (this instanceof GF2nPolynomialField && !(object instanceof GF2nPolynomialField)) {
                return false;
            }
            return !(this instanceof GF2nONBField) || object instanceof GF2nONBField;
        }
        return false;
    }

    public int hashCode() {
        GF2nField gF2nField = this;
        int n3 = gF2nField.mDegree;
        return gF2nField.fieldPolynomial.hashCode() + n3;
    }

    public abstract GF2nElement getRandomRoot(GF2Polynomial var1);

    public abstract void computeCOBMatrix(GF2nField var1);

    public abstract void computeFieldPolynomial();

    public final GF2Polynomial[] invertMatrix(GF2Polynomial[] gF2PolynomialArray) {
        int n3;
        GF2Polynomial[] gF2PolynomialArray2 = new GF2Polynomial[gF2PolynomialArray.length];
        GF2Polynomial[] gF2PolynomialArray3 = new GF2Polynomial[gF2PolynomialArray.length];
        for (n3 = 0; n3 < this.mDegree; ++n3) {
            GF2Polynomial gF2Polynomial;
            GF2Polynomial gF2Polynomial2;
            GF2Polynomial gF2Polynomial3 = gF2Polynomial2;
            gF2Polynomial2 = new GF2Polynomial(gF2PolynomialArray[n3]);
            gF2PolynomialArray2[n3] = gF2Polynomial3;
            gF2Polynomial3 = gF2Polynomial;
            gF2Polynomial3(this.mDegree);
            gF2PolynomialArray3[n3] = gF2Polynomial3;
            gF2Polynomial.setBit(this.mDegree - 1 - n3);
        }
        int n4 = 0;
        while (n4 < (n3 = this.mDegree) - 1) {
            int n5;
            for (n3 = n4; n3 < (n5 = this.mDegree) && !gF2PolynomialArray2[n3].testBit(n5 - 1 - n4); ++n3) {
            }
            if (n3 < this.mDegree) {
                int n6;
                if (n4 != n3) {
                    GF2Polynomial[] gF2PolynomialArray4 = gF2PolynomialArray3;
                    GF2Polynomial[] gF2PolynomialArray5 = gF2PolynomialArray3;
                    GF2Polynomial[] gF2PolynomialArray6 = gF2PolynomialArray2;
                    GF2Polynomial[] gF2PolynomialArray7 = gF2PolynomialArray2;
                    GF2Polynomial gF2Polynomial = gF2PolynomialArray6[n4];
                    gF2PolynomialArray6[n4] = gF2PolynomialArray7[n3];
                    gF2PolynomialArray7[n3] = gF2Polynomial;
                    gF2Polynomial = gF2PolynomialArray4[n4];
                    gF2PolynomialArray4[n4] = gF2PolynomialArray5[n3];
                    gF2PolynomialArray5[n3] = gF2Polynomial;
                }
                for (int i3 = n3 = n4 + 1; i3 < (n6 = this.mDegree); ++i3) {
                    if (!gF2PolynomialArray2[i3].testBit(n6 - 1 - n4)) continue;
                    gF2PolynomialArray2[i3].addToThis(gF2PolynomialArray2[n4]);
                    gF2PolynomialArray3[i3].addToThis(gF2PolynomialArray3[n4]);
                }
                n4 = n3;
                continue;
            }
            throw new RuntimeException("GF2nField.invertMatrix: Matrix cannot be inverted!");
        }
        for (n4 = n3 - 1; n4 > 0; --n4) {
            for (n3 = n4 - 1; n3 >= 0; --n3) {
                if (!gF2PolynomialArray2[n3].testBit(this.mDegree - 1 - n4)) continue;
                gF2PolynomialArray2[n3].addToThis(gF2PolynomialArray2[n4]);
                gF2PolynomialArray3[n3].addToThis(gF2PolynomialArray3[n4]);
            }
        }
        return gF2PolynomialArray3;
    }

    public final GF2nElement convert(GF2nElement gF2PolynomialArray, GF2nField gF2nField) {
        if (gF2nField == gF2nField3) {
            return (GF2nElement)gF2PolynomialArray.clone();
        }
        if (gF2nField3.fieldPolynomial.equals(gF2nField.fieldPolynomial)) {
            return (GF2nElement)gF2PolynomialArray.clone();
        }
        if (gF2nField3.mDegree == gF2nField.mDegree) {
            GF2Polynomial gF2Polynomial;
            GF2Polynomial gF2Polynomial2;
            int n3 = gF2nField3.fields.indexOf(gF2nField);
            if (n3 == -1) {
                GF2nField gF2nField2 = gF2nField3;
                gF2nField2.computeCOBMatrix(gF2nField);
                n3 = gF2nField2.fields.indexOf(gF2nField);
            }
            GF2Polynomial[] gF2PolynomialArray2 = gF2PolynomialArray;
            gF2PolynomialArray = (GF2Polynomial[])gF2nField3.matrices.elementAt(n3);
            GF2nElement gF2nElement = (GF2nElement)gF2PolynomialArray2.clone();
            if (gF2nElement instanceof GF2nONBElement) {
                ((GF2nONBElement)gF2nElement).reverseOrder();
            }
            GF2Polynomial gF2Polynomial3 = gF2Polynomial2;
            int n4 = gF2nField3.mDegree;
            gF2Polynomial3(n4, gF2nElement.toFlexiBigInt());
            gF2Polynomial2.expandN(gF2nField3.mDegree);
            GF2Polynomial gF2Polynomial4 = gF2Polynomial;
            gF2Polynomial = new GF2Polynomial(gF2nField3.mDegree);
            for (int i3 = 0; i3 < gF2nField3.mDegree; ++i3) {
                if (!gF2Polynomial3.vectorMult(gF2PolynomialArray[i3])) continue;
                gF2Polynomial4.setBit(gF2nField3.mDegree - 1 - i3);
            }
            if (gF2nField instanceof GF2nPolynomialField) {
                return new GF2nPolynomialElement((GF2nPolynomialField)gF2nField, gF2Polynomial4);
            }
            if (gF2nField instanceof GF2nONBField) {
                GF2nField gF2nField3 = (GF2nONBField)gF2nField;
                GF2nONBElement gF2nONBElement = new GF2nONBElement((GF2nONBField)gF2nField3, gF2Polynomial4.toFlexiBigInt());
                gF2nONBElement.reverseOrder();
                return gF2nONBElement;
            }
            throw new RuntimeException("GF2nField.convert: B1 must be an instance of GF2nPolynomialField or GF2nONBField!");
        }
        throw new RuntimeException("GF2nField.convert: B1 has a different degree and thus cannot be coverted to!");
    }
}

