/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

public final class LittleEndianConversions {
    private LittleEndianConversions() {
    }

    public static int OS2IP(byte[] byArray) {
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
    }

    public static int OS2IP(byte[] byArray, int n3) {
        return byArray[n3++] & 0xFF | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3] & 0xFF) << 24;
    }

    public static int OS2IP(byte[] byArray, int n3, int n4) {
        int n5 = n4;
        n4 = 0;
        for (int i3 = (v1417459) - 1; i3 >= 0; --i3) {
            n4 |= (byArray[n3 + i3] & 0xFF) << i3 * 8;
        }
        return n4;
    }

    public static long OS2LIP(byte[] byArray, int n3) {
        return (long)(byArray[n3++] & 0xFF) | (long)((byArray[n3++] & 0xFF) << 8) | (long)((byArray[n3++] & 0xFF) << 16) | ((long)byArray[n3++] & 0xFFL) << 24 | ((long)byArray[n3++] & 0xFFL) << 32 | ((long)byArray[n3++] & 0xFFL) << 40 | ((long)byArray[n3++] & 0xFFL) << 48 | ((long)byArray[n3] & 0xFFL) << 56;
    }

    public static byte[] I2OSP(int n3) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray2[0] = (byte)n3;
        byArray2[1] = (byte)(n3 >>> 8);
        byArray2[2] = (byte)(n3 >>> 16);
        byArray[3] = (byte)(n3 >>> 24);
        return byArray;
    }

    public static void I2OSP(int n3, byte[] byArray, int n4) {
        int n5 = n3;
        int n6 = n3;
        int n7 = n3;
        int n8 = n3;
        n3 = n4 + 1;
        byArray[n4] = (byte)n8;
        int n9 = n3 + 1;
        byArray[n3] = (byte)(n7 >>> 8);
        n3 = n9 + 1;
        byArray[n9] = (byte)(n6 >>> 16);
        byArray[n3] = (byte)(n5 >>> 24);
    }

    public static void I2OSP(int n3, byte[] byArray, int n4, int n5) {
        --n5;
        while (n5 >= 0) {
            int n6 = n4 + n5;
            byArray[n6] = (byte)(n3 >>> n5 * 8);
            --n5;
        }
    }

    public static byte[] I2OSP(long l3) {
        byte[] byArray = new byte[8];
        byte[] byArray2 = byArray;
        byArray2[0] = (byte)l3;
        byArray2[1] = (byte)(l3 >>> 8);
        byArray2[2] = (byte)(l3 >>> 16);
        byArray2[3] = (byte)(l3 >>> 24);
        byArray2[4] = (byte)(l3 >>> 32);
        byArray2[5] = (byte)(l3 >>> 40);
        byArray2[6] = (byte)(l3 >>> 48);
        byArray[7] = (byte)(l3 >>> 56);
        return byArray;
    }

    public static void I2OSP(long l3, byte[] byArray, int n3) {
        int n4 = n3 + 1;
        byArray[n3] = (byte)l3;
        int n5 = n4 + 1;
        byArray[n4] = (byte)(l3 >>> 8);
        n4 = n5 + 1;
        byArray[n5] = (byte)(l3 >>> 16);
        n5 = n4 + 1;
        byArray[n4] = (byte)(l3 >>> 24);
        n4 = n5 + 1;
        byArray[n5] = (byte)(l3 >>> 32);
        n5 = n4 + 1;
        byArray[n4] = (byte)(l3 >>> 40);
        n4 = n5 + 1;
        byArray[n5] = (byte)(l3 >>> 48);
        byArray[n4] = (byte)(l3 >>> 56);
    }

    public static byte[] toByteArray(int[] nArray, int n3) {
        int n4 = nArray.length;
        byte[] byArray = new byte[n3];
        int n5 = 0;
        int n6 = 0;
        while (n6 <= n4 - 2) {
            LittleEndianConversions.I2OSP(nArray[n6], byArray, n5);
            ++n6;
            n5 += 4;
        }
        LittleEndianConversions.I2OSP(nArray[n4 - 1], byArray, n5, n3 - n5);
        return byArray;
    }

    public static int[] toIntArray(byte[] byArray) {
        int n3 = (byArray.length + 3) / 4;
        int n4 = byArray.length & 3;
        int[] nArray = new int[n3];
        int n5 = 0;
        int n6 = 0;
        while (n6 <= n3 - 2) {
            nArray[n6] = LittleEndianConversions.OS2IP(byArray, n5);
            ++n6;
            n5 += 4;
        }
        if (n4 != 0) {
            int n7 = n3 - 1;
            nArray[n7] = LittleEndianConversions.OS2IP(byArray, n5, n4);
        } else {
            int n8 = n3 - 1;
            nArray[n8] = LittleEndianConversions.OS2IP(byArray, n5);
        }
        return nArray;
    }
}

