/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.e;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.RandUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class Permutation {
    private int[] perm;

    public Permutation(int n3) {
        if (n3 > 0) {
            this.perm = new int[n3];
            --n3;
            while (n3 >= 0) {
                int n4 = n3--;
                this.perm[n4] = n4;
            }
            return;
        }
        throw new IllegalArgumentException("invalid length");
    }

    public Permutation(int[] nArray) {
        if (this.isPermutation(nArray)) {
            this.perm = IntUtils.clone(nArray);
            return;
        }
        throw new IllegalArgumentException("array is not a permutation vector");
    }

    public Permutation(byte[] byArray) {
        if (byArray.length > 4) {
            int n3;
            int n4 = LittleEndianConversions.OS2IP(byArray, 0);
            if (byArray.length == n4 * (n3 = IntegerFunctions.ceilLog256(n4 - 1)) + 4) {
                this.perm = new int[n4];
                for (int i3 = 0; i3 < n4; ++i3) {
                    this.perm[i3] = LittleEndianConversions.OS2IP(byArray, i3 * n3 + 4, n3);
                }
                Permutation permutation = this;
                if (permutation.isPermutation(permutation.perm)) {
                    return;
                }
                throw new IllegalArgumentException("invalid encoding");
            }
            throw new IllegalArgumentException("invalid encoding");
        }
        throw new IllegalArgumentException("invalid encoding");
    }

    public Permutation(int n3, SecureRandom secureRandom) {
        if (n3 > 0) {
            this.perm = new int[n3];
            int[] nArray = new int[n3];
            int n4 = 0;
            while (n4 < n3) {
                int n5 = n4++;
                nArray[n5] = n5;
            }
            int n6 = n3;
            for (n4 = 0; n4 < n3; ++n4) {
                int n7 = RandUtils.nextInt(secureRandom, n6);
                this.perm[n4] = nArray[n7];
                nArray[n7] = nArray[n6 += -1];
            }
            return;
        }
        throw new IllegalArgumentException("invalid length");
    }

    private boolean isPermutation(int[] nArray) {
        int n3 = nArray.length;
        boolean[] blArray = new boolean[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            int n4 = nArray[i3];
            if (n4 >= 0 && n4 < n3 && !blArray[n4]) {
                blArray[n4] = true;
                continue;
            }
            return false;
        }
        return true;
    }

    public byte[] getEncoded() {
        int n3 = this.perm.length;
        int n4 = IntegerFunctions.ceilLog256(n3 - 1);
        byte[] byArray = new byte[n3 * n4 + 4];
        LittleEndianConversions.I2OSP(n3, byArray, 0);
        for (int i3 = 0; i3 < n3; ++i3) {
            LittleEndianConversions.I2OSP(this.perm[i3], byArray, i3 * n4 + 4, n4);
        }
        return byArray;
    }

    public int[] getVector() {
        return IntUtils.clone(this.perm);
    }

    public Permutation computeInverse() {
        Permutation permutation;
        Permutation permutation2 = permutation;
        permutation = new Permutation(this.perm.length);
        for (int i3 = this.perm.length - 1; i3 >= 0; --i3) {
            permutation2.perm[this.perm[i3]] = i3;
        }
        return permutation2;
    }

    public Permutation rightMultiply(Permutation permutation) {
        int[] nArray = this.perm;
        if (permutation.perm.length == this.perm.length) {
            Permutation permutation2;
            Permutation permutation3 = permutation2;
            permutation2 = new Permutation(nArray.length);
            for (int i3 = this.perm.length - 1; i3 >= 0; --i3) {
                permutation3.perm[i3] = this.perm[permutation.perm[i3]];
            }
            return permutation3;
        }
        throw new IllegalArgumentException("length mismatch");
    }

    public boolean equals(Object object) {
        if (!(object instanceof Permutation)) {
            return false;
        }
        Permutation permutation = permutation2;
        Permutation permutation2 = (Permutation)object;
        return IntUtils.equals(permutation.perm, permutation2.perm);
    }

    public String toString() {
        String string2 = b.a("[").append(this.perm[0]).toString();
        for (int i3 = 1; i3 < this.perm.length; ++i3) {
            string2 = e.a(string2, ", ").append(this.perm[i3]).toString();
        }
        return i.a(string2, "]");
    }

    public int hashCode() {
        return Arrays.hashCode(this.perm);
    }
}

