/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.RandUtils;
import java.security.SecureRandom;

public class PolynomialGF2mSmallM {
    public static final char RANDOM_IRREDUCIBLE_POLYNOMIAL = 'I';
    private GF2mField field;
    private int degree;
    private int[] coefficients;

    public PolynomialGF2mSmallM(GF2mField gF2mField) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = this;
        polynomialGF2mSmallM.field = gF2mField;
        polynomialGF2mSmallM.degree = -1;
        polynomialGF2mSmallM.coefficients = new int[1];
    }

    public PolynomialGF2mSmallM(GF2mField gF2mField, int n3, char c3, SecureRandom secureRandom) {
        this.field = gF2mField;
        if (c3 == 'I') {
            PolynomialGF2mSmallM polynomialGF2mSmallM = this;
            polynomialGF2mSmallM.coefficients = polynomialGF2mSmallM.createRandomIrreduciblePolynomial(n3, secureRandom);
            polynomialGF2mSmallM.computeDegree();
            return;
        }
        throw new IllegalArgumentException(" Error: type " + c3 + " is not defined for GF2smallmPolynomial");
    }

    private int[] createRandomIrreduciblePolynomial(int n3, SecureRandom secureRandom) {
        int n4;
        int[] nArray = new int[n3 + 1];
        int[] nArray2 = nArray;
        nArray2[n3] = 1;
        nArray[0] = this.field.getRandomNonZeroElement(secureRandom);
        for (n4 = 1; n4 < n3; ++n4) {
            nArray2[n4] = this.field.getRandomElement(secureRandom);
        }
        while (!this.isIrreducible(nArray2)) {
            n4 = RandUtils.nextInt(secureRandom, n3);
            if (n4 == 0) {
                nArray2[0] = this.field.getRandomNonZeroElement(secureRandom);
                continue;
            }
            nArray2[n4] = this.field.getRandomElement(secureRandom);
        }
        return nArray2;
    }

    public PolynomialGF2mSmallM(GF2mField object, int n3) {
        this.field = object;
        this.degree = n3;
        int[] nArray = new int[n3 + 1];
        object = nArray;
        this.coefficients = (int[])object;
        nArray[n3] = 1;
    }

    public PolynomialGF2mSmallM(GF2mField gF2mField, int[] nArray) {
        this.field = gF2mField;
        this.coefficients = PolynomialGF2mSmallM.normalForm(nArray);
        this.computeDegree();
    }

    public PolynomialGF2mSmallM(GF2mField gF2mField, byte[] byArray) {
        int n3;
        this.field = gF2mField;
        int n4 = 1;
        for (n3 = 8; gF2mField.getDegree() > n3; n3 += 8) {
            ++n4;
        }
        if (byArray.length % n4 == 0) {
            int[] nArray;
            block5: {
                this.coefficients = new int[byArray.length / n4];
                int n5 = 0;
                n4 = 0;
                while (true) {
                    nArray = this.coefficients;
                    if (n4 >= this.coefficients.length) break block5;
                    for (int i3 = 0; i3 < n3; i3 += 8) {
                        this.coefficients[n4] = this.coefficients[n4] ^ (byArray[n5++] & 0xFF) << i3;
                    }
                    if (!this.field.isElementOfThisField(this.coefficients[n4])) break;
                    ++n4;
                }
                throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
            }
            if (nArray.length != 1 && nArray[nArray.length - 1] == 0) {
                throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
            }
            this.computeDegree();
            return;
        }
        throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
    }

    public PolynomialGF2mSmallM(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        this.field = polynomialGF2mSmallM.field;
        this.degree = polynomialGF2mSmallM.degree;
        this.coefficients = IntUtils.clone(polynomialGF2mSmallM.coefficients);
    }

    public PolynomialGF2mSmallM(GF2mVector gF2mVector) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = gF2mField;
        GF2mVector gF2mVector2 = gF2mVector;
        GF2mField gF2mField = gF2mVector2.getField();
        polynomialGF2mSmallM(gF2mField, gF2mVector2.getIntArrayForm());
    }

    private static int headCoefficient(int[] nArray) {
        int n3 = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n3 == -1) {
            return 0;
        }
        return nArray[n3];
    }

    private int[] add(int[] nArray, int[] nArray2) {
        int n3;
        if (nArray.length < nArray2.length) {
            nArray2 = new int[nArray2.length];
            n3 = nArray2.length;
            System.arraycopy(nArray2, 0, nArray2, 0, n3);
        } else {
            nArray = new int[nArray.length];
            n3 = nArray.length;
            System.arraycopy(nArray, 0, nArray, 0, n3);
            int[] nArray3 = nArray2;
            nArray2 = nArray;
            nArray = nArray3;
        }
        for (n3 = nArray.length - 1; n3 >= 0; --n3) {
            int n4 = nArray2[n3];
            nArray2[n3] = this.field.add(n4, nArray[n3]);
        }
        return nArray2;
    }

    private int[] multWithElement(int[] nArray, int n3) {
        int n4 = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n4 != -1 && n3 != 0) {
            if (n3 == 1) {
                return IntUtils.clone(nArray);
            }
            int[] nArray2 = new int[n4 + 1];
            while (n4 >= 0) {
                nArray2[n4] = this.field.mult(nArray[n4], n3);
                --n4;
            }
            return nArray2;
        }
        return new int[1];
    }

    private static int[] multWithMonomial(int[] nArray, int n3) {
        int n4 = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n4 == -1) {
            return new int[1];
        }
        int[] nArray2 = new int[n4 + n3 + 1];
        int n5 = n4 + 1;
        System.arraycopy(nArray, 0, nArray2, n3, n5);
        return nArray2;
    }

    private int[][] div(int[] object, int[] nArray) {
        int n3 = PolynomialGF2mSmallM.computeDegree(nArray);
        int n4 = PolynomialGF2mSmallM.computeDegree(object) + 1;
        if (n3 != -1) {
            int[] nArray2 = object;
            int[][] nArrayArray = new int[2][];
            object = nArrayArray;
            object[0] = (int)new int[1];
            object[1] = (int)new int[n4];
            n4 = PolynomialGF2mSmallM.headCoefficient(nArray);
            n4 = this.field.inverse(n4);
            nArrayArray[0][0] = 0;
            int[] nArray3 = nArrayArray[1];
            int n5 = nArray3.length;
            System.arraycopy(nArray2, 0, nArray3, 0, n5);
            while (n3 <= PolynomialGF2mSmallM.computeDegree((int[])object[1])) {
                int n6 = this.field.mult(PolynomialGF2mSmallM.headCoefficient((int[])object[1]), n4);
                nArray3 = new int[]{n6};
                int[] nArray4 = this.multWithElement(nArray, n6);
                n6 = PolynomialGF2mSmallM.computeDegree((int[])object[1]) - n3;
                int[] nArray5 = PolynomialGF2mSmallM.multWithMonomial(nArray4, n6);
                nArray3 = PolynomialGF2mSmallM.multWithMonomial(nArray3, n6);
                object[0] = (int)this.add(nArray3, (int[])object[0]);
                object[1] = (int)this.add(nArray5, (int[])object[1]);
            }
            return object;
        }
        throw new ArithmeticException("Division by zero.");
    }

    private int[] gcd(int[] nArray, int[] nArray2) {
        if (PolynomialGF2mSmallM.computeDegree(nArray) == -1) {
            return nArray2;
        }
        while (PolynomialGF2mSmallM.computeDegree(nArray2) != -1) {
            int[] nArray3 = this.mod(nArray, nArray2);
            int n3 = nArray2.length;
            nArray2 = new int[n3];
            System.arraycopy(nArray2, 0, nArray2, 0, n3);
            n3 = nArray3.length;
            int[] nArray4 = new int[n3];
            System.arraycopy(nArray3, 0, nArray4, 0, n3);
            nArray = nArray2;
            nArray2 = nArray4;
        }
        return this.multWithElement(nArray, this.field.inverse(PolynomialGF2mSmallM.headCoefficient(nArray)));
    }

    private int[] multiply(int[] nArray, int[] nArray2) {
        int[] nArray3;
        Object object;
        if (PolynomialGF2mSmallM.computeDegree(nArray) < PolynomialGF2mSmallM.computeDegree(nArray2)) {
            int[] nArray4 = nArray2;
            nArray2 = nArray;
            nArray = nArray4;
        }
        nArray = PolynomialGF2mSmallM.normalForm(nArray);
        if ((nArray2 = PolynomialGF2mSmallM.normalForm(nArray2)).length == 1) {
            return ((PolynomialGF2mSmallM)object).multWithElement(nArray, nArray2[0]);
        }
        int n3 = nArray.length;
        int n4 = nArray2.length;
        int n5 = n3;
        int[] cfr_ignored_0 = new int[n5 + n4 - 1];
        if (n4 != n5) {
            PolynomialGF2mSmallM polynomialGF2mSmallM = object;
            int n6 = n4;
            object = new int[n6];
            int n7 = n3 - n6;
            int[] nArray5 = new int[n7];
            System.arraycopy(nArray, 0, object, 0, n4);
            System.arraycopy(nArray, n4, nArray5, 0, n7);
            object = polynomialGF2mSmallM.multiply((int[])object, nArray2);
            nArray3 = polynomialGF2mSmallM.add((int[])object, PolynomialGF2mSmallM.multWithMonomial(polynomialGF2mSmallM.multiply(nArray5, nArray2), n4));
        } else {
            PolynomialGF2mSmallM polynomialGF2mSmallM = object;
            int n8 = n3;
            int n9 = n8 + 1 >>> 1;
            int n10 = n8 - n9;
            int n11 = n9;
            int[] nArray6 = new int[n11];
            int[] nArray7 = new int[n11];
            int[] nArray8 = new int[n10];
            int[] nArray9 = new int[n10];
            System.arraycopy(nArray, 0, nArray6, 0, n9);
            System.arraycopy(nArray, n9, nArray8, 0, n10);
            System.arraycopy(nArray2, 0, nArray7, 0, n9);
            System.arraycopy(nArray2, n9, nArray9, 0, n10);
            int[] nArray10 = polynomialGF2mSmallM.add(nArray6, nArray8);
            int[] nArray11 = polynomialGF2mSmallM.add(nArray7, nArray9);
            nArray6 = polynomialGF2mSmallM.multiply(nArray6, nArray7);
            nArray10 = polynomialGF2mSmallM.multiply(nArray10, nArray11);
            nArray7 = polynomialGF2mSmallM.multiply(nArray8, nArray9);
            Object object2 = object;
            object = super.add(super.add(nArray10, nArray6), nArray7);
            nArray3 = polynomialGF2mSmallM.add(PolynomialGF2mSmallM.multWithMonomial(polynomialGF2mSmallM.add((int[])object, PolynomialGF2mSmallM.multWithMonomial(nArray7, n9)), n9), nArray6);
        }
        return nArray3;
    }

    private boolean isIrreducible(int[] nArray) {
        if (nArray[0] == 0) {
            return false;
        }
        int n3 = PolynomialGF2mSmallM.computeDegree(nArray) >> 1;
        int[] nArray2 = new int[2];
        int[] nArray3 = nArray2;
        nArray2[0] = 0;
        nArray2[1] = 1;
        int[] nArray4 = new int[2];
        int[] nArray5 = nArray4;
        nArray4[0] = 0;
        nArray4[1] = 1;
        int n4 = this.field.getDegree();
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i4 = n4 - 1; i4 >= 0; --i4) {
                nArray3 = this.modMultiply(nArray3, nArray3, nArray);
            }
            PolynomialGF2mSmallM polynomialGF2mSmallM = this;
            if (PolynomialGF2mSmallM.computeDegree(polynomialGF2mSmallM.gcd(polynomialGF2mSmallM.add(nArray3 = PolynomialGF2mSmallM.normalForm(nArray3), nArray5), nArray)) == 0) continue;
            return false;
        }
        return true;
    }

    private int[] mod(int[] nArray, int[] nArray2) {
        int n3 = PolynomialGF2mSmallM.computeDegree(nArray2);
        if (n3 != -1) {
            int n4 = nArray.length;
            int[] nArray3 = new int[n4];
            int n5 = PolynomialGF2mSmallM.headCoefficient(nArray2);
            n5 = this.field.inverse(n5);
            System.arraycopy(nArray, 0, nArray3, 0, n4);
            while (n3 <= PolynomialGF2mSmallM.computeDegree(nArray3)) {
                PolynomialGF2mSmallM polynomialGF2mSmallM = this;
                n4 = this.field.mult(PolynomialGF2mSmallM.headCoefficient(nArray3), n5);
                nArray3 = polynomialGF2mSmallM.add(polynomialGF2mSmallM.multWithElement(PolynomialGF2mSmallM.multWithMonomial(nArray2, PolynomialGF2mSmallM.computeDegree(nArray3) - n3), n4), nArray3);
            }
            return nArray3;
        }
        throw new ArithmeticException("Division by zero");
    }

    private int[] modMultiply(int[] nArray, int[] nArray2, int[] nArray3) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = this;
        return polynomialGF2mSmallM.mod(polynomialGF2mSmallM.multiply(nArray, nArray2), nArray3);
    }

    private int[] modDiv(int[] nArray, int[] nArray2, int[] nArray3) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = this;
        int[] nArray4 = PolynomialGF2mSmallM.normalForm(nArray3);
        nArray2 = polynomialGF2mSmallM.mod(nArray2, nArray3);
        int[] nArray5 = new int[1];
        int[] nArray6 = nArray5;
        nArray5[0] = 0;
        nArray = polynomialGF2mSmallM.mod(nArray, nArray3);
        while (PolynomialGF2mSmallM.computeDegree(nArray2) != -1) {
            PolynomialGF2mSmallM polynomialGF2mSmallM2 = this;
            int[][] nArray7 = polynomialGF2mSmallM2.div(nArray4, nArray2);
            nArray4 = PolynomialGF2mSmallM.normalForm(nArray2);
            nArray2 = PolynomialGF2mSmallM.normalForm(nArray7[1]);
            int[] nArray8 = this.add(nArray6, polynomialGF2mSmallM2.modMultiply(nArray7[0], nArray, nArray3));
            nArray6 = PolynomialGF2mSmallM.normalForm(nArray);
            nArray = PolynomialGF2mSmallM.normalForm(nArray8);
        }
        int n3 = PolynomialGF2mSmallM.headCoefficient(nArray4);
        return this.multWithElement(nArray6, this.field.inverse(n3));
    }

    private static boolean isEqual(int[] nArray, int[] nArray2) {
        int n3 = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n3 != PolynomialGF2mSmallM.computeDegree(nArray2)) {
            return false;
        }
        for (int i3 = 0; i3 <= n3; ++i3) {
            if (nArray[i3] == nArray2[i3]) continue;
            return false;
        }
        return true;
    }

    private void computeDegree() {
        int n3;
        this.degree = this.coefficients.length - 1;
        while ((n3 = this.degree) >= 0 && this.coefficients[n3] == 0) {
            this.degree = n3 - 1;
        }
    }

    private static int computeDegree(int[] nArray) {
        int n3;
        for (n3 = nArray.length - 1; n3 >= 0 && nArray[n3] == 0; --n3) {
        }
        return n3;
    }

    private static int[] normalForm(int[] nArray) {
        int n3 = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n3 == -1) {
            return new int[1];
        }
        if (nArray.length == ++n3) {
            return IntUtils.clone(nArray);
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    public int getDegree() {
        int n3 = this.coefficients.length - 1;
        if (this.coefficients[n3] == 0) {
            return -1;
        }
        return n3;
    }

    public int getHeadCoefficient() {
        int n3 = this.degree;
        if (n3 == -1) {
            return 0;
        }
        return this.coefficients[n3];
    }

    public int getCoefficient(int n3) {
        if (n3 >= 0 && n3 <= this.degree) {
            return this.coefficients[n3];
        }
        return 0;
    }

    public byte[] getEncoded() {
        int n3;
        int n4 = 1;
        for (n3 = 8; this.field.getDegree() > n3; n3 += 8) {
            ++n4;
        }
        byte[] byArray = new byte[this.coefficients.length * n4];
        int n5 = 0;
        for (int i3 = 0; i3 < this.coefficients.length; ++i3) {
            for (int i4 = 0; i4 < n3; i4 += 8) {
                byArray[n5++] = (byte)(this.coefficients[i3] >>> i4);
            }
        }
        return byArray;
    }

    public int evaluateAt(int n3) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = this;
        int[] nArray = polynomialGF2mSmallM.coefficients;
        int n4 = nArray[polynomialGF2mSmallM.degree];
        for (int i3 = (v1419182) - 1; i3 >= 0; --i3) {
            n4 = this.field.mult(n4, n3) ^ this.coefficients[i3];
        }
        return n4;
    }

    public PolynomialGF2mSmallM add(PolynomialGF2mSmallM object) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = object;
        object = this.coefficients;
        object = this.add((int[])object, polynomialGF2mSmallM.coefficients);
        return new PolynomialGF2mSmallM(this.field, (int[])object);
    }

    public void addToThis(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        PolynomialGF2mSmallM polynomialGF2mSmallM2 = object;
        Object object = ((PolynomialGF2mSmallM)object).coefficients;
        polynomialGF2mSmallM2.coefficients = polynomialGF2mSmallM2.add((int[])object, polynomialGF2mSmallM.coefficients);
        polynomialGF2mSmallM2.computeDegree();
    }

    public PolynomialGF2mSmallM addMonomial(int n3) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = this;
        int[] nArray = new int[n3 + 1];
        int[] nArray2 = nArray;
        nArray[n3] = 1;
        int[] nArray3 = polynomialGF2mSmallM.add(polynomialGF2mSmallM.coefficients, nArray2);
        return new PolynomialGF2mSmallM(this.field, nArray3);
    }

    public PolynomialGF2mSmallM multWithElement(int n3) {
        if (this.field.isElementOfThisField(n3)) {
            PolynomialGF2mSmallM polynomialGF2mSmallM = this;
            int[] nArray = polynomialGF2mSmallM.multWithElement(polynomialGF2mSmallM.coefficients, n3);
            return new PolynomialGF2mSmallM(this.field, nArray);
        }
        throw new ArithmeticException("Not an element of the finite field this polynomial is defined over.");
    }

    public void multThisWithElement(int n3) {
        if (this.field.isElementOfThisField(n3)) {
            PolynomialGF2mSmallM polynomialGF2mSmallM = this;
            polynomialGF2mSmallM.coefficients = polynomialGF2mSmallM.multWithElement(polynomialGF2mSmallM.coefficients, n3);
            polynomialGF2mSmallM.computeDegree();
            return;
        }
        throw new ArithmeticException("Not an element of the finite field this polynomial is defined over.");
    }

    public PolynomialGF2mSmallM multWithMonomial(int n3) {
        int[] nArray = PolynomialGF2mSmallM.multWithMonomial(this.coefficients, n3);
        return new PolynomialGF2mSmallM(this.field, nArray);
    }

    public PolynomialGF2mSmallM[] div(PolynomialGF2mSmallM object) {
        PolynomialGF2mSmallM polynomialGF2mSmallM;
        PolynomialGF2mSmallM polynomialGF2mSmallM2;
        PolynomialGF2mSmallM polynomialGF2mSmallM3 = object;
        object = ((PolynomialGF2mSmallM)((Object)gF2mField2)).coefficients;
        object = ((PolynomialGF2mSmallM)((Object)gF2mField2)).div((int[])object, polynomialGF2mSmallM3.coefficients);
        PolynomialGF2mSmallM[] polynomialGF2mSmallMArray = new PolynomialGF2mSmallM[2];
        PolynomialGF2mSmallM polynomialGF2mSmallM4 = polynomialGF2mSmallM2;
        GF2mField gF2mField = ((PolynomialGF2mSmallM)((Object)gF2mField2)).field;
        polynomialGF2mSmallM2 = new PolynomialGF2mSmallM(gF2mField, (int[])object[0]);
        polynomialGF2mSmallMArray[0] = polynomialGF2mSmallM4;
        polynomialGF2mSmallM4 = polynomialGF2mSmallM;
        GF2mField gF2mField2 = ((PolynomialGF2mSmallM)((Object)gF2mField2)).field;
        polynomialGF2mSmallM = new PolynomialGF2mSmallM(gF2mField2, (int[])object[1]);
        polynomialGF2mSmallMArray[1] = polynomialGF2mSmallM4;
        return polynomialGF2mSmallMArray;
    }

    public PolynomialGF2mSmallM gcd(PolynomialGF2mSmallM object) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = object;
        object = this.coefficients;
        object = this.gcd((int[])object, polynomialGF2mSmallM.coefficients);
        return new PolynomialGF2mSmallM(this.field, (int[])object);
    }

    public PolynomialGF2mSmallM multiply(PolynomialGF2mSmallM object) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = object;
        object = this.coefficients;
        object = this.multiply((int[])object, polynomialGF2mSmallM.coefficients);
        return new PolynomialGF2mSmallM(this.field, (int[])object);
    }

    public PolynomialGF2mSmallM mod(PolynomialGF2mSmallM object) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = object;
        object = this.coefficients;
        object = this.mod((int[])object, polynomialGF2mSmallM.coefficients);
        return new PolynomialGF2mSmallM(this.field, (int[])object);
    }

    public PolynomialGF2mSmallM modMultiply(PolynomialGF2mSmallM object, PolynomialGF2mSmallM object2) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = object2;
        PolynomialGF2mSmallM polynomialGF2mSmallM2 = object;
        object = this.coefficients;
        object2 = polynomialGF2mSmallM2.coefficients;
        int[] nArray = polynomialGF2mSmallM.coefficients;
        object = this.modMultiply((int[])object, (int[])object2, nArray);
        return new PolynomialGF2mSmallM(this.field, (int[])object);
    }

    public PolynomialGF2mSmallM modSquareMatrix(PolynomialGF2mSmallM[] polynomialGF2mSmallMArray) {
        int n3 = polynomialGF2mSmallMArray.length;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int n4 = 0;
        while (true) {
            int[] nArray3 = this.coefficients;
            if (n4 >= this.coefficients.length) break;
            int n5 = nArray3[n4];
            nArray2[n4] = this.field.mult(n5, n5);
            ++n4;
        }
        for (n4 = 0; n4 < n3; ++n4) {
            for (int i3 = 0; i3 < n3; ++i3) {
                int[] nArray4 = polynomialGF2mSmallMArray[i3].coefficients;
                if (n4 >= polynomialGF2mSmallMArray[i3].coefficients.length) continue;
                PolynomialGF2mSmallM polynomialGF2mSmallM = this;
                int n6 = nArray4[n4];
                n6 = polynomialGF2mSmallM.field.mult(n6, nArray2[i3]);
                nArray[n4] = polynomialGF2mSmallM.field.add(nArray[n4], n6);
            }
        }
        return new PolynomialGF2mSmallM(this.field, nArray);
    }

    public PolynomialGF2mSmallM modSquareRoot(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        int[] nArray = IntUtils.clone(this.coefficients);
        int[] nArray2 = polynomialGF2mSmallM.coefficients;
        nArray2 = this.modMultiply(nArray, nArray, nArray2);
        while (!PolynomialGF2mSmallM.isEqual(nArray2, this.coefficients)) {
            nArray = PolynomialGF2mSmallM.normalForm(nArray2);
            nArray2 = polynomialGF2mSmallM.coefficients;
            nArray2 = this.modMultiply(nArray, nArray, nArray2);
        }
        return new PolynomialGF2mSmallM(this.field, nArray);
    }

    public PolynomialGF2mSmallM modSquareRootMatrix(PolynomialGF2mSmallM[] polynomialGF2mSmallMArray) {
        int n3 = polynomialGF2mSmallMArray.length;
        int[] nArray = new int[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i4 = 0; i4 < n3; ++i4) {
                int[] nArray2 = polynomialGF2mSmallMArray[i4].coefficients;
                if (i3 >= polynomialGF2mSmallMArray[i4].coefficients.length) continue;
                int[] nArray3 = this.coefficients;
                if (i4 >= this.coefficients.length) continue;
                PolynomialGF2mSmallM polynomialGF2mSmallM = this;
                int n4 = nArray2[i3];
                n4 = polynomialGF2mSmallM.field.mult(n4, nArray3[i4]);
                nArray[i3] = polynomialGF2mSmallM.field.add(nArray[i3], n4);
            }
        }
        for (int i5 = 0; i5 < n3; ++i5) {
            nArray[i5] = this.field.sqRoot(nArray[i5]);
        }
        return new PolynomialGF2mSmallM(this.field, nArray);
    }

    public PolynomialGF2mSmallM modDiv(PolynomialGF2mSmallM object, PolynomialGF2mSmallM object2) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = object2;
        PolynomialGF2mSmallM polynomialGF2mSmallM2 = object;
        object = this.coefficients;
        object2 = polynomialGF2mSmallM2.coefficients;
        int[] nArray = polynomialGF2mSmallM.coefficients;
        object = this.modDiv((int[])object, (int[])object2, nArray);
        return new PolynomialGF2mSmallM(this.field, (int[])object);
    }

    public PolynomialGF2mSmallM modInverse(PolynomialGF2mSmallM object) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = object;
        int[] nArray = new int[1];
        object = nArray;
        nArray[0] = 1;
        int[] nArray2 = this.coefficients;
        int[] nArray3 = polynomialGF2mSmallM.coefficients;
        object = this.modDiv((int[])object, nArray2, nArray3);
        return new PolynomialGF2mSmallM(this.field, (int[])object);
    }

    public PolynomialGF2mSmallM[] modPolynomialToFracton(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        PolynomialGF2mSmallM polynomialGF2mSmallM2;
        PolynomialGF2mSmallM polynomialGF2mSmallM3;
        PolynomialGF2mSmallM polynomialGF2mSmallM4 = polynomialGF2mSmallM;
        int n3 = polynomialGF2mSmallM4.degree >> 1;
        int[] nArray = PolynomialGF2mSmallM.normalForm(polynomialGF2mSmallM4.coefficients);
        int[] nArray2 = this.coefficients;
        nArray2 = this.mod(nArray2, polynomialGF2mSmallM.coefficients);
        int[] nArray3 = new int[1];
        int[] nArray4 = nArray3;
        nArray3[0] = 0;
        int[] nArray5 = new int[1];
        int[] nArray6 = nArray5;
        nArray5[0] = 1;
        int[] nArray7 = nArray2;
        int[] nArray8 = nArray6;
        nArray6 = nArray4;
        nArray2 = nArray;
        nArray4 = nArray8;
        nArray = nArray7;
        while (PolynomialGF2mSmallM.computeDegree(nArray) > n3) {
            PolynomialGF2mSmallM polynomialGF2mSmallM5 = this;
            int[][] nArray9 = this.div(nArray2, nArray);
            nArray2 = nArray9[1];
            int[] nArray10 = nArray9[0];
            int[] nArray11 = polynomialGF2mSmallM.coefficients;
            nArray6 = polynomialGF2mSmallM5.add(nArray6, polynomialGF2mSmallM5.modMultiply(nArray10, nArray4, nArray11));
            int[] nArray12 = nArray2;
            int[] nArray13 = nArray6;
            nArray6 = nArray4;
            nArray2 = nArray;
            nArray4 = nArray13;
            nArray = nArray12;
        }
        PolynomialGF2mSmallM[] polynomialGF2mSmallMArray = new PolynomialGF2mSmallM[2];
        polynomialGF2mSmallM = polynomialGF2mSmallM3;
        polynomialGF2mSmallM3 = new PolynomialGF2mSmallM(this.field, nArray);
        polynomialGF2mSmallMArray[0] = polynomialGF2mSmallM;
        polynomialGF2mSmallM = polynomialGF2mSmallM2;
        polynomialGF2mSmallM2 = new PolynomialGF2mSmallM(this.field, nArray4);
        polynomialGF2mSmallMArray[1] = polynomialGF2mSmallM;
        return polynomialGF2mSmallMArray;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof PolynomialGF2mSmallM) {
            object = (PolynomialGF2mSmallM)object;
            return this.field.equals(((PolynomialGF2mSmallM)object).field) && this.degree == ((PolynomialGF2mSmallM)object).degree && PolynomialGF2mSmallM.isEqual(this.coefficients, ((PolynomialGF2mSmallM)object).coefficients);
        }
        return false;
    }

    public int hashCode() {
        int n3 = this.field.hashCode();
        int n4 = 0;
        while (true) {
            int[] nArray = this.coefficients;
            if (n4 >= this.coefficients.length) break;
            n3 = n3 * 31 + nArray[n4];
            ++n4;
        }
        return n3;
    }

    public String toString() {
        String string2 = b.a(" Polynomial over ").append(this.field.toString()).append(": \n").toString();
        for (int i3 = 0; i3 < this.coefficients.length; ++i3) {
            string2 = b.a(string2).append(this.field.elementToStr(this.coefficients[i3])).append("Y^").append(i3).append("+").toString();
        }
        return i.a(string2, ";");
    }
}

