/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;

public class PolynomialRingGF2m {
    private GF2mField field;
    private PolynomialGF2mSmallM p;
    public PolynomialGF2mSmallM[] sqMatrix;
    public PolynomialGF2mSmallM[] sqRootMatrix;

    public PolynomialRingGF2m(GF2mField gF2mField, PolynomialGF2mSmallM polynomialGF2mSmallM) {
        PolynomialRingGF2m polynomialRingGF2m = this;
        polynomialRingGF2m.field = gF2mField;
        polynomialRingGF2m.p = polynomialGF2mSmallM;
        polynomialRingGF2m.computeSquaringMatrix();
        polynomialRingGF2m.computeSquareRootMatrix();
    }

    private void computeSquaringMatrix() {
        int[] nArray;
        int n3;
        int n4;
        int n5 = this.p.getDegree();
        this.sqMatrix = new PolynomialGF2mSmallM[n5];
        for (n4 = 0; n4 < (n3 = n5 >> 1); ++n4) {
            PolynomialGF2mSmallM polynomialGF2mSmallM;
            n3 = n4 << 1;
            int[] nArray2 = new int[n3 + 1];
            nArray = nArray2;
            nArray2[n3] = 1;
            PolynomialGF2mSmallM polynomialGF2mSmallM2 = polynomialGF2mSmallM;
            polynomialGF2mSmallM = new PolynomialGF2mSmallM(this.field, nArray);
            this.sqMatrix[n4] = polynomialGF2mSmallM2;
        }
        while (n3 < n5) {
            PolynomialGF2mSmallM polynomialGF2mSmallM;
            n4 = n3 << 1;
            int[] nArray3 = new int[n4 + 1];
            nArray = nArray3;
            nArray3[n4] = 1;
            PolynomialGF2mSmallM polynomialGF2mSmallM3 = polynomialGF2mSmallM;
            polynomialGF2mSmallM = new PolynomialGF2mSmallM(this.field, nArray);
            this.sqMatrix[n3] = polynomialGF2mSmallM3.mod(this.p);
            ++n3;
        }
    }

    private void computeSquareRootMatrix() {
        int n3;
        int n4;
        int n5 = this.p.getDegree();
        PolynomialGF2mSmallM[] polynomialGF2mSmallMArray = new PolynomialGF2mSmallM[n5];
        for (n4 = n3 = n5 - 1; n4 >= 0; --n4) {
            PolynomialGF2mSmallM polynomialGF2mSmallM;
            PolynomialGF2mSmallM polynomialGF2mSmallM2 = polynomialGF2mSmallM;
            polynomialGF2mSmallM = new PolynomialGF2mSmallM(this.sqMatrix[n4]);
            polynomialGF2mSmallMArray[n4] = polynomialGF2mSmallM2;
        }
        this.sqRootMatrix = new PolynomialGF2mSmallM[n5];
        while (n3 >= 0) {
            PolynomialGF2mSmallM polynomialGF2mSmallM;
            PolynomialGF2mSmallM polynomialGF2mSmallM3 = polynomialGF2mSmallM;
            polynomialGF2mSmallM = new PolynomialGF2mSmallM(this.field, n3);
            this.sqRootMatrix[n3] = polynomialGF2mSmallM3;
            --n3;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            if (polynomialGF2mSmallMArray[n3].getCoefficient(n3) == 0) {
                n4 = 0;
                for (int i3 = n3 + 1; i3 < n5; ++i3) {
                    if (polynomialGF2mSmallMArray[i3].getCoefficient(n3) == 0) continue;
                    n4 = 1;
                    PolynomialRingGF2m.swapColumns(polynomialGF2mSmallMArray, n3, i3);
                    PolynomialRingGF2m.swapColumns(this.sqRootMatrix, n3, i3);
                    i3 = n5;
                }
                if (n4 == 0) {
                    throw new ArithmeticException("Squaring matrix is not invertible.");
                }
            }
            n4 = polynomialGF2mSmallMArray[n3].getCoefficient(n3);
            n4 = this.field.inverse(n4);
            polynomialGF2mSmallMArray[n3].multThisWithElement(n4);
            this.sqRootMatrix[n3].multThisWithElement(n4);
            for (n4 = 0; n4 < n5; ++n4) {
                int n6;
                if (n4 == n3 || (n6 = polynomialGF2mSmallMArray[n4].getCoefficient(n3)) == 0) continue;
                PolynomialGF2mSmallM polynomialGF2mSmallM = polynomialGF2mSmallMArray[n3].multWithElement(n6);
                PolynomialGF2mSmallM polynomialGF2mSmallM4 = this.sqRootMatrix[n3].multWithElement(n6);
                polynomialGF2mSmallMArray[n4].addToThis(polynomialGF2mSmallM);
                this.sqRootMatrix[n4].addToThis(polynomialGF2mSmallM4);
            }
        }
    }

    private static void swapColumns(PolynomialGF2mSmallM[] object, int n3, int n4) {
        PolynomialGF2mSmallM[] polynomialGF2mSmallMArray = object;
        PolynomialGF2mSmallM[] polynomialGF2mSmallMArray2 = object;
        object = polynomialGF2mSmallMArray[n3];
        polynomialGF2mSmallMArray[n3] = polynomialGF2mSmallMArray2[n4];
        polynomialGF2mSmallMArray2[n4] = object;
    }

    public PolynomialGF2mSmallM[] getSquaringMatrix() {
        return this.sqMatrix;
    }

    public PolynomialGF2mSmallM[] getSquareRootMatrix() {
        return this.sqRootMatrix;
    }
}

