/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.BigDecimalPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.Constants;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;

public class BigIntPolynomial {
    private static final double LOG_10_2 = Math.log10(2.0);
    public BigInteger[] coeffs;

    public BigIntPolynomial(int n3) {
        this.coeffs = new BigInteger[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            this.coeffs[i3] = Constants.BIGINT_ZERO;
        }
    }

    public BigIntPolynomial(BigInteger[] bigIntegerArray) {
        this.coeffs = bigIntegerArray;
    }

    public BigIntPolynomial(IntegerPolynomial integerPolynomial) {
        this.coeffs = new BigInteger[integerPolynomial.coeffs.length];
        int n3 = 0;
        while (true) {
            BigInteger[] bigIntegerArray = this.coeffs;
            if (n3 >= this.coeffs.length) break;
            bigIntegerArray[n3] = BigInteger.valueOf(integerPolynomial.coeffs[n3]);
            ++n3;
        }
    }

    public static BigIntPolynomial generateRandomSmall(int n3, int n4, int n5) {
        BigIntPolynomial bigIntPolynomial;
        ArrayList<BigInteger> arrayList;
        ArrayList<BigInteger> arrayList2 = arrayList;
        arrayList = new ArrayList<BigInteger>();
        for (int i3 = 0; i3 < n4; ++i3) {
            arrayList2.add(Constants.BIGINT_ONE);
        }
        for (n4 = 0; n4 < n5; ++n4) {
            arrayList2.add(BigInteger.valueOf(-1L));
        }
        while (arrayList2.size() < n3) {
            arrayList2.add(Constants.BIGINT_ZERO);
        }
        Collections.shuffle(arrayList2, CryptoServicesRegistrar.getSecureRandom());
        BigIntPolynomial bigIntPolynomial2 = bigIntPolynomial;
        bigIntPolynomial = new BigIntPolynomial(n3);
        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
            bigIntPolynomial2.coeffs[n3] = (BigInteger)arrayList2.get(n3);
        }
        return bigIntPolynomial2;
    }

    private BigIntPolynomial multRecursive(BigIntPolynomial bigIntPolynomial) {
        BigIntPolynomial bigIntPolynomial2;
        BigInteger[] bigIntegerArray;
        BigIntPolynomial bigIntPolynomial3;
        BigIntPolynomial bigIntPolynomial4;
        BigIntPolynomial bigIntPolynomial5;
        Object object = this.coeffs;
        Object object2 = bigIntPolynomial.coeffs;
        int n3 = bigIntPolynomial.coeffs.length;
        if (n3 <= 1) {
            object = Arrays.clone((BigInteger[])object);
            for (int i3 = 0; i3 < this.coeffs.length; ++i3) {
                object[i3] = object[i3].multiply(bigIntPolynomial.coeffs[0]);
            }
            return new BigIntPolynomial((BigInteger[])object);
        }
        int n4 = n3 / 2;
        bigIntPolynomial = bigIntPolynomial5;
        bigIntPolynomial5 = new BigIntPolynomial(Arrays.copyOf((BigInteger[])object, n4));
        BigIntPolynomial bigIntPolynomial6 = bigIntPolynomial4;
        bigIntPolynomial4 = new BigIntPolynomial(Arrays.copyOfRange((BigInteger[])object, n4, n3));
        object = bigIntPolynomial3;
        bigIntPolynomial3 = new BigIntPolynomial(Arrays.copyOf((BigInteger[])object2, n4));
        BigInteger[] bigIntegerArray2 = bigIntegerArray;
        bigIntegerArray = new BigIntPolynomial(Arrays.copyOfRange((BigInteger[])object2, n4, n3));
        BigIntPolynomial bigIntPolynomial7 = (BigIntPolynomial)bigIntPolynomial5.clone();
        object2 = bigIntPolynomial7;
        BigIntPolynomial bigIntPolynomial8 = bigIntPolynomial;
        Object object3 = object;
        ((BigIntPolynomial)object2).add(bigIntPolynomial6);
        bigIntPolynomial = (BigIntPolynomial)((BigIntPolynomial)object3).clone();
        bigIntPolynomial.add((BigIntPolynomial)bigIntegerArray2);
        object = bigIntPolynomial8.multRecursive((BigIntPolynomial)object3);
        object2 = bigIntPolynomial6.multRecursive((BigIntPolynomial)bigIntegerArray2);
        bigIntPolynomial = bigIntPolynomial7.multRecursive(bigIntPolynomial);
        bigIntPolynomial.sub((BigIntPolynomial)object);
        bigIntPolynomial.sub((BigIntPolynomial)object2);
        bigIntPolynomial6 = bigIntPolynomial2;
        bigIntPolynomial2 = new BigIntPolynomial(n3 * 2 - 1);
        n3 = 0;
        while (true) {
            bigIntegerArray2 = ((BigIntPolynomial)object).coeffs;
            if (n3 >= ((BigIntPolynomial)object).coeffs.length) break;
            bigIntPolynomial6.coeffs[n3] = bigIntegerArray2[n3];
            ++n3;
        }
        int n5 = 0;
        while (true) {
            BigInteger[] bigIntegerArray3 = bigIntPolynomial.coeffs;
            if (n5 >= bigIntPolynomial.coeffs.length) break;
            int n6 = n4 + n5;
            bigIntPolynomial6.coeffs[n6] = bigIntPolynomial6.coeffs[n6].add(bigIntegerArray3[n5]);
            ++n5;
        }
        int n7 = 0;
        while (true) {
            BigInteger[] bigIntegerArray4 = ((BigIntPolynomial)object2).coeffs;
            if (n7 >= ((BigIntPolynomial)object2).coeffs.length) break;
            int n8 = n4 * 2 + n7;
            bigIntPolynomial6.coeffs[n8] = bigIntPolynomial6.coeffs[n8].add(bigIntegerArray4[n7]);
            ++n7;
        }
        return bigIntPolynomial6;
    }

    private BigInteger maxCoeffAbs() {
        Object object = this.coeffs[0].abs();
        int n3 = 1;
        while (true) {
            Object object2 = this.coeffs;
            if (n3 >= this.coeffs.length) break;
            if ((object2 = object2[n3].abs()).compareTo((BigInteger)object) > 0) {
                object = object2;
            }
            ++n3;
        }
        return object;
    }

    public BigIntPolynomial mult(BigIntPolynomial bigIntPolynomial) {
        int n3 = bigIntPolynomial2.coeffs.length;
        if (bigIntPolynomial.coeffs.length == n3) {
            BigIntPolynomial bigIntPolynomial2 = bigIntPolynomial2.multRecursive(bigIntPolynomial);
            if (bigIntPolynomial2.coeffs.length > n3) {
                BigInteger[] bigIntegerArray;
                int n4 = n3;
                while (true) {
                    bigIntegerArray = bigIntPolynomial2.coeffs;
                    if (n4 >= bigIntPolynomial2.coeffs.length) break;
                    int n5 = n4 - n3;
                    bigIntegerArray[n5] = bigIntegerArray[n5].add(bigIntegerArray[n4]);
                    ++n4;
                }
                bigIntPolynomial2.coeffs = Arrays.copyOf(bigIntegerArray, n3);
            }
            return bigIntPolynomial2;
        }
        throw new IllegalArgumentException("Number of coefficients must be the same");
    }

    public void add(BigIntPolynomial bigIntPolynomial, BigInteger bigInteger) {
        BigIntPolynomial bigIntPolynomial2 = this;
        bigIntPolynomial2.add(bigIntPolynomial);
        bigIntPolynomial2.mod(bigInteger);
    }

    public void add(BigIntPolynomial bigIntPolynomial) {
        BigInteger[] bigIntegerArray = bigIntPolynomial.coeffs;
        BigInteger[] bigIntegerArray2 = this.coeffs;
        if (bigIntPolynomial.coeffs.length > this.coeffs.length) {
            int n3 = bigIntegerArray2.length;
            this.coeffs = Arrays.copyOf(bigIntegerArray2, bigIntegerArray.length);
            while (true) {
                bigIntegerArray2 = this.coeffs;
                if (n3 >= this.coeffs.length) break;
                bigIntegerArray2[n3] = Constants.BIGINT_ZERO;
                ++n3;
            }
        }
        int n4 = 0;
        while (true) {
            bigIntegerArray2 = bigIntPolynomial.coeffs;
            if (n4 >= bigIntPolynomial.coeffs.length) break;
            this.coeffs[n4] = this.coeffs[n4].add(bigIntegerArray2[n4]);
            ++n4;
        }
    }

    public void sub(BigIntPolynomial bigIntPolynomial) {
        BigInteger[] bigIntegerArray = bigIntPolynomial.coeffs;
        BigInteger[] bigIntegerArray2 = this.coeffs;
        if (bigIntPolynomial.coeffs.length > this.coeffs.length) {
            int n3 = bigIntegerArray2.length;
            this.coeffs = Arrays.copyOf(bigIntegerArray2, bigIntegerArray.length);
            while (true) {
                bigIntegerArray2 = this.coeffs;
                if (n3 >= this.coeffs.length) break;
                bigIntegerArray2[n3] = Constants.BIGINT_ZERO;
                ++n3;
            }
        }
        int n4 = 0;
        while (true) {
            bigIntegerArray2 = bigIntPolynomial.coeffs;
            if (n4 >= bigIntPolynomial.coeffs.length) break;
            this.coeffs[n4] = this.coeffs[n4].subtract(bigIntegerArray2[n4]);
            ++n4;
        }
    }

    public void mult(BigInteger bigInteger) {
        int n3 = 0;
        while (true) {
            BigInteger[] bigIntegerArray = this.coeffs;
            if (n3 >= this.coeffs.length) break;
            bigIntegerArray[n3] = bigIntegerArray[n3].multiply(bigInteger);
            ++n3;
        }
    }

    public void mult(int n3) {
        this.mult(BigInteger.valueOf(n3));
    }

    public void div(BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger.add(Constants.BIGINT_ONE).divide(BigInteger.valueOf(2L));
        int n3 = 0;
        while (true) {
            BigInteger[] bigIntegerArray = this.coeffs;
            if (n3 >= this.coeffs.length) break;
            BigInteger bigInteger3 = bigIntegerArray[n3].compareTo(Constants.BIGINT_ZERO) > 0 ? this.coeffs[n3].add(bigInteger2) : this.coeffs[n3].add(bigInteger2.negate());
            bigIntegerArray[n3] = bigInteger3;
            this.coeffs[n3] = this.coeffs[n3].divide(bigInteger);
            ++n3;
        }
    }

    public BigDecimalPolynomial div(BigDecimal bigDecimal, int n3) {
        BigDecimalPolynomial bigDecimalPolynomial;
        int n4 = (int)((double)this.maxCoeffAbs().bitLength() * LOG_10_2) + 1;
        bigDecimal = Constants.BIGDEC_ONE.divide(bigDecimal, n4 + n3 + 1, 6);
        BigDecimalPolynomial bigDecimalPolynomial2 = bigDecimalPolynomial;
        bigDecimalPolynomial = new BigDecimalPolynomial(this.coeffs.length);
        for (int i3 = 0; i3 < this.coeffs.length; ++i3) {
            bigDecimalPolynomial2.coeffs[i3] = new BigDecimal(this.coeffs[i3]).multiply(bigDecimal).setScale(n3, 6);
        }
        return bigDecimalPolynomial2;
    }

    public int getMaxCoeffLength() {
        return (int)((double)this.maxCoeffAbs().bitLength() * LOG_10_2) + 1;
    }

    public void mod(BigInteger bigInteger) {
        int n3 = 0;
        while (true) {
            BigInteger[] bigIntegerArray = this.coeffs;
            if (n3 >= this.coeffs.length) break;
            bigIntegerArray[n3] = bigIntegerArray[n3].mod(bigInteger);
            ++n3;
        }
    }

    public BigInteger sumCoeffs() {
        BigInteger bigInteger = Constants.BIGINT_ZERO;
        int n3 = 0;
        while (true) {
            BigInteger[] bigIntegerArray = this.coeffs;
            if (n3 >= this.coeffs.length) break;
            bigInteger = bigInteger.add(bigIntegerArray[n3]);
            ++n3;
        }
        return bigInteger;
    }

    public Object clone() {
        return new BigIntPolynomial((BigInteger[])this.coeffs.clone());
    }

    public int hashCode() {
        return 31 + Arrays.hashCode(this.coeffs);
    }

    public boolean equals(Object object) {
        if (bigIntPolynomial2 == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (bigIntPolynomial2.getClass() != object.getClass()) {
            return false;
        }
        BigIntPolynomial bigIntPolynomial = bigIntPolynomial2;
        BigIntPolynomial bigIntPolynomial2 = (BigIntPolynomial)object;
        return Arrays.areEqual(bigIntPolynomial.coeffs, bigIntPolynomial2.coeffs);
    }

    public BigInteger[] getCoeffs() {
        return Arrays.clone(this.coeffs);
    }
}

