/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.LongPolynomial5;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.TernaryPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.util.Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class DenseTernaryPolynomial
extends IntegerPolynomial
implements TernaryPolynomial {
    public DenseTernaryPolynomial(int n3) {
        DenseTernaryPolynomial denseTernaryPolynomial = this;
        super(n3);
        denseTernaryPolynomial.checkTernarity();
    }

    public DenseTernaryPolynomial(IntegerPolynomial integerPolynomial) {
        this(integerPolynomial.coeffs);
    }

    public DenseTernaryPolynomial(int[] nArray) {
        DenseTernaryPolynomial denseTernaryPolynomial = this;
        super(nArray);
        denseTernaryPolynomial.checkTernarity();
    }

    private void checkTernarity() {
        block1: {
            int n3;
            int n4 = 0;
            while (true) {
                int[] nArray = this.coeffs;
                if (n4 == this.coeffs.length) break block1;
                n3 = nArray[n4];
                if (n3 < -1 || n3 > 1) break;
                ++n4;
            }
            throw new IllegalStateException(f.a("Illegal value: ", n3, ", must be one of {-1, 0, 1}"));
        }
    }

    public static DenseTernaryPolynomial generateRandom(int n3, int n4, int n5, SecureRandom secureRandom) {
        int[] nArray = Util.generateRandomTernary(n3, n4, n5, secureRandom);
        return new DenseTernaryPolynomial(nArray);
    }

    public static DenseTernaryPolynomial generateRandom(int n3, SecureRandom secureRandom) {
        DenseTernaryPolynomial denseTernaryPolynomial;
        DenseTernaryPolynomial denseTernaryPolynomial2 = denseTernaryPolynomial;
        denseTernaryPolynomial = new DenseTernaryPolynomial(n3);
        for (int i3 = 0; i3 < n3; ++i3) {
            denseTernaryPolynomial2.coeffs[i3] = secureRandom.nextInt(3) - 1;
        }
        return denseTernaryPolynomial2;
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial integerPolynomial, int n3) {
        if (n3 == 2048) {
            integerPolynomial = (IntegerPolynomial)integerPolynomial.clone();
            integerPolynomial.modPositive(2048);
            return new LongPolynomial5(integerPolynomial).mult(this).toIntegerPolynomial();
        }
        return super.mult(integerPolynomial, n3);
    }

    @Override
    public int[] getOnes() {
        int n3 = this.coeffs.length;
        int[] nArray = new int[n3];
        int n4 = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            if (this.coeffs[i3] != 1) continue;
            int n5 = n4 + 1;
            nArray[n4] = i3;
            n4 = n5;
        }
        return Arrays.copyOf(nArray, n4);
    }

    @Override
    public int[] getNegOnes() {
        int n3 = this.coeffs.length;
        int[] nArray = new int[n3];
        int n4 = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            if (this.coeffs[i3] != -1) continue;
            int n5 = n4 + 1;
            nArray[n4] = i3;
            n4 = n5;
        }
        return Arrays.copyOf(nArray, n4);
    }

    @Override
    public int size() {
        return this.coeffs.length;
    }
}

