/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.euclid.BigIntEuclidean;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.BigIntPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.Constants;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.LongPolynomial2;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.ModularResultant;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.Resultant;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.util.ArrayEncoder;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.util.Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

public class IntegerPolynomial
implements Polynomial {
    private static final int NUM_EQUAL_RESULTANTS = 3;
    private static final int[] PRIMES = new int[]{4507, 4513, 4517, 4519, 4523, 4547, 4549, 4561, 4567, 4583, 4591, 4597, 4603, 4621, 4637, 4639, 4643, 4649, 4651, 4657, 4663, 4673, 4679, 4691, 4703, 4721, 4723, 4729, 4733, 4751, 4759, 4783, 4787, 4789, 4793, 4799, 4801, 4813, 4817, 4831, 4861, 4871, 4877, 4889, 4903, 4909, 4919, 4931, 4933, 4937, 4943, 4951, 4957, 4967, 4969, 4973, 4987, 4993, 4999, 5003, 5009, 5011, 5021, 5023, 5039, 5051, 5059, 5077, 5081, 5087, 5099, 5101, 5107, 5113, 5119, 5147, 5153, 5167, 5171, 5179, 5189, 5197, 5209, 5227, 5231, 5233, 5237, 5261, 5273, 5279, 5281, 5297, 5303, 5309, 5323, 5333, 5347, 5351, 5381, 5387, 5393, 5399, 5407, 5413, 5417, 5419, 5431, 5437, 5441, 5443, 5449, 5471, 5477, 5479, 5483, 5501, 5503, 5507, 5519, 5521, 5527, 5531, 5557, 5563, 5569, 5573, 5581, 5591, 5623, 5639, 5641, 5647, 5651, 5653, 5657, 5659, 5669, 5683, 5689, 5693, 5701, 5711, 5717, 5737, 5741, 5743, 5749, 5779, 5783, 5791, 5801, 5807, 5813, 5821, 5827, 5839, 5843, 5849, 5851, 5857, 5861, 5867, 5869, 5879, 5881, 5897, 5903, 5923, 5927, 5939, 5953, 5981, 5987, 6007, 6011, 6029, 6037, 6043, 6047, 6053, 6067, 6073, 6079, 6089, 6091, 6101, 6113, 6121, 6131, 6133, 6143, 6151, 6163, 6173, 6197, 6199, 6203, 6211, 6217, 6221, 6229, 6247, 6257, 6263, 6269, 6271, 6277, 6287, 6299, 6301, 6311, 6317, 6323, 6329, 6337, 6343, 6353, 6359, 6361, 6367, 6373, 6379, 6389, 6397, 6421, 6427, 6449, 6451, 6469, 6473, 6481, 6491, 6521, 6529, 6547, 6551, 6553, 6563, 6569, 6571, 6577, 6581, 6599, 6607, 6619, 6637, 6653, 6659, 6661, 6673, 6679, 6689, 6691, 6701, 6703, 6709, 6719, 6733, 6737, 6761, 6763, 6779, 6781, 6791, 6793, 6803, 6823, 6827, 6829, 6833, 6841, 6857, 6863, 6869, 6871, 6883, 6899, 6907, 6911, 6917, 6947, 6949, 6959, 6961, 6967, 6971, 6977, 6983, 6991, 6997, 7001, 7013, 7019, 7027, 7039, 7043, 7057, 7069, 7079, 7103, 7109, 7121, 7127, 7129, 7151, 7159, 7177, 7187, 7193, 7207, 7211, 7213, 7219, 7229, 7237, 7243, 7247, 7253, 7283, 7297, 7307, 7309, 7321, 7331, 7333, 7349, 7351, 7369, 7393, 7411, 7417, 7433, 7451, 7457, 7459, 7477, 7481, 7487, 7489, 7499, 7507, 7517, 7523, 7529, 7537, 7541, 7547, 7549, 7559, 7561, 7573, 7577, 7583, 7589, 7591, 7603, 7607, 7621, 7639, 7643, 7649, 7669, 7673, 7681, 7687, 7691, 7699, 7703, 7717, 7723, 7727, 7741, 7753, 7757, 7759, 7789, 7793, 7817, 7823, 7829, 7841, 7853, 7867, 7873, 7877, 7879, 7883, 7901, 7907, 7919, 7927, 7933, 7937, 7949, 7951, 7963, 7993, 8009, 8011, 8017, 8039, 8053, 8059, 8069, 8081, 8087, 8089, 8093, 8101, 8111, 8117, 8123, 8147, 8161, 8167, 8171, 8179, 8191, 8209, 8219, 8221, 8231, 8233, 8237, 8243, 8263, 8269, 8273, 8287, 8291, 8293, 8297, 8311, 8317, 8329, 8353, 8363, 8369, 8377, 8387, 8389, 8419, 8423, 8429, 8431, 8443, 8447, 8461, 8467, 8501, 8513, 8521, 8527, 8537, 8539, 8543, 8563, 8573, 8581, 8597, 8599, 8609, 8623, 8627, 8629, 8641, 8647, 8663, 8669, 8677, 8681, 8689, 8693, 8699, 8707, 8713, 8719, 8731, 8737, 8741, 8747, 8753, 8761, 8779, 8783, 8803, 8807, 8819, 8821, 8831, 8837, 8839, 8849, 8861, 8863, 8867, 8887, 8893, 8923, 8929, 8933, 8941, 8951, 8963, 8969, 8971, 8999, 9001, 9007, 9011, 9013, 9029, 9041, 9043, 9049, 9059, 9067, 9091, 9103, 9109, 9127, 9133, 9137, 9151, 9157, 9161, 9173, 9181, 9187, 9199, 9203, 9209, 9221, 9227, 9239, 9241, 9257, 9277, 9281, 9283, 9293, 9311, 9319, 9323, 9337, 9341, 9343, 9349, 9371, 9377, 9391, 9397, 9403, 9413, 9419, 9421, 9431, 9433, 9437, 9439, 9461, 9463, 9467, 9473, 9479, 9491, 9497, 9511, 9521, 9533, 9539, 9547, 9551, 9587, 9601, 9613, 9619, 9623, 9629, 9631, 9643, 9649, 9661, 9677, 9679, 9689, 9697, 9719, 9721, 9733, 9739, 9743, 9749, 9767, 9769, 9781, 9787, 9791, 9803, 9811, 9817, 9829, 9833, 9839, 9851, 9857, 9859, 9871, 9883, 9887, 9901, 9907, 9923, 9929, 9931, 9941, 9949, 9967, 9973};
    private static final List BIGINT_PRIMES = new ArrayList();
    public int[] coeffs;

    public IntegerPolynomial(int n3) {
        this.coeffs = new int[n3];
    }

    public IntegerPolynomial(int[] nArray) {
        this.coeffs = nArray;
    }

    public IntegerPolynomial(BigIntPolynomial bigIntPolynomial) {
        this.coeffs = new int[bigIntPolynomial.coeffs.length];
        int n3 = 0;
        while (true) {
            BigInteger[] bigIntegerArray = bigIntPolynomial.coeffs;
            if (n3 >= bigIntPolynomial.coeffs.length) break;
            this.coeffs[n3] = bigIntegerArray[n3].intValue();
            ++n3;
        }
    }

    public static IntegerPolynomial fromBinary3Sves(byte[] byArray, int n3) {
        return new IntegerPolynomial(ArrayEncoder.decodeMod3Sves(byArray, n3));
    }

    public static IntegerPolynomial fromBinary3Tight(byte[] byArray, int n3) {
        return new IntegerPolynomial(ArrayEncoder.decodeMod3Tight(byArray, n3));
    }

    public static IntegerPolynomial fromBinary3Tight(InputStream inputStream, int n3) {
        return new IntegerPolynomial(ArrayEncoder.decodeMod3Tight(inputStream, n3));
    }

    public static IntegerPolynomial fromBinary(byte[] byArray, int n3, int n4) {
        return new IntegerPolynomial(ArrayEncoder.decodeModQ(byArray, n3, n4));
    }

    public static IntegerPolynomial fromBinary(InputStream inputStream, int n3, int n4) {
        return new IntegerPolynomial(ArrayEncoder.decodeModQ(inputStream, n3, n4));
    }

    private IntegerPolynomial multRecursive(IntegerPolynomial object) {
        IntegerPolynomial integerPolynomial;
        IntegerPolynomial integerPolynomial2;
        IntegerPolynomial integerPolynomial3;
        IntegerPolynomial integerPolynomial4;
        IntegerPolynomial integerPolynomial5;
        Object object2 = ((IntegerPolynomial)object2).coeffs;
        object = ((IntegerPolynomial)object).coeffs;
        int n3 = ((IntegerPolynomial)object).coeffs.length;
        if (n3 <= 32) {
            IntegerPolynomial integerPolynomial6;
            int n4 = n3 * 2 - 1;
            IntegerPolynomial integerPolynomial7 = integerPolynomial6;
            integerPolynomial6 = new IntegerPolynomial(new int[n4]);
            for (int i3 = 0; i3 < n4; ++i3) {
                for (int i4 = Math.max(0, i3 - n3 + 1); i4 <= Math.min(i3, n3 - 1); ++i4) {
                    int[] nArray = integerPolynomial7.coeffs;
                    int n5 = nArray[i3];
                    integerPolynomial7.coeffs[i3] = (int)(object[i4] * object2[i3 - i4] + n5);
                }
            }
            return integerPolynomial7;
        }
        int n6 = n3 / 2;
        IntegerPolynomial integerPolynomial8 = integerPolynomial5;
        integerPolynomial5 = new IntegerPolynomial(Arrays.copyOf((int[])object2, n6));
        IntegerPolynomial integerPolynomial9 = integerPolynomial4;
        integerPolynomial4 = new IntegerPolynomial(Arrays.copyOfRange((int[])object2, n6, n3));
        object2 = integerPolynomial3;
        integerPolynomial3 = new IntegerPolynomial(Arrays.copyOf((int[])object, n6));
        Object object3 = integerPolynomial2;
        integerPolynomial2 = new IntegerPolynomial(Arrays.copyOfRange((int[])object, n6, n3));
        IntegerPolynomial integerPolynomial10 = (IntegerPolynomial)integerPolynomial5.clone();
        object = integerPolynomial10;
        Object object4 = object2;
        ((IntegerPolynomial)object).add(integerPolynomial9);
        object2 = (IntegerPolynomial)((IntegerPolynomial)object4).clone();
        ((IntegerPolynomial)object2).add((IntegerPolynomial)object3);
        object = integerPolynomial8.multRecursive((IntegerPolynomial)object4);
        integerPolynomial8 = integerPolynomial9.multRecursive((IntegerPolynomial)object3);
        object2 = integerPolynomial10.multRecursive((IntegerPolynomial)object2);
        ((IntegerPolynomial)object2).sub((IntegerPolynomial)object);
        ((IntegerPolynomial)object2).sub(integerPolynomial8);
        integerPolynomial9 = integerPolynomial;
        integerPolynomial = new IntegerPolynomial(n3 * 2 - 1);
        n3 = 0;
        while (true) {
            object3 = ((IntegerPolynomial)object).coeffs;
            if (n3 >= ((IntegerPolynomial)object).coeffs.length) break;
            integerPolynomial9.coeffs[n3] = (int)object3[n3];
            ++n3;
        }
        int n7 = 0;
        while (true) {
            int[] nArray = ((IntegerPolynomial)object2).coeffs;
            if (n7 >= ((IntegerPolynomial)object2).coeffs.length) break;
            int n8 = n6 + n7;
            integerPolynomial9.coeffs[n8] = integerPolynomial9.coeffs[n8] + nArray[n7];
            ++n7;
        }
        int n9 = 0;
        while (true) {
            int[] nArray = integerPolynomial8.coeffs;
            if (n9 >= integerPolynomial8.coeffs.length) break;
            int n10 = n6 * 2 + n9;
            integerPolynomial9.coeffs[n10] = integerPolynomial9.coeffs[n10] + nArray[n9];
            ++n9;
        }
        return integerPolynomial9;
    }

    private IntegerPolynomial mod2ToModq(IntegerPolynomial integerPolynomial, int n3) {
        if (Util.is64BitJVM() && n3 == 2048) {
            LongPolynomial2 longPolynomial2;
            LongPolynomial2 longPolynomial22;
            LongPolynomial2 longPolynomial23 = longPolynomial22;
            longPolynomial22 = new LongPolynomial2((IntegerPolynomial)object);
            Object object = longPolynomial2;
            longPolynomial2 = new LongPolynomial2(integerPolynomial);
            int n4 = 2;
            while (n4 < n3) {
                LongPolynomial2 longPolynomial24 = (LongPolynomial2)((LongPolynomial2)object).clone();
                int n5 = (n4 *= 2) - 1;
                longPolynomial24.mult2And(n5);
                longPolynomial24.subAnd(longPolynomial23.mult((LongPolynomial2)object).mult((LongPolynomial2)object), n5);
                object = longPolynomial24;
            }
            return ((LongPolynomial2)object).toIntegerPolynomial();
        }
        int n6 = 2;
        while (n6 < n3) {
            IntegerPolynomial integerPolynomial2;
            IntegerPolynomial integerPolynomial3 = integerPolynomial2;
            integerPolynomial3(Arrays.copyOf(integerPolynomial.coeffs, integerPolynomial.coeffs.length));
            integerPolynomial3.mult2(n6 *= 2);
            integerPolynomial2.sub(((IntegerPolynomial)object).mult(integerPolynomial, n6).mult(integerPolynomial, n6), n6);
            integerPolynomial = integerPolynomial3;
        }
        return integerPolynomial;
    }

    private void multShiftSub(IntegerPolynomial integerPolynomial, int n3, int n4, int n5) {
        int n6 = this.coeffs.length;
        for (int i3 = n4; i3 < n6; ++i3) {
            this.coeffs[i3] = (this.coeffs[i3] - integerPolynomial.coeffs[i3 - n4] * n3) % n5;
        }
    }

    private BigInteger squareSum() {
        BigInteger bigInteger = Constants.BIGINT_ZERO;
        int n3 = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n3 >= this.coeffs.length) break;
            int n4 = nArray[n3];
            bigInteger = bigInteger.add(BigInteger.valueOf(n4 * n4));
            ++n3;
        }
        return bigInteger;
    }

    private void mult2(int n3) {
        int n4 = 0;
        while (true) {
            int n5;
            int[] nArray = this.coeffs;
            if (n4 >= this.coeffs.length) break;
            nArray[n4] = n5 = nArray[n4] * 2;
            nArray[n4] = n5 % n3;
            ++n4;
        }
    }

    private void sort(int[] nArray) {
        boolean bl = true;
        while (bl) {
            bl = false;
            int n3 = 0;
            while (n3 != nArray.length - 1) {
                int n4 = nArray[n3];
                int n5 = n3 + 1;
                int n6 = nArray[n5];
                if (n4 > n6) {
                    nArray[n3] = n6;
                    nArray[n5] = n4;
                    bl = true;
                }
                n3 = n5;
            }
        }
    }

    private boolean equalsZero() {
        int n3 = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n3 >= this.coeffs.length) break;
            if (nArray[n3] != 0) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private boolean equalsAbsOne() {
        int[] nArray;
        int n3 = 1;
        while (true) {
            nArray = this.coeffs;
            if (n3 >= this.coeffs.length) break;
            if (nArray[n3] != 0) {
                return false;
            }
            ++n3;
        }
        return Math.abs(nArray[0]) == 1;
    }

    static {
        int n3 = 0;
        while (true) {
            int[] nArray = PRIMES;
            if (n3 == PRIMES.length) break;
            BIGINT_PRIMES.add(BigInteger.valueOf(nArray[n3]));
            ++n3;
        }
    }

    public byte[] toBinary3Sves() {
        return ArrayEncoder.encodeMod3Sves(this.coeffs);
    }

    public byte[] toBinary3Tight() {
        Object object = Constants.BIGINT_ZERO;
        for (int i3 = this.coeffs.length - 1; i3 >= 0; --i3) {
            object = ((BigInteger)object).multiply(BigInteger.valueOf(3L)).add(BigInteger.valueOf(this.coeffs[i3] + 1));
        }
        int n3 = (BigInteger.valueOf(3L).pow(this.coeffs.length).bitLength() + 7) / 8;
        byte[] byArray = ((BigInteger)object).toByteArray();
        object = byArray;
        if (byArray.length < n3) {
            byte[] byArray2 = new byte[n3];
            Object object2 = object;
            int n4 = ((Object)object2).length;
            System.arraycopy(object2, 0, byArray2, n3 -= ((Object)object).length, n4);
            return byArray2;
        }
        if (((Object)object).length > n3) {
            Object object3 = object;
            object = Arrays.copyOfRange((byte[])object3, 1, ((Object)object3).length);
        }
        return object;
    }

    public byte[] toBinary(int n3) {
        return ArrayEncoder.encodeModQ(this.coeffs, n3);
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial integerPolynomial, int n3) {
        IntegerPolynomial integerPolynomial2 = this.mult(integerPolynomial);
        integerPolynomial2.mod(n3);
        return integerPolynomial2;
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial integerPolynomial) {
        int n3 = integerPolynomial2.coeffs.length;
        if (integerPolynomial.coeffs.length == n3) {
            IntegerPolynomial integerPolynomial2 = integerPolynomial2.multRecursive(integerPolynomial);
            if (integerPolynomial2.coeffs.length > n3) {
                int[] nArray;
                int n4 = n3;
                while (true) {
                    nArray = integerPolynomial2.coeffs;
                    if (n4 >= integerPolynomial2.coeffs.length) break;
                    int n5 = n4 - n3;
                    nArray[n5] = nArray[n5] + nArray[n4];
                    ++n4;
                }
                integerPolynomial2.coeffs = Arrays.copyOf(nArray, n3);
            }
            return integerPolynomial2;
        }
        throw new IllegalArgumentException("Number of coefficients must be the same");
    }

    @Override
    public BigIntPolynomial mult(BigIntPolynomial bigIntPolynomial) {
        return new BigIntPolynomial(this).mult(bigIntPolynomial);
    }

    public IntegerPolynomial invertFq(int n3) {
        IntegerPolynomial integerPolynomial;
        IntegerPolynomial integerPolynomial2;
        IntegerPolynomial integerPolynomial3;
        IntegerPolynomial integerPolynomial4;
        int n4 = this.coeffs.length;
        int n5 = 0;
        IntegerPolynomial integerPolynomial5 = integerPolynomial4;
        int n6 = n4 + 1;
        new IntegerPolynomial((int)n6).coeffs[0] = 1;
        IntegerPolynomial integerPolynomial6 = integerPolynomial3;
        integerPolynomial3 = new IntegerPolynomial(n6);
        IntegerPolynomial integerPolynomial7 = integerPolynomial2;
        integerPolynomial7(n6);
        integerPolynomial2.coeffs = Arrays.copyOf(this.coeffs, n6);
        integerPolynomial2.modPositive(2);
        IntegerPolynomial integerPolynomial8 = integerPolynomial;
        new IntegerPolynomial((int)n6).coeffs[0] = 1;
        new IntegerPolynomial((int)n6).coeffs[n4] = 1;
        while (true) {
            if (integerPolynomial7.coeffs[0] == 0) {
                for (int i3 = 1; i3 <= n4; ++i3) {
                    int n7 = i3;
                    int n8 = n7 - 1;
                    integerPolynomial7.coeffs[n8] = integerPolynomial7.coeffs[n7];
                    n8 = n6 - i3;
                    integerPolynomial6.coeffs[n8] = integerPolynomial6.coeffs[n4 - i3];
                }
                integerPolynomial7.coeffs[n4] = 0;
                integerPolynomial6.coeffs[0] = 0;
                ++n5;
                if (!integerPolynomial7.equalsZero()) continue;
                return null;
            }
            if (integerPolynomial7.equalsOne()) {
                IntegerPolynomial integerPolynomial9;
                if (integerPolynomial5.coeffs[n4] != 0) {
                    return null;
                }
                IntegerPolynomial integerPolynomial10 = integerPolynomial9;
                integerPolynomial9 = new IntegerPolynomial(n4);
                n6 = n5 % n4;
                for (int i4 = n4 - 1; i4 >= 0; --i4) {
                    int n9 = i4 - n6;
                    if (n9 < 0) {
                        n9 += n4;
                    }
                    integerPolynomial10.coeffs[n9] = integerPolynomial5.coeffs[i4];
                }
                return this.mod2ToModq(integerPolynomial10, n3);
            }
            if (integerPolynomial7.degree() < integerPolynomial8.degree()) {
                IntegerPolynomial integerPolynomial11 = integerPolynomial8;
                IntegerPolynomial integerPolynomial12 = integerPolynomial6;
                integerPolynomial6 = integerPolynomial5;
                integerPolynomial5 = integerPolynomial12;
                integerPolynomial8 = integerPolynomial7;
                integerPolynomial7 = integerPolynomial11;
            }
            integerPolynomial7.add(integerPolynomial8, 2);
            integerPolynomial5.add(integerPolynomial6, 2);
        }
    }

    public IntegerPolynomial invertF3() {
        IntegerPolynomial integerPolynomial;
        IntegerPolynomial integerPolynomial2;
        IntegerPolynomial integerPolynomial3;
        IntegerPolynomial integerPolynomial4;
        int n3 = integerPolynomial8.coeffs.length;
        int n4 = 0;
        IntegerPolynomial integerPolynomial5 = integerPolynomial4;
        int n5 = n3 + 1;
        new IntegerPolynomial((int)n5).coeffs[0] = 1;
        IntegerPolynomial integerPolynomial6 = integerPolynomial3;
        integerPolynomial3 = new IntegerPolynomial(n5);
        IntegerPolynomial integerPolynomial7 = integerPolynomial2;
        integerPolynomial7(n5);
        integerPolynomial2.coeffs = Arrays.copyOf(integerPolynomial8.coeffs, n5);
        integerPolynomial2.modPositive(3);
        IntegerPolynomial integerPolynomial8 = integerPolynomial;
        new IntegerPolynomial((int)n5).coeffs[0] = -1;
        new IntegerPolynomial((int)n5).coeffs[n3] = 1;
        while (true) {
            if (integerPolynomial7.coeffs[0] == 0) {
                for (int i3 = 1; i3 <= n3; ++i3) {
                    int n6 = i3;
                    int n7 = n6 - 1;
                    integerPolynomial7.coeffs[n7] = integerPolynomial7.coeffs[n6];
                    n7 = n5 - i3;
                    integerPolynomial6.coeffs[n7] = integerPolynomial6.coeffs[n3 - i3];
                }
                integerPolynomial7.coeffs[n3] = 0;
                integerPolynomial6.coeffs[0] = 0;
                ++n4;
                if (!integerPolynomial7.equalsZero()) continue;
                return null;
            }
            if (integerPolynomial7.equalsAbsOne()) {
                IntegerPolynomial integerPolynomial9;
                if (integerPolynomial5.coeffs[n3] != 0) {
                    return null;
                }
                integerPolynomial8 = integerPolynomial9;
                integerPolynomial9 = new IntegerPolynomial(n3);
                n4 %= n3;
                for (n5 = n3 - 1; n5 >= 0; --n5) {
                    int n8 = n5 - n4;
                    if (n8 < 0) {
                        n8 += n3;
                    }
                    integerPolynomial8.coeffs[n8] = integerPolynomial7.coeffs[0] * integerPolynomial5.coeffs[n5];
                }
                IntegerPolynomial integerPolynomial10 = integerPolynomial8;
                integerPolynomial10.ensurePositive(3);
                return integerPolynomial10;
            }
            if (integerPolynomial7.degree() < integerPolynomial8.degree()) {
                IntegerPolynomial integerPolynomial11 = integerPolynomial8;
                IntegerPolynomial integerPolynomial12 = integerPolynomial6;
                integerPolynomial6 = integerPolynomial5;
                integerPolynomial5 = integerPolynomial12;
                integerPolynomial8 = integerPolynomial7;
                integerPolynomial7 = integerPolynomial11;
            }
            if (integerPolynomial7.coeffs[0] == integerPolynomial8.coeffs[0]) {
                integerPolynomial7.sub(integerPolynomial8, 3);
                integerPolynomial5.sub(integerPolynomial6, 3);
                continue;
            }
            integerPolynomial7.add(integerPolynomial8, 3);
            integerPolynomial5.add(integerPolynomial6, 3);
        }
    }

    public Resultant resultant() {
        PrimeGenerator primeGenerator;
        LinkedList<ModularResultant> linkedList;
        int n3 = ((IntegerPolynomial)((Object)bigIntPolynomial)).coeffs.length;
        Serializable serializable = linkedList;
        linkedList = new LinkedList<ModularResultant>();
        BigInteger bigInteger = Constants.BIGINT_ONE;
        int n4 = 1;
        PrimeGenerator primeGenerator2 = primeGenerator;
        primeGenerator = (IntegerPolynomial)((Object)bigIntPolynomial).new PrimeGenerator(null);
        int n5 = n4;
        BigInteger bigInteger2 = bigInteger;
        while (true) {
            int n6;
            BigInteger bigInteger3 = primeGenerator2.nextPrime();
            BigInteger bigInteger4 = bigInteger;
            ModularResultant modularResultant = ((IntegerPolynomial)((Object)bigIntPolynomial)).resultant(bigInteger3.intValue());
            serializable.add(modularResultant);
            BigInteger bigInteger5 = bigInteger4.multiply(bigInteger3);
            BigIntEuclidean bigIntEuclidean = BigIntEuclidean.calculate(bigInteger3, bigInteger4);
            bigInteger = bigInteger2.multiply(bigIntEuclidean.x.multiply(bigInteger3)).add(modularResultant.res.multiply(bigIntEuclidean.y.multiply(bigInteger))).mod(bigInteger5);
            BigInteger bigInteger6 = bigInteger5.divide(BigInteger.valueOf(2L));
            bigInteger3 = bigInteger6.negate();
            if (bigInteger.compareTo(bigInteger6) > 0) {
                bigInteger = bigInteger.subtract(bigInteger5);
            } else if (bigInteger.compareTo(bigInteger3) < 0) {
                bigInteger = bigInteger.add(bigInteger5);
            }
            if (bigInteger.equals(bigInteger2)) {
                n6 = n5 + 1;
                if (n6 >= 3) {
                    while (serializable.size() > 1) {
                        LinkedList<ModularResultant> linkedList2 = serializable;
                        linkedList2.addLast(ModularResultant.combineRho((ModularResultant)linkedList2.removeFirst(), (ModularResultant)serializable.removeFirst()));
                    }
                    BigIntPolynomial bigIntPolynomial = ((ModularResultant)serializable.getFirst()).rho;
                    serializable = bigInteger5.divide(BigInteger.valueOf(2L));
                    BigInteger bigInteger7 = ((BigInteger)serializable).negate();
                    if (bigInteger.compareTo((BigInteger)serializable) > 0) {
                        bigInteger = bigInteger.subtract(bigInteger5);
                    }
                    if (bigInteger.compareTo(bigInteger7) < 0) {
                        bigInteger = bigInteger.add(bigInteger5);
                    }
                    for (int i3 = 0; i3 < n3; ++i3) {
                        BigInteger bigInteger8 = bigIntPolynomial.coeffs[i3];
                        if (bigInteger8.compareTo((BigInteger)serializable) > 0) {
                            bigIntPolynomial.coeffs[i3] = bigInteger8.subtract(bigInteger5);
                        }
                        if (bigInteger8.compareTo(bigInteger7) >= 0) continue;
                        bigIntPolynomial.coeffs[i3] = bigInteger8.add(bigInteger5);
                    }
                    return new Resultant(bigIntPolynomial, bigInteger);
                }
            } else {
                n6 = 1;
            }
            n5 = n6;
            bigInteger2 = bigInteger;
            bigInteger = bigInteger5;
        }
    }

    public Resultant resultantMultiThread() {
        LinkedBlockingQueue<Future<ModularResultant>> linkedBlockingQueue;
        IntegerPolynomial integerPolynomial = object7;
        int n3 = integerPolynomial.coeffs.length;
        Object object = integerPolynomial.squareSum().pow((n3 + 1) / 2).multiply(BigInteger.valueOf(2L).pow((((IntegerPolynomial)object7).degree() + 1) / 2)).multiply(BigInteger.valueOf(2L));
        Object object2 = BigInteger.valueOf(10000L);
        BigInteger bigInteger = Constants.BIGINT_ONE;
        Serializable serializable = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Future<ModularResultant>>();
        Object object3 = BIGINT_PRIMES.iterator();
        Object object4 = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        while (bigInteger.compareTo((BigInteger)object) < 0) {
            object2 = object3.hasNext() ? (BigInteger)object3.next() : ((BigInteger)object2).nextProbablePrime();
            ((AbstractCollection)((Object)serializable)).add(object4.submit((IntegerPolynomial)object7.new ModResultantTask(((BigInteger)object2).intValue(), null)));
            bigInteger = bigInteger.multiply((BigInteger)object2);
        }
        object = null;
        while (!serializable.isEmpty()) {
            CombineTask combineTask;
            block12: {
                LinkedBlockingQueue<Future<ModularResultant>> linkedBlockingQueue2;
                try {
                    LinkedBlockingQueue<Future<ModularResultant>> linkedBlockingQueue3 = serializable;
                    linkedBlockingQueue2 = linkedBlockingQueue3;
                    object2 = (Future)linkedBlockingQueue3.take();
                }
                catch (Exception exception) {
                    throw new IllegalStateException(((Object)exception).toString());
                }
                object3 = (Future)linkedBlockingQueue2.poll();
                if (object3 != null) break block12;
                object = (ModularResultant)object2.get();
                break;
            }
            LinkedBlockingQueue<Future<ModularResultant>> linkedBlockingQueue4 = serializable;
            ExecutorService executorService = object4;
            CombineTask combineTask2 = combineTask;
            CombineTask combineTask3 = combineTask;
            Object object5 = object7;
            Object object6 = object3;
            object2 = (ModularResultant)object2.get();
            combineTask2((ModularResultant)object2, (ModularResultant)object6.get(), null);
            ((AbstractCollection)linkedBlockingQueue4).add(executorService.submit(combineTask3));
        }
        object4.shutdown();
        Object object7 = ((Resultant)object).res;
        object = ((Resultant)object).rho;
        object2 = bigInteger.divide(BigInteger.valueOf(2L));
        serializable = ((BigInteger)object2).negate();
        if (((BigInteger)object7).compareTo((BigInteger)object2) > 0) {
            object7 = ((BigInteger)object7).subtract(bigInteger);
        }
        if (((BigInteger)object7).compareTo((BigInteger)serializable) < 0) {
            object7 = ((BigInteger)object7).add(bigInteger);
        }
        for (int i3 = 0; i3 < n3; ++i3) {
            object4 = ((BigIntPolynomial)object).coeffs[i3];
            if (((BigInteger)object4).compareTo((BigInteger)object2) > 0) {
                ((BigIntPolynomial)object).coeffs[i3] = ((BigInteger)object4).subtract(bigInteger);
            }
            if (((BigInteger)object4).compareTo((BigInteger)serializable) >= 0) continue;
            ((BigIntPolynomial)object).coeffs[i3] = ((BigInteger)object4).add(bigInteger);
        }
        return new Resultant((BigIntPolynomial)object, (BigInteger)object7);
    }

    public ModularResultant resultant(int n3) {
        BigIntPolynomial bigIntPolynomial;
        int n4;
        IntegerPolynomial integerPolynomial;
        IntegerPolynomial integerPolynomial2;
        IntegerPolynomial integerPolynomial3;
        IntegerPolynomial integerPolynomial4;
        IntegerPolynomial integerPolynomial5;
        int[] nArray = Arrays.copyOf(((IntegerPolynomial)object).coeffs, ((IntegerPolynomial)object).coeffs.length + 1);
        Object object = nArray;
        IntegerPolynomial integerPolynomial6 = integerPolynomial5;
        integerPolynomial5 = new IntegerPolynomial((int[])object);
        int n5 = nArray.length;
        Object object2 = integerPolynomial4;
        new IntegerPolynomial((int)n5).coeffs[0] = -1;
        int n6 = n5 - 1;
        new IntegerPolynomial((int)n5).coeffs[n6] = 1;
        IntegerPolynomial integerPolynomial7 = integerPolynomial3;
        integerPolynomial6 = integerPolynomial2;
        integerPolynomial2 = new IntegerPolynomial(n5);
        IntegerPolynomial integerPolynomial8 = integerPolynomial;
        new IntegerPolynomial((int)n5).coeffs[0] = 1;
        n5 = new IntegerPolynomial(integerPolynomial6.coeffs).degree();
        int n7 = n4 = 1;
        n4 = n6;
        IntegerPolynomial integerPolynomial9 = integerPolynomial6;
        Object object3 = object2;
        integerPolynomial6 = integerPolynomial8;
        int n8 = n6;
        object2 = integerPolynomial7;
        int n9 = n7;
        int n10 = n5;
        while (n10 > 0) {
            int n11 = n8;
            n8 = Util.invert(((IntegerPolynomial)object2).coeffs[n10], n3) * ((IntegerPolynomial)object3).coeffs[n8] % n3;
            int n12 = n11 - n10;
            ((IntegerPolynomial)object3).multShiftSub((IntegerPolynomial)object2, n8, n12, n3);
            integerPolynomial9.multShiftSub(integerPolynomial6, n8, n12, n3);
            n8 = ((IntegerPolynomial)object3).degree();
            if (n8 >= n10) continue;
            int n13 = n4;
            n4 = Util.pow(((IntegerPolynomial)object2).coeffs[n10], n4 - n8, n3) * n9 % n3;
            if (n13 % 2 == 1 && n10 % 2 == 1) {
                n4 = -n4 % n3;
            }
            int n14 = n8;
            int n15 = n4;
            IntegerPolynomial integerPolynomial10 = object3;
            IntegerPolynomial integerPolynomial11 = integerPolynomial9;
            n4 = n10;
            integerPolynomial9 = integerPolynomial6;
            object3 = object2;
            integerPolynomial6 = integerPolynomial11;
            n8 = n10;
            object2 = integerPolynomial10;
            n9 = n15;
            n10 = n14;
        }
        IntegerPolynomial integerPolynomial12 = integerPolynomial6;
        IntegerPolynomial integerPolynomial13 = integerPolynomial6;
        IntegerPolynomial integerPolynomial14 = object2;
        int n16 = Util.pow(integerPolynomial14.coeffs[0], n8, n3) * n9 % n3;
        integerPolynomial6.mult(Util.invert(integerPolynomial14.coeffs[0], n3));
        integerPolynomial13.mod(n3);
        integerPolynomial13.mult(n16);
        integerPolynomial12.mod(n3);
        integerPolynomial12.coeffs = Arrays.copyOf(integerPolynomial12.coeffs, integerPolynomial12.coeffs.length - 1);
        object2 = bigIntPolynomial;
        ((BigIntPolynomial)object2)(integerPolynomial6);
        BigInteger bigInteger = BigInteger.valueOf(n16);
        return new ModularResultant(bigIntPolynomial, bigInteger, BigInteger.valueOf(n3));
    }

    public int degree() {
        int n3;
        for (n3 = this.coeffs.length - 1; n3 > 0 && this.coeffs[n3] == 0; --n3) {
        }
        return n3;
    }

    public void add(IntegerPolynomial integerPolynomial, int n3) {
        IntegerPolynomial integerPolynomial2 = this;
        integerPolynomial2.add(integerPolynomial);
        integerPolynomial2.mod(n3);
    }

    public void add(IntegerPolynomial integerPolynomial) {
        int[] nArray = integerPolynomial.coeffs;
        int[] nArray2 = this.coeffs;
        if (integerPolynomial.coeffs.length > this.coeffs.length) {
            this.coeffs = Arrays.copyOf(nArray2, nArray.length);
        }
        int n3 = 0;
        while (true) {
            nArray2 = integerPolynomial.coeffs;
            if (n3 >= integerPolynomial.coeffs.length) break;
            this.coeffs[n3] = this.coeffs[n3] + nArray2[n3];
            ++n3;
        }
    }

    public void sub(IntegerPolynomial integerPolynomial, int n3) {
        IntegerPolynomial integerPolynomial2 = this;
        integerPolynomial2.sub(integerPolynomial);
        integerPolynomial2.mod(n3);
    }

    public void sub(IntegerPolynomial integerPolynomial) {
        int[] nArray = integerPolynomial.coeffs;
        int[] nArray2 = this.coeffs;
        if (integerPolynomial.coeffs.length > this.coeffs.length) {
            this.coeffs = Arrays.copyOf(nArray2, nArray.length);
        }
        int n3 = 0;
        while (true) {
            nArray2 = integerPolynomial.coeffs;
            if (n3 >= integerPolynomial.coeffs.length) break;
            this.coeffs[n3] = this.coeffs[n3] - nArray2[n3];
            ++n3;
        }
    }

    public void sub(int n3) {
        int n4 = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n4 >= this.coeffs.length) break;
            nArray[n4] = nArray[n4] - n3;
            ++n4;
        }
    }

    public void mult(int n3) {
        int n4 = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n4 >= this.coeffs.length) break;
            nArray[n4] = nArray[n4] * n3;
            ++n4;
        }
    }

    public void mult3(int n3) {
        int n4 = 0;
        while (true) {
            int n5;
            int[] nArray = this.coeffs;
            if (n4 >= this.coeffs.length) break;
            nArray[n4] = n5 = nArray[n4] * 3;
            nArray[n4] = n5 % n3;
            ++n4;
        }
    }

    public void div(int n3) {
        int n4 = (n3 + 1) / 2;
        int n5 = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n5 >= this.coeffs.length) break;
            int n6 = nArray[n5];
            int n7 = n6 > 0 ? n4 : -n4;
            nArray[n5] = n6 += n7;
            nArray[n5] = n6 / n3;
            ++n5;
        }
    }

    public void mod3() {
        int n3 = 0;
        while (true) {
            int n4;
            int[] nArray = this.coeffs;
            if (n3 >= this.coeffs.length) break;
            nArray[n3] = n4 = nArray[n3] % 3;
            if (n4 > 1) {
                nArray[n3] = n4 - 3;
            }
            if ((n4 = nArray[n3]) < -1) {
                nArray[n3] = n4 + 3;
            }
            ++n3;
        }
    }

    public void modPositive(int n3) {
        IntegerPolynomial integerPolynomial = this;
        integerPolynomial.mod(n3);
        integerPolynomial.ensurePositive(n3);
    }

    public void modCenter(int n3) {
        this.mod(n3);
        block0: for (int i3 = 0; i3 < this.coeffs.length; ++i3) {
            int n4;
            int n5;
            int[] nArray;
            while (true) {
                nArray = this.coeffs;
                n5 = this.coeffs[i3];
                n4 = n3 / 2;
                if (n5 >= n4) break;
                nArray[i3] = n5 + n3;
            }
            while (true) {
                nArray = this.coeffs;
                n5 = this.coeffs[i3];
                if (n5 < n4) continue block0;
                nArray[i3] = n5 - n3;
            }
        }
    }

    public void mod(int n3) {
        int n4 = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n4 >= this.coeffs.length) break;
            nArray[n4] = nArray[n4] % n3;
            ++n4;
        }
    }

    public void ensurePositive(int n3) {
        block0: for (int i3 = 0; i3 < this.coeffs.length; ++i3) {
            while (true) {
                int[] nArray = this.coeffs;
                int n4 = this.coeffs[i3];
                if (n4 >= 0) continue block0;
                nArray[i3] = n4 + n3;
            }
        }
    }

    public long centeredNormSq(int n3) {
        IntegerPolynomial integerPolynomial = this;
        int n4 = integerPolynomial.coeffs.length;
        IntegerPolynomial integerPolynomial2 = (IntegerPolynomial)integerPolynomial.clone();
        integerPolynomial2.shiftGap(n3);
        long l3 = 0L;
        long l4 = 0L;
        n3 = 0;
        while (true) {
            int[] nArray = integerPolynomial2.coeffs;
            if (n3 == integerPolynomial2.coeffs.length) break;
            int n5 = nArray[n3];
            l3 += (long)n5;
            l4 += (long)(n5 * n5);
            ++n3;
        }
        long l5 = l3;
        return l4 - l5 * l5 / (long)n4;
    }

    public void shiftGap(int n3) {
        IntegerPolynomial integerPolynomial = this;
        integerPolynomial.modCenter(n3);
        int[] nArray = Arrays.clone(integerPolynomial.coeffs);
        integerPolynomial.sort(nArray);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < nArray.length - 1) {
            int n7 = n6 + 1;
            int n8 = nArray[n7] - (n6 = nArray[n6]);
            if (n8 > n4) {
                n5 = n6;
                n4 = n8;
            }
            n6 = n7;
        }
        n6 = nArray[nArray.length - 1];
        int n9 = nArray[0];
        if (n3 - n6 + n9 > n4) {
            n3 = (n6 + n9) / 2;
        } else {
            int n10 = n3;
            n3 = n4 / 2 + n5;
            n3 = n10 / 2 + n3;
        }
        this.sub(n3);
    }

    public void center0(int n3) {
        block0: for (int i3 = 0; i3 < this.coeffs.length; ++i3) {
            int n4;
            int[] nArray;
            while (true) {
                nArray = this.coeffs;
                n4 = this.coeffs[i3];
                if (n4 >= -n3 / 2) break;
                nArray[i3] = n4 + n3;
            }
            while (true) {
                nArray = this.coeffs;
                n4 = this.coeffs[i3];
                if (n4 <= n3 / 2) continue block0;
                nArray[i3] = n4 - n3;
            }
        }
    }

    public int sumCoeffs() {
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n4 >= this.coeffs.length) break;
            n3 += nArray[n4];
            ++n4;
        }
        return n3;
    }

    public boolean equalsOne() {
        int[] nArray;
        int n3 = 1;
        while (true) {
            nArray = this.coeffs;
            if (n3 >= this.coeffs.length) break;
            if (nArray[n3] != 0) {
                return false;
            }
            ++n3;
        }
        return nArray[0] == 1;
    }

    public int count(int n3) {
        int n4 = 0;
        int n5 = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n5 == this.coeffs.length) break;
            if (nArray[n5] == n3) {
                ++n4;
            }
            ++n5;
        }
        return n4;
    }

    public void rotate1() {
        int n3 = this.coeffs[this.coeffs.length - 1];
        for (int i3 = this.coeffs.length - 1; i3 > 0; --i3) {
            this.coeffs[i3] = this.coeffs[i3 - 1];
        }
        this.coeffs[0] = n3;
    }

    public void clear() {
        int n3 = 0;
        while (true) {
            int[] nArray = this.coeffs;
            if (n3 >= this.coeffs.length) break;
            nArray[n3] = 0;
            ++n3;
        }
    }

    @Override
    public IntegerPolynomial toIntegerPolynomial() {
        return (IntegerPolynomial)this.clone();
    }

    public Object clone() {
        return new IntegerPolynomial((int[])this.coeffs.clone());
    }

    public boolean equals(Object object) {
        if (object instanceof IntegerPolynomial) {
            return Arrays.areEqual(this.coeffs, ((IntegerPolynomial)object).coeffs);
        }
        return false;
    }

    public class PrimeGenerator {
        private int index = 0;
        private BigInteger prime;

        private PrimeGenerator() {
        }

        public /* synthetic */ PrimeGenerator(1 var2_2) {
            this();
        }

        public BigInteger nextPrime() {
            if (this.index < BIGINT_PRIMES.size()) {
                int n3 = this.index;
                this.index = n3 + 1;
                this.prime = (BigInteger)BIGINT_PRIMES.get(n3);
            } else {
                this.prime = this.prime.nextProbablePrime();
            }
            return this.prime;
        }
    }

    public class CombineTask
    implements Callable<ModularResultant> {
        private ModularResultant modRes1;
        private ModularResultant modRes2;

        private CombineTask(ModularResultant modularResultant, ModularResultant modularResultant2) {
            this.modRes1 = modularResultant;
            this.modRes2 = modularResultant2;
        }

        public /* synthetic */ CombineTask(ModularResultant modularResultant, ModularResultant modularResultant2, 1 var4_4) {
            this(modularResultant, modularResultant2);
        }

        @Override
        public ModularResultant call() {
            return ModularResultant.combineRho(this.modRes1, this.modRes2);
        }
    }

    public class ModResultantTask
    implements Callable<ModularResultant> {
        private int modulus;

        private ModResultantTask(int n3) {
            this.modulus = n3;
        }

        public /* synthetic */ ModResultantTask(int n3, 1 var3_3) {
            this(n3);
        }

        @Override
        public ModularResultant call() {
            return IntegerPolynomial.this.resultant(this.modulus);
        }
    }
}

