/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.BigIntPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.TernaryPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.util.ArrayEncoder;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.util.Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SparseTernaryPolynomial
implements TernaryPolynomial {
    private static final int BITS_PER_INDEX = 11;
    private int N;
    private int[] ones;
    private int[] negOnes;

    public SparseTernaryPolynomial(int n3, int[] nArray, int[] nArray2) {
        this.N = n3;
        this.ones = nArray;
        this.negOnes = nArray2;
    }

    public SparseTernaryPolynomial(IntegerPolynomial integerPolynomial) {
        this(integerPolynomial.coeffs);
    }

    public SparseTernaryPolynomial(int[] nArray) {
        int n3;
        SparseTernaryPolynomial sparseTernaryPolynomial = this;
        sparseTernaryPolynomial.N = n3 = nArray.length;
        sparseTernaryPolynomial.ones = new int[n3];
        sparseTernaryPolynomial.negOnes = new int[n3];
        n3 = 0;
        int n4 = 0;
        for (int i3 = 0; i3 < this.N; ++i3) {
            int n5 = nArray[i3];
            if (n5 != -1) {
                if (n5 == 0) continue;
                if (n5 == 1) {
                    this.ones[n3++] = i3;
                    continue;
                }
                throw new IllegalArgumentException(f.a("Illegal value: ", n5, ", must be one of {-1, 0, 1}"));
            }
            this.negOnes[n4++] = i3;
        }
        SparseTernaryPolynomial sparseTernaryPolynomial2 = this;
        sparseTernaryPolynomial2.ones = Arrays.copyOf(sparseTernaryPolynomial2.ones, n3);
        sparseTernaryPolynomial2.negOnes = Arrays.copyOf(sparseTernaryPolynomial2.negOnes, n4);
    }

    public static SparseTernaryPolynomial fromBinary(InputStream inputStream, int n3, int n4, int n5) {
        int n6 = 32 - Integer.numberOfLeadingZeros(2047);
        int[] nArray = ArrayEncoder.decodeModQ(Util.readFullLength(inputStream, (n4 * n6 + 7) / 8), n4, 2048);
        int[] nArray2 = ArrayEncoder.decodeModQ(Util.readFullLength(inputStream, (n5 * n6 + 7) / 8), n5, 2048);
        return new SparseTernaryPolynomial(n3, nArray, nArray2);
    }

    public static SparseTernaryPolynomial generateRandom(int n3, int n4, int n5, SecureRandom secureRandom) {
        int[] nArray = Util.generateRandomTernary(n3, n4, n5, secureRandom);
        return new SparseTernaryPolynomial(nArray);
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial object) {
        object = ((IntegerPolynomial)object).coeffs;
        int n3 = this.N;
        if (((IntegerPolynomial)object).coeffs.length == n3) {
            int n4;
            int[] nArray;
            int[] nArray2 = new int[n3];
            int n5 = 0;
            while (true) {
                nArray = this.ones;
                if (n5 == this.ones.length) break;
                int n6 = nArray[n5];
                n6 = this.N - 1 - n6;
                for (n4 = (v1428135) - 1; n4 >= 0; --n4) {
                    nArray2[n4] = nArray2[n4] + object[n6];
                    if ((n6 += -1) >= 0) continue;
                    n6 = this.N - 1;
                }
                ++n5;
            }
            n5 = 0;
            while (true) {
                nArray = this.negOnes;
                if (n5 == this.negOnes.length) break;
                int n7 = nArray[n5];
                n7 = this.N - 1 - n7;
                for (n4 = (v1428176) - 1; n4 >= 0; --n4) {
                    nArray2[n4] = nArray2[n4] - object[n7];
                    if ((n7 += -1) >= 0) continue;
                    n7 = this.N - 1;
                }
                ++n5;
            }
            return new IntegerPolynomial(nArray2);
        }
        throw new IllegalArgumentException("Number of coefficients must be the same");
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial integerPolynomial, int n3) {
        IntegerPolynomial integerPolynomial2 = this.mult(integerPolynomial);
        integerPolynomial2.mod(n3);
        return integerPolynomial2;
    }

    @Override
    public BigIntPolynomial mult(BigIntPolynomial bigIntegerArray) {
        bigIntegerArray = bigIntegerArray.coeffs;
        int n3 = this.N;
        if (bigIntegerArray.coeffs.length == n3) {
            int n4;
            int[] nArray;
            int n5;
            BigInteger[] bigIntegerArray2 = new BigInteger[n3];
            for (n5 = 0; n5 < this.N; ++n5) {
                bigIntegerArray2[n5] = BigInteger.ZERO;
            }
            n5 = 0;
            while (true) {
                nArray = this.ones;
                if (n5 == this.ones.length) break;
                int n6 = nArray[n5];
                n6 = this.N - 1 - n6;
                for (n4 = (v1428253) - 1; n4 >= 0; --n4) {
                    bigIntegerArray2[n4] = bigIntegerArray2[n4].add(bigIntegerArray[n6]);
                    if ((n6 += -1) >= 0) continue;
                    n6 = this.N - 1;
                }
                ++n5;
            }
            n5 = 0;
            while (true) {
                nArray = this.negOnes;
                if (n5 == this.negOnes.length) break;
                int n7 = nArray[n5];
                n7 = this.N - 1 - n7;
                for (n4 = (v1428294) - 1; n4 >= 0; --n4) {
                    bigIntegerArray2[n4] = bigIntegerArray2[n4].subtract(bigIntegerArray[n7]);
                    if ((n7 += -1) >= 0) continue;
                    n7 = this.N - 1;
                }
                ++n5;
            }
            return new BigIntPolynomial(bigIntegerArray2);
        }
        throw new IllegalArgumentException("Number of coefficients must be the same");
    }

    @Override
    public int[] getOnes() {
        return this.ones;
    }

    @Override
    public int[] getNegOnes() {
        return this.negOnes;
    }

    public byte[] toBinary() {
        byte[] byArray = ArrayEncoder.encodeModQ(((SparseTernaryPolynomial)object).ones, 2048);
        Object object = ArrayEncoder.encodeModQ(((SparseTernaryPolynomial)object).negOnes, 2048);
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length + ((Object)object).length);
        Object object2 = object;
        int n3 = byArray.length;
        int n4 = ((Object)object2).length;
        System.arraycopy(object2, 0, byArray2, n3, n4);
        return byArray2;
    }

    @Override
    public IntegerPolynomial toIntegerPolynomial() {
        int[] nArray;
        int[] nArray2 = new int[this.N];
        int n3 = 0;
        while (true) {
            nArray = this.ones;
            if (n3 == this.ones.length) break;
            nArray2[nArray[n3]] = 1;
            ++n3;
        }
        n3 = 0;
        while (true) {
            nArray = this.negOnes;
            if (n3 == this.negOnes.length) break;
            nArray2[nArray[n3]] = -1;
            ++n3;
        }
        return new IntegerPolynomial(nArray2);
    }

    @Override
    public int size() {
        return this.N;
    }

    @Override
    public void clear() {
        int[] nArray;
        int n3 = 0;
        while (true) {
            nArray = this.ones;
            if (n3 >= this.ones.length) break;
            nArray[n3] = 0;
            ++n3;
        }
        n3 = 0;
        while (true) {
            nArray = this.negOnes;
            if (n3 >= this.negOnes.length) break;
            nArray[n3] = 0;
            ++n3;
        }
    }

    public int hashCode() {
        SparseTernaryPolynomial sparseTernaryPolynomial = this;
        int n3 = (31 + sparseTernaryPolynomial.N) * 31;
        n3 = (Arrays.hashCode(sparseTernaryPolynomial.negOnes) + n3) * 31;
        return Arrays.hashCode(sparseTernaryPolynomial.ones) + n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (SparseTernaryPolynomial)object;
        if (this.N != ((SparseTernaryPolynomial)object).N) {
            return false;
        }
        if (!Arrays.areEqual(this.negOnes, ((SparseTernaryPolynomial)object).negOnes)) {
            return false;
        }
        return Arrays.areEqual(this.ones, ((SparseTernaryPolynomial)object).ones);
    }
}

