/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.util.Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.InputStream;
import java.math.BigInteger;

public class ArrayEncoder {
    private static final int[] COEFF1_TABLE = new int[]{0, 0, 0, 1, 1, 1, -1, -1};
    private static final int[] COEFF2_TABLE = new int[]{0, 1, -1, 0, 1, -1, 0, 1};
    private static final int[] BIT1_TABLE = new int[]{1, 1, 1, 0, 0, 0, 1, 0, 1};
    private static final int[] BIT2_TABLE = new int[]{1, 1, 1, 1, 0, 0, 0, 1, 0};
    private static final int[] BIT3_TABLE = new int[]{1, 0, 1, 0, 0, 1, 1, 1, 0};

    public static byte[] encodeModQ(int[] nArray, int n3) {
        n3 = 31 - Integer.numberOfLeadingZeros(n3);
        byte[] byArray = new byte[(nArray.length * n3 + 7) / 8];
        int n4 = 0;
        int n5 = 0;
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            for (int i4 = 0; i4 < n3; ++i4) {
                int n6 = nArray[i3] >> i4 & 1;
                byArray[n5] = (byte)(byArray[n5] | n6 << n4);
                if (n4 == 7) {
                    n4 = 0;
                    ++n5;
                    continue;
                }
                ++n4;
            }
        }
        return byArray;
    }

    public static int[] decodeModQ(byte[] byArray, int n3, int n4) {
        int[] nArray = new int[n3];
        n4 = 31 - Integer.numberOfLeadingZeros(n4);
        int n5 = n3 * n4;
        int n6 = 0;
        for (int i3 = 0; i3 < n5; ++i3) {
            if (i3 > 0 && i3 % n4 == 0) {
                ++n6;
            }
            int n7 = ArrayEncoder.getBit(byArray, i3);
            nArray[n6] = nArray[n6] + (n7 << i3 % n4);
        }
        return nArray;
    }

    public static int[] decodeModQ(InputStream inputStream, int n3, int n4) {
        return ArrayEncoder.decodeModQ(Util.readFullLength(inputStream, ((31 - Integer.numberOfLeadingZeros(n4)) * n3 + 7) / 8), n3, n4);
    }

    public static int[] decodeMod3Sves(byte[] byArray, int n3) {
        int[] nArray = new int[n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < byArray.length * 8) {
            int n6 = ArrayEncoder.getBit(byArray, n5++);
            int n7 = n5++;
            int n8 = n6;
            n6 = ArrayEncoder.getBit(byArray, n5++);
            int n9 = n8 * 4;
            n6 = ArrayEncoder.getBit(byArray, n7) * 2 + n9 + n6;
            nArray[n4++] = COEFF1_TABLE[n6];
            n9 = n4 + 1;
            nArray[n4] = COEFF2_TABLE[n6];
            if (n9 > n3 - 2) break;
            n4 = n9;
        }
        return nArray;
    }

    public static byte[] encodeMod3Sves(int[] nArray) {
        byte[] byArray = new byte[((nArray.length * 3 + 1) / 2 + 7) / 8];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < nArray.length / 2 * 2) {
            int n6 = nArray[n5++] + 1;
            int n7 = nArray[n5++] + 1;
            if (n6 == 0 && n7 == 0) {
                throw new IllegalStateException("Illegal encoding!");
            }
            n6 = n6 * 3 + n7;
            int[] nArray2 = new int[3];
            int[] nArray3 = nArray2;
            nArray2[0] = BIT1_TABLE[n6];
            nArray2[1] = BIT2_TABLE[n6];
            nArray2[2] = BIT3_TABLE[n6];
            for (n6 = 0; n6 < 3; ++n6) {
                byArray[n4] = (byte)(byArray[n4] | nArray3[n6] << n3);
                if (n3 == 7) {
                    n3 = 0;
                    ++n4;
                    continue;
                }
                ++n3;
            }
        }
        return byArray;
    }

    public static byte[] encodeMod3Tight(int[] nArray) {
        Object object = BigInteger.ZERO;
        for (int i3 = nArray.length - 1; i3 >= 0; --i3) {
            object = ((BigInteger)object).multiply(BigInteger.valueOf(3L)).add(BigInteger.valueOf(nArray[i3] + 1));
        }
        int n3 = (BigInteger.valueOf(3L).pow(nArray.length).bitLength() + 7) / 8;
        byte[] byArray = ((BigInteger)object).toByteArray();
        object = byArray;
        if (byArray.length < n3) {
            byte[] byArray2 = new byte[n3];
            Object object2 = object;
            int n4 = ((Object)object2).length;
            System.arraycopy(object2, 0, byArray2, n3 -= ((Object)object).length, n4);
            return byArray2;
        }
        if (((Object)object).length > n3) {
            Object object3 = object;
            object = Arrays.copyOfRange((byte[])object3, 1, ((Object)object3).length);
        }
        return object;
    }

    public static int[] decodeMod3Tight(byte[] objectArray, int n3) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = bigInteger;
        bigInteger = new BigInteger(1, (byte[])objectArray);
        objectArray = new int[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            int n4;
            objectArray[i3] = n4 = bigInteger2.mod(BigInteger.valueOf(3L)).intValue() - 1;
            if (n4 > 1) {
                objectArray[i3] = n4 - 3;
            }
            bigInteger2 = bigInteger2.divide(BigInteger.valueOf(3L));
        }
        return objectArray;
    }

    public static int[] decodeMod3Tight(InputStream inputStream, int n3) {
        double d3 = n3;
        return ArrayEncoder.decodeMod3Tight(Util.readFullLength(inputStream, (int)Math.ceil(Math.log(3.0) * d3 / Math.log(2.0) / 8.0)), n3);
    }

    private static int getBit(byte[] byArray, int n3) {
        return (byArray[n3 / 8] & 0xFF) >> n3 % 8 & 1;
    }
}

