/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.security.SecureRandom;

public final class BigIntegers {
    public static final BigInteger ZERO = BigInteger.valueOf(0L);
    public static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger THREE = BigInteger.valueOf(3L);
    private static final int MAX_ITERATIONS = 1000;
    private static final BigInteger SMALL_PRIMES_PRODUCT = new BigInteger("8138e8a0fcf3a4e84a771d40fd305d7f4aa59306d7251de54d98af8fe95729a1f73d893fa424cd2edc8636a6c3285e022b0e3866a565ae8108eed8591cd4fe8d2ce86165a978d719ebf647f362d33fca29cd179fb42401cbaf3df0c614056f9c8f3cfd51e474afb6bc6974f78db8aba8e9e517fded658591ab7502bd41849462f", 16);
    private static final int MAX_SMALL = BigInteger.valueOf(743L).bitLength();

    public static byte[] asUnsignedByteArray(BigInteger object) {
        byte[] byArray = ((BigInteger)object).toByteArray();
        object = byArray;
        if (byArray[0] == 0) {
            int n3 = ((Object)object).length - 1;
            byte[] byArray2 = new byte[n3];
            System.arraycopy(object, 1, byArray2, 0, n3);
            return byArray2;
        }
        return object;
    }

    public static byte[] asUnsignedByteArray(int n3, BigInteger object) {
        byte[] byArray = ((BigInteger)object).toByteArray();
        object = byArray;
        if (byArray.length == n3) {
            return object;
        }
        int n4 = object[0] == false ? 1 : 0;
        int n5 = ((Object)object).length - n4;
        if (n5 <= n3) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(object, n4, byArray2, n3 -= n5, n5);
            return byArray2;
        }
        throw new IllegalArgumentException("standard length exceeded for value");
    }

    public static void asUnsignedByteArray(BigInteger object, byte[] byArray, int n3, int n4) {
        byte[] byArray2 = ((BigInteger)object).toByteArray();
        object = byArray2;
        if (byArray2.length == n4) {
            System.arraycopy(object, 0, byArray, n3, n4);
            return;
        }
        int n5 = object[0] == false ? 1 : 0;
        int n6 = ((Object)object).length - n5;
        if (n6 <= n4) {
            int n7 = n4 - n6 + n3;
            Arrays.fill(byArray, n3, n7, (byte)0);
            System.arraycopy(object, n5, byArray, n7, n6);
            return;
        }
        throw new IllegalArgumentException("standard length exceeded for value");
    }

    public static BigInteger createRandomInRange(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        int n3 = bigInteger.compareTo(bigInteger2);
        if (n3 >= 0) {
            if (n3 <= 0) {
                return bigInteger;
            }
            throw new IllegalArgumentException("'min' may not be greater than 'max'");
        }
        if (bigInteger.bitLength() > bigInteger2.bitLength() / 2) {
            return BigIntegers.createRandomInRange(ZERO, bigInteger2.subtract(bigInteger), secureRandom).add(bigInteger);
        }
        for (n3 = 0; n3 < 1000; ++n3) {
            BigInteger bigInteger3 = BigIntegers.createRandomBigInteger(bigInteger2.bitLength(), secureRandom);
            if (bigInteger3.compareTo(bigInteger) < 0 || bigInteger3.compareTo(bigInteger2) > 0) continue;
            return bigInteger3;
        }
        return BigIntegers.createRandomBigInteger(bigInteger2.subtract(bigInteger).bitLength() - 1, secureRandom).add(bigInteger);
    }

    public static BigInteger fromUnsignedByteArray(byte[] byArray) {
        return new BigInteger(1, byArray);
    }

    public static BigInteger fromUnsignedByteArray(byte[] byArray, int n3, int n4) {
        if (n3 != 0 || n4 != byArray.length) {
            byte[] byArray2 = byArray;
            byArray = new byte[n4];
            System.arraycopy(byArray2, n3, byArray, 0, n4);
        }
        return new BigInteger(1, byArray);
    }

    public static int intValueExact(BigInteger bigInteger) {
        if (bigInteger.bitLength() <= 31) {
            return bigInteger.intValue();
        }
        throw new ArithmeticException("BigInteger out of int range");
    }

    public static long longValueExact(BigInteger bigInteger) {
        if (bigInteger.bitLength() <= 63) {
            return bigInteger.longValue();
        }
        throw new ArithmeticException("BigInteger out of long range");
    }

    public static BigInteger modOddInverse(BigInteger object, BigInteger bigInteger) {
        if (((BigInteger)object).testBit(0)) {
            if (((BigInteger)object).signum() == 1) {
                if (bigInteger.signum() < 0 || bigInteger.compareTo((BigInteger)object) >= 0) {
                    bigInteger = bigInteger.mod((BigInteger)object);
                }
                int n3 = ((BigInteger)object).bitLength();
                int[] nArray = Nat.fromBigInteger(n3, (BigInteger)object);
                object = Nat.fromBigInteger(n3, bigInteger);
                int n4 = nArray.length;
                Object object2 = object;
                int[] nArray2 = Nat.create(n4);
                object = nArray2;
                if (Mod.modOddInverse(nArray, (int[])object2, nArray2) != 0) {
                    return Nat.toBigInteger(n4, (int[])object);
                }
                throw new ArithmeticException("BigInteger not invertible.");
            }
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        throw new IllegalArgumentException("'M' must be odd");
    }

    public static BigInteger modOddInverseVar(BigInteger object, BigInteger bigInteger) {
        if (((BigInteger)object).testBit(0)) {
            if (((BigInteger)object).signum() == 1) {
                BigInteger bigInteger2 = ONE;
                if (((BigInteger)object).equals(bigInteger2)) {
                    return ZERO;
                }
                if (bigInteger.signum() < 0 || bigInteger.compareTo((BigInteger)object) >= 0) {
                    bigInteger = bigInteger.mod((BigInteger)object);
                }
                if (bigInteger.equals(bigInteger2)) {
                    return bigInteger2;
                }
                int n3 = ((BigInteger)object).bitLength();
                int[] nArray = Nat.fromBigInteger(n3, (BigInteger)object);
                object = Nat.fromBigInteger(n3, bigInteger);
                int n4 = nArray.length;
                Object object2 = object;
                int[] nArray2 = Nat.create(n4);
                object = nArray2;
                if (Mod.modOddInverseVar(nArray, (int[])object2, nArray2)) {
                    return Nat.toBigInteger(n4, (int[])object);
                }
                throw new ArithmeticException("BigInteger not invertible.");
            }
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        throw new IllegalArgumentException("'M' must be odd");
    }

    public static int getUnsignedByteLength(BigInteger bigInteger) {
        return (bigInteger.bitLength() + 7) / 8;
    }

    public static BigInteger createRandomBigInteger(int n3, SecureRandom secureRandom) {
        return new BigInteger(1, BigIntegers.createRandom(n3, secureRandom));
    }

    public static BigInteger createRandomPrime(int n3, int n4, SecureRandom secureRandom) {
        if (n3 >= 2) {
            Object object;
            if (n3 == 2) {
                return secureRandom.nextInt() < 0 ? TWO : THREE;
            }
            do {
                BigInteger bigInteger;
                int n5 = n3;
                byte[] byArray = BigIntegers.createRandom(n5, secureRandom);
                Object object2 = byArray;
                int n6 = 1 << 7 - (byArray.length * 8 - n3);
                byArray[0] = (byte)(byArray[0] | n6);
                n6 = byArray.length - 1;
                byArray[n6] = (byte)(byArray[n6] | 1);
                object = bigInteger;
                bigInteger = new BigInteger(1, (byte[])object2);
                if (n5 <= MAX_SMALL) continue;
                while (!((BigInteger)object).gcd(SMALL_PRIMES_PRODUCT).equals(ONE)) {
                    object2 = ((BigInteger)object).add(TWO);
                    object = object2;
                }
            } while (!((BigInteger)object).isProbablePrime(n4));
            return object;
        }
        throw new IllegalArgumentException("bitLength < 2");
    }

    private static byte[] createRandom(int n3, SecureRandom secureRandom) {
        if (n3 >= 1) {
            int n4 = (n3 + 7) / 8;
            byte[] byArray = new byte[n4];
            byte[] byArray2 = byArray;
            secureRandom.nextBytes(byArray2);
            n3 = n4 * 8 - n3;
            byArray[0] = (byte)(byArray[0] & (byte)(255 >>> n3));
            return byArray;
        }
        throw new IllegalArgumentException("bitLength must be at least 1");
    }
}

