/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512tDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHAKEDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class Fingerprint {
    private static char[] encodingTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final byte[] fingerprint;

    public Fingerprint(byte[] byArray) {
        this(byArray, 160);
    }

    public Fingerprint(byte[] byArray, int n3) {
        this.fingerprint = Fingerprint.calculateFingerprint(byArray, n3);
    }

    public Fingerprint(byte[] byArray, boolean bl) {
        this.fingerprint = bl ? Fingerprint.calculateFingerprintSHA512_160(byArray) : Fingerprint.calculateFingerprint(byArray);
    }

    public static byte[] calculateFingerprint(byte[] byArray) {
        return Fingerprint.calculateFingerprint(byArray, 160);
    }

    public static byte[] calculateFingerprint(byte[] byArray, int n3) {
        if (n3 % 8 == 0) {
            SHAKEDigest sHAKEDigest;
            SHAKEDigest sHAKEDigest2 = sHAKEDigest;
            sHAKEDigest2(256);
            int n4 = byArray.length;
            sHAKEDigest.update(byArray, 0, n4);
            int n5 = n3 / 8;
            byte[] byArray2 = new byte[n5];
            sHAKEDigest2.doFinal(byArray2, 0, n5);
            return byArray2;
        }
        throw new IllegalArgumentException("bitLength must be a multiple of 8");
    }

    public static byte[] calculateFingerprintSHA512_160(byte[] byArray) {
        SHA512tDigest sHA512tDigest;
        SHA512tDigest sHA512tDigest2 = sHA512tDigest;
        sHA512tDigest2(160);
        sHA512tDigest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[sHA512tDigest.getDigestSize()];
        sHA512tDigest2.doFinal(byArray2, 0);
        return byArray2;
    }

    public byte[] getFingerprint() {
        return Arrays.clone(this.fingerprint);
    }

    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        for (int i3 = 0; i3 != this.fingerprint.length; ++i3) {
            if (i3 > 0) {
                stringBuffer2.append(":");
            }
            StringBuffer stringBuffer3 = stringBuffer2;
            stringBuffer3.append(encodingTable[this.fingerprint[i3] >>> 4 & 0xF]);
            stringBuffer3.append(encodingTable[this.fingerprint[i3] & 0xF]);
        }
        return stringBuffer2.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Fingerprint) {
            return Arrays.areEqual(((Fingerprint)object).fingerprint, this.fingerprint);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.fingerprint);
    }
}

