/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;

public class IPAddress {
    public static boolean isValid(String string2) {
        return IPAddress.isValidIPv4(string2) || IPAddress.isValidIPv6(string2);
    }

    public static boolean isValidWithNetMask(String string2) {
        return IPAddress.isValidIPv4WithNetmask(string2) || IPAddress.isValidIPv6WithNetmask(string2);
    }

    public static boolean isValidIPv4(String string2) {
        int n3;
        if (string2.length() == 0) {
            return false;
        }
        int n4 = 0;
        String string3 = i.a(string2, ".");
        int n5 = 0;
        while (n5 < string3.length() && (n3 = string3.indexOf(46, n5)) > n5) {
            if (n4 == 4) {
                return false;
            }
            try {
                n5 = Integer.parseInt(string3.substring(n5, n3));
                if (n5 >= 0 && n5 <= 255) {
                    n5 = n3 + 1;
                    ++n4;
                    continue;
                }
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return n4 == 4;
    }

    public static boolean isValidIPv4WithNetmask(String string2) {
        int n3 = string2.indexOf("/");
        String string3 = string2.substring(n3 + 1);
        return n3 > 0 && IPAddress.isValidIPv4(string2.substring(0, n3)) && (IPAddress.isValidIPv4(string3) || IPAddress.isMaskValue(string3, 32));
    }

    public static boolean isValidIPv6WithNetmask(String string2) {
        int n3 = string2.indexOf("/");
        String string3 = string2.substring(n3 + 1);
        return n3 > 0 && IPAddress.isValidIPv6(string2.substring(0, n3)) && (IPAddress.isValidIPv6(string3) || IPAddress.isMaskValue(string3, 128));
    }

    private static boolean isMaskValue(String string2, int n3) {
        try {
            int n4 = Integer.parseInt(string2);
            return n4 >= 0 && n4 <= n3;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidIPv6(String string2) {
        int n3;
        if (string2.length() == 0) {
            return false;
        }
        int n4 = 0;
        String string3 = i.a(string2, ":");
        boolean bl = false;
        int n5 = 0;
        while (n5 < string3.length() && (n3 = string3.indexOf(58, n5)) >= n5) {
            block10: {
                block11: {
                    if (n4 == 8) {
                        return false;
                    }
                    if (n5 == n3) break block11;
                    String string4 = string3;
                    String string5 = string4.substring(n5, n3);
                    if (n3 == string4.length() - 1 && string5.indexOf(46) > 0) {
                        if (!IPAddress.isValidIPv4(string5)) {
                            return false;
                        }
                        ++n4;
                        break block10;
                    } else {
                        try {
                            n5 = Integer.parseInt(string3.substring(n5, n3), 16);
                            if (n5 < 0) return false;
                            if (n5 > 65535) {
                                return false;
                            }
                            break block10;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return false;
                        }
                    }
                }
                if (n3 != 1 && n3 != string3.length() - 1 && bl) {
                    return false;
                }
                bl = true;
            }
            n5 = n3 + 1;
            ++n4;
        }
        if (n4 == 8) return true;
        if (bl) return true;
        return false;
    }
}

