/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.StringList;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.UTF8;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Vector;

public final class Strings {
    private static String LINE_SEPARATOR;

    public static String fromUTF8ByteArray(byte[] objectArray) {
        char[] cArray = new char[objectArray.length];
        objectArray = cArray;
        int n3 = UTF8.transcodeToUTF16(objectArray, cArray);
        if (n3 >= 0) {
            return new String((char[])objectArray, 0, n3);
        }
        throw new IllegalArgumentException("Invalid UTF-8 input");
    }

    public static byte[] toUTF8ByteArray(String string2) {
        return Strings.toUTF8ByteArray(string2.toCharArray());
    }

    public static byte[] toUTF8ByteArray(char[] object) {
        ByteArrayOutputStream byteArrayOutputStream;
        char[] cArray = object;
        object = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Strings.toUTF8ByteArray(cArray, byteArrayOutputStream);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot encode string to byte array!");
        }
    }

    public static void toUTF8ByteArray(char[] cArray, OutputStream outputStream) {
        for (int i3 = 0; i3 < cArray.length; ++i3) {
            int n3 = cArray[i3];
            if (n3 < 128) {
                outputStream.write(n3);
                continue;
            }
            if (n3 < 2048) {
                outputStream.write(n3 >> 6 | 0xC0);
                outputStream.write(n3 & 0x3F | 0x80);
                continue;
            }
            if (n3 >= 55296 && n3 <= 57343) {
                if (++i3 < cArray.length) {
                    char c3 = cArray[i3];
                    if (n3 <= 56319) {
                        n3 = ((n3 & 0x3FF) << 10 | c3 & 0x3FF) + 65536;
                        outputStream.write(n3 >> 18 | 0xF0);
                        outputStream.write(n3 >> 12 & 0x3F | 0x80);
                        outputStream.write(n3 >> 6 & 0x3F | 0x80);
                        outputStream.write(n3 & 0x3F | 0x80);
                        continue;
                    }
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                throw new IllegalStateException("invalid UTF-16 codepoint");
            }
            outputStream.write(n3 >> 12 | 0xE0);
            outputStream.write(n3 >> 6 & 0x3F | 0x80);
            outputStream.write(n3 & 0x3F | 0x80);
        }
    }

    public static String toUpperCase(String string2) {
        boolean bl = false;
        char[] cArray = string2.toCharArray();
        for (int i3 = 0; i3 != cArray.length; ++i3) {
            char c3 = cArray[i3];
            if ('a' > c3 || 'z' < c3) continue;
            bl = true;
            cArray[i3] = (char)(c3 - 97 + 65);
        }
        if (bl) {
            return new String(cArray);
        }
        return string2;
    }

    public static String toLowerCase(String string2) {
        boolean bl = false;
        char[] cArray = string2.toCharArray();
        for (int i3 = 0; i3 != cArray.length; ++i3) {
            char c3 = cArray[i3];
            if ('A' > c3 || 'Z' < c3) continue;
            bl = true;
            cArray[i3] = (char)(c3 - 65 + 97);
        }
        if (bl) {
            return new String(cArray);
        }
        return string2;
    }

    public static byte[] toByteArray(char[] cArray) {
        int n3 = cArray.length;
        byte[] byArray = new byte[n3];
        for (int i3 = 0; i3 != n3; ++i3) {
            byArray[i3] = (byte)cArray[i3];
        }
        return byArray;
    }

    public static byte[] toByteArray(String string2) {
        int n3 = string2.length();
        byte[] byArray = new byte[n3];
        for (int i3 = 0; i3 != n3; ++i3) {
            byArray[i3] = (byte)string2.charAt(i3);
        }
        return byArray;
    }

    public static int toByteArray(String string2, byte[] byArray, int n3) {
        int n4 = string2.length();
        for (int i3 = 0; i3 < n4; ++i3) {
            int n5 = n3 + i3;
            byArray[n5] = (byte)string2.charAt(i3);
        }
        return n4;
    }

    public static String fromByteArray(byte[] byArray) {
        return new String(Strings.asCharArray(byArray));
    }

    public static char[] asCharArray(byte[] byArray) {
        int n3 = byArray.length;
        char[] cArray = new char[n3];
        for (int i3 = 0; i3 != n3; ++i3) {
            cArray[i3] = (char)(byArray[i3] & 0xFF);
        }
        return cArray;
    }

    public static String[] split(String string2, char c3) {
        Vector<String> vector;
        Vector<String> vector2 = vector;
        vector = new Vector<String>();
        int n3 = 1;
        while (n3 != 0) {
            int n4 = string2.indexOf(c3);
            if (n4 > 0) {
                vector2.addElement(string2.substring(0, n4));
                string2 = string2.substring(n4 + 1);
                continue;
            }
            n3 = 0;
            vector2.addElement(string2);
        }
        int n5 = vector2.size();
        String[] stringArray = new String[n5];
        for (n3 = 0; n3 != n5; ++n3) {
            stringArray[n3] = (String)vector2.elementAt(n3);
        }
        return stringArray;
    }

    public static StringList newList() {
        return new StringListImpl(null);
    }

    public static String lineSeparator() {
        return LINE_SEPARATOR;
    }

    static {
        try {
            LINE_SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("line.separator");
                }
            });
        }
        catch (Exception exception) {
            try {
                LINE_SEPARATOR = String.format("%n", new Object[0]);
            }
            catch (Exception exception2) {
                LINE_SEPARATOR = "\n";
            }
        }
    }

    public static class StringListImpl
    extends ArrayList<String>
    implements StringList {
        private StringListImpl() {
        }

        public /* synthetic */ StringListImpl(1 var1_1) {
            this();
        }

        @Override
        public boolean add(String string2) {
            return super.add(string2);
        }

        @Override
        public String set(int n3, String string2) {
            return super.set(n3, string2);
        }

        @Override
        public void add(int n3, String string2) {
            super.add(n3, string2);
        }

        @Override
        public String[] toStringArray() {
            int n3 = ((AbstractCollection)this).size();
            String[] stringArray = new String[n3];
            for (int i3 = 0; i3 != n3; ++i3) {
                stringArray[i3] = (String)((AbstractList)this).get(i3);
            }
            return stringArray;
        }

        @Override
        public String[] toStringArray(int n3, int n4) {
            String[] stringArray = new String[n4 - n3];
            int n5 = n3;
            while (n5 != ((AbstractCollection)this).size() && n5 != n4) {
                int n6 = n5++;
                int n7 = n6 - n3;
                stringArray[n7] = (String)((AbstractList)this).get(n6);
            }
            return stringArray;
        }
    }
}

