/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Encoder;
import java.io.IOException;
import java.io.OutputStream;

public class Base32Encoder
implements Encoder {
    private static final byte[] DEAULT_ENCODING_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 50, 51, 52, 53, 54, 55};
    private static final byte DEFAULT_PADDING = 61;
    private final byte[] encodingTable;
    private final byte padding;
    private final byte[] decodingTable;

    public Base32Encoder() {
        Base32Encoder base32Encoder = this;
        base32Encoder.decodingTable = new byte[128];
        base32Encoder.encodingTable = DEAULT_ENCODING_TABLE;
        base32Encoder.padding = (byte)61;
        base32Encoder.initialiseDecodingTable();
    }

    public Base32Encoder(byte[] byArray, byte by) {
        this.decodingTable = new byte[128];
        if (byArray.length == 32) {
            this.encodingTable = Arrays.clone(byArray);
            this.padding = by;
            this.initialiseDecodingTable();
            return;
        }
        throw new IllegalArgumentException("encoding table needs to be length 32");
    }

    private void encodeBlock(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = n3;
        int n6 = n5 + 1;
        int n7 = byArray[n5];
        n3 = byArray[n6++] & 0xFF;
        int n8 = byArray[n6++] & 0xFF;
        int n9 = byArray[n6++] & 0xFF;
        n6 = byArray[n6] & 0xFF;
        int n10 = n4 + 1;
        byte[] byArray3 = this.encodingTable;
        int n11 = n3;
        int n12 = n3;
        int n13 = n7;
        byArray2[n4] = byArray3[n7 >>> 3 & 0x1F];
        n7 = n10 + 1;
        byArray2[n10] = byArray3[(n13 << 2 | n3 >>> 6) & 0x1F];
        n3 = n7 + 1;
        byArray2[n7] = byArray3[n12 >>> 1 & 0x1F];
        n7 = n3 + 1;
        byArray2[n3] = byArray3[(n11 << 4 | n8 >>> 4) & 0x1F];
        n3 = n7 + 1;
        byArray2[n7] = byArray3[(n8 << 1 | n9 >>> 7) & 0x1F];
        n7 = n3 + 1;
        byArray2[n3] = byArray3[n9 >>> 2 & 0x1F];
        n3 = n7 + 1;
        byArray2[n7] = byArray3[(n9 << 3 | n6 >>> 5) & 0x1F];
        byArray2[n3] = this.encodingTable[n6 & 0x1F];
    }

    private boolean ignore(char c3) {
        return c3 == '\n' || c3 == '\r' || c3 == '\t' || c3 == ' ';
    }

    private int nextI(byte[] byArray, int n3, int n4) {
        while (n3 < n4 && this.ignore((char)byArray[n3])) {
            ++n3;
        }
        return n3;
    }

    private int decodeLastBlock(OutputStream outputStream, char c3, char object, char object2, char object3, char object4, char object5, char object6, char c4) {
        Object object7;
        byte by = ((Base32Encoder)object7).padding;
        if (c4 == by) {
            if (object6 != by) {
                object7 = ((Base32Encoder)object7).decodingTable;
                Object object8 = object7[object];
                if (((c3 = ((Base32Encoder)object7).decodingTable[c3]) | object8 | (object = (Object)object7[object2]) | (object2 = (Object)object7[object3]) | (object3 = (Object)object7[object4]) | (object4 = (Object)object7[object5]) | (object5 = (Object)object7[object6])) >= 0) {
                    outputStream.write(c3 << 3 | object8 >> 2);
                    outputStream.write(object8 << 6 | object << 1 | object2 >> 4);
                    outputStream.write(object2 << 4 | object3 >> 1);
                    outputStream.write(object3 << 7 | object4 << 2 | object5 >> 3);
                    return 4;
                }
                throw new IOException("invalid characters encountered at end of base32 data");
            }
            if (object5 == by) {
                if (object4 != by) {
                    object7 = ((Base32Encoder)object7).decodingTable;
                    Object object9 = object7[object];
                    if (((c3 = ((Base32Encoder)object7).decodingTable[c3]) | object9 | (object = (Object)object7[object2]) | (object2 = (Object)object7[object3]) | (object3 = (Object)object7[object4])) >= 0) {
                        outputStream.write(c3 << 3 | object9 >> 2);
                        outputStream.write(object9 << 6 | object << 1 | object2 >> 4);
                        outputStream.write(object2 << 4 | object3 >> 1);
                        return 3;
                    }
                    throw new IOException("invalid characters encountered at end of base32 data");
                }
                if (object3 != by) {
                    object7 = ((Base32Encoder)object7).decodingTable;
                    Object object10 = object7[object];
                    if (((c3 = ((Base32Encoder)object7).decodingTable[c3]) | object10 | (object = (Object)object7[object2]) | (object2 = (Object)object7[object3])) >= 0) {
                        outputStream.write(c3 << 3 | object10 >> 2);
                        outputStream.write(object10 << 6 | object << 1 | object2 >> 4);
                        return 2;
                    }
                    throw new IOException("invalid characters encountered at end of base32 data");
                }
                if (object2 == by) {
                    object7 = ((Base32Encoder)object7).decodingTable;
                    Object object11 = object7[object];
                    if (((c3 = ((Base32Encoder)object7).decodingTable[c3]) | object11) >= 0) {
                        outputStream.write(c3 << 3 | object11 >> 2);
                        return 1;
                    }
                    throw new IOException("invalid characters encountered at end of base32 data");
                }
                throw new IOException("invalid characters encountered at end of base32 data");
            }
            throw new IOException("invalid characters encountered at end of base32 data");
        }
        object7 = ((Base32Encoder)object7).decodingTable;
        Object object12 = object7[object];
        if (((c3 = ((Base32Encoder)object7).decodingTable[c3]) | object12 | (object = (Object)object7[object2]) | (object2 = (Object)object7[object3]) | (object3 = (Object)object7[object4]) | (object4 = (Object)object7[object5]) | (object5 = (Object)object7[object6]) | (object6 = (Object)object7[c4])) >= 0) {
            outputStream.write(c3 << 3 | object12 >> 2);
            outputStream.write(object12 << 6 | object << 1 | object2 >> 4);
            outputStream.write(object2 << 4 | object3 >> 1);
            outputStream.write(object3 << 7 | object4 << 2 | object5 >> 3);
            outputStream.write(object5 << 5 | object6);
            return 5;
        }
        throw new IOException("invalid characters encountered at end of base32 data");
    }

    public void initialiseDecodingTable() {
        byte[] byArray;
        int n3 = 0;
        while (true) {
            byArray = this.decodingTable;
            if (n3 >= this.decodingTable.length) break;
            byArray[n3] = -1;
            ++n3;
        }
        n3 = 0;
        while (true) {
            byArray = this.encodingTable;
            if (n3 >= this.encodingTable.length) break;
            byte by = byArray[n3];
            this.decodingTable[by] = (byte)n3;
            ++n3;
        }
    }

    public int encode(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        int n6 = n3 + n4 - 4;
        int n7 = n5;
        int n8 = n3;
        while (n8 < n6) {
            this.encodeBlock(byArray, n8, byArray2, n7);
            n8 += 5;
            n7 += 8;
        }
        if ((n3 = n4 - (n8 - n3)) > 0) {
            byte[] byArray3 = byArray;
            byArray = new byte[5];
            System.arraycopy(byArray3, n8, byArray, 0, n3);
            this.encodeBlock(byArray, 0, byArray2, n7);
            switch (n3) {
                default: {
                    break;
                }
                case 4: {
                    int n9 = n7 + 7;
                    byArray2[n9] = this.padding;
                    break;
                }
                case 3: {
                    byte by;
                    int n10 = n7 + 5;
                    byArray2[n10] = by = this.padding;
                    byArray2[n7 + 6] = by;
                    byArray2[n7 + 7] = by;
                    break;
                }
                case 2: {
                    byte by;
                    int n11 = n7 + 4;
                    byArray2[n11] = by = this.padding;
                    byArray2[n7 + 5] = by;
                    byArray2[n7 + 6] = by;
                    byArray2[n7 + 7] = by;
                    break;
                }
                case 1: {
                    byte by;
                    int n12 = n7 + 2;
                    byArray2[n12] = by = this.padding;
                    byArray2[n7 + 3] = by;
                    byArray2[n7 + 4] = by;
                    byArray2[n7 + 5] = by;
                    byArray2[n7 + 6] = by;
                    byArray2[n7 + 7] = by;
                }
            }
            n7 += 8;
        }
        return n7 - n5;
    }

    public int getEncodedLength(int n3) {
        return (n3 + 4) / 5 * 8;
    }

    public int getMaxDecodedLength(int n3) {
        return n3 / 8 * 5;
    }

    @Override
    public int encode(byte[] byArray, int n3, int n4, OutputStream outputStream) {
        if (n4 < 0) {
            return 0;
        }
        byte[] byArray2 = new byte[72];
        int n5 = n4;
        while (n5 > 0) {
            int n6 = n5;
            int n7 = n3;
            n5 = Math.min(45, n5);
            n3 = this.encode(byArray, n3, n5, byArray2, 0);
            outputStream.write(byArray2, 0, n3);
            n3 = n7 + n5;
            n5 = n6 - n5;
        }
        return (n4 + 2) / 3 * 4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int decode(byte[] byArray, int n3, int n4, OutputStream outputStream) {
        void var4_8;
        void var10_18;
        void c4;
        int n5;
        char c3;
        int n6 = 55;
        byte[] byArray2 = new byte[55];
        int n7 = 0;
        int n8 = 0;
        for (c3 = n5 + c3; c3 > n5 && this.ignore((char)c4[c3 - true]); --c3) {
        }
        if (c3 == '\u0000') {
            return 0;
        }
        int n9 = 0;
        for (var10_18 = c3; var10_18 > n5 && n9 != 8; --var10_18) {
            if (this.ignore((char)c4[var10_18 - true])) continue;
            ++n9;
        }
        n5 = this.nextI((byte[])c4, n5, (int)var10_18);
        while (n5 < var10_18) {
            byte by;
            n9 = this.decodingTable[c4[n5++]];
            Base32Encoder base32Encoder = this;
            Base32Encoder base32Encoder2 = this;
            Base32Encoder base32Encoder3 = this;
            Base32Encoder base32Encoder4 = this;
            Base32Encoder base32Encoder5 = this;
            Base32Encoder base32Encoder6 = this;
            n5 = base32Encoder6.nextI((byte[])c4, n5, (int)var10_18);
            byte by2 = base32Encoder6.decodingTable[c4[n5++]];
            n5 = base32Encoder5.nextI((byte[])c4, n5, (int)var10_18);
            byte by3 = base32Encoder5.decodingTable[c4[n5++]];
            n5 = base32Encoder4.nextI((byte[])c4, n5, (int)var10_18);
            byte by4 = base32Encoder4.decodingTable[c4[n5++]];
            n5 = base32Encoder3.nextI((byte[])c4, n5, (int)var10_18);
            byte by5 = base32Encoder3.decodingTable[c4[n5++]];
            n5 = base32Encoder2.nextI((byte[])c4, n5, (int)var10_18);
            byte by6 = base32Encoder2.decodingTable[c4[n5++]];
            n5 = base32Encoder.nextI((byte[])c4, n5, (int)var10_18);
            byte by7 = base32Encoder.decodingTable[c4[n5++]];
            n5 = this.nextI((byte[])c4, n5, (int)var10_18);
            if ((n9 | by2 | by3 | by4 | by5 | by6 | by7 | (by = this.decodingTable[c4[n5++]])) >= 0) {
                byArray2[n7++] = (byte)(n9 << 3 | by2 >> 2);
                n9 = n7 + 1;
                byArray2[n7] = (byte)(by2 << 6 | by3 << 1 | by4 >> 4);
                n7 = n9 + 1;
                byArray2[n9] = (byte)(by4 << 4 | by5 >> 1);
                n9 = n7 + 1;
                byArray2[n7] = (byte)(by5 << 7 | by6 << 2 | by7 >> 3);
                n7 = n9 + 1;
                byArray2[n9] = (byte)(by7 << 5 | by);
                if (n7 == n6) {
                    var4_8.write(byArray2);
                    n7 = 0;
                }
                n8 += 5;
                n5 = this.nextI((byte[])c4, n5, (int)var10_18);
                continue;
            }
            throw new IOException("invalid characters encountered in base32 data");
        }
        if (n7 > 0) {
            var4_8.write(byArray2, 0, n7);
        }
        void v6 = c4;
        int c32 = this.nextI((byte[])c4, n5, c3);
        int n10 = this.nextI((byte[])c4, c32 + 1, c3);
        n5 = this.nextI((byte[])c4, n10 + 1, c3);
        int n11 = this.nextI((byte[])c4, n5 + 1, c3);
        n6 = this.nextI((byte[])c4, n11 + 1, c3);
        int n12 = this.nextI((byte[])c4, n6 + 1, c3);
        n7 = this.nextI((byte[])c4, n12 + 1, c3);
        c3 = this.nextI((byte[])c4, n7 + 1, c3);
        char c5 = (char)v6[c32];
        char c6 = (char)v6[n10];
        n5 = (char)v6[n5];
        char c7 = (char)v6[n11];
        n6 = (char)v6[n6];
        char c8 = (char)v6[n12];
        n7 = (char)v6[n7];
        c3 = (char)v6[c3];
        return n8 + this.decodeLastBlock((OutputStream)var4_8, c5, c6, (char)n5, c7, (char)n6, c8, (char)n7, c3);
    }

    @Override
    public int decode(String string2, OutputStream outputStream) {
        byte[] byArray = Strings.toByteArray(string2);
        return this.decode(byArray, 0, byArray.length, outputStream);
    }
}

