/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Encoder;
import java.io.IOException;
import java.io.OutputStream;

public class HexEncoder
implements Encoder {
    public final byte[] encodingTable;
    public final byte[] decodingTable;

    public HexEncoder() {
        HexEncoder hexEncoder = this;
        hexEncoder.encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        hexEncoder.decodingTable = new byte[128];
        hexEncoder.initialiseDecodingTable();
    }

    private static boolean ignore(char c3) {
        return c3 == '\n' || c3 == '\r' || c3 == '\t' || c3 == ' ';
    }

    public void initialiseDecodingTable() {
        byte[] byArray;
        int n3 = 0;
        while (true) {
            byArray = this.decodingTable;
            if (n3 >= this.decodingTable.length) break;
            byArray[n3] = -1;
            ++n3;
        }
        n3 = 0;
        while (true) {
            byArray = this.encodingTable;
            if (n3 >= this.encodingTable.length) break;
            byte by = byArray[n3];
            this.decodingTable[by] = (byte)n3;
            ++n3;
        }
        byte[] byArray2 = this.decodingTable;
        byArray2[65] = this.decodingTable[97];
        byArray2[66] = this.decodingTable[98];
        byArray2[67] = this.decodingTable[99];
        byArray2[68] = this.decodingTable[100];
        byArray2[69] = this.decodingTable[101];
        byArray2[70] = this.decodingTable[102];
    }

    public int encode(byte[] byArray, int n3, int n4, byte[] byArray2, int n5) {
        n4 = n3 + n4;
        int n6 = n5;
        while (n3 < n4) {
            int n7 = byArray[n3++] & 0xFF;
            int n8 = n6 + 1;
            byte[] byArray3 = this.encodingTable;
            byArray2[n6] = byArray3[n7 >>> 4];
            n6 = n8 + 1;
            byArray2[n8] = byArray3[n7 & 0xF];
        }
        return n6 - n5;
    }

    @Override
    public int encode(byte[] byArray, int n3, int n4, OutputStream outputStream) {
        byte[] byArray2 = new byte[72];
        while (n4 > 0) {
            int n5 = n4;
            int n6 = n3;
            n4 = Math.min(36, n4);
            n3 = this.encode(byArray, n3, n4, byArray2, 0);
            outputStream.write(byArray2, 0, n3);
            n3 = n6 + n4;
            n4 = n5 - n4;
        }
        return n4 * 2;
    }

    @Override
    public int decode(byte[] byArray, int n3, int n4, OutputStream outputStream) {
        int n5 = 0;
        int n6 = 36;
        byte[] byArray2 = new byte[36];
        int n7 = 0;
        for (n4 = n3 + n4; n4 > n3 && HexEncoder.ignore((char)byArray[n4 - 1]); --n4) {
        }
        while (n3 < n4) {
            byte by;
            while (n3 < n4 && HexEncoder.ignore((char)byArray[n3])) {
                ++n3;
            }
            byte by2 = this.decodingTable[byArray[n3++]];
            while (n3 < n4 && HexEncoder.ignore((char)byArray[n3])) {
                ++n3;
            }
            if ((by2 | (by = this.decodingTable[byArray[n3++]])) >= 0) {
                int n8 = n7 + 1;
                byArray2[n7] = (byte)(by2 << 4 | by);
                if (n8 == n6) {
                    outputStream.write(byArray2);
                    n7 = 0;
                } else {
                    n7 = n8;
                }
                ++n5;
                continue;
            }
            throw new IOException("invalid characters encountered in Hex data");
        }
        if (n7 > 0) {
            outputStream.write(byArray2, 0, n7);
        }
        return n5;
    }

    @Override
    public int decode(String string2, OutputStream outputStream) {
        int n3;
        int n4 = 0;
        int n5 = 36;
        byte[] byArray = new byte[36];
        int n6 = 0;
        for (n3 = string2.length(); n3 > 0 && HexEncoder.ignore(string2.charAt(n3 - 1)); --n3) {
        }
        int n7 = 0;
        while (n7 < n3) {
            byte by;
            while (n7 < n3 && HexEncoder.ignore(string2.charAt(n7))) {
                ++n7;
            }
            byte by2 = this.decodingTable[string2.charAt(n7++)];
            while (n7 < n3 && HexEncoder.ignore(string2.charAt(n7))) {
                ++n7;
            }
            if ((by2 | (by = this.decodingTable[string2.charAt(n7++)])) >= 0) {
                int n8 = n6 + 1;
                byArray[n6] = (byte)(by2 << 4 | by);
                if (n8 == n5) {
                    outputStream.write(byArray);
                    n6 = 0;
                } else {
                    n6 = n8;
                }
                ++n4;
                continue;
            }
            throw new IOException("invalid characters encountered in Hex string");
        }
        if (n6 > 0) {
            outputStream.write(byArray, 0, n6);
        }
        return n4;
    }

    public byte[] decodeStrict(String string2, int n3, int n4) {
        if (string2 != null) {
            if (n3 >= 0 && n4 >= 0 && n3 <= string2.length() - n4) {
                if ((n4 & 1) == 0) {
                    byte[] byArray = new byte[n4 >>>= 1];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n5 = n3++;
                        int n6 = this.decodingTable[string2.charAt(n3++)];
                        n6 = this.decodingTable[string2.charAt(n5)] << 4 | n6;
                        if (n6 >= 0) {
                            byArray[i3] = (byte)n6;
                            continue;
                        }
                        throw new IOException("invalid characters encountered in Hex string");
                    }
                    return byArray;
                }
                throw new IOException("a hexadecimal encoding must have an even number of characters");
            }
            throw new IndexOutOfBoundsException("invalid offset and/or length specified");
        }
        throw new NullPointerException("'str' cannot be null");
    }
}

