/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders;

public class UTF8 {
    private static final byte C_ILL = 0;
    private static final byte C_CR1 = 1;
    private static final byte C_CR2 = 2;
    private static final byte C_CR3 = 3;
    private static final byte C_L2A = 4;
    private static final byte C_L3A = 5;
    private static final byte C_L3B = 6;
    private static final byte C_L3C = 7;
    private static final byte C_L4A = 8;
    private static final byte C_L4B = 9;
    private static final byte C_L4C = 10;
    private static final byte S_ERR = -2;
    private static final byte S_END = -1;
    private static final byte S_CS1 = 0;
    private static final byte S_CS2 = 16;
    private static final byte S_CS3 = 32;
    private static final byte S_P3A = 48;
    private static final byte S_P3B = 64;
    private static final byte S_P4A = 80;
    private static final byte S_P4B = 96;
    private static final short[] firstUnitTable = new short[128];
    private static final byte[] transitionTable = new byte[112];

    private static void fill(byte[] byArray, int n3, int n4, byte by) {
        while (n3 <= n4) {
            byArray[n3] = by;
            ++n3;
        }
    }

    public static int transcodeToUTF16(byte[] byArray, char[] cArray) {
        int n3 = 0;
        int n4 = 0;
        while (n3 < byArray.length) {
            int n5 = n3 + 1;
            if ((n3 = byArray[n3]) >= 0) {
                if (n4 >= cArray.length) {
                    return -1;
                }
                int n6 = n3;
                n3 = n4 + 1;
                cArray[n4] = (char)n6;
                n4 = n3;
                n3 = n5;
                continue;
            }
            short s2 = firstUnitTable[n3 & 0x7F];
            n3 = s2 >>> 8;
            byte by = (byte)s2;
            int n7 = n5;
            n5 = n3;
            n3 = n7;
            while (by >= 0) {
                if (n3 >= byArray.length) {
                    return -1;
                }
                int n8 = n5;
                n5 = byArray[n3++];
                int n9 = n8 << 6 | n5 & 0x3F;
                by = transitionTable[by + ((n5 & 0xFF) >>> 4)];
                n5 = n9;
            }
            if (by == -2) {
                return -1;
            }
            if (n5 <= 65535) {
                if (n4 >= cArray.length) {
                    return -1;
                }
                int n10 = n5;
                n5 = n4 + 1;
                cArray[n4] = (char)n10;
                n4 = n5;
                continue;
            }
            if (n4 >= cArray.length - 1) {
                return -1;
            }
            int n11 = n5;
            cArray[n4++] = (char)((n5 >>> 10) + 55232);
            n5 = n4 + 1;
            cArray[n4] = (char)(n11 & 0x3FF | 0xDC00);
            n4 = n5;
        }
        return n4;
    }

    static {
        byte[] byArray = new byte[128];
        UTF8.fill(byArray, 0, 15, (byte)1);
        UTF8.fill(byArray, 16, 31, (byte)2);
        UTF8.fill(byArray, 32, 63, (byte)3);
        UTF8.fill(byArray, 64, 65, (byte)0);
        UTF8.fill(byArray, 66, 95, (byte)4);
        UTF8.fill(byArray, 96, 96, (byte)5);
        UTF8.fill(byArray, 97, 108, (byte)6);
        UTF8.fill(byArray, 109, 109, (byte)7);
        UTF8.fill(byArray, 110, 111, (byte)6);
        UTF8.fill(byArray, 112, 112, (byte)8);
        UTF8.fill(byArray, 113, 115, (byte)9);
        UTF8.fill(byArray, 116, 116, (byte)10);
        UTF8.fill(byArray, 117, 127, (byte)0);
        UTF8.fill(transitionTable, 0, transitionTable.length - 1, (byte)-2);
        UTF8.fill(transitionTable, 8, 11, (byte)-1);
        UTF8.fill(transitionTable, 24, 27, (byte)0);
        UTF8.fill(transitionTable, 40, 43, (byte)16);
        UTF8.fill(transitionTable, 58, 59, (byte)0);
        UTF8.fill(transitionTable, 72, 73, (byte)0);
        UTF8.fill(transitionTable, 89, 91, (byte)16);
        UTF8.fill(transitionTable, 104, 104, (byte)16);
        byte[] byArray2 = new byte[11];
        byte[] byArray3 = byArray2;
        byArray2[0] = 0;
        byArray2[1] = 0;
        byArray2[2] = 0;
        byArray2[3] = 0;
        byArray2[4] = 31;
        byArray2[5] = 15;
        byArray2[6] = 15;
        byArray2[7] = 15;
        byArray2[8] = 7;
        byArray2[9] = 7;
        byArray2[10] = 7;
        byte[] byArray4 = new byte[11];
        byte[] byArray5 = byArray4;
        byArray4[0] = -2;
        byArray4[1] = -2;
        byArray4[2] = -2;
        byArray4[3] = -2;
        byArray4[4] = 0;
        byArray4[5] = 48;
        byArray4[6] = 16;
        byArray4[7] = 64;
        byArray4[8] = 80;
        byArray4[9] = 32;
        byArray4[10] = 96;
        for (int i3 = 0; i3 < 128; ++i3) {
            byte by = byArray[i3];
            int n3 = i3 & byArray3[by];
            by = byArray5[by];
            UTF8.firstUnitTable[i3] = (short)(n3 << 8 | by);
        }
    }
}

