/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.util.io;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.StreamOverflowException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class Streams {
    private static int BUFFER_SIZE = 4096;

    public static void drain(InputStream inputStream) {
        int n3 = BUFFER_SIZE;
        byte[] byArray = new byte[n3];
        while (inputStream.read(byArray, 0, n3) >= 0) {
        }
    }

    public static byte[] readAll(InputStream closeable) {
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream = closeable;
        closeable = byteArrayOutputStream;
        Streams.pipeAll(inputStream, new ByteArrayOutputStream());
        return ((ByteArrayOutputStream)closeable).toByteArray();
    }

    public static byte[] readAllLimited(InputStream closeable, int n3) {
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream = closeable;
        closeable = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.pipeAllLimited(inputStream, n3, (OutputStream)closeable);
        return ((ByteArrayOutputStream)closeable).toByteArray();
    }

    public static int readFully(InputStream inputStream, byte[] byArray) {
        return Streams.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static int readFully(InputStream inputStream, byte[] byArray, int n3, int n4) {
        int n5;
        int n6;
        for (n5 = 0; n5 < n4; n5 += n6) {
            n6 = n3 + n5;
            int n7 = n4 - n5;
            if ((n6 = inputStream.read(byArray, n6, n7)) < 0) break;
        }
        return n5;
    }

    public static void pipeAll(InputStream inputStream, OutputStream outputStream) {
        int n3;
        int n4 = BUFFER_SIZE;
        byte[] byArray = new byte[n4];
        while ((n3 = inputStream.read(byArray, 0, n4)) >= 0) {
            outputStream.write(byArray, 0, n3);
        }
    }

    public static long pipeAllLimited(InputStream inputStream, long l3, OutputStream outputStream) {
        int n3;
        long l4 = 0L;
        int n4 = BUFFER_SIZE;
        byte[] byArray = new byte[n4];
        while ((n3 = inputStream.read(byArray, 0, n4)) >= 0) {
            long l5 = n3;
            if (l3 - l4 >= l5) {
                l4 += l5;
                outputStream.write(byArray, 0, n3);
                continue;
            }
            throw new StreamOverflowException("Data Overflow");
        }
        return l4;
    }

    public static void writeBufTo(ByteArrayOutputStream byteArrayOutputStream, OutputStream outputStream) {
        byteArrayOutputStream.writeTo(outputStream);
    }
}

