/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.util.io.pem;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Base64;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.pem.PemHeader;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.pem.PemObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.pem.PemObjectGenerator;
import java.io.BufferedWriter;
import java.io.Writer;
import java.util.Iterator;

public class PemWriter
extends BufferedWriter {
    private static final int LINE_LENGTH = 64;
    private final int nlLength;
    private char[] buf = new char[64];

    public PemWriter(Writer object) {
        super((Writer)object);
        object = Strings.lineSeparator();
        this.nlLength = object != null ? ((String)object).length() : 2;
    }

    private void writeEncoded(byte[] byArray) {
        PemWriter pemWriter;
        byArray = Base64.encode(byArray);
        for (int i3 = 0; i3 < byArray.length; i3 += pemWriter.buf.length) {
            char[] cArray;
            int n3 = 0;
            while (true) {
                int n4;
                cArray = this.buf;
                if (n3 == this.buf.length || (n4 = i3 + n3) >= byArray.length) break;
                cArray[n3] = (char)byArray[n4];
                ++n3;
            }
            pemWriter = this;
            ((Writer)pemWriter).write(cArray, 0, n3);
            pemWriter.newLine();
        }
    }

    private void writePreEncapsulationBoundary(String string2) {
        PemWriter pemWriter = this;
        pemWriter.write("-----BEGIN " + string2 + "-----");
        pemWriter.newLine();
    }

    private void writePostEncapsulationBoundary(String string2) {
        PemWriter pemWriter = this;
        pemWriter.write("-----END " + string2 + "-----");
        pemWriter.newLine();
    }

    public int getOutputSize(PemObject pemObject) {
        PemObject pemObject2 = pemObject;
        int n3 = (pemObject2.getType().length() + 10 + this.nlLength) * 2 + 6 + 4;
        if (!pemObject2.getHeaders().isEmpty()) {
            for (PemHeader pemHeader : pemObject.getHeaders()) {
                int n4 = pemHeader.getName().length() + 2;
                n3 = pemHeader.getValue().length() + n4 + this.nlLength + n3;
            }
            n3 += this.nlLength;
        }
        int n5 = (pemObject.getContent().length + 2) / 3 * 4;
        return (n5 + 64 - 1) / 64 * this.nlLength + n5 + n3;
    }

    public void writeObject(PemObjectGenerator pemObjectGenerator) {
        pemObjectGenerator = pemObjectGenerator.generate();
        this.writePreEncapsulationBoundary(((PemObject)pemObjectGenerator).getType());
        if (!((PemObject)pemObjectGenerator).getHeaders().isEmpty()) {
            Iterator iterator = ((PemObject)pemObjectGenerator).getHeaders().iterator();
            while (iterator.hasNext()) {
                PemWriter pemWriter = this;
                PemHeader pemHeader = (PemHeader)iterator.next();
                pemWriter.write(pemHeader.getName());
                pemWriter.write(": ");
                pemWriter.write(pemHeader.getValue());
                pemWriter.newLine();
            }
            this.newLine();
        }
        this.writeEncoded(((PemObject)pemObjectGenerator).getContent());
        this.writePostEncapsulationBoundary(((PemObject)pemObjectGenerator).getType());
    }
}

