/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AttCertIssuer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralNames;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.V2Form;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.X509Principal;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Selector;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;

public class AttributeCertificateIssuer
implements CertSelector,
Selector {
    public final ASN1Encodable form;

    public AttributeCertificateIssuer(AttCertIssuer attCertIssuer) {
        this.form = attCertIssuer.getIssuer();
    }

    public AttributeCertificateIssuer(X500Principal x500Principal) {
        this(new X509Principal(x500Principal.getEncoded()));
    }

    public AttributeCertificateIssuer(X509Principal x509Principal) {
        this.form = new V2Form(GeneralNames.getInstance(new DERSequence(new GeneralName(x509Principal))));
    }

    private Object[] getNames() {
        ArrayList<X500Principal> arrayList;
        Object object = object.form;
        object = (object instanceof V2Form ? ((V2Form)object).getIssuerName() : (GeneralNames)object).getNames();
        ArrayList<X500Principal> arrayList2 = arrayList;
        arrayList = new ArrayList<X500Principal>(((GeneralName[])object).length);
        for (int i3 = 0; i3 != ((GeneralName[])object).length; ++i3) {
            if (object[i3].getTagNo() != 4) continue;
            try {
                arrayList2.add(new X500Principal(object[i3].getName().toASN1Primitive().getEncoded()));
            }
            catch (IOException iOException) {
                throw new RuntimeException("badly formed Name object");
            }
        }
        ArrayList<X500Principal> arrayList3 = arrayList2;
        return arrayList3.toArray(new Object[arrayList3.size()]);
    }

    private boolean matchesDN(X500Principal x500Principal, GeneralNames generalNames) {
        GeneralName[] generalNameArray = generalNames.getNames();
        for (int i3 = 0; i3 != generalNameArray.length; ++i3) {
            GeneralName generalName = generalNameArray[i3];
            if (generalName.getTagNo() != 4) continue;
            try {
                if (!new X500Principal(generalName.getName().toASN1Primitive().getEncoded()).equals(x500Principal)) continue;
                return true;
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public Principal[] getPrincipals() {
        ArrayList<Object> arrayList;
        Object[] objectArray = objectArray.getNames();
        ArrayList<Object> arrayList2 = arrayList;
        arrayList = new ArrayList<Object>();
        for (int i3 = 0; i3 != objectArray.length; ++i3) {
            Object object = objectArray[i3];
            if (!(object instanceof Principal)) continue;
            arrayList2.add(object);
        }
        ArrayList<Object> arrayList3 = arrayList2;
        return arrayList3.toArray(new Principal[arrayList3.size()]);
    }

    @Override
    public Object clone() {
        return new AttributeCertificateIssuer(AttCertIssuer.getInstance(this.form));
    }

    @Override
    public boolean match(Certificate certificate) {
        Object object;
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        certificate = (X509Certificate)certificate;
        ASN1Encodable aSN1Encodable = ((AttributeCertificateIssuer)object).form;
        if (aSN1Encodable instanceof V2Form) {
            if (((V2Form)(aSN1Encodable = (V2Form)aSN1Encodable)).getBaseCertificateID() != null) {
                return ((V2Form)aSN1Encodable).getBaseCertificateID().getSerial().hasValue(((X509Certificate)certificate).getSerialNumber()) && super.matchesDN(((X509Certificate)certificate).getIssuerX500Principal(), ((V2Form)aSN1Encodable).getBaseCertificateID().getIssuer());
            }
            Object object2 = object;
            object = ((V2Form)aSN1Encodable).getIssuerName();
            if (super.matchesDN(((X509Certificate)certificate).getSubjectX500Principal(), (GeneralNames)object)) {
                return true;
            }
        } else {
            AttributeCertificateIssuer attributeCertificateIssuer = object;
            object = (GeneralNames)aSN1Encodable;
            if (attributeCertificateIssuer.matchesDN(((X509Certificate)certificate).getSubjectX500Principal(), (GeneralNames)object)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == attributeCertificateIssuer2) {
            return true;
        }
        if (!(object instanceof AttributeCertificateIssuer)) {
            return false;
        }
        AttributeCertificateIssuer attributeCertificateIssuer = attributeCertificateIssuer2;
        AttributeCertificateIssuer attributeCertificateIssuer2 = (AttributeCertificateIssuer)object;
        return attributeCertificateIssuer.form.equals(attributeCertificateIssuer2.form);
    }

    public int hashCode() {
        return this.form.hashCode();
    }

    public boolean match(Object object) {
        if (!(object instanceof X509Certificate)) {
            return false;
        }
        return this.match((Certificate)object);
    }
}

