/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Target;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.TargetInformation;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Targets;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Selector;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.AttributeCertificateHolder;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.AttributeCertificateIssuer;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509AttributeCertificate;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class X509AttributeCertStoreSelector
implements Selector {
    private AttributeCertificateHolder holder;
    private AttributeCertificateIssuer issuer;
    private BigInteger serialNumber;
    private Date attributeCertificateValid;
    private X509AttributeCertificate attributeCert;
    private Collection targetNames;
    private Collection targetGroups;

    public X509AttributeCertStoreSelector() {
        HashSet hashSet;
        HashSet hashSet2;
        Cloneable cloneable = hashSet2;
        hashSet2 = new HashSet();
        v1.targetNames = cloneable;
        cloneable = hashSet;
        hashSet = new HashSet();
        v1.targetGroups = cloneable;
    }

    private Set extractGeneralNames(Collection object) {
        if (object != null && !object.isEmpty()) {
            HashSet hashSet;
            Cloneable cloneable = hashSet;
            hashSet = new HashSet();
            object = object.iterator();
            while (object.hasNext()) {
                Object e3 = object.next();
                if (e3 instanceof GeneralName) {
                    ((HashSet)cloneable).add(e3);
                    continue;
                }
                ((HashSet)cloneable).add(GeneralName.getInstance(ASN1Primitive.fromByteArray((byte[])e3)));
            }
            return cloneable;
        }
        return new HashSet();
    }

    public boolean match(Object targetsArray) {
        if (!(targetsArray instanceof X509AttributeCertificate)) {
            return false;
        }
        targetsArray = (X509AttributeCertificate)targetsArray;
        Object object = this.attributeCert;
        if (object != null && !object.equals(targetsArray)) {
            return false;
        }
        if (this.serialNumber != null && !targetsArray.getSerialNumber().equals(this.serialNumber)) {
            return false;
        }
        if (this.holder != null && !targetsArray.getHolder().equals(this.holder)) {
            return false;
        }
        if (this.issuer != null && !targetsArray.getIssuer().equals(this.issuer)) {
            return false;
        }
        object = this.attributeCertificateValid;
        if (object != null) {
            try {
                targetsArray.checkValidity((Date)object);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                return false;
            }
            catch (CertificateExpiredException certificateExpiredException) {
                return false;
            }
        }
        if (!this.targetNames.isEmpty() || !this.targetGroups.isEmpty()) {
            byte[] byArray = targetsArray.getExtensionValue(Extension.targetInformation.getId());
            targetsArray = (Targets[])byArray;
            if (byArray != null) {
                int n3;
                Target[] targetArray;
                int n4;
                block21: {
                    boolean bl;
                    try {
                        targetsArray = TargetInformation.getInstance(new ASN1InputStream(((DEROctetString)ASN1Primitive.fromByteArray((byte[])targetsArray)).getOctets()).readObject()).getTargetsObjects();
                        if (this.targetNames.isEmpty()) break block21;
                        bl = false;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                    block6: for (n4 = 0; n4 < targetsArray.length; ++n4) {
                        targetArray = targetsArray[n4].getTargets();
                        for (n3 = 0; n3 < targetArray.length; ++n3) {
                            if (!this.targetNames.contains(GeneralName.getInstance(targetArray[n3].getTargetName()))) continue;
                            bl = true;
                            continue block6;
                        }
                    }
                    if (!bl) {
                        return false;
                    }
                }
                if (!this.targetGroups.isEmpty()) {
                    boolean bl = false;
                    block8: for (n4 = 0; n4 < targetsArray.length; ++n4) {
                        targetArray = targetsArray[n4].getTargets();
                        for (n3 = 0; n3 < targetArray.length; ++n3) {
                            if (!this.targetGroups.contains(GeneralName.getInstance(targetArray[n3].getTargetGroup()))) continue;
                            bl = true;
                            continue block8;
                        }
                    }
                    if (!bl) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public Object clone() {
        X509AttributeCertStoreSelector x509AttributeCertStoreSelector;
        X509AttributeCertStoreSelector x509AttributeCertStoreSelector2 = x509AttributeCertStoreSelector;
        x509AttributeCertStoreSelector2();
        x509AttributeCertStoreSelector2.attributeCert = this.attributeCert;
        x509AttributeCertStoreSelector2.attributeCertificateValid = this.getAttributeCertificateValid();
        x509AttributeCertStoreSelector2.holder = this.holder;
        x509AttributeCertStoreSelector2.issuer = this.issuer;
        x509AttributeCertStoreSelector2.serialNumber = this.serialNumber;
        x509AttributeCertStoreSelector2.targetGroups = this.getTargetGroups();
        x509AttributeCertStoreSelector.targetNames = this.getTargetNames();
        return x509AttributeCertStoreSelector;
    }

    public X509AttributeCertificate getAttributeCert() {
        return this.attributeCert;
    }

    public void setAttributeCert(X509AttributeCertificate x509AttributeCertificate) {
        this.attributeCert = x509AttributeCertificate;
    }

    public Date getAttributeCertificateValid() {
        if (this.attributeCertificateValid != null) {
            return new Date(this.attributeCertificateValid.getTime());
        }
        return null;
    }

    public void setAttributeCertificateValid(Date date) {
        this.attributeCertificateValid = date != null ? new Date(date.getTime()) : null;
    }

    public AttributeCertificateHolder getHolder() {
        return this.holder;
    }

    public void setHolder(AttributeCertificateHolder attributeCertificateHolder) {
        this.holder = attributeCertificateHolder;
    }

    public AttributeCertificateIssuer getIssuer() {
        return this.issuer;
    }

    public void setIssuer(AttributeCertificateIssuer attributeCertificateIssuer) {
        this.issuer = attributeCertificateIssuer;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.serialNumber = bigInteger;
    }

    public void addTargetName(GeneralName generalName) {
        this.targetNames.add(generalName);
    }

    public void addTargetName(byte[] byArray) {
        this.addTargetName(GeneralName.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    public void setTargetNames(Collection collection) {
        this.targetNames = this.extractGeneralNames(collection);
    }

    public Collection getTargetNames() {
        return Collections.unmodifiableCollection(this.targetNames);
    }

    public void addTargetGroup(GeneralName generalName) {
        this.targetGroups.add(generalName);
    }

    public void addTargetGroup(byte[] byArray) {
        this.addTargetGroup(GeneralName.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    public void setTargetGroups(Collection collection) {
        this.targetGroups = this.extractGeneralNames(collection);
    }

    public Collection getTargetGroups() {
        return Collections.unmodifiableCollection(this.targetGroups);
    }
}

