/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.x509;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AttributeCertificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.AttributeCertificateHolder;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.AttributeCertificateIssuer;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509Attribute;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509AttributeCertificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class X509V2AttributeCertificate
implements X509AttributeCertificate {
    private AttributeCertificate cert;
    private Date notBefore;
    private Date notAfter;

    private static AttributeCertificate getObject(InputStream inputStream) {
        try {
            return AttributeCertificate.getInstance(new ASN1InputStream(inputStream).readObject());
        }
        catch (Exception exception) {
            throw new IOException(d.a(exception, b.a("exception decoding certificate structure: ")));
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    public X509V2AttributeCertificate(InputStream inputStream) {
        this(X509V2AttributeCertificate.getObject(inputStream));
    }

    public X509V2AttributeCertificate(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream;
        X509V2AttributeCertificate x509V2AttributeCertificate = byteArrayInputStream2;
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        x509V2AttributeCertificate(byteArrayInputStream2);
    }

    public X509V2AttributeCertificate(AttributeCertificate attributeCertificate) {
        this.cert = attributeCertificate;
        try {
            this.notAfter = attributeCertificate.getAcinfo().getAttrCertValidityPeriod().getNotAfterTime().getDate();
            this.notBefore = attributeCertificate.getAcinfo().getAttrCertValidityPeriod().getNotBeforeTime().getDate();
            return;
        }
        catch (ParseException parseException) {
            throw new IOException("invalid data structure in certificate!");
        }
    }

    private Set getExtensionOIDs(boolean bl) {
        Extensions extensions = ((X509V2AttributeCertificate)((Object)extensions)).cert.getAcinfo().getExtensions();
        if (extensions != null) {
            HashSet<String> hashSet;
            HashSet<String> hashSet2 = hashSet;
            hashSet = new HashSet<String>();
            Enumeration enumeration = extensions.oids();
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                if (extensions.getExtension(aSN1ObjectIdentifier).isCritical() != bl) continue;
                hashSet2.add(aSN1ObjectIdentifier.getId());
            }
            return hashSet2;
        }
        return null;
    }

    @Override
    public int getVersion() {
        return this.cert.getAcinfo().getVersion().intValueExact() + 1;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.cert.getAcinfo().getSerialNumber().getValue();
    }

    @Override
    public AttributeCertificateHolder getHolder() {
        return new AttributeCertificateHolder((ASN1Sequence)this.cert.getAcinfo().getHolder().toASN1Primitive());
    }

    @Override
    public AttributeCertificateIssuer getIssuer() {
        return new AttributeCertificateIssuer(this.cert.getAcinfo().getIssuer());
    }

    @Override
    public Date getNotBefore() {
        return this.notBefore;
    }

    @Override
    public Date getNotAfter() {
        return this.notAfter;
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        DERBitString dERBitString = ((X509V2AttributeCertificate)((Object)dERBitString)).cert.getAcinfo().getIssuerUniqueID();
        if (dERBitString != null) {
            byte[] byArray = dERBitString.getBytes();
            int n3 = byArray.length * 8 - dERBitString.getPadBits();
            boolean[] blArray = new boolean[n3];
            for (int i3 = 0; i3 != n3; ++i3) {
                boolean bl = (byArray[i3 / 8] & 128 >>> i3 % 8) != 0;
                blArray[i3] = bl;
            }
            return blArray;
        }
        return null;
    }

    @Override
    public void checkValidity() {
        Date date;
        X509V2AttributeCertificate x509V2AttributeCertificate = date2;
        Date date2 = date;
        date = new Date();
        x509V2AttributeCertificate.checkValidity(date2);
    }

    @Override
    public void checkValidity(Date date) {
        if (!date.after(this.getNotAfter())) {
            if (!date.before(this.getNotBefore())) {
                return;
            }
            throw new CertificateNotYetValidException(b.a("certificate not valid till ").append(this.getNotBefore()).toString());
        }
        throw new CertificateExpiredException(b.a("certificate expired on ").append(this.getNotAfter()).toString());
    }

    @Override
    public byte[] getSignature() {
        return this.cert.getSignatureValue().getOctets();
    }

    @Override
    public final void verify(PublicKey publicKey, String object) {
        if (this.cert.getSignatureAlgorithm().equals(this.cert.getAcinfo().getSignature())) {
            object = Signature.getInstance(this.cert.getSignatureAlgorithm().getAlgorithm().getId(), (String)object);
            ((Signature)object).initVerify(publicKey);
            try {
                ((Signature)object).update(this.cert.getAcinfo().getEncoded());
                if (((Signature)object).verify(this.getSignature())) {
                    return;
                }
                throw new InvalidKeyException("Public key presented not for certificate signature");
            }
            catch (IOException iOException) {
                throw new SignatureException("Exception encoding certificate info object");
            }
        }
        throw new CertificateException("Signature algorithm in certificate info not same as outer certificate");
    }

    @Override
    public byte[] getEncoded() {
        return this.cert.getEncoded();
    }

    @Override
    public byte[] getExtensionValue(String string2) {
        Object object = ((X509V2AttributeCertificate)object).cert.getAcinfo().getExtensions();
        if (object != null) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            Object object2 = object;
            object = aSN1ObjectIdentifier;
            aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string2);
            if ((object = ((Extensions)object2).getExtension((ASN1ObjectIdentifier)object)) != null) {
                try {
                    return ((Extension)object).getExtnValue().getEncoded("DER");
                }
                catch (Exception exception) {
                    throw new RuntimeException(d.a(exception, b.a("error encoding ")));
                }
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return (this = ((X509V2AttributeCertificate)this).getCriticalExtensionOIDs()) != null && !this.isEmpty();
    }

    @Override
    public X509Attribute[] getAttributes() {
        ASN1Sequence aSN1Sequence = ((X509V2AttributeCertificate)((Object)aSN1Sequence)).cert.getAcinfo().getAttributes();
        X509Attribute[] x509AttributeArray = new X509Attribute[aSN1Sequence.size()];
        for (int i3 = 0; i3 != aSN1Sequence.size(); ++i3) {
            X509Attribute x509Attribute;
            X509Attribute x509Attribute2 = x509Attribute;
            x509Attribute = new X509Attribute(aSN1Sequence.getObjectAt(i3));
            x509AttributeArray[i3] = x509Attribute2;
        }
        return x509AttributeArray;
    }

    @Override
    public X509Attribute[] getAttributes(String string2) {
        ArrayList<X509Attribute> arrayList;
        ASN1Sequence aSN1Sequence = ((X509V2AttributeCertificate)((Object)aSN1Sequence)).cert.getAcinfo().getAttributes();
        ArrayList<X509Attribute> arrayList2 = arrayList;
        arrayList = new ArrayList<X509Attribute>();
        for (int i3 = 0; i3 != aSN1Sequence.size(); ++i3) {
            X509Attribute x509Attribute;
            X509Attribute x509Attribute2 = x509Attribute;
            if (!new X509Attribute(aSN1Sequence.getObjectAt(i3)).getOID().equals(string2)) continue;
            arrayList2.add(x509Attribute2);
        }
        if (arrayList2.size() == 0) {
            return null;
        }
        ArrayList<X509Attribute> arrayList3 = arrayList2;
        return arrayList3.toArray(new X509Attribute[arrayList3.size()]);
    }

    public boolean equals(Object object) {
        if (object == x509AttributeCertificate) {
            return true;
        }
        if (!(object instanceof X509AttributeCertificate)) {
            return false;
        }
        X509V2AttributeCertificate x509V2AttributeCertificate = x509AttributeCertificate;
        X509AttributeCertificate x509AttributeCertificate = (X509AttributeCertificate)object;
        try {
            return Arrays.areEqual(x509V2AttributeCertificate.getEncoded(), x509AttributeCertificate.getEncoded());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return Arrays.hashCode(this.getEncoded());
        }
        catch (IOException iOException) {
            return 0;
        }
    }
}

