/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.x509;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1GeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.j;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CertificateList;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.TBSCertList;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Time;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.V2TBSCertListGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509ExtensionsGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.JcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.X509Principal;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509CRLObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;

public class X509V2CRLGenerator {
    private final JcaJceHelper bcHelper;
    private V2TBSCertListGenerator tbsGen;
    private ASN1ObjectIdentifier sigOID;
    private AlgorithmIdentifier sigAlgId;
    private String signatureAlgorithm;
    private X509ExtensionsGenerator extGenerator;

    public X509V2CRLGenerator() {
        X509ExtensionsGenerator x509ExtensionsGenerator;
        V2TBSCertListGenerator v2TBSCertListGenerator;
        BCJcaJceHelper bCJcaJceHelper;
        Object object = bCJcaJceHelper;
        bCJcaJceHelper = new BCJcaJceHelper();
        v1.bcHelper = object;
        object = v2TBSCertListGenerator;
        v2TBSCertListGenerator = new V2TBSCertListGenerator();
        v1.tbsGen = object;
        object = x509ExtensionsGenerator;
        x509ExtensionsGenerator = new X509ExtensionsGenerator();
        v1.extGenerator = object;
    }

    private TBSCertList generateCertList() {
        if (!this.extGenerator.isEmpty()) {
            this.tbsGen.setExtensions(this.extGenerator.generate());
        }
        return this.tbsGen.generateTBSCertList();
    }

    private X509CRL generateJcaObject(TBSCertList tBSCertList, byte[] byArray) {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2();
        aSN1EncodableVector2.add(tBSCertList);
        aSN1EncodableVector.add(this.sigAlgId);
        aSN1EncodableVector.add(new DERBitString(byArray));
        return new X509CRLObject(new CertificateList(new DERSequence(aSN1EncodableVector2)));
    }

    public void reset() {
        this.tbsGen = new V2TBSCertListGenerator();
        this.extGenerator.reset();
    }

    public void setIssuerDN(X500Principal x500Principal) {
        try {
            this.tbsGen.setIssuer(new X509Principal(x500Principal.getEncoded()));
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(j.a("can't process principal: ", iOException));
        }
    }

    public void setIssuerDN(X509Name x509Name) {
        this.tbsGen.setIssuer(x509Name);
    }

    public void setThisUpdate(Date date) {
        this.tbsGen.setThisUpdate(new Time(date));
    }

    public void setNextUpdate(Date date) {
        this.tbsGen.setNextUpdate(new Time(date));
    }

    public void addCRLEntry(BigInteger bigInteger, Date date, int n3) {
        Time time;
        Time time2 = time;
        time = new Time(date);
        ((X509V2CRLGenerator)((Object)time2)).tbsGen.addCRLEntry(new ASN1Integer(bigInteger), time2, n3);
    }

    public void addCRLEntry(BigInteger object, Date date, int n3, Date date2) {
        ASN1GeneralizedTime aSN1GeneralizedTime;
        Time time;
        ASN1Integer aSN1Integer = new ASN1Integer((BigInteger)object);
        Time time2 = time;
        time = new Time(date);
        object = aSN1GeneralizedTime;
        aSN1GeneralizedTime = new ASN1GeneralizedTime(date2);
        ((X509V2CRLGenerator)((Object)time2)).tbsGen.addCRLEntry(aSN1Integer, time2, n3, (ASN1GeneralizedTime)object);
    }

    public void addCRLEntry(BigInteger object, Date object2, X509Extensions x509Extensions) {
        Time time;
        ASN1Integer aSN1Integer;
        ASN1Integer aSN1Integer2 = aSN1Integer;
        aSN1Integer = new ASN1Integer((BigInteger)object);
        object = time;
        time = new Time((Date)object2);
        object2 = Extensions.getInstance(x509Extensions);
        ((X509V2CRLGenerator)((Object)aSN1Integer2)).tbsGen.addCRLEntry(aSN1Integer2, (Time)object, (Extensions)object2);
    }

    public void addCRL(X509CRL iterator) {
        if ((iterator = ((X509CRL)((Object)iterator)).getRevokedCertificates()) != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ASN1InputStream aSN1InputStream;
                X509CRLEntry x509CRLEntry = (X509CRLEntry)iterator.next();
                ASN1InputStream aSN1InputStream2 = aSN1InputStream;
                aSN1InputStream = new ASN1InputStream(x509CRLEntry.getEncoded());
                try {
                    this.tbsGen.addCRLEntry(ASN1Sequence.getInstance(aSN1InputStream2.readObject()));
                }
                catch (IOException iOException) {
                    throw new CRLException(b.a("exception processing encoding of CRL: ").append(((Object)iOException).toString()).toString());
                }
            }
        }
    }

    public void setSignatureAlgorithm(String string2) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        X509V2CRLGenerator x509V2CRLGenerator = algorithmIdentifier;
        ((X509V2CRLGenerator)((Object)algorithmIdentifier)).signatureAlgorithm = string2;
        try {
            aSN1ObjectIdentifier = X509Util.getAlgorithmOID(string2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        ((X509V2CRLGenerator)((Object)algorithmIdentifier)).sigOID = aSN1ObjectIdentifier;
        AlgorithmIdentifier algorithmIdentifier = X509Util.getSigAlgID(aSN1ObjectIdentifier, string2);
        x509V2CRLGenerator.sigAlgId = algorithmIdentifier;
        x509V2CRLGenerator.tbsGen.setSignature(algorithmIdentifier);
    }

    public void addExtension(String string2, boolean bl, ASN1Encodable aSN1Encodable) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        X509V2CRLGenerator x509V2CRLGenerator = aSN1ObjectIdentifier2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = aSN1ObjectIdentifier;
        aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string2);
        x509V2CRLGenerator.addExtension(aSN1ObjectIdentifier2, bl, aSN1Encodable);
    }

    public void addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, ASN1Encodable aSN1Encodable) {
        this.extGenerator.addExtension(new ASN1ObjectIdentifier(aSN1ObjectIdentifier.getId()), bl, aSN1Encodable);
    }

    public void addExtension(String string2, boolean bl, byte[] byArray) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        X509V2CRLGenerator x509V2CRLGenerator = aSN1ObjectIdentifier2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = aSN1ObjectIdentifier;
        aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string2);
        x509V2CRLGenerator.addExtension(aSN1ObjectIdentifier2, bl, byArray);
    }

    public void addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, byte[] byArray) {
        this.extGenerator.addExtension(new ASN1ObjectIdentifier(aSN1ObjectIdentifier.getId()), bl, byArray);
    }

    public X509CRL generateX509CRL(PrivateKey privateKey) {
        try {
            return this.generateX509CRL(privateKey, "BC", null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509CRL generateX509CRL(PrivateKey privateKey, SecureRandom secureRandom) {
        try {
            return this.generateX509CRL(privateKey, "BC", secureRandom);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509CRL generateX509CRL(PrivateKey privateKey, String string2) {
        return this.generateX509CRL(privateKey, string2, null);
    }

    public X509CRL generateX509CRL(PrivateKey privateKey, String string2, SecureRandom secureRandom) {
        try {
            return this.generate(privateKey, string2, secureRandom);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SecurityException("exception: " + generalSecurityException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (SignatureException signatureException) {
            throw signatureException;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
    }

    public X509CRL generate(PrivateKey privateKey) {
        return this.generate(privateKey, (SecureRandom)null);
    }

    public X509CRL generate(PrivateKey privateKey, SecureRandom secureRandom) {
        X509V2CRLGenerator x509V2CRLGenerator = this;
        TBSCertList tBSCertList = x509V2CRLGenerator.generateCertList();
        try {
            return x509V2CRLGenerator.generateJcaObject(tBSCertList, X509Util.calculateSignature(this.sigOID, this.signatureAlgorithm, privateKey, secureRandom, tBSCertList));
        }
        catch (IOException iOException) {
            throw new ExtCRLException("cannot generate CRL encoding", iOException);
        }
    }

    public X509CRL generate(PrivateKey privateKey, String string2) {
        return this.generate(privateKey, string2, null);
    }

    public X509CRL generate(PrivateKey privateKey, String string2, SecureRandom secureRandom) {
        X509V2CRLGenerator x509V2CRLGenerator = this;
        TBSCertList tBSCertList = x509V2CRLGenerator.generateCertList();
        try {
            return x509V2CRLGenerator.generateJcaObject(tBSCertList, X509Util.calculateSignature(this.sigOID, this.signatureAlgorithm, string2, privateKey, secureRandom, tBSCertList));
        }
        catch (IOException iOException) {
            throw new ExtCRLException("cannot generate CRL encoding", iOException);
        }
    }

    public Iterator getSignatureAlgNames() {
        return X509Util.getAlgNames();
    }

    public static class ExtCRLException
    extends CRLException {
        public Throwable cause;

        public ExtCRLException(String string2, Throwable throwable) {
            super(string2);
            this.cause = throwable;
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }
    }
}

