/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.cvc;

import com.fis.ekyc.nfc.build_in.cvc.AbstractSequence;
import com.fis.ekyc.nfc.build_in.cvc.CVCTagEnum;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public abstract class CVCObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CVC_VERSION = 0;
    public static final String NEWLINE = System.getProperty("line.separator");
    private static final int INT_LENGTH = 4;
    private static final int LONG_LENGTH = 8;
    private final CVCTagEnum tag;
    private AbstractSequence parent;

    public CVCObject(CVCTagEnum cVCTagEnum) {
        this.tag = cVCTagEnum;
    }

    public static byte[] encodeLength(int n3) {
        int n4 = 0;
        if (n3 > 127) {
            n4 = 1;
            if (n3 > 255) {
                n4 = 2;
            }
        }
        int n5 = n4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n5 + 1);
        if (n5 == 0) {
            byteBuffer.put(0, (byte)n3);
        } else {
            byteBuffer.put(0, (byte)(n4 + 128));
            if (n4 == 1) {
                byteBuffer.put(1, (byte)n3);
            } else {
                byteBuffer.putShort(1, (short)n3);
            }
        }
        return byteBuffer.array();
    }

    public static int decodeLength(DataInputStream dataInputStream) {
        int n3 = ((InputStream)dataInputStream).read();
        if (n3 > 127) {
            n3 = (n3 & 0xF) == 1 ? dataInputStream.readUnsignedByte() : (int)dataInputStream.readShort();
        }
        return n3;
    }

    public static byte[] toByteArray(Integer n3) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n3);
        return CVCObject.trimByteArray(byteBuffer.array());
    }

    public static byte[] toByteArray(Long l3) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putLong(l3);
        return CVCObject.trimByteArray(byteBuffer.array());
    }

    public static byte[] trimByteArray(byte[] byArray) {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < byArray.length && (n4 = byArray[n3] != 0 ? 1 : 0) == 0; ++n3) {
        }
        if (n4 != 0) {
            byte[] byArray2 = byArray;
            byArray = new byte[byArray.length - n3];
            n4 = byArray.length - n3;
            System.arraycopy(byArray2, n3, byArray, 0, n4);
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        }
        return byArray;
    }

    public CVCTagEnum getTag() {
        return this.tag;
    }

    public AbstractSequence getParent() {
        return this.parent;
    }

    public void setParent(AbstractSequence abstractSequence) {
        this.parent = abstractSequence;
    }

    public abstract int encode(DataOutputStream var1);

    public String getAsText() {
        return this.getAsText("", true);
    }

    public String getAsText(boolean bl) {
        return this.getAsText("", bl);
    }

    public String getAsText(String string2) {
        return this.getAsText(string2, true);
    }

    public String getAsText(String string2, boolean bl) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        new StringBuffer().append(string2);
        if (bl) {
            stringBuffer2.append(Integer.toHexString(this.getTag().getValue())).append(' ');
        }
        StringBuffer stringBuffer3 = stringBuffer2;
        stringBuffer3.append(this.getTag().name()).append("  ");
        return stringBuffer3.toString();
    }
}

