/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.cvc;

import com.fis.ekyc.nfc.build_in.cvc.AccessRightEnum;
import com.fis.ekyc.nfc.build_in.cvc.AccessRights;
import com.fis.ekyc.nfc.build_in.cvc.AlgorithmUtil;
import com.fis.ekyc.nfc.build_in.cvc.AuthorizationRole;
import com.fis.ekyc.nfc.build_in.cvc.AuthorizationRoleEnum;
import com.fis.ekyc.nfc.build_in.cvc.CAReferenceField;
import com.fis.ekyc.nfc.build_in.cvc.CVCAuthenticatedRequest;
import com.fis.ekyc.nfc.build_in.cvc.CVCDiscretionaryDataTemplate;
import com.fis.ekyc.nfc.build_in.cvc.CVCPublicKey;
import com.fis.ekyc.nfc.build_in.cvc.CVCertificate;
import com.fis.ekyc.nfc.build_in.cvc.CVCertificateBody;
import com.fis.ekyc.nfc.build_in.cvc.HolderReferenceField;
import com.fis.ekyc.nfc.build_in.cvc.KeyFactory;
import com.fis.ekyc.nfc.build_in.cvc.util.BCECUtil;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;

public final class CertificateGenerator {
    private CertificateGenerator() {
    }

    public static CVCertificate createTestCertificate(PublicKey serializable, PrivateKey serializable2, CAReferenceField cAReferenceField, HolderReferenceField holderReferenceField, String string2, AuthorizationRoleEnum authorizationRoleEnum) {
        PublicKey publicKey = serializable;
        PrivateKey privateKey = serializable2;
        serializable = Calendar.getInstance().getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 3);
        serializable2 = calendar.getTime();
        AccessRightEnum accessRightEnum = AccessRightEnum.READ_ACCESS_DG3_AND_DG4;
        return CertificateGenerator.createCertificate(publicKey, privateKey, string2, cAReferenceField, holderReferenceField, authorizationRoleEnum, accessRightEnum, (Date)serializable, (Date)serializable2, "BC");
    }

    public static CVCertificate createCertificate(PrivateKey privateKey, String string2, CVCertificateBody cVCertificateBody, String string3) {
        CVCertificate cVCertificate;
        CVCertificate cVCertificate2 = cVCertificate;
        String string4 = string2;
        cVCertificate2(cVCertificateBody);
        Signature signature = Signature.getInstance(AlgorithmUtil.convertAlgorithmNameToCVC(string4), string3);
        signature.initSign(privateKey);
        signature.update(cVCertificate2.getTBS());
        cVCertificate.setSignature(BCECUtil.convertX962SigToCVC(string4, signature.sign()));
        return cVCertificate;
    }

    public static CVCertificate createCertificate(PublicKey publicKey, PrivateKey serializable, String string2, CAReferenceField cAReferenceField, HolderReferenceField holderReferenceField, AuthorizationRole authorizationRole, AccessRights accessRights, Date date, Date date2, Collection<CVCDiscretionaryDataTemplate> collection, String string3) {
        CVCertificateBody cVCertificateBody;
        PrivateKey privateKey = serializable;
        publicKey = KeyFactory.createInstance(publicKey, string2, authorizationRole);
        serializable = cVCertificateBody;
        cVCertificateBody = new CVCertificateBody(cAReferenceField, (CVCPublicKey)publicKey, holderReferenceField, authorizationRole, accessRights, date, date2, collection);
        return CertificateGenerator.createCertificate(privateKey, string2, (CVCertificateBody)serializable, string3);
    }

    public static CVCertificate createCertificate(PublicKey publicKey, PrivateKey privateKey, String string2, CAReferenceField cAReferenceField, HolderReferenceField holderReferenceField, AuthorizationRole authorizationRole, AccessRights accessRights, Date date, Date date2, String string3) {
        return CertificateGenerator.createCertificate(publicKey, privateKey, string2, cAReferenceField, holderReferenceField, authorizationRole, accessRights, date, date2, null, string3);
    }

    public static CVCertificate createCertificate(PublicKey publicKey, PrivateKey privateKey, String string2, CAReferenceField cAReferenceField, HolderReferenceField holderReferenceField, AuthorizationRoleEnum authorizationRoleEnum, AccessRightEnum accessRightEnum, Date date, Date date2, String string3) {
        return CertificateGenerator.createCertificate(publicKey, privateKey, string2, cAReferenceField, holderReferenceField, (AuthorizationRole)authorizationRoleEnum, (AccessRights)accessRightEnum, date, date2, string3);
    }

    public static CVCertificate createRequest(KeyPair keyPair, String string2, HolderReferenceField holderReferenceField) {
        return CertificateGenerator.createRequest(keyPair, string2, holderReferenceField, "BC");
    }

    public static CVCertificate createRequest(KeyPair keyPair, String string2, HolderReferenceField holderReferenceField, String string3) {
        return CertificateGenerator.createRequest(keyPair, string2, null, holderReferenceField, string3);
    }

    public static CVCertificate createRequest(KeyPair keyPair, String string2, CAReferenceField cAReferenceField, HolderReferenceField holderReferenceField) {
        return CertificateGenerator.createRequest(keyPair, string2, cAReferenceField, holderReferenceField, null, "BC");
    }

    public static CVCertificate createRequest(KeyPair keyPair, String string2, CAReferenceField cAReferenceField, HolderReferenceField holderReferenceField, String string3) {
        return CertificateGenerator.createRequest(keyPair, string2, cAReferenceField, holderReferenceField, null, string3);
    }

    public static CVCertificate createRequest(KeyPair keyPair, String string2, CAReferenceField cVCObject, HolderReferenceField holderReferenceField, Collection<CVCDiscretionaryDataTemplate> collection, String string3) {
        CVCertificate cVCertificate;
        CVCertificateBody cVCertificateBody;
        CVCPublicKey cVCPublicKey = KeyFactory.createInstance(keyPair.getPublic(), string2, null);
        CVCertificateBody cVCertificateBody2 = cVCertificateBody;
        cVCertificateBody = new CVCertificateBody((CAReferenceField)cVCObject, cVCPublicKey, holderReferenceField, collection);
        cVCObject = cVCertificate;
        String string4 = string2;
        ((CVCertificate)cVCObject)(cVCertificateBody2);
        Signature signature = Signature.getInstance(AlgorithmUtil.convertAlgorithmNameToCVC(string4), string3);
        signature.initSign(keyPair.getPrivate());
        signature.update(((CVCertificate)cVCObject).getTBS());
        cVCertificate.setSignature(BCECUtil.convertX962SigToCVC(string4, signature.sign()));
        return cVCertificate;
    }

    public static CVCAuthenticatedRequest createAuthenticatedRequest(CVCertificate cVCertificate, KeyPair keyPair, String string2, CAReferenceField cAReferenceField) {
        return CertificateGenerator.createAuthenticatedRequest(cVCertificate, keyPair, string2, cAReferenceField, "BC");
    }

    public static CVCAuthenticatedRequest createAuthenticatedRequest(CVCertificate cVCertificate, KeyPair keyPair, String string2, CAReferenceField cAReferenceField, String string3) {
        CVCAuthenticatedRequest cVCAuthenticatedRequest;
        CVCAuthenticatedRequest cVCAuthenticatedRequest2 = cVCAuthenticatedRequest;
        String string4 = string2;
        cVCAuthenticatedRequest2(cVCertificate, cAReferenceField);
        Signature signature = Signature.getInstance(AlgorithmUtil.convertAlgorithmNameToCVC(string4), string3);
        signature.initSign(keyPair.getPrivate());
        signature.update(cVCAuthenticatedRequest2.getTBS());
        cVCAuthenticatedRequest.setSignature(BCECUtil.convertX962SigToCVC(string4, signature.sign()));
        return cVCAuthenticatedRequest;
    }
}

