/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.cvc;

import com.fis.ekyc.nfc.build_in.cvc.AbstractSequence;
import com.fis.ekyc.nfc.build_in.cvc.ByteField;
import com.fis.ekyc.nfc.build_in.cvc.CVCObject;
import com.fis.ekyc.nfc.build_in.cvc.CVCPublicKey;
import com.fis.ekyc.nfc.build_in.cvc.CVCTagEnum;
import com.fis.ekyc.nfc.build_in.cvc.GenericPublicKeyField;
import com.fis.ekyc.nfc.build_in.cvc.OIDField;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;

public class PublicKeyRSA
extends CVCPublicKey
implements RSAPublicKey {
    private static final long serialVersionUID = 1L;
    private static CVCTagEnum[] allowedFields = new CVCTagEnum[]{CVCTagEnum.OID, CVCTagEnum.MODULUS, CVCTagEnum.EXPONENT};

    public PublicKeyRSA(GenericPublicKeyField genericPublicKeyField) {
        PublicKeyRSA publicKeyRSA = cVCObject;
        PublicKeyRSA publicKeyRSA2 = cVCObject;
        GenericPublicKeyField genericPublicKeyField2 = genericPublicKeyField;
        CVCObject cVCObject = (ByteField)genericPublicKeyField2.getSubfield(CVCTagEnum.MODULUS);
        ((ByteField)cVCObject).setShowBitLength(true);
        publicKeyRSA2.addSubfield(genericPublicKeyField2.getSubfield(CVCTagEnum.OID));
        publicKeyRSA2.addSubfield(cVCObject);
        publicKeyRSA.addSubfield(genericPublicKeyField.getSubfield(CVCTagEnum.EXPONENT));
    }

    public PublicKeyRSA(OIDField oIDField, RSAPublicKey rSAPublicKey) {
        PublicKeyRSA publicKeyRSA = this;
        publicKeyRSA.addSubfield(oIDField);
        publicKeyRSA.addSubfield(new ByteField(CVCTagEnum.MODULUS, CVCObject.trimByteArray(rSAPublicKey.getModulus().toByteArray()), true));
        publicKeyRSA.addSubfield(new ByteField(CVCTagEnum.EXPONENT, CVCObject.trimByteArray(rSAPublicKey.getPublicExponent().toByteArray())));
    }

    @Override
    public CVCTagEnum[] getAllowedFields() {
        return allowedFields;
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public String getFormat() {
        return "CVC";
    }

    @Override
    public BigInteger getPublicExponent() {
        int n3;
        try {
            CVCObject cVCObject = (ByteField)((AbstractSequence)cVCObject).getSubfield(CVCTagEnum.EXPONENT);
            n3 = 1;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException(noSuchFieldException);
        }
        return new BigInteger(n3, ((ByteField)cVCObject).getData());
    }

    @Override
    public BigInteger getModulus() {
        int n3;
        try {
            CVCObject cVCObject = (ByteField)((AbstractSequence)cVCObject).getSubfield(CVCTagEnum.MODULUS);
            n3 = 1;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException(noSuchFieldException);
        }
        return new BigInteger(n3, ((ByteField)cVCObject).getData());
    }
}

