/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.cvc;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.cvc.AbstractDataField;
import com.fis.ekyc.nfc.build_in.cvc.CVCTagEnum;

public abstract class ReferenceField
extends AbstractDataField {
    private static final long serialVersionUID = 1L;
    private String country = null;
    private String mnemonic = null;
    private String sequence = null;

    public ReferenceField(CVCTagEnum cVCTagEnum, String string2, String string3, String string4) {
        super(cVCTagEnum);
        if (string2.length() == 2) {
            if (this.isValidCountry(string2)) {
                if (string3.length() != 0) {
                    if (string3.length() <= 9) {
                        if (string4.length() == 5) {
                            for (int i3 = 0; i3 < string4.length(); ++i3) {
                                if (Character.isLetterOrDigit(string4.charAt(i3))) {
                                    continue;
                                }
                                throw new IllegalArgumentException(i.a("Sequence number can only contain alphanumerics: ", string4));
                            }
                            ReferenceField referenceField = this;
                            referenceField.country = string2;
                            referenceField.mnemonic = string3;
                            referenceField.sequence = string4;
                            return;
                        }
                        throw new IllegalArgumentException(b.a("Sequence number must have length 5, was ").append(string4.length()).toString());
                    }
                    throw new IllegalArgumentException(b.a("Holder mnemonic too long, max=9, was ").append(string3.length()).toString());
                }
                throw new IllegalArgumentException("Holder mnemonic too short, must have at least one character");
            }
            throw new IllegalArgumentException(i.a("Unknown country code: ", string2));
        }
        throw new IllegalArgumentException(b.a("Country code length must be 2, was ").append(string2.length()).toString());
    }

    public ReferenceField(CVCTagEnum object, byte[] byArray) {
        super((CVCTagEnum)((Object)object));
        String string2;
        Object object2 = object = string2;
        Object object3 = object;
        super(byArray);
        this.country = ((String)object3).substring(0, 2);
        this.mnemonic = ((String)object2).substring(2, ((String)object2).length() - 5);
        this.sequence = string2.substring(string2.length() - 5);
    }

    private boolean okChar(char c3) {
        return c3 >= 'A' && c3 <= 'Z';
    }

    private boolean isValidCountry(String string2) {
        return this.okChar(string2.charAt(0)) && this.okChar(string2.charAt(1));
    }

    public String getConcatenated() {
        return this.country + this.mnemonic + this.sequence;
    }

    public String getCountry() {
        return this.country;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public String getSequence() {
        return this.sequence;
    }

    @Override
    public byte[] getEncoded() {
        return this.getConcatenated().getBytes();
    }

    @Override
    public String valueAsText() {
        return this.country + "/" + this.mnemonic + "/" + this.sequence;
    }
}

