/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.e;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.DHParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X962NamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.ECNamedCurveTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import com.fis.ekyc.nfc.build_in.eidparser.PACESecretKeySpec;
import com.fis.ekyc.nfc.build_in.eidparser.lds.PACEInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.SecurityInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.icao.MRZInfo;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVInputStream;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class Util {
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    public static final int ENC_MODE = 1;
    public static final int MAC_MODE = 2;
    public static final int PACE_MODE = 3;
    private static final Provider BC_PROVIDER = new BouncyCastleProvider();
    private static final String RFC5114_1024_160_P = "B10B8F96A080E01DDE92DE5EAE5D54EC52C99FBCFB06A3C69A6A9DCA52D23B616073E28675A23D189838EF1E2EE652C013ECB4AEA906112324975C3CD49B83BFACCBDD7D90C4BD7098488E9C219A73724EFFD6FAE5644738FAA31A4FF55BCCC0A151AF5F0DC8B4BD45BF37DF365C1A65E68CFDA76D4DA708DF1FB2BC2E4A4371";
    private static final String RFC5114_1024_160_G = "A4D1CBD5C3FD34126765A442EFB99905F8104DD258AC507FD6406CFF14266D31266FEA1E5C41564B777E690F5504F213160217B4B01B886A5E91547F9E2749F4D7FBD7D3B9A92EE1909D0D2263F80A76A6A24C087A091F531DBF0A0169B6A28AD662A4D18E73AFA32D779D5918D08BC8858F4DCEF97C2A24855E6EEB22B3B2E5";
    private static final String RFC5114_1024_160_Q = "F518AA8781A8DF278ABA4E7D64B7CB9D49462353";
    private static final String RFC5114_2048_224_P = "AD107E1E9123A9D0D660FAA79559C51FA20D64E5683B9FD1B54B1597B61D0A75E6FA141DF95A56DBAF9A3C407BA1DF15EB3D688A309C180E1DE6B85A1274A0A66D3F8152AD6AC2129037C9EDEFDA4DF8D91E8FEF55B7394B7AD5B7D0B6C12207C9F98D11ED34DBF6C6BA0B2C8BBC27BE6A00E0A0B9C49708B3BF8A317091883681286130BC8985DB1602E714415D9330278273C7DE31EFDC7310F7121FD5A07415987D9ADC0A486DCDF93ACC44328387315D75E198C641A480CD86A1B9E587E8BE60E69CC928B2B9C52172E413042E9B23F10B0E16E79763C9B53DCF4BA80A29E3FB73C16B8E75B97EF363E2FFA31F71CF9DE5384E71B81C0AC4DFFE0C10E64F";
    private static final String RFC5114_2048_224_G = "AC4032EF4F2D9AE39DF30B5C8FFDAC506CDEBE7B89998CAF74866A08CFE4FFE3A6824A4E10B9A6F0DD921F01A70C4AFAAB739D7700C29F52C57DB17C620A8652BE5E9001A8D66AD7C17669101999024AF4D027275AC1348BB8A762D0521BC98AE247150422EA1ED409939D54DA7460CDB5F6C6B250717CBEF180EB34118E98D119529A45D6F834566E3025E316A330EFBB77A86F0C1AB15B051AE3D428C8F8ACB70A8137150B8EEB10E183EDD19963DDD9E263E4770589EF6AA21E7F5F2FF381B539CCE3409D13CD566AFBB48D6C019181E1BCFE94B30269EDFE72FE9B6AA4BD7B5A0F1C71CFFF4C19C418E1F6EC017981BC087F2A7065B384B890D3191F2BFA";
    private static final String RFC5114_2048_224_Q = "801C0D34C58D93FE997177101F80535A4738CEBCBF389A99B36371EB";
    private static final String RFC5114_2048_256_P = "87A8E61DB4B6663CFFBBD19C651959998CEEF608660DD0F25D2CEED4435E3B00E00DF8F1D61957D4FAF7DF4561B2AA3016C3D91134096FAA3BF4296D830E9A7C209E0C6497517ABD5A8A9D306BCF67ED91F9E6725B4758C022E0B1EF4275BF7B6C5BFC11D45F9088B941F54EB1E59BB8BC39A0BF12307F5C4FDB70C581B23F76B63ACAE1CAA6B7902D52526735488A0EF13C6D9A51BFA4AB3AD8347796524D8EF6A167B5A41825D967E144E5140564251CCACB83E6B486F6B3CA3F7971506026C0B857F689962856DED4010ABD0BE621C3A3960A54E710C375F26375D7014103A4B54330C198AF126116D2276E11715F693877FAD7EF09CADB094AE91E1A1597";
    private static final String RFC5114_2048_256_G = "3FB32C9B73134D0B2E77506660EDBD484CA7B18F21EF205407F4793A1A0BA12510DBC15077BE463FFF4FED4AAC0BB555BE3A6C1B0C6B47B1BC3773BF7E8C6F62901228F8C28CBB18A55AE31341000A650196F931C77A57F2DDF463E5E9EC144B777DE62AAAB8A8628AC376D282D6ED3864E67982428EBC831D14348F6F2F9193B5045AF2767164E1DFC967C1FB3F2E55A4BD1BFFE83B9C80D052B985D182EA0ADB2A3B7313D3FE14C8484B1E052588B9B7D2BBD2DF016199ECD06E1557CD0915B3353BBB64E0EC377FD028370DF92B52C7891428CDC67EB6184B523D1DB246C32F63078490F00EF8D647D148D47954515E2327CFEF98C582664B4C0F6CC41659";
    private static final String RFC5114_2048_256_Q = "8CF83642A709A097B447997640129DA299B1A47D1EB3750BA308B0FE64F5FBD3";
    @Deprecated
    public static final DHParameters RFC5114_1024_160 = Util.fromPGQ("B10B8F96A080E01DDE92DE5EAE5D54EC52C99FBCFB06A3C69A6A9DCA52D23B616073E28675A23D189838EF1E2EE652C013ECB4AEA906112324975C3CD49B83BFACCBDD7D90C4BD7098488E9C219A73724EFFD6FAE5644738FAA31A4FF55BCCC0A151AF5F0DC8B4BD45BF37DF365C1A65E68CFDA76D4DA708DF1FB2BC2E4A4371", "A4D1CBD5C3FD34126765A442EFB99905F8104DD258AC507FD6406CFF14266D31266FEA1E5C41564B777E690F5504F213160217B4B01B886A5E91547F9E2749F4D7FBD7D3B9A92EE1909D0D2263F80A76A6A24C087A091F531DBF0A0169B6A28AD662A4D18E73AFA32D779D5918D08BC8858F4DCEF97C2A24855E6EEB22B3B2E5", "F518AA8781A8DF278ABA4E7D64B7CB9D49462353");
    @Deprecated
    public static final DHParameters RFC5114_2048_224 = Util.fromPGQ("AD107E1E9123A9D0D660FAA79559C51FA20D64E5683B9FD1B54B1597B61D0A75E6FA141DF95A56DBAF9A3C407BA1DF15EB3D688A309C180E1DE6B85A1274A0A66D3F8152AD6AC2129037C9EDEFDA4DF8D91E8FEF55B7394B7AD5B7D0B6C12207C9F98D11ED34DBF6C6BA0B2C8BBC27BE6A00E0A0B9C49708B3BF8A317091883681286130BC8985DB1602E714415D9330278273C7DE31EFDC7310F7121FD5A07415987D9ADC0A486DCDF93ACC44328387315D75E198C641A480CD86A1B9E587E8BE60E69CC928B2B9C52172E413042E9B23F10B0E16E79763C9B53DCF4BA80A29E3FB73C16B8E75B97EF363E2FFA31F71CF9DE5384E71B81C0AC4DFFE0C10E64F", "AC4032EF4F2D9AE39DF30B5C8FFDAC506CDEBE7B89998CAF74866A08CFE4FFE3A6824A4E10B9A6F0DD921F01A70C4AFAAB739D7700C29F52C57DB17C620A8652BE5E9001A8D66AD7C17669101999024AF4D027275AC1348BB8A762D0521BC98AE247150422EA1ED409939D54DA7460CDB5F6C6B250717CBEF180EB34118E98D119529A45D6F834566E3025E316A330EFBB77A86F0C1AB15B051AE3D428C8F8ACB70A8137150B8EEB10E183EDD19963DDD9E263E4770589EF6AA21E7F5F2FF381B539CCE3409D13CD566AFBB48D6C019181E1BCFE94B30269EDFE72FE9B6AA4BD7B5A0F1C71CFFF4C19C418E1F6EC017981BC087F2A7065B384B890D3191F2BFA", "801C0D34C58D93FE997177101F80535A4738CEBCBF389A99B36371EB");
    @Deprecated
    public static final DHParameters RFC5114_2048_256 = Util.fromPGQ("87A8E61DB4B6663CFFBBD19C651959998CEEF608660DD0F25D2CEED4435E3B00E00DF8F1D61957D4FAF7DF4561B2AA3016C3D91134096FAA3BF4296D830E9A7C209E0C6497517ABD5A8A9D306BCF67ED91F9E6725B4758C022E0B1EF4275BF7B6C5BFC11D45F9088B941F54EB1E59BB8BC39A0BF12307F5C4FDB70C581B23F76B63ACAE1CAA6B7902D52526735488A0EF13C6D9A51BFA4AB3AD8347796524D8EF6A167B5A41825D967E144E5140564251CCACB83E6B486F6B3CA3F7971506026C0B857F689962856DED4010ABD0BE621C3A3960A54E710C375F26375D7014103A4B54330C198AF126116D2276E11715F693877FAD7EF09CADB094AE91E1A1597", "3FB32C9B73134D0B2E77506660EDBD484CA7B18F21EF205407F4793A1A0BA12510DBC15077BE463FFF4FED4AAC0BB555BE3A6C1B0C6B47B1BC3773BF7E8C6F62901228F8C28CBB18A55AE31341000A650196F931C77A57F2DDF463E5E9EC144B777DE62AAAB8A8628AC376D282D6ED3864E67982428EBC831D14348F6F2F9193B5045AF2767164E1DFC967C1FB3F2E55A4BD1BFFE83B9C80D052B985D182EA0ADB2A3B7313D3FE14C8484B1E052588B9B7D2BBD2DF016199ECD06E1557CD0915B3353BBB64E0EC377FD028370DF92B52C7891428CDC67EB6184B523D1DB246C32F63078490F00EF8D647D148D47954515E2327CFEF98C582664B4C0F6CC41659", "8CF83642A709A097B447997640129DA299B1A47D1EB3750BA308B0FE64F5FBD3");

    private Util() {
    }

    public static Provider getBouncyCastleProvider() {
        return BC_PROVIDER;
    }

    public static SecretKey deriveKey(byte[] byArray, int n3) {
        return Util.deriveKey(byArray, "DESede", 128, n3);
    }

    public static SecretKey deriveKey(byte[] byArray, String string2, int n3, int n4) {
        return Util.deriveKey(byArray, string2, n3, null, n4);
    }

    public static SecretKey deriveKey(byte[] byArray, String string2, int n3, byte[] byArray2, int n4) {
        return Util.deriveKey(byArray, string2, n3, byArray2, n4, (byte)0);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecretKey deriveKey(byte[] object, String string2, int n3, byte[] byArray, int n4, byte by) {
        void var0_4;
        void var5_9;
        void var4_8;
        byte[] byArray2;
        void var2_6;
        void var1_5;
        MessageDigest messageDigest = Util.getMessageDigest(Util.inferDigestAlgorithmFromCipherAlgorithmForKeyDerivation((String)var1_5, (int)var2_6));
        messageDigest.reset();
        messageDigest.update((byte[])object);
        if (byArray2 != null) {
            messageDigest.update(byArray2);
        }
        MessageDigest messageDigest2 = messageDigest;
        messageDigest2.update(new byte[]{0, 0, 0, (byte)var4_8});
        byte[] byArray3 = messageDigest2.digest();
        byArray2 = null;
        if (!"DESede".equalsIgnoreCase((String)var1_5) && !"3DES".equalsIgnoreCase((String)var1_5)) {
            if ("AES".equalsIgnoreCase((String)var1_5) || var1_5.startsWith("AES")) {
                if (var2_6 != 128) {
                    if (var2_6 != 192) {
                        if (var2_6 != 256) throw new IllegalArgumentException(f.a("KDF can only use AES with 128-bit, 192-bit key or 256-bit length, found: ", (int)var2_6, "-bit key length"));
                        byArray2 = new byte[32];
                        System.arraycopy(byArray3, 0, byArray2, 0, 32);
                    } else {
                        byArray2 = new byte[24];
                        System.arraycopy(byArray3, 0, byArray2, 0, 24);
                    }
                } else {
                    byArray2 = new byte[16];
                    System.arraycopy(byArray3, 0, byArray2, 0, 16);
                }
            }
        } else {
            if (var2_6 != 112 && var2_6 != 128) {
                throw new IllegalArgumentException("KDF can only use DESede with 128-bit key length");
            }
            byte[] byArray4 = byArray3;
            byArray2 = new byte[24];
            System.arraycopy(byArray4, 0, byArray2, 0, 8);
            System.arraycopy(byArray4, 8, byArray2, 8, 8);
            System.arraycopy(byArray3, 0, byArray2, 16, 8);
        }
        if (var5_9 == false) {
            SecretKeySpec secretKeySpec;
            SecretKeySpec secretKeySpec2 = secretKeySpec;
            secretKeySpec = new SecretKeySpec(byArray2, (String)var1_5);
            return var0_4;
        } else {
            PACESecretKeySpec pACESecretKeySpec;
            PACESecretKeySpec pACESecretKeySpec2 = pACESecretKeySpec;
            pACESecretKeySpec = new PACESecretKeySpec(byArray2, (String)var1_5, (byte)var5_9);
        }
        return var0_4;
    }

    public static byte[] computeKeySeed(String string2, String string3, String string4, String string5, boolean bl) {
        return Util.computeKeySeed(b.a(string2).append(MRZInfo.checkDigit(string2)).append(string3).append(MRZInfo.checkDigit(string3)).append(string4).append(MRZInfo.checkDigit(string4)).toString(), string5, bl);
    }

    public static byte[] computeKeySeed(String object, String object2, boolean bl) {
        MessageDigest messageDigest = MessageDigest.getInstance((String)object2);
        messageDigest.update(Util.getBytes((String)object));
        object = messageDigest.digest();
        if (bl) {
            byte[] byArray = new byte[16];
            object2 = byArray;
            System.arraycopy(object, 0, object2, 0, 16);
            return byArray;
        }
        return object;
    }

    public static byte[] pad(byte[] byArray, int n3) {
        return Util.pad(byArray, 0, byArray.length, n3);
    }

    public static byte[] pad(byte[] byArray, int n3, int n4, int n5) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        new ByteArrayOutputStream().write(byArray, n3, n4);
        byteArrayOutputStream2.write(-128);
        while (byteArrayOutputStream2.size() % n5 != 0) {
            byteArrayOutputStream2.write(0);
        }
        return byteArrayOutputStream2.toByteArray();
    }

    public static byte[] unpad(byte[] object) {
        int n3;
        for (n3 = ((byte[])object).length - 1; n3 >= 0 && object[n3] == 0; --n3) {
        }
        if ((object[n3] & 0xFF) == 128) {
            byte[] byArray = new byte[n3];
            System.arraycopy(object, 0, byArray, 0, n3);
            return byArray;
        }
        byte[] byArray = object;
        object = b.a("Expected constant 0x80, found 0x");
        throw new BadPaddingException(h.a(byArray[n3] & 0xFF, (StringBuilder)object));
    }

    public static byte[] recoverMessage(int n3, byte[] byArray) {
        block7: {
            block8: {
                block11: {
                    int n4;
                    block10: {
                        block9: {
                            if (byArray == null || byArray.length < 1) break block7;
                            if ((byArray[byArray.length - 1] & 0xF ^ 0xC) != 0) break block8;
                            if ((byArray[byArray.length - 1] & 0xFF ^ 0xBC) != 0) break block9;
                            n4 = 1;
                            break block10;
                        }
                        if ((byArray[byArray.length - 1] & 0xFF ^ 0xCC) != 0) break block11;
                        n4 = 2;
                    }
                    int n5 = byArray[0];
                    if ((n5 & 0xC0 ^ 0x40) == 0) {
                        if ((n5 & 0x20) != 0) {
                            for (n5 = 0; n5 < byArray.length && (byArray[n5] & 0xF ^ 0xA) != 0; ++n5) {
                            }
                            if ((n3 = a.a(byArray.length, n4, n3, ++n5)) > 0) {
                                byte[] byArray2 = new byte[n3];
                                System.arraycopy(byArray, n5, byArray2, 0, n3);
                                return byArray2;
                            }
                            throw new NumberFormatException("Could not get M1");
                        }
                        StringBuilder stringBuilder = b.a("Could not get M1, first byte indicates partial recovery not enabled: ");
                        throw new NumberFormatException(h.a(byArray[0], stringBuilder));
                    }
                    throw new NumberFormatException("Could not get M1");
                }
                throw new NumberFormatException("Not an ISO 9796-2 scheme 2 signature trailer");
            }
            throw new NumberFormatException("Could not get M1, malformed trailer");
        }
        throw new IllegalArgumentException("Plaintext is too short to recover message");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getRawECDSASignature(byte[] object, int n3) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream;
        ASN1InputStream aSN1InputStream;
        ASN1InputStream aSN1InputStream2 = aSN1InputStream;
        aSN1InputStream = new ASN1InputStream((byte[])object);
        object = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Enumeration enumeration = ((ASN1Sequence)aSN1InputStream.readObject()).getObjects();
            while (enumeration.hasMoreElements()) {
                ((OutputStream)object).write(Util.alignKeyDataToSize(((ASN1Integer)enumeration.nextElement()).getValue().toByteArray(), n3));
            }
            Object object2 = object;
            ((OutputStream)object2).flush();
            byArray = ((ByteArrayOutputStream)object2).toByteArray();
        }
        catch (Throwable throwable) {
            ((InputStream)aSN1InputStream2).close();
            ((ByteArrayOutputStream)object).close();
            throw throwable;
        }
        ((InputStream)aSN1InputStream2).close();
        ((ByteArrayOutputStream)object).close();
        return byArray;
    }

    public static byte[] alignKeyDataToSize(byte[] byArray, int n3) {
        byte[] byArray2 = new byte[n3];
        int n4 = byArray.length < n3 ? byArray.length : n3;
        int n5 = byArray.length - n4;
        System.arraycopy(byArray, n5, byArray2, n3 -= n4, n4);
        return byArray2;
    }

    public static byte[] i2os(BigInteger bigInteger, int n3) {
        BigInteger bigInteger2 = BigInteger.valueOf(256L);
        byte[] byArray = new byte[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            BigInteger bigInteger3 = bigInteger;
            bigInteger = bigInteger.mod(bigInteger2);
            BigInteger bigInteger4 = bigInteger3.divide(bigInteger2);
            byArray[n3 - 1 - i3] = (byte)bigInteger.intValue();
            bigInteger = bigInteger4;
        }
        return byArray;
    }

    public static byte[] i2os(BigInteger bigInteger) {
        int n3 = bigInteger.toString(16).length();
        if (n3 % 2 != 0) {
            ++n3;
        }
        return Util.i2os(bigInteger, n3 / 2);
    }

    public static BigInteger os2i(byte[] byArray) {
        if (byArray != null) {
            return Util.os2i(byArray, 0, byArray.length);
        }
        throw new IllegalArgumentException();
    }

    public static BigInteger os2i(byte[] byArray, int n3, int n4) {
        if (byArray != null) {
            BigInteger bigInteger = BigInteger.ZERO;
            BigInteger bigInteger2 = BigInteger.valueOf(256L);
            for (int i3 = n3; i3 < n3 + n4; ++i3) {
                bigInteger = bigInteger.multiply(bigInteger2).add(BigInteger.valueOf(byArray[i3] & 0xFF));
            }
            return bigInteger;
        }
        throw new IllegalArgumentException();
    }

    public static BigInteger os2fe(byte[] byArray, BigInteger bigInteger) {
        return Util.os2i(byArray).mod(bigInteger);
    }

    public static String inferDigestAlgorithmFromSignatureAlgorithm(String string2) {
        if (string2 != null) {
            String string3 = string2;
            string2 = null;
            String string4 = string3.toUpperCase();
            if (string4.contains("WITH")) {
                string2 = string4.split("WITH")[0];
            }
            if ("SHA1".equalsIgnoreCase(string2)) {
                return "SHA-1";
            }
            if ("SHA224".equalsIgnoreCase(string2)) {
                return "SHA-224";
            }
            if ("SHA256".equalsIgnoreCase(string2)) {
                return "SHA-256";
            }
            if ("SHA384".equalsIgnoreCase(string2)) {
                return "SHA-384";
            }
            if ("SHA512".equalsIgnoreCase(string2)) {
                string2 = "SHA-512";
            }
            return string2;
        }
        throw new IllegalArgumentException();
    }

    public static String inferDigestAlgorithmFromCipherAlgorithmForKeyDerivation(String string2, int n3) {
        if (string2 != null) {
            if (!"DESede".equals(string2) && !"AES-128".equals(string2)) {
                if ("AES".equals(string2) && n3 == 128) {
                    return "SHA-1";
                }
                if (!"AES-256".equals(string2) && !"AES-192".equals(string2)) {
                    if ("AES".equals(string2) && (n3 == 192 || n3 == 256)) {
                        return "SHA-256";
                    }
                    throw new IllegalArgumentException("Unsupported cipher algorithm or key length \"" + string2 + "\", " + n3);
                }
                return "SHA-256";
            }
            return "SHA-1";
        }
        throw new IllegalArgumentException();
    }

    public static DHParameterSpec toExplicitDHParameterSpec(DHParameters dHParameters) {
        DHParameters dHParameters2 = dHParameters;
        BigInteger bigInteger = dHParameters2.getP();
        BigInteger bigInteger2 = dHParameters2.getG();
        Object object = dHParameters2.getQ();
        int n3 = dHParameters.getL();
        if (object == null) {
            DHParameterSpec dHParameterSpec;
            object = dHParameterSpec;
            dHParameterSpec = new DHParameterSpec(bigInteger, bigInteger2, n3);
        } else {
            PACEInfo.DHCParameterSpec dHCParameterSpec;
            PACEInfo.DHCParameterSpec dHCParameterSpec2 = dHCParameterSpec;
            dHCParameterSpec = new PACEInfo.DHCParameterSpec(bigInteger, bigInteger2, (BigInteger)object);
            object = dHCParameterSpec2;
        }
        return object;
    }

    public static String getDetailedPublicKeyAlgorithm(PublicKey object) {
        if (object == null) {
            return "null";
        }
        PublicKey publicKey = object;
        String string2 = publicKey.getAlgorithm();
        if (publicKey instanceof RSAPublicKey) {
            string2 = string2 + " [" + ((RSAPublicKey)object).getModulus().bitLength() + " bit]";
        } else if (object instanceof ECPublicKey) {
            if ((object = Util.getCurveName(((ECPublicKey)object).getParams())) != null) {
                string2 = string2 + " [" + (String)object + "]";
            }
        } else if (object instanceof DHPublicKey) {
            DHPublicKey dHPublicKey = (DHPublicKey)object;
            dHPublicKey.getY();
            DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
            object = dHParameterSpec.getG();
            int n3 = dHParameterSpec.getL();
            BigInteger bigInteger = dHParameterSpec.getP();
            string2 = e.a(string2, " [p.length = ").append(bigInteger.bitLength()).append(", g.length = ").append(((BigInteger)object).bitLength()).append(", l = ").append(n3).append("]").toString();
        }
        return string2;
    }

    public static String getDetailedPrivateKeyAlgorithm(PrivateKey object) {
        if (object == null) {
            return "null";
        }
        PrivateKey privateKey = object;
        String string2 = privateKey.getAlgorithm();
        if (privateKey instanceof RSAPrivateKey) {
            string2 = string2 + " [" + ((RSAPrivateKey)object).getModulus().bitLength() + " bit]";
        } else if (object instanceof ECPrivateKey && (object = Util.getCurveName(((ECPrivateKey)object).getParams())) != null) {
            string2 = string2 + " [" + (String)object + "]";
        }
        return string2;
    }

    public static String getCurveName(ECParameterSpec eCParameterSpec) {
        return (eCParameterSpec = Util.toNamedCurveSpec(eCParameterSpec)) == null ? null : ((ECNamedCurveSpec)eCParameterSpec).getName();
    }

    public static ECParameterSpec toExplicitECParameterSpec(ECNamedCurveParameterSpec eCNamedCurveParameterSpec) {
        return Util.toExplicitECParameterSpec(Util.toECNamedCurveSpec(eCNamedCurveParameterSpec));
    }

    /*
     * Unable to fully structure code
     */
    public static ECParameterSpec toExplicitECParameterSpec(ECParameterSpec var0) {
        if (var0 == null) {
            return null;
        }
        try {
            v0 = var0;
            v1 = v0;
            v2 = v0;
            v3 = v0;
            var1_1 = v0.getGenerator();
        }
        catch (Exception var1_2) {
            Util.LOGGER.log(Level.WARNING, "Could not make named EC param spec explicit", var1_2);
            return var0;
        }
        var2_3 = v1.getOrder();
        var3_4 = v2.getCofactor();
        v4 = v3.getCurve();
        v5 = v4;
        v6 = v4;
        var4_5 = v4.getA();
        var5_6 = v6.getB();
        var6_7 = v5.getField();
        if (!(var6_7 instanceof ECFieldFp)) ** GOTO lbl36
        var6_7 = ((ECFieldFp)var6_7).getP();
        var7_10 = v7;
        v7 = new ECFieldFp((BigInteger)var6_7);
        var6_7 = v8;
        v8 = new EllipticCurve(var7_10, var4_5, var5_6);
        return new ECParameterSpec((EllipticCurve)var6_7, var1_1, var2_3, var3_4);
lbl36:
        // 1 sources

        if (!(var6_7 instanceof ECFieldF2m)) ** GOTO lbl46
        var6_8 = ((ECFieldF2m)var6_7).getM();
        var7_11 = v9;
        v9 = new ECFieldF2m(var6_8);
        var6_9 = v10;
        v10 = new EllipticCurve(var7_11, var4_5, var5_6);
        return new ECParameterSpec(var6_9, var1_1, var2_3, var3_4);
lbl46:
        // 1 sources

        Util.LOGGER.warning("Could not make named EC param spec explicit");
        return var0;
    }

    private static ECNamedCurveSpec toNamedCurveSpec(ECParameterSpec eCParameterSpec) {
        ArrayList<ECNamedCurveSpec> arrayList;
        if (eCParameterSpec == null) {
            return null;
        }
        if (eCParameterSpec instanceof ECNamedCurveSpec) {
            return (ECNamedCurveSpec)eCParameterSpec;
        }
        ArrayList<ECNamedCurveSpec> arrayList2 = arrayList;
        arrayList = new ArrayList<ECNamedCurveSpec>();
        Iterator iterator = Collections.list(ECNamedCurveTable.getNames()).iterator();
        while (iterator.hasNext()) {
            ECNamedCurveSpec eCNamedCurveSpec = Util.toECNamedCurveSpec(ECNamedCurveTable.getParameterSpec((String)iterator.next()));
            if (!eCNamedCurveSpec.getCurve().equals(eCParameterSpec.getCurve()) || !eCNamedCurveSpec.getGenerator().equals(eCParameterSpec.getGenerator()) || !eCNamedCurveSpec.getOrder().equals(eCParameterSpec.getOrder()) || eCNamedCurveSpec.getCofactor() != eCParameterSpec.getCofactor()) continue;
            arrayList2.add(eCNamedCurveSpec);
        }
        if (arrayList2.isEmpty()) {
            return null;
        }
        if (arrayList2.size() == 1) {
            return (ECNamedCurveSpec)arrayList2.get(0);
        }
        return (ECNamedCurveSpec)arrayList2.get(0);
    }

    public static ECNamedCurveSpec toECNamedCurveSpec(ECNamedCurveParameterSpec object) {
        ECNamedCurveParameterSpec eCNamedCurveParameterSpec = object;
        object = eCNamedCurveParameterSpec.getName();
        ECCurve eCCurve = eCNamedCurveParameterSpec.getCurve();
        ECPoint eCPoint = eCNamedCurveParameterSpec.getG();
        BigInteger bigInteger = eCNamedCurveParameterSpec.getN();
        BigInteger bigInteger2 = eCNamedCurveParameterSpec.getH();
        byte[] byArray = eCNamedCurveParameterSpec.getSeed();
        return new ECNamedCurveSpec((String)object, eCCurve, eCPoint, bigInteger, bigInteger2, byArray);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SubjectPublicKeyInfo toSubjectPublicKeyInfo(PublicKey var0) {
        block28: {
            block29: {
                block30: {
                    block27: {
                        var1_4 = var0.getAlgorithm();
                        if ("EC".equals(var1_4) || "ECDH".equals(var1_4) || var0 instanceof ECPublicKey) break block27;
                        if (!"DH".equals(var1_4) && !(var0 instanceof DHPublicKey)) {
                            throw new IllegalArgumentException("Unrecognized key type, found " + var0.getAlgorithm() + ", should be DH or ECDH");
                        }
                        v0 = var0;
                        {
                            catch (Exception var0_3) {
                                Util.LOGGER.log(Level.WARNING, "Exception", var0_3);
                                return null;
                            }
                        }
                        var1_4 = v1;
                        v1 = new ASN1InputStream(var0.getEncoded());
                        var0 = SubjectPublicKeyInfo.getInstance(v1.readObject()).getAlgorithm();
                        var2_5 = (DHPublicKey)v0;
                        var3_7 = var2_5.getParams();
                        v2 = var1_4;
                        v3 = var0.getAlgorithm();
                        v4 = var3_7;
                        var0 = v4.getP();
                        var3_7 = v4.getG();
                        var4_9 = v4.getL();
                        v5 = new SubjectPublicKeyInfo(new AlgorithmIdentifier(v3, new DHParameter((BigInteger)var0, (BigInteger)var3_7, var4_9).toASN1Primitive()), new ASN1Integer(var2_5.getY()));
                        {
                            catch (Throwable var0_1) {
                                var1_4.close();
                                throw var0_1;
                            }
                        }
                        v2.close();
                        return v5;
                    }
                    var1_4 = v6;
                    v6 = new ASN1InputStream(var0.getEncoded());
                    var2_6 = SubjectPublicKeyInfo.getInstance(v6.readObject());
                    var3_8 = var2_6.getAlgorithm();
                    var4_10 = var3_8.getAlgorithm().getId();
                    if (!SecurityInfo.ID_EC_PUBLIC_KEY.equals(var4_10)) break block28;
                    var3_8 = var3_8.getParameters().toASN1Primitive();
                    if (!(var3_8 instanceof ASN1ObjectIdentifier)) break block29;
                    var3_8 = (ASN1ObjectIdentifier)var3_8;
                    var4_10 = X962NamedCurves.getByOID((ASN1ObjectIdentifier)var3_8);
                    if (var4_10 == null) break block30;
                    v7 = var0;
                    var3_8 = var4_10.getG();
                    var3_8 = var3_8.getCurve().createPoint(var3_8.getAffineXCoord().toBigInteger(), var3_8.getAffineYCoord().toBigInteger());
                    var5_11 = v8;
                    v9 = var4_10;
                    v10 = v9;
                    v11 = v9;
                    v12 = v9;
                    var4_10 = v9.getCurve();
                    var6_12 = v13;
                    v13 = new X9ECPoint((ECPoint)var3_8, false);
                    var3_8 = v10.getN();
                    var7_13 = v11.getH();
                    var8_14 = v12.getSeed();
                    v8 = new X9ECParameters((ECCurve)var4_10, var6_12, (BigInteger)var3_8, var7_13, var8_14);
                    if (!(v7 instanceof com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPublicKey)) ** GOTO lbl78
                    v14 = (com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPublicKey)var0;
                    var0 = v15;
                    var2_6 = var2_6.getAlgorithm().getAlgorithm();
                    v15 = new AlgorithmIdentifier((ASN1ObjectIdentifier)var2_6, var5_11.toASN1Primitive());
                    var2_6 = v14.getQ();
                    v16 = var1_4;
                    v17 = new SubjectPublicKeyInfo((AlgorithmIdentifier)var0, var2_6.getEncoded(false));
                    v16.close();
                    return v17;
lbl78:
                    // 1 sources

                    var1_4.close();
                    return var2_6;
                }
                throw new IllegalStateException("Could not find X9.62 named curve for OID " + var3_8.getId());
            }
            var1_4.close();
            return var2_6;
        }
        try {
            throw new IllegalStateException("Was expecting id-ecPublicKey (" + SecurityInfo.ID_EC_PUBLIC_KEY_TYPE + "), found " + (String)var4_10);
        }
        catch (Throwable var0_2) {
            var1_4.close();
            throw var0_2;
        }
    }

    /*
     * Loose catch block
     */
    public static PublicKey toPublicKey(SubjectPublicKeyInfo object) {
        X509EncodedKeySpec x509EncodedKeySpec;
        object = ((ASN1Object)object).getEncoded("DER");
        X509EncodedKeySpec x509EncodedKeySpec2 = x509EncodedKeySpec;
        x509EncodedKeySpec = new X509EncodedKeySpec((byte[])object);
        {
            catch (GeneralSecurityException generalSecurityException) {
                LOGGER.log(Level.WARNING, "Exception", generalSecurityException);
                return null;
            }
        }
        try {
            return KeyFactory.getInstance("DH").generatePublic(x509EncodedKeySpec2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            try {
                LOGGER.log(Level.FINE, "Not DH public key? Fine, try EC public key", generalSecurityException);
                return KeyFactory.getInstance("EC", BC_PROVIDER).generatePublic(x509EncodedKeySpec2);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Exception", exception);
                return null;
            }
        }
    }

    public static PublicKey reconstructPublicKey(PublicKey publicKey) {
        ECPublicKeySpec eCPublicKeySpec;
        java.security.spec.ECPoint eCPoint;
        ECPublicKey eCPublicKey;
        if (!(publicKey instanceof ECPublicKey)) {
            return publicKey;
        }
        try {
            ECPublicKey eCPublicKey2 = (ECPublicKey)publicKey;
            eCPublicKey = eCPublicKey2;
            eCPoint = eCPublicKey2.getW();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Could not make public key param spec explicit", exception);
            return publicKey;
        }
        ECParameterSpec eCParameterSpec = Util.toExplicitECParameterSpec(eCPublicKey.getParams());
        ECPublicKeySpec eCPublicKeySpec2 = eCPublicKeySpec;
        eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
        return KeyFactory.getInstance("EC", BC_PROVIDER).generatePublic(eCPublicKeySpec2);
    }

    public static PublicKey addMissingParametersToPublicKey(AlgorithmParameterSpec algorithmParameterSpec, PublicKey publicKey) {
        ECPublicKeySpec eCPublicKeySpec;
        Object object;
        block11: {
            block10: {
                if (publicKey == null) {
                    return null;
                }
                try {
                    object = publicKey.getAlgorithm();
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Could not make public key param spec explicit", exception);
                    return publicKey;
                }
                if ("EC".equals(object)) break block10;
                if ("ECDSA".equals(object)) break block10;
                if ("ECDH".equals(object)) break block10;
                return publicKey;
            }
            if (algorithmParameterSpec instanceof ECParameterSpec) break block11;
            return publicKey;
        }
        object = ((ECPublicKey)publicKey).getW();
        ECPublicKeySpec eCPublicKeySpec2 = eCPublicKeySpec;
        eCPublicKeySpec = new ECPublicKeySpec((java.security.spec.ECPoint)object, (ECParameterSpec)algorithmParameterSpec);
        return KeyFactory.getInstance("EC", BC_PROVIDER).generatePublic(eCPublicKeySpec2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static java.security.spec.ECPoint os2ECPoint(byte[] object) {
        Throwable throwable222222;
        DataInputStream dataInputStream;
        block13: {
            block12: {
                java.security.spec.ECPoint eCPoint;
                DataInputStream dataInputStream2;
                dataInputStream = dataInputStream2;
                if (((InputStream)new DataInputStream(new ByteArrayInputStream((byte[])object))).read() != 4) break block12;
                DataInputStream dataInputStream3 = dataInputStream;
                int n3 = (((byte[])object).length - 1) / 2;
                object = new byte[n3];
                Object object2 = new byte[n3];
                DataInputStream dataInputStream4 = dataInputStream;
                dataInputStream.readFully((byte[])object);
                dataInputStream4.readFully((byte[])object2);
                ((InputStream)dataInputStream4).close();
                object = Util.os2i(object);
                object2 = Util.os2i(object2);
                java.security.spec.ECPoint eCPoint2 = eCPoint;
                eCPoint = new java.security.spec.ECPoint((BigInteger)object, (BigInteger)object2);
                try {
                    ((InputStream)dataInputStream3).close();
                    return eCPoint2;
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, "Error closing stream", iOException);
                }
                return eCPoint2;
            }
            try {
                throw new IllegalArgumentException("Expected encoded ECPoint to start with 0x04");
            }
            catch (Throwable throwable222222) {
                break block13;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Exception", iOException);
            }
        }
        try {
            ((InputStream)dataInputStream).close();
            throw throwable222222;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error closing stream", iOException);
        }
        throw throwable222222;
    }

    public static byte[] ecPoint2OS(java.security.spec.ECPoint object, int n3) {
        double d3;
        Object object2;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2;
        ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream2;
        java.security.spec.ECPoint eCPoint = object;
        byteArrayOutputStream3();
        object = eCPoint.getAffineX();
        BigInteger bigInteger = eCPoint.getAffineY();
        try {
            byteArrayOutputStream = byteArrayOutputStream3;
            object2 = object;
            byteArrayOutputStream3.write(4);
            d3 = (double)n3 / 8.0;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Exception", iOException);
        }
        int n4 = (int)Math.ceil(d3);
        byteArrayOutputStream.write(Util.i2os((BigInteger)object2, n4));
        int n5 = (int)Math.ceil(d3);
        byteArrayOutputStream2.write(Util.i2os(bigInteger, n5));
        byteArrayOutputStream2.close();
        return byteArrayOutputStream2.toByteArray();
    }

    public static String inferProtocolIdentifier(PublicKey object) {
        if (!"EC".equals(object = object.getAlgorithm()) && !"ECDH".equals(object)) {
            if ("DH".equals(object)) {
                return SecurityInfo.ID_PK_DH;
            }
            throw new IllegalArgumentException("Wrong key type. Was expecting ECDH or DH public key.");
        }
        return SecurityInfo.ID_PK_ECDH;
    }

    public static java.security.spec.ECPoint add(java.security.spec.ECPoint eCPoint, java.security.spec.ECPoint eCPoint2, ECParameterSpec eCParameterSpec) {
        return Util.fromBouncyCastleECPoint(Util.toBouncyCastleECPoint(eCPoint, eCParameterSpec).add(Util.toBouncyCastleECPoint(eCPoint2, eCParameterSpec)));
    }

    public static java.security.spec.ECPoint multiply(BigInteger bigInteger, java.security.spec.ECPoint eCPoint, ECParameterSpec eCParameterSpec) {
        return Util.fromBouncyCastleECPoint(Util.toBouncyCastleECPoint(eCPoint, eCParameterSpec).multiply(bigInteger));
    }

    public static boolean isPointOnCurve(java.security.spec.ECPoint object, ECParameterSpec object2) {
        java.security.spec.ECPoint eCPoint = object;
        object = eCPoint.getAffineX();
        BigInteger bigInteger = eCPoint.getAffineY();
        ECParameterSpec eCParameterSpec = object2;
        object2 = Util.getPrime(eCParameterSpec);
        EllipticCurve ellipticCurve = eCParameterSpec.getCurve();
        BigInteger bigInteger2 = ellipticCurve.getA();
        BigInteger bigInteger3 = ellipticCurve.getB();
        Object object3 = object;
        return bigInteger.multiply(bigInteger).mod((BigInteger)object2).equals(((BigInteger)object3).multiply((BigInteger)object3).multiply((BigInteger)object).add(bigInteger2.multiply((BigInteger)object)).add(bigInteger3).mod((BigInteger)object2));
    }

    public static byte[] getBytes(String object) {
        String string2 = object;
        object = string2.getBytes();
        try {
            object = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
        }
        return object;
    }

    public static BigInteger getPrime(AlgorithmParameterSpec object) {
        if (object != null) {
            if (object instanceof DHParameterSpec) {
                return ((DHParameterSpec)object).getP();
            }
            if (object instanceof ECParameterSpec) {
                if ((object = ((ECParameterSpec)object).getCurve().getField()) instanceof ECFieldFp) {
                    return ((ECFieldFp)object).getP();
                }
                throw new IllegalStateException(b.a("Was expecting prime field of type ECFieldFp, found ").append(object.getClass().getCanonicalName()).toString());
            }
            throw new IllegalArgumentException(b.a("Unsupported agreement algorithm, was expecting DHParameterSpec or ECParameterSpec, found ").append(object.getClass().getCanonicalName()).toString());
        }
        throw new IllegalArgumentException("Parameters null");
    }

    public static String inferKeyAgreementAlgorithm(PublicKey publicKey) {
        if (publicKey instanceof ECPublicKey) {
            return "ECDH";
        }
        if (publicKey instanceof DHPublicKey) {
            return "DH";
        }
        throw new IllegalArgumentException("Unsupported public key: " + publicKey);
    }

    public static BigInteger computeAffineY(BigInteger object, ECParameterSpec object2) {
        ECCurve eCCurve = Util.toBouncyCastleECCurve((ECParameterSpec)object2);
        object = eCCurve.getA();
        object2 = eCCurve.getB();
        ECFieldElement eCFieldElement = eCCurve.fromBigInteger((BigInteger)object);
        return eCFieldElement.multiply(eCFieldElement).add((ECFieldElement)object).multiply(eCFieldElement).add((ECFieldElement)object2).sqrt().toBigInteger();
    }

    public static ECPoint toBouncyCastleECPoint(java.security.spec.ECPoint object, ECParameterSpec eCParameterSpec) {
        java.security.spec.ECPoint eCPoint = object;
        object = eCPoint.getAffineX();
        return Util.toBouncyCastleECCurve(eCParameterSpec).createPoint((BigInteger)object, eCPoint.getAffineY());
    }

    public static java.security.spec.ECPoint fromBouncyCastleECPoint(ECPoint eCPoint) {
        if (!(eCPoint = eCPoint.normalize()).isValid()) {
            LOGGER.warning("point not valid");
        }
        return new java.security.spec.ECPoint(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger());
    }

    public static boolean isValid(java.security.spec.ECPoint eCPoint, ECParameterSpec eCParameterSpec) {
        return Util.toBouncyCastleECPoint(eCPoint, eCParameterSpec).isValid();
    }

    public static java.security.spec.ECPoint normalize(java.security.spec.ECPoint eCPoint, ECParameterSpec eCParameterSpec) {
        return Util.fromBouncyCastleECPoint(Util.toBouncyCastleECPoint(eCPoint, eCParameterSpec).normalize());
    }

    private static ECCurve toBouncyCastleECCurve(ECParameterSpec eCParameterSpec) {
        Object object = eCParameterSpec.getCurve();
        Object object2 = ((EllipticCurve)object).getField();
        if (object2 instanceof ECFieldFp) {
            EllipticCurve ellipticCurve = object;
            ECParameterSpec eCParameterSpec2 = eCParameterSpec;
            int n3 = eCParameterSpec2.getCofactor();
            object = eCParameterSpec2.getOrder();
            object2 = ellipticCurve.getA();
            BigInteger bigInteger = ellipticCurve.getB();
            BigInteger bigInteger2 = Util.getPrime(eCParameterSpec);
            BigInteger bigInteger3 = BigInteger.valueOf(n3);
            return new ECCurve.Fp(bigInteger2, (BigInteger)object2, bigInteger, (BigInteger)object, bigInteger3);
        }
        throw new IllegalArgumentException(b.a("Only prime field supported (for now), found ").append(object2.getClass().getCanonicalName()).toString());
    }

    public static ECPublicKeyParameters toBouncyECPublicKeyParameters(ECPublicKey object) {
        ECPublicKey eCPublicKey = object;
        object = eCPublicKey.getParams();
        ECPoint eCPoint = Util.toBouncyCastleECPoint(eCPublicKey.getW(), (ECParameterSpec)object);
        return new ECPublicKeyParameters(eCPoint, Util.toBouncyECDomainParameters((ECParameterSpec)object));
    }

    public static ECPrivateKeyParameters toBouncyECPrivateKeyParameters(ECPrivateKey serializable) {
        ECPrivateKey eCPrivateKey = serializable;
        serializable = eCPrivateKey.getS();
        ECDomainParameters eCDomainParameters = Util.toBouncyECDomainParameters(eCPrivateKey.getParams());
        return new ECPrivateKeyParameters((BigInteger)serializable, eCDomainParameters);
    }

    public static ECDomainParameters toBouncyECDomainParameters(ECParameterSpec object) {
        ECParameterSpec eCParameterSpec = object;
        ECCurve eCCurve = Util.toBouncyCastleECCurve(eCParameterSpec);
        object = Util.toBouncyCastleECPoint(eCParameterSpec.getGenerator(), (ECParameterSpec)object);
        BigInteger bigInteger = eCParameterSpec.getOrder();
        BigInteger bigInteger2 = BigInteger.valueOf(eCParameterSpec.getCofactor());
        byte[] byArray = eCParameterSpec.getCurve().getSeed();
        return new ECDomainParameters(eCCurve, (ECPoint)object, bigInteger, bigInteger2, byArray);
    }

    public static Cipher getCipher(String string2) {
        try {
            return Cipher.getInstance(string2);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this cipher, falling back to explicit BC", exception);
            return Cipher.getInstance(string2, BC_PROVIDER);
        }
    }

    public static Cipher getCipher(String string2, int n3, Key key) {
        try {
            Cipher cipher = Cipher.getInstance(string2);
            cipher.init(n3, key);
            return cipher;
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Cipher, falling back to explicit BC", exception);
            Cipher cipher = Cipher.getInstance(string2, BC_PROVIDER);
            cipher.init(n3, key);
            return cipher;
        }
    }

    public static KeyAgreement getKeyAgreement(String string2) {
        try {
            return KeyAgreement.getInstance(string2);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Key Agreement, falling back to explicit BC", exception);
            return KeyAgreement.getInstance(string2, BC_PROVIDER);
        }
    }

    public static KeyPairGenerator getKeyPairGenerator(String string2) {
        try {
            return KeyPairGenerator.getInstance(string2);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Key Pair Generator, falling back to explicit BC", exception);
            return KeyPairGenerator.getInstance(string2, BC_PROVIDER);
        }
    }

    public static Mac getMac(String string2) {
        try {
            return Mac.getInstance(string2);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Mac, falling back to explicit BC", exception);
            return Mac.getInstance(string2, BC_PROVIDER);
        }
    }

    public static Mac getMac(String string2, Key key) {
        try {
            Mac mac = Mac.getInstance(string2);
            mac.init(key);
            return mac;
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Mac, falling back to explicit BC", exception);
            Mac mac = Mac.getInstance(string2, BC_PROVIDER);
            mac.init(key);
            return mac;
        }
    }

    public static MessageDigest getMessageDigest(String string2) {
        try {
            return MessageDigest.getInstance(string2);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Message Digest, falling back to explicit BC", exception);
            return MessageDigest.getInstance(string2, BC_PROVIDER);
        }
    }

    public static PublicKey getPublicKey(String string2, KeySpec keySpec) {
        try {
            return KeyFactory.getInstance(string2).generatePublic(keySpec);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Key Factory or Public Key, falling back to explicit BC", exception);
            return KeyFactory.getInstance(string2, BC_PROVIDER).generatePublic(keySpec);
        }
    }

    public static Signature getSignature(String string2) {
        try {
            return Signature.getInstance(string2);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Signature, falling back to explicit BC", exception);
            return Signature.getInstance(string2, BC_PROVIDER);
        }
    }

    public static CertificateFactory getCertificateFactory(String string2) {
        try {
            return CertificateFactory.getInstance(string2);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Certificate Factory, falling back ot explicit BC", exception);
            return CertificateFactory.getInstance(string2, BC_PROVIDER);
        }
    }

    /*
     * Loose catch block
     */
    public static byte[] toOIDBytes(String string2) {
        TLVInputStream tLVInputStream;
        Object object = tLVInputStream;
        tLVInputStream = new TLVInputStream(new ByteArrayInputStream(new ASN1ObjectIdentifier(string2).getEncoded()));
        {
            catch (IOException iOException) {
                throw new IllegalArgumentException(i.a("Illegal OID: \"", string2), iOException);
            }
        }
        tLVInputStream.readTag();
        tLVInputStream.readLength();
        object = tLVInputStream.readValue();
        tLVInputStream.close();
        return TLVUtil.wrapDO(128, (byte[])object);
        catch (Throwable throwable) {
            ((TLVInputStream)object).close();
            throw throwable;
        }
    }

    public static List<byte[]> partition(int n3, byte[] byArray) {
        ArrayList<byte[]> arrayList;
        ArrayList<byte[]> arrayList2 = arrayList;
        arrayList = new ArrayList<byte[]>();
        if (byArray != null && n3 > 0) {
            n3 = Math.min(byArray.length, n3);
            int n4 = byArray.length / n3;
            int n5 = byArray.length % n3;
            int n6 = 0;
            for (int i3 = 0; i3 < n4; ++i3) {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n6, byArray2, 0, n3);
                arrayList2.add(byArray2);
                n6 += n3;
            }
            if (n5 != 0) {
                byte[] byArray3 = new byte[n5];
                System.arraycopy(byArray, n6, byArray3, 0, n5);
                arrayList2.add(byArray3);
            }
            return arrayList2;
        }
        throw new IllegalArgumentException("Cannot partition");
    }

    public static byte[] stripLeadingZeroes(byte[] byArray) {
        if (byArray != null && byArray.length > 1) {
            while (byArray.length > 0 && byArray[0] == 0) {
                int n3 = byArray.length - 1;
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, 1, byArray2, 0, n3);
                byArray = byArray2;
            }
            return byArray;
        }
        return byArray;
    }

    private static DHParameters fromPGQ(String object, String object2, String object3) {
        object = Util.fromHex((String)object);
        object2 = Util.fromHex((String)object2);
        object3 = Util.fromHex((String)object3);
        return new DHParameters((BigInteger)object, (BigInteger)object2, (BigInteger)object3);
    }

    private static BigInteger fromHex(String string2) {
        return new BigInteger(1, Hex.decodeStrict(string2));
    }
}

