/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.cbeff;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.BiometricDataBlock;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.BiometricDataBlockDecoder;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.CBEFFInfo;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.ComplexCBEFFInfo;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.ISO781611;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.SimpleCBEFFInfo;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.StandardBiometricHeader;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVInputStream;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.logging.Logger;

public class ISO781611Decoder
implements ISO781611 {
    private static final Logger LOGGER = Logger.getLogger("org.com.htc.sdk.jmrtd");
    private BiometricDataBlockDecoder<?> bdbDecoder;

    public ISO781611Decoder(BiometricDataBlockDecoder<?> biometricDataBlockDecoder) {
        this.bdbDecoder = biometricDataBlockDecoder;
    }

    private ComplexCBEFFInfo readBITGroup(InputStream inputStream) {
        TLVInputStream tLVInputStream;
        if (inputStream instanceof TLVInputStream) {
            tLVInputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream2;
            tLVInputStream = tLVInputStream2;
            tLVInputStream2 = new TLVInputStream(inputStream);
        }
        int n3 = tLVInputStream.readTag();
        if (n3 == 32609) {
            return this.readBITGroup(n3, tLVInputStream.readLength(), inputStream);
        }
        throw new IllegalArgumentException(h.a(n3, h.a.a(32609, b.a("Expected tag "), ", found ")));
    }

    private ComplexCBEFFInfo readBITGroup(int n3, int n4, InputStream inputStream) {
        ComplexCBEFFInfo complexCBEFFInfo;
        TLVInputStream tLVInputStream;
        if (inputStream instanceof TLVInputStream) {
            tLVInputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream2;
            tLVInputStream = tLVInputStream2;
            tLVInputStream2 = new TLVInputStream(inputStream);
        }
        ComplexCBEFFInfo complexCBEFFInfo2 = complexCBEFFInfo;
        complexCBEFFInfo = new ComplexCBEFFInfo();
        if (n3 == 32609) {
            n3 = tLVInputStream.readTag();
            if (n3 == 2) {
                n3 = tLVInputStream.readLength();
                if (n3 == 1) {
                    n3 = tLVInputStream.readValue()[0] & 0xFF;
                    for (int i3 = 0; i3 < n3; ++i3) {
                        complexCBEFFInfo2.add(this.readBIT(inputStream, i3));
                    }
                    return complexCBEFFInfo2;
                }
                throw new IllegalArgumentException(a.a("BIOMETRIC_INFO_COUNT should have length 1, found length ", n3));
            }
            throw new IllegalArgumentException(h.a(n3, h.a.a(2, b.a("Expected tag BIOMETRIC_INFO_COUNT_TAG ("), ") in CBEFF structure, found ")));
        }
        throw new IllegalArgumentException(h.a(n3, h.a.a(32609, b.a("Expected tag "), ", found ")));
    }

    private CBEFFInfo readBIT(InputStream inputStream, int n3) {
        TLVInputStream tLVInputStream;
        if (inputStream instanceof TLVInputStream) {
            tLVInputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream2;
            tLVInputStream = tLVInputStream2;
            tLVInputStream2 = new TLVInputStream(inputStream);
        }
        TLVInputStream tLVInputStream3 = tLVInputStream;
        int n4 = tLVInputStream3.readTag();
        return this.readBIT(n4, tLVInputStream3.readLength(), inputStream, n3);
    }

    private CBEFFInfo readBIT(int n3, int n4, InputStream inputStream, int n5) {
        TLVInputStream tLVInputStream;
        if (inputStream instanceof TLVInputStream) {
            tLVInputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream2;
            tLVInputStream = tLVInputStream2;
            tLVInputStream2 = new TLVInputStream(inputStream);
        }
        if (n3 == 32608) {
            n3 = tLVInputStream.readTag();
            int n6 = tLVInputStream.readLength();
            if (n3 == 125) {
                ((ISO781611Decoder)((Object)biometricDataBlock)).readStaticallyProtectedBIT(inputStream, n3, n6, n5);
                return null;
            }
            if ((n3 & 0xA0) == 160) {
                ISO781611Decoder iSO781611Decoder = biometricDataBlock;
                BiometricDataBlock biometricDataBlock = iSO781611Decoder.readBiometricDataBlock(inputStream, iSO781611Decoder.readBHT(inputStream, n3, n6, n5), n5);
                return new SimpleCBEFFInfo<Object>(biometricDataBlock);
            }
            throw new IllegalArgumentException(h.a(n3, b.a("Unsupported template tag: ")));
        }
        throw new IllegalArgumentException(h.a.a(32608, b.a("Expected tag BIOMETRIC_INFORMATION_TEMPLATE_TAG ("), "), found ").append(Integer.toHexString(n3)).append(", index is ").append(n5).toString());
    }

    private StandardBiometricHeader readBHT(InputStream inputStream, int n3, int n4, int n5) {
        HashMap<Integer, byte[]> hashMap;
        Object object;
        if (inputStream instanceof TLVInputStream) {
            object = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream;
            object = tLVInputStream;
            tLVInputStream = new TLVInputStream(inputStream);
        }
        int n6 = 161;
        if (n3 != 161) {
            LOGGER.warning(h.a.a(n6, b.a("Expected tag "), ", found ").append(Integer.toHexString(n3)).toString());
        }
        HashMap<Integer, byte[]> hashMap2 = hashMap;
        hashMap = new HashMap<Integer, byte[]>();
        n3 = 0;
        while (n3 < n4) {
            int n7 = ((TLVInputStream)object).readTag();
            n3 = TLVUtil.getTagLength(n7) + n3;
            byte[] byArray = ((TLVInputStream)object).readValue();
            n5 = TLVUtil.getLengthLength(((TLVInputStream)object).readLength()) + n3 + byArray.length;
            hashMap2.put(n7, byArray);
            n3 = n5;
        }
        return new StandardBiometricHeader(hashMap2);
    }

    private void readStaticallyProtectedBIT(InputStream inputStream, int n3, int n4, int n5) {
        TLVInputStream tLVInputStream;
        TLVInputStream tLVInputStream2 = tLVInputStream;
        ISO781611Decoder iSO781611Decoder = this;
        TLVInputStream tLVInputStream3 = tLVInputStream2;
        tLVInputStream3(new ByteArrayInputStream(this.decodeSMTValue(inputStream)));
        try {
            n4 = tLVInputStream3.readTag();
        }
        catch (Throwable throwable) {
            tLVInputStream2.close();
            throw throwable;
        }
        StandardBiometricHeader standardBiometricHeader = iSO781611Decoder.readBHT(tLVInputStream3, n4, tLVInputStream3.readLength(), n5);
        iSO781611Decoder.readBiometricDataBlock(new ByteArrayInputStream(this.decodeSMTValue(inputStream)), standardBiometricHeader, n5);
        tLVInputStream.close();
    }

    private byte[] decodeSMTValue(InputStream inputStream) {
        Object object;
        if (inputStream instanceof TLVInputStream) {
            object = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream;
            object = tLVInputStream;
            tLVInputStream = new TLVInputStream(inputStream);
        }
        int n3 = ((TLVInputStream)object).readTag();
        ((TLVInputStream)object).readLength();
        if (n3 != 129) {
            if (n3 != 133) {
                if (n3 != 142 && n3 != 158) {
                    LOGGER.info(b.a("Unsupported data object tag ").append(Integer.toHexString(n3)).toString());
                    return null;
                }
                return null;
            }
            throw new AccessControlException("Access denied. Biometric Information Template is statically protected.");
        }
        return ((TLVInputStream)object).readValue();
    }

    private BiometricDataBlock readBiometricDataBlock(InputStream inputStream, StandardBiometricHeader standardBiometricHeader, int n3) {
        TLVInputStream tLVInputStream;
        if (inputStream instanceof TLVInputStream) {
            tLVInputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream2;
            tLVInputStream = tLVInputStream2;
            tLVInputStream2 = new TLVInputStream(inputStream);
        }
        int n4 = tLVInputStream.readTag();
        if (n4 != 24366 && n4 != 32558) {
            throw new IllegalArgumentException(h.a(n4, h.a.a(32558, h.a.a(24366, b.a("Expected tag BIOMETRIC_DATA_BLOCK_TAG ("), ") or BIOMETRIC_DATA_BLOCK_TAG_ALT ("), "), found ")));
        }
        int n5 = tLVInputStream.readLength();
        return this.bdbDecoder.decode(inputStream, standardBiometricHeader, n3, n5);
    }

    public ComplexCBEFFInfo decode(InputStream inputStream) {
        return this.readBITGroup(inputStream);
    }
}

