/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.cert;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.scuba.data.Country;
import java.io.Serializable;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CVCPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = -4905647207367309688L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private Country country;
    private String mnemonic;
    private String seqNumber;

    public CVCPrincipal(String string2) {
        if (string2 != null) {
            if (string2.length() >= 7 && string2.length() <= 16) {
                final String string3 = string2.substring(0, 2).toUpperCase();
                try {
                    this.country = Country.getInstance(string3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOGGER.log(Level.FINE, "Could not find country for " + string3, illegalArgumentException);
                    this.country = new Country(){
                        private static final long serialVersionUID = 345841304964161797L;

                        @Override
                        public int valueOf() {
                            return -1;
                        }

                        @Override
                        public String getName() {
                            return "Unknown";
                        }

                        @Override
                        public String getNationality() {
                            return "Unknown";
                        }

                        @Override
                        public String toAlpha2Code() {
                            return string3;
                        }

                        @Override
                        public String toAlpha3Code() {
                            return "XXX";
                        }
                    };
                }
                String string4 = string2;
                String string5 = string2;
                this.mnemonic = string5.substring(2, string5.length() - 5);
                int n3 = string4.length() - 5;
                this.seqNumber = string4.substring(n3, string4.length());
                return;
            }
            throw new IllegalArgumentException(g.a("Name should be <Country (2F)><Mnemonic (9V)><SeqNum (5F)> formatted, found \"", string2, "\""));
        }
        throw new IllegalArgumentException("Name should be <Country (2F)><Mnemonic (9V)><SeqNum (5F)> formatted, found null");
    }

    public CVCPrincipal(Country country, String string2, String string3) {
        if (string2 != null && string2.length() <= 9) {
            if (string3 != null && string3.length() == 5) {
                CVCPrincipal cVCPrincipal = this;
                cVCPrincipal.country = country;
                cVCPrincipal.mnemonic = string2;
                cVCPrincipal.seqNumber = string3;
                return;
            }
            throw new IllegalArgumentException("Wrong length seqNumber");
        }
        throw new IllegalArgumentException("Wrong length mnemonic");
    }

    @Override
    public String getName() {
        return this.country.toAlpha2Code() + this.mnemonic + this.seqNumber;
    }

    @Override
    public String toString() {
        return this.country.toAlpha2Code() + "/" + this.mnemonic + "/" + this.seqNumber;
    }

    public Country getCountry() {
        return this.country;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public String getSeqNumber() {
        return this.seqNumber;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        object = (CVCPrincipal)object;
        return ((CVCPrincipal)object).country.equals(this.country) && ((CVCPrincipal)object).mnemonic.equals(this.mnemonic) && ((CVCPrincipal)object).seqNumber.equals(this.seqNumber);
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() * 2 + 1231211;
    }
}

