/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.ext;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.logging.Logger;

public class JMRTDSecurityProvider
extends Provider {
    private static final long serialVersionUID = -2881416441551680704L;
    private static final Logger LOGGER;
    private static final String SUN_PROVIDER_CLASS_NAME = "sun.security.provider.Sun";
    private static final String BC_PROVIDER_CLASS_NAME = "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final String SC_PROVIDER_CLASS_NAME = "org.spongycastle.jce.provider.BouncyCastleProvider";
    private static final Provider BC_PROVIDER;
    private static final Provider SC_PROVIDER;
    private static final Provider JMRTD_PROVIDER;

    private JMRTDSecurityProvider() {
        JMRTDSecurityProvider jMRTDSecurityProvider = provider;
        super("JMRTD", 0.1, "JMRTD Security Provider");
        ((Dictionary)jMRTDSecurityProvider).put("CertificateFactory.CVC", "org.jmrtd.cert.CVCertificateFactorySpi");
        if (BC_PROVIDER != null) {
            JMRTDSecurityProvider jMRTDSecurityProvider2 = provider;
            Provider provider = JMRTDSecurityProvider.getBouncyCastleProvider();
            jMRTDSecurityProvider2.replicateFromProvider("CertificateFactory", "X.509", provider);
            provider = JMRTDSecurityProvider.getBouncyCastleProvider();
            jMRTDSecurityProvider2.replicateFromProvider("CertStore", "Collection", provider);
            provider = JMRTDSecurityProvider.getBouncyCastleProvider();
            jMRTDSecurityProvider2.replicateFromProvider("MessageDigest", "SHA1", provider);
            provider = JMRTDSecurityProvider.getBouncyCastleProvider();
            jMRTDSecurityProvider2.replicateFromProvider("Signature", "SHA1withRSA/ISO9796-2", provider);
            provider = JMRTDSecurityProvider.getBouncyCastleProvider();
            jMRTDSecurityProvider2.replicateFromProvider("Signature", "MD2withRSA", provider);
            provider = JMRTDSecurityProvider.getBouncyCastleProvider();
            jMRTDSecurityProvider2.replicateFromProvider("Signature", "MD4withRSA", provider);
            provider = JMRTDSecurityProvider.getBouncyCastleProvider();
            jMRTDSecurityProvider2.replicateFromProvider("Signature", "MD5withRSA", provider);
            provider = JMRTDSecurityProvider.getBouncyCastleProvider();
            jMRTDSecurityProvider2.replicateFromProvider("Signature", "SHA1withRSA", provider);
            provider = JMRTDSecurityProvider.getBouncyCastleProvider();
            jMRTDSecurityProvider2.replicateFromProvider("Signature", "SHA1withRSA/ISO9796-2", provider);
            provider = JMRTDSecurityProvider.getBouncyCastleProvider();
            jMRTDSecurityProvider2.replicateFromProvider("Signature", "SHA256withRSA", provider);
            provider = JMRTDSecurityProvider.getBouncyCastleProvider();
            jMRTDSecurityProvider2.replicateFromProvider("Signature", "SHA256withRSA/ISO9796-2", provider);
            provider = JMRTDSecurityProvider.getBouncyCastleProvider();
            jMRTDSecurityProvider2.replicateFromProvider("Signature", "SHA384withRSA", provider);
            provider = JMRTDSecurityProvider.getBouncyCastleProvider();
            jMRTDSecurityProvider2.replicateFromProvider("Signature", "SHA384withRSA/ISO9796-2", provider);
            provider = JMRTDSecurityProvider.getBouncyCastleProvider();
            jMRTDSecurityProvider2.replicateFromProvider("Signature", "SHA512withRSA", provider);
            provider = JMRTDSecurityProvider.getBouncyCastleProvider();
            jMRTDSecurityProvider2.replicateFromProvider("Signature", "SHA512withRSA/ISO9796-2", provider);
            provider = JMRTDSecurityProvider.getBouncyCastleProvider();
            jMRTDSecurityProvider2.replicateFromProvider("Signature", "SHA224withRSA", provider);
            provider = JMRTDSecurityProvider.getBouncyCastleProvider();
            jMRTDSecurityProvider2.replicateFromProvider("Signature", "SHA224withRSA/ISO9796-2", provider);
            ((Dictionary)jMRTDSecurityProvider2).put("Alg.Alias.Mac.ISO9797Alg3Mac", "ISO9797ALG3MAC");
            ((Dictionary)jMRTDSecurityProvider2).put("Alg.Alias.CertificateFactory.X509", "X.509");
        }
    }

    private void replicateFromProvider(String string2, String object, Provider provider) {
        if ((object = provider.get(string2 = g.a(string2, ".", (String)object))) != null) {
            ((Dictionary)this).put(string2, object);
        }
    }

    public static Provider getInstance() {
        return JMRTD_PROVIDER;
    }

    public static int beginPreferBouncyCastleProvider() {
        Provider provider = JMRTDSecurityProvider.getBouncyCastleProvider();
        if (provider == null) {
            return -1;
        }
        Provider[] providerArray = Security.getProviders();
        for (int i3 = 0; i3 < providerArray.length; ++i3) {
            Provider provider2 = providerArray[i3];
            if (!provider.getClass().getCanonicalName().equals(provider2.getClass().getCanonicalName())) continue;
            Security.removeProvider(provider2.getName());
            Security.insertProviderAt(provider, 1);
            return i3 + 1;
        }
        return -1;
    }

    public static void endPreferBouncyCastleProvider(int n3) {
        Provider provider = JMRTDSecurityProvider.getBouncyCastleProvider();
        Security.removeProvider(provider.getName());
        if (n3 > 0) {
            Security.insertProviderAt(provider, n3);
        }
    }

    public static Provider getBouncyCastleProvider() {
        Provider provider = BC_PROVIDER;
        if (provider != null) {
            return provider;
        }
        provider = SC_PROVIDER;
        if (provider != null) {
            return provider;
        }
        LOGGER.severe("No Bouncy or Spongy provider");
        return null;
    }

    public static Provider getSpongyCastleProvider() {
        Provider provider = SC_PROVIDER;
        if (provider != null) {
            return provider;
        }
        provider = BC_PROVIDER;
        if (provider != null) {
            return provider;
        }
        LOGGER.severe("No Bouncy or Spongy provider");
        return null;
    }

    private static Provider getProvider(String object, String string2) {
        if ((object = JMRTDSecurityProvider.getProviders((String)object, string2)) != null && object.size() > 0) {
            return (Provider)object.get(0);
        }
        return null;
    }

    private static List<Provider> getProviders(String providerArray, String string2) {
        if (Security.getAlgorithms((String)providerArray).contains(string2)) {
            providerArray = Security.getProviders((String)providerArray + "." + string2);
            return new ArrayList<Provider>(Arrays.asList(providerArray));
        }
        Provider provider = BC_PROVIDER;
        if (provider != null && provider.getService((String)providerArray, string2) != null) {
            return new ArrayList<Provider>(Collections.singletonList(provider));
        }
        provider = SC_PROVIDER;
        if (provider != null && provider.getService((String)providerArray, string2) != null) {
            return new ArrayList<Provider>(Collections.singletonList(provider));
        }
        provider = JMRTD_PROVIDER;
        if (provider != null && provider.getService((String)providerArray, string2) != null) {
            return new ArrayList<Provider>(Collections.singletonList(provider));
        }
        return null;
    }

    static {
        JMRTDSecurityProvider jMRTDSecurityProvider;
        JMRTDSecurityProvider jMRTDSecurityProvider2;
        BouncyCastleProvider bouncyCastleProvider;
        BouncyCastleProvider bouncyCastleProvider2;
        LOGGER = Logger.getLogger("org.jmrtd");
        BouncyCastleProvider bouncyCastleProvider3 = bouncyCastleProvider2;
        BC_PROVIDER = new BouncyCastleProvider();
        BouncyCastleProvider bouncyCastleProvider4 = bouncyCastleProvider;
        SC_PROVIDER = new BouncyCastleProvider();
        JMRTDSecurityProvider jMRTDSecurityProvider3 = jMRTDSecurityProvider2 = jMRTDSecurityProvider;
        jMRTDSecurityProvider3();
        JMRTD_PROVIDER = jMRTDSecurityProvider3;
        Security.insertProviderAt(bouncyCastleProvider3, 1);
        Security.insertProviderAt(bouncyCastleProvider4, 2);
        Security.insertProviderAt(jMRTDSecurityProvider, 3);
    }
}

