/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.io;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class FragmentBuffer
implements Serializable {
    private static final long serialVersionUID = -3510872461790499721L;
    private static final int DEFAULT_SIZE = 2000;
    private byte[] buffer;
    private Collection<Fragment> fragments;

    public FragmentBuffer() {
        this(2000);
    }

    public FragmentBuffer(int n3) {
        FragmentBuffer fragmentBuffer = this;
        fragmentBuffer.buffer = new byte[n3];
        fragmentBuffer.fragments = new HashSet<Fragment>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setLength(int n3) {
        FragmentBuffer fragmentBuffer = this;
        synchronized (fragmentBuffer) {
            byte[] byArray = fragmentBuffer.buffer;
            {
                if (n3 <= fragmentBuffer.buffer.length) {
                    // ** MonitorExit[this] (shouldn't be in output)
                    return;
                }
                byte[] byArray2 = new byte[n3];
                int n4 = 0;
                int n5 = 0;
                int n6 = byArray.length;
                System.arraycopy(byArray, n4, byArray2, n5, n6);
                this.buffer = byArray2;
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
        }
    }

    public synchronized void updateFrom(FragmentBuffer fragmentBuffer) {
        for (Fragment fragment : fragmentBuffer.fragments) {
            int n3 = fragment.offset;
            byte[] byArray = fragmentBuffer.buffer;
            int n4 = fragment.offset;
            int n5 = fragment.length;
            this.addFragment(n3, byArray, n4, n5);
        }
    }

    public synchronized void addFragment(int n3, byte by) {
        FragmentBuffer fragmentBuffer = object;
        byte[] byArray = new byte[1];
        Object object = byArray;
        byArray[0] = by;
        fragmentBuffer.addFragment(n3, (byte[])object);
    }

    public synchronized void addFragment(int n3, byte[] byArray) {
        int n4 = byArray.length;
        this.addFragment(n3, byArray, 0, n4);
    }

    public synchronized void addFragment(int n3, byte[] object, int n4, int n5) {
        int n6 = n3 + n5;
        byte[] byArray = this.buffer;
        if (n6 > this.buffer.length) {
            this.setLength(Math.max(n6, byArray.length) * 2);
        }
        System.arraycopy(object, n4, this.buffer, n3, n5);
        object = new ArrayList<Fragment>(this.fragments).iterator();
        while (object.hasNext()) {
            Fragment fragment = (Fragment)object.next();
            if (fragment.getOffset() <= n3) {
                Fragment fragment2 = fragment;
                n6 = fragment2.getOffset();
                if (n3 + n5 <= fragment2.getLength() + n6) {
                    return;
                }
            }
            if (fragment.getOffset() <= n3) {
                Fragment fragment3 = fragment;
                n6 = fragment3.getOffset();
                if (n3 <= fragment3.getLength() + n6) {
                    n5 = n3 + n5 - fragment.getOffset();
                    n3 = fragment.getOffset();
                    this.fragments.remove(fragment);
                    continue;
                }
            }
            if (n3 <= fragment.getOffset()) {
                Fragment fragment4 = fragment;
                n6 = fragment4.getOffset();
                if (fragment4.getLength() + n6 <= n3 + n5) {
                    this.fragments.remove(fragment);
                    continue;
                }
            }
            if (n3 > fragment.getOffset() || fragment.getOffset() > n3 + n5) continue;
            Fragment fragment5 = fragment;
            n5 = fragment5.getOffset();
            n5 = fragment5.getLength() + n5 - n3;
            this.fragments.remove(fragment);
        }
        this.fragments.add(Fragment.getInstance(n3, n5));
    }

    public synchronized int getPosition() {
        int n3 = 0;
        for (int i3 = 0; i3 < this.buffer.length; ++i3) {
            if (!this.isCoveredByFragment(i3)) continue;
            n3 = i3 + 1;
        }
        return n3;
    }

    public synchronized int getBytesBuffered() {
        int n3 = 0;
        for (int i3 = 0; i3 < this.buffer.length; ++i3) {
            if (!this.isCoveredByFragment(i3)) continue;
            ++n3;
        }
        return n3;
    }

    public synchronized boolean isCoveredByFragment(int n3) {
        return this.isCoveredByFragment(n3, 1);
    }

    public synchronized boolean isCoveredByFragment(int n3, int n4) {
        Iterator<Fragment> iterator = ((FragmentBuffer)((Object)iterator)).fragments.iterator();
        while (iterator.hasNext()) {
            Fragment fragment;
            Fragment fragment2 = fragment = (Fragment)iterator.next();
            int n5 = fragment2.getOffset();
            n5 = fragment2.getLength() + n5;
            if (fragment.getOffset() > n3 || n3 + n4 > n5) continue;
            return true;
        }
        return false;
    }

    public synchronized int getBufferedLength(int n3) {
        int n4 = 0;
        if (n3 >= ((FragmentBuffer)((Object)iterator)).buffer.length) {
            return 0;
        }
        Iterator<Fragment> iterator = ((FragmentBuffer)((Object)iterator)).fragments.iterator();
        while (iterator.hasNext()) {
            Fragment fragment;
            Fragment fragment2 = fragment = (Fragment)iterator.next();
            int n5 = fragment2.getOffset();
            n5 = fragment2.getLength() + n5;
            if (fragment.getOffset() > n3 || n3 >= n5 || (n5 -= n3) <= n4) continue;
            n4 = n5;
        }
        return n4;
    }

    public Collection<Fragment> getFragments() {
        return this.fragments;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        FragmentBuffer fragmentBuffer = this;
        synchronized (fragmentBuffer) {
            // ** MonitorExit[this] (shouldn't be in output)
            return fragmentBuffer.buffer.length;
        }
    }

    public synchronized Fragment getSmallestUnbufferedFragment(int n3, int n4) {
        Iterator<Fragment> iterator = ((FragmentBuffer)((Object)iterator)).fragments.iterator();
        int n5 = n3;
        while (iterator.hasNext()) {
            int n6;
            Fragment fragment = (Fragment)iterator.next();
            if (fragment.getOffset() <= n5) {
                Fragment fragment2 = fragment;
                n6 = fragment2.getOffset();
                if (n5 + n4 <= fragment2.getLength() + n6) {
                    n4 = 0;
                    break;
                }
            }
            if (fragment.getOffset() <= n5) {
                Fragment fragment3 = fragment;
                n6 = fragment3.getOffset();
                if (n5 < fragment3.getLength() + n6) {
                    int n7 = n5;
                    int n8 = n4;
                    Fragment fragment4 = fragment;
                    n4 = fragment4.getOffset();
                    n5 = fragment4.getLength() + n4;
                    n4 = n7 + n8 - n5;
                    continue;
                }
            }
            if (n5 <= fragment.getOffset()) {
                Fragment fragment5 = fragment;
                n6 = fragment5.getOffset();
                if (fragment5.getLength() + n6 <= n5 + n4) continue;
            }
            if (n3 > fragment.getOffset() || fragment.getOffset() >= n5 + n4) continue;
            n4 = fragment.getOffset() - n5;
        }
        return Fragment.getInstance(n5, n4);
    }

    public synchronized String toString() {
        return b.b.a("FragmentBuffer [").append(this.buffer.length).append(", ").append(this.fragments).append("]").toString();
    }

    public synchronized boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!object.getClass().equals(FragmentBuffer.class)) {
            return false;
        }
        object = (FragmentBuffer)object;
        byte[] byArray = ((FragmentBuffer)object).buffer;
        if (((FragmentBuffer)object).buffer == null && this.buffer != null) {
            return false;
        }
        if (byArray != null && this.buffer == null) {
            return false;
        }
        Collection<Fragment> collection = ((FragmentBuffer)object).fragments;
        if (collection == null && this.fragments != null) {
            return false;
        }
        if (collection != null && this.fragments == null) {
            return false;
        }
        return Arrays.equals(byArray, this.buffer) && ((FragmentBuffer)object).fragments.equals(this.fragments);
    }

    public int hashCode() {
        FragmentBuffer fragmentBuffer = this;
        int n3 = Arrays.hashCode(fragmentBuffer.buffer) * 3;
        return fragmentBuffer.fragments.hashCode() * 2 + n3 + 7;
    }

    public static class Fragment
    implements Serializable {
        private static final long serialVersionUID = -3795931618553980328L;
        private int offset;
        private int length;

        private Fragment(int n3, int n4) {
            this.offset = n3;
            this.length = n4;
        }

        public static Fragment getInstance(int n3, int n4) {
            return new Fragment(n3, n4);
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            return b.a(b.b.a("[").append(this.offset).append(" .. ").append(this.offset + this.length - 1).append(" ("), this.length, ")]");
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!object.getClass().equals(Fragment.class)) {
                return false;
            }
            object = (Fragment)object;
            return ((Fragment)object).offset == this.offset && ((Fragment)object).length == this.length;
        }

        public int hashCode() {
            Fragment fragment = this;
            int n3 = fragment.offset * 2;
            return fragment.length * 3 + n3 + 5;
        }
    }
}

