/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.eidparser.Util;
import com.fis.ekyc.nfc.build_in.eidparser.lds.SecurityInfo;
import d.a;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChipAuthenticationPublicKeyInfo
extends SecurityInfo {
    private static final long serialVersionUID = 5687291829854501771L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private String oid;
    private BigInteger keyId;
    private PublicKey publicKey;

    public ChipAuthenticationPublicKeyInfo(PublicKey publicKey) {
        this(publicKey, null);
    }

    public ChipAuthenticationPublicKeyInfo(PublicKey publicKey, BigInteger bigInteger) {
        this(Util.inferProtocolIdentifier(publicKey), publicKey, bigInteger);
    }

    public ChipAuthenticationPublicKeyInfo(String string2, PublicKey publicKey) {
        this(string2, publicKey, null);
    }

    public ChipAuthenticationPublicKeyInfo(String string2, PublicKey publicKey, BigInteger bigInteger) {
        this.oid = string2;
        this.publicKey = Util.reconstructPublicKey(publicKey);
        this.keyId = bigInteger;
        this.checkFields();
    }

    public static boolean checkRequiredIdentifier(String string2) {
        return SecurityInfo.ID_PK_DH.equals(string2) || SecurityInfo.ID_PK_ECDH.equals(string2);
    }

    public static String toKeyAgreementAlgorithm(String string2) {
        if (string2 != null) {
            if (SecurityInfo.ID_PK_DH.equals(string2)) {
                return "DH";
            }
            if (SecurityInfo.ID_PK_ECDH.equals(string2)) {
                return "ECDH";
            }
            throw new NumberFormatException(g.a("Unknown OID: \"", string2, "\""));
        }
        throw new NumberFormatException("Unknown OID: null");
    }

    private static String toProtocolOIDString(String string2) {
        if (SecurityInfo.ID_PK_DH.equals(string2)) {
            return "id-PK-DH";
        }
        if (SecurityInfo.ID_PK_ECDH.equals(string2)) {
            return "id-PK-ECDH";
        }
        return string2;
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector();
        ASN1Object aSN1Object = Util.toSubjectPublicKeyInfo(serializable.publicKey);
        if (aSN1Object == null) {
            LOGGER.log(Level.WARNING, "Could not convert public key to subject-public-key-info structure");
        } else {
            aSN1EncodableVector2.add(new ASN1ObjectIdentifier(serializable.oid));
            aSN1EncodableVector2.add(aSN1Object.toASN1Primitive());
            Serializable serializable = serializable.keyId;
            if (serializable != null) {
                ASN1Integer aSN1Integer;
                aSN1Object = aSN1Integer;
                aSN1Integer = new ASN1Integer((BigInteger)serializable);
                aSN1EncodableVector2.add(aSN1Object);
            }
        }
        return new DLSequence(aSN1EncodableVector2);
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    @Override
    public String getProtocolOIDString() {
        return ChipAuthenticationPublicKeyInfo.toProtocolOIDString(this.oid);
    }

    public BigInteger getKeyId() {
        return this.keyId;
    }

    public PublicKey getSubjectPublicKey() {
        return this.publicKey;
    }

    public void checkFields() {
        block3: {
            try {
                if (!ChipAuthenticationPublicKeyInfo.checkRequiredIdentifier(this.oid)) break block3;
                return;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Malformed ChipAuthenticationInfo", exception);
            }
        }
        throw new IllegalArgumentException("Wrong identifier: " + this.oid);
    }

    public String toString() {
        ChipAuthenticationPublicKeyInfo chipAuthenticationPublicKeyInfo = serializable;
        Serializable serializable = b.a("ChipAuthenticationPublicKeyInfo [protocol: ").append(ChipAuthenticationPublicKeyInfo.toProtocolOIDString(serializable.oid)).append(", chipAuthenticationPublicKey: ").append(Util.getDetailedPublicKeyAlgorithm(serializable.getSubjectPublicKey())).append(", keyId: ");
        Object object = chipAuthenticationPublicKeyInfo.keyId;
        object = object == null ? "-" : ((BigInteger)object).toString();
        return a.a((StringBuilder)serializable, (String)object, "]");
    }

    public int hashCode() {
        ChipAuthenticationPublicKeyInfo chipAuthenticationPublicKeyInfo = this;
        int n3 = 123;
        int n4 = 1337;
        int n5 = chipAuthenticationPublicKeyInfo.oid.hashCode();
        BigInteger bigInteger = chipAuthenticationPublicKeyInfo.keyId;
        int n6 = bigInteger == null ? 111 : bigInteger.hashCode();
        int n7 = n5 + n6;
        PublicKey publicKey = this.publicKey;
        int n8 = publicKey == null ? 111 : publicKey.hashCode();
        return (n7 + n8) * n4 + n3;
    }

    public boolean equals(Object object) {
        BigInteger bigInteger;
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!ChipAuthenticationPublicKeyInfo.class.equals(object.getClass())) {
            return false;
        }
        object = (ChipAuthenticationPublicKeyInfo)object;
        return this.oid.equals(((ChipAuthenticationPublicKeyInfo)object).oid) && ((bigInteger = this.keyId) == null && ((ChipAuthenticationPublicKeyInfo)object).keyId == null || bigInteger != null && bigInteger.equals(((ChipAuthenticationPublicKeyInfo)object).keyId)) && this.publicKey.equals(((ChipAuthenticationPublicKeyInfo)object).publicKey);
    }
}

