/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.eidparser.lds.AbstractImageInfo;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVInputStream;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVOutputStream;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class DisplayedImageInfo
extends AbstractImageInfo {
    private static final long serialVersionUID = 3801320585294302721L;
    public static final int DISPLAYED_PORTRAIT_TAG = 24384;
    public static final int DISPLAYED_SIGNATURE_OR_MARK_TAG = 24387;
    private int displayedImageTag;

    public DisplayedImageInfo(int n3, byte[] byArray) {
        int n4 = n3;
        super(n4, DisplayedImageInfo.getMimeTypeFromType(n4));
        this.displayedImageTag = DisplayedImageInfo.getDisplayedImageTagFromType(n3);
        this.setImageBytes(byArray);
    }

    public DisplayedImageInfo(InputStream inputStream) {
        DisplayedImageInfo displayedImageInfo = this;
        displayedImageInfo.readObject(inputStream);
    }

    private static String getMimeTypeFromType(int n3) {
        if (n3 != 0) {
            if (n3 != 1) {
                if (n3 == 2) {
                    return "image/x-wsq";
                }
                throw new NumberFormatException(h.a(n3, b.a("Unknown type: ")));
            }
            return "image/jpeg";
        }
        return "image/jpeg";
    }

    private static int getDisplayedImageTagFromType(int n3) {
        if (n3 != 0) {
            if (n3 == 1) {
                return 24387;
            }
            throw new NumberFormatException(h.a(n3, b.a("Unknown type: ")));
        }
        return 24384;
    }

    private static int getTypeFromDisplayedImageTag(int n3) {
        if (n3 != 24384) {
            if (n3 == 24387) {
                return 1;
            }
            throw new NumberFormatException(h.a(n3, b.a("Unknown tag: ")));
        }
        return 0;
    }

    @Override
    public void readObject(InputStream inputStream) {
        int n3;
        if (inputStream instanceof TLVInputStream) {
            inputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream;
            TLVInputStream tLVInputStream2 = tLVInputStream;
            tLVInputStream = new TLVInputStream(inputStream);
            inputStream = tLVInputStream2;
        }
        serializable.displayedImageTag = n3 = ((TLVInputStream)inputStream).readTag();
        if (n3 != 24384 && n3 != 24387) {
            DisplayedImageInfo displayedImageInfo = serializable;
            Serializable serializable = b.a("Expected tag 0x5F40 or 0x5F43, found ");
            throw new IllegalArgumentException(h.a(displayedImageInfo.displayedImageTag, (StringBuilder)serializable));
        }
        InputStream inputStream2 = inputStream;
        DisplayedImageInfo displayedImageInfo = serializable;
        int n4 = DisplayedImageInfo.getTypeFromDisplayedImageTag(n3);
        displayedImageInfo.setType(n4);
        displayedImageInfo.setMimeType(DisplayedImageInfo.getMimeTypeFromType(n4));
        serializable.readImage(inputStream2, ((TLVInputStream)inputStream2).readLength());
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        if (outputStream instanceof TLVOutputStream) {
            outputStream = (TLVOutputStream)outputStream;
        } else {
            TLVOutputStream tLVOutputStream;
            TLVOutputStream tLVOutputStream2 = tLVOutputStream;
            tLVOutputStream = new TLVOutputStream(outputStream);
            outputStream = tLVOutputStream2;
        }
        OutputStream outputStream2 = outputStream;
        ((TLVOutputStream)outputStream2).writeTag(DisplayedImageInfo.getDisplayedImageTagFromType(this.getType()));
        this.writeImage(outputStream2);
        ((TLVOutputStream)outputStream).writeValueEnd();
    }

    public int getDisplayedImageTag() {
        return this.displayedImageTag;
    }

    @Override
    public long getRecordLength() {
        DisplayedImageInfo displayedImageInfo = this;
        int n3 = displayedImageInfo.getImageLength();
        return (long)TLVUtil.getTagLength(DisplayedImageInfo.getDisplayedImageTagFromType(displayedImageInfo.getType())) + 0L + (long)TLVUtil.getLengthLength(n3) + (long)n3;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.displayedImageTag;
    }

    @Override
    public boolean equals(Object object) {
        if (displayedImageInfo2 == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (displayedImageInfo2.getClass() != object.getClass()) {
            return false;
        }
        DisplayedImageInfo displayedImageInfo = displayedImageInfo2;
        DisplayedImageInfo displayedImageInfo2 = (DisplayedImageInfo)object;
        return displayedImageInfo.displayedImageTag == displayedImageInfo2.displayedImageTag;
    }
}

