/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.ECNamedCurveTable;
import com.fis.ekyc.nfc.build_in.eidparser.Util;
import com.fis.ekyc.nfc.build_in.eidparser.lds.SecurityInfo;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.crypto.spec.DHParameterSpec;

public class PACEInfo
extends SecurityInfo {
    private static final long serialVersionUID = 7960925013249578359L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd.lds");
    private static final int VERSION_2 = 2;
    public static final int PARAM_ID_GFP_1024_160 = 0;
    public static final int PARAM_ID_GFP_2048_224 = 1;
    public static final int PARAM_ID_GFP_2048_256 = 2;
    public static final int PARAM_ID_ECP_NIST_P192_R1 = 8;
    public static final int PARAM_ID_ECP_BRAINPOOL_P192_R1 = 9;
    public static final int PARAM_ID_ECP_NIST_P224_R1 = 10;
    public static final int PARAM_ID_ECP_BRAINPOOL_P224_R1 = 11;
    public static final int PARAM_ID_ECP_NIST_P256_R1 = 12;
    public static final int PARAM_ID_ECP_BRAINPOOL_P256_R1 = 13;
    public static final int PARAM_ID_ECP_BRAINPOOL_P320_R1 = 14;
    public static final int PARAM_ID_ECP_NIST_P384_R1 = 15;
    public static final int PARAM_ID_ECP_BRAINPOOL_P384_R1 = 16;
    public static final int PARAM_ID_ECP_BRAINPOOL_P512_R1 = 17;
    public static final int PARAM_ID_ECP_NIST_P521_R1 = 18;
    private static final DHParameterSpec PARAMS_GFP_1024_160 = Util.toExplicitDHParameterSpec(Util.RFC5114_1024_160);
    private static final DHParameterSpec PARAMS_GFP_2048_224 = Util.toExplicitDHParameterSpec(Util.RFC5114_2048_224);
    private static final DHParameterSpec PARAMS_GFP_2048_256 = Util.toExplicitDHParameterSpec(Util.RFC5114_2048_256);
    private static final ECParameterSpec PARAMS_ECP_NIST_P192_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec("secp192r1"));
    private static final ECParameterSpec PARAMS_ECP_NIST_P224_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec("secp224r1"));
    private static final ECParameterSpec PARAMS_ECP_NIST_P256_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec("secp256r1"));
    private static final ECParameterSpec PARAMS_ECP_NIST_P384_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec("secp384r1"));
    private static final ECParameterSpec PARAMS_ECP_NIST_P521_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec("secp521r1"));
    private static final ECParameterSpec PARAMS_ECP_BRAINPOOL_P192_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec("brainpoolp192r1"));
    private static final ECParameterSpec PARAMS_ECP_BRAINPOOL_P224_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec("brainpoolp224r1"));
    private static final ECParameterSpec PARAMS_ECP_BRAINPOOL_P256_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec("brainpoolp256r1"));
    private static final ECParameterSpec PARAMS_ECP_BRAINPOOL_P320_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec("brainpoolp320r1"));
    private static final ECParameterSpec PARAMS_ECP_BRAINPOOL_P384_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec("brainpoolp384r1"));
    private static final ECParameterSpec PARAMS_ECP_BRAINPOOL_P512_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec("brainpoolp512r1"));
    private static final Set<String> ALLOWED_REQUIRED_IDENTIFIERS = new TreeSet<String>(Arrays.asList("0.4.0.127.0.7.2.2.4.1.1", "0.4.0.127.0.7.2.2.4.1.2", "0.4.0.127.0.7.2.2.4.1.3", "0.4.0.127.0.7.2.2.4.1.4", "0.4.0.127.0.7.2.2.4.3.1", "0.4.0.127.0.7.2.2.4.3.2", "0.4.0.127.0.7.2.2.4.3.3", "0.4.0.127.0.7.2.2.4.3.4", "0.4.0.127.0.7.2.2.4.2.1", "0.4.0.127.0.7.2.2.4.2.2", "0.4.0.127.0.7.2.2.4.2.3", "0.4.0.127.0.7.2.2.4.2.4", "0.4.0.127.0.7.2.2.4.4.1", "0.4.0.127.0.7.2.2.4.4.2", "0.4.0.127.0.7.2.2.4.4.3", "0.4.0.127.0.7.2.2.4.4.4", "0.4.0.127.0.7.2.2.4.6.2", "0.4.0.127.0.7.2.2.4.6.3", "0.4.0.127.0.7.2.2.4.6.4"));
    private String protocolOID;
    private int version;
    private BigInteger parameterId;

    public PACEInfo(String string2, int n3, int n4) {
        this(string2, n3, BigInteger.valueOf(n4));
    }

    public PACEInfo(String string2, int n3, BigInteger bigInteger) {
        if (PACEInfo.checkRequiredIdentifier(string2)) {
            if (n3 != 2) {
                LOGGER.warning("Invalid version, must be 2");
            }
            PACEInfo pACEInfo = this;
            pACEInfo.protocolOID = string2;
            pACEInfo.version = n3;
            pACEInfo.parameterId = bigInteger;
            return;
        }
        throw new IllegalArgumentException("Invalid OID");
    }

    public static PACEInfo createPACEInfo(byte[] object) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(object);
        object = aSN1Sequence;
        String string2 = ((ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0)).getId();
        Object object2 = aSN1Sequence.getObjectAt(1).toASN1Primitive();
        ASN1Primitive aSN1Primitive = null;
        if (aSN1Sequence.size() == 3) {
            aSN1Primitive = ((ASN1Sequence)object).getObjectAt(2).toASN1Primitive();
        }
        int n3 = ((ASN1Integer)object2).getValue().intValue();
        object2 = null;
        if (aSN1Primitive != null) {
            object2 = ((ASN1Integer)aSN1Primitive).getValue();
        }
        return new PACEInfo(string2, n3, (BigInteger)object2);
    }

    public static boolean checkRequiredIdentifier(String string2) {
        return ALLOWED_REQUIRED_IDENTIFIERS.contains(string2);
    }

    public static MappingType toMappingType(String string2) {
        if (!("0.4.0.127.0.7.2.2.4.1.1".equals(string2) || "0.4.0.127.0.7.2.2.4.1.2".equals(string2) || "0.4.0.127.0.7.2.2.4.1.3".equals(string2) || "0.4.0.127.0.7.2.2.4.1.4".equals(string2) || "0.4.0.127.0.7.2.2.4.2.1".equals(string2) || "0.4.0.127.0.7.2.2.4.2.2".equals(string2) || "0.4.0.127.0.7.2.2.4.2.3".equals(string2) || "0.4.0.127.0.7.2.2.4.2.4".equals(string2))) {
            if (!("0.4.0.127.0.7.2.2.4.3.1".equals(string2) || "0.4.0.127.0.7.2.2.4.3.2".equals(string2) || "0.4.0.127.0.7.2.2.4.3.3".equals(string2) || "0.4.0.127.0.7.2.2.4.3.4".equals(string2) || "0.4.0.127.0.7.2.2.4.4.1".equals(string2) || "0.4.0.127.0.7.2.2.4.4.2".equals(string2) || "0.4.0.127.0.7.2.2.4.4.3".equals(string2) || "0.4.0.127.0.7.2.2.4.4.4".equals(string2))) {
                if (!("0.4.0.127.0.7.2.2.4.6.2".equals(string2) || "0.4.0.127.0.7.2.2.4.6.3".equals(string2) || "0.4.0.127.0.7.2.2.4.6.4".equals(string2))) {
                    throw new NumberFormatException(g.a("Unknown OID: \"", string2, "\""));
                }
                return MappingType.CAM;
            }
            return MappingType.IM;
        }
        return MappingType.GM;
    }

    public static String toKeyAgreementAlgorithm(String string2) {
        if (!("0.4.0.127.0.7.2.2.4.1.1".equals(string2) || "0.4.0.127.0.7.2.2.4.1.2".equals(string2) || "0.4.0.127.0.7.2.2.4.1.3".equals(string2) || "0.4.0.127.0.7.2.2.4.1.4".equals(string2) || "0.4.0.127.0.7.2.2.4.3.1".equals(string2) || "0.4.0.127.0.7.2.2.4.3.2".equals(string2) || "0.4.0.127.0.7.2.2.4.3.3".equals(string2) || "0.4.0.127.0.7.2.2.4.3.4".equals(string2))) {
            if (!("0.4.0.127.0.7.2.2.4.2.1".equals(string2) || "0.4.0.127.0.7.2.2.4.2.2".equals(string2) || "0.4.0.127.0.7.2.2.4.2.3".equals(string2) || "0.4.0.127.0.7.2.2.4.2.4".equals(string2) || "0.4.0.127.0.7.2.2.4.4.1".equals(string2) || "0.4.0.127.0.7.2.2.4.4.2".equals(string2) || "0.4.0.127.0.7.2.2.4.4.3".equals(string2) || "0.4.0.127.0.7.2.2.4.4.4".equals(string2) || "0.4.0.127.0.7.2.2.4.6.2".equals(string2) || "0.4.0.127.0.7.2.2.4.6.3".equals(string2) || "0.4.0.127.0.7.2.2.4.6.4".equals(string2))) {
                throw new NumberFormatException(g.a("Unknown OID: \"", string2, "\""));
            }
            return "ECDH";
        }
        return "DH";
    }

    public static String toCipherAlgorithm(String string2) {
        if (!("0.4.0.127.0.7.2.2.4.1.1".equals(string2) || "0.4.0.127.0.7.2.2.4.3.1".equals(string2) || "0.4.0.127.0.7.2.2.4.2.1".equals(string2) || "0.4.0.127.0.7.2.2.4.4.1".equals(string2))) {
            if (!("0.4.0.127.0.7.2.2.4.1.2".equals(string2) || "0.4.0.127.0.7.2.2.4.1.3".equals(string2) || "0.4.0.127.0.7.2.2.4.1.4".equals(string2) || "0.4.0.127.0.7.2.2.4.3.2".equals(string2) || "0.4.0.127.0.7.2.2.4.3.3".equals(string2) || "0.4.0.127.0.7.2.2.4.3.4".equals(string2) || "0.4.0.127.0.7.2.2.4.2.2".equals(string2) || "0.4.0.127.0.7.2.2.4.2.3".equals(string2) || "0.4.0.127.0.7.2.2.4.2.4".equals(string2) || "0.4.0.127.0.7.2.2.4.4.2".equals(string2) || "0.4.0.127.0.7.2.2.4.4.3".equals(string2) || "0.4.0.127.0.7.2.2.4.4.4".equals(string2) || "0.4.0.127.0.7.2.2.4.6.2".equals(string2) || "0.4.0.127.0.7.2.2.4.6.3".equals(string2) || "0.4.0.127.0.7.2.2.4.6.4".equals(string2))) {
                throw new NumberFormatException(g.a("Unknown OID: \"", string2, "\""));
            }
            return "AES";
        }
        return "DESede";
    }

    public static String toDigestAlgorithm(String string2) {
        if (!("0.4.0.127.0.7.2.2.4.1.1".equals(string2) || "0.4.0.127.0.7.2.2.4.3.1".equals(string2) || "0.4.0.127.0.7.2.2.4.2.1".equals(string2) || "0.4.0.127.0.7.2.2.4.4.1".equals(string2) || "0.4.0.127.0.7.2.2.4.1.2".equals(string2) || "0.4.0.127.0.7.2.2.4.3.2".equals(string2) || "0.4.0.127.0.7.2.2.4.2.2".equals(string2) || "0.4.0.127.0.7.2.2.4.4.2".equals(string2) || "0.4.0.127.0.7.2.2.4.6.2".equals(string2))) {
            if (!("0.4.0.127.0.7.2.2.4.1.3".equals(string2) || "0.4.0.127.0.7.2.2.4.3.3".equals(string2) || "0.4.0.127.0.7.2.2.4.2.3".equals(string2) || "0.4.0.127.0.7.2.2.4.4.3".equals(string2) || "0.4.0.127.0.7.2.2.4.6.3".equals(string2) || "0.4.0.127.0.7.2.2.4.1.4".equals(string2) || "0.4.0.127.0.7.2.2.4.3.4".equals(string2) || "0.4.0.127.0.7.2.2.4.2.4".equals(string2) || "0.4.0.127.0.7.2.2.4.4.4".equals(string2) || "0.4.0.127.0.7.2.2.4.6.4".equals(string2))) {
                throw new NumberFormatException(g.a("Unknown OID: \"", string2, "\""));
            }
            return "SHA-256";
        }
        return "SHA-1";
    }

    public static int toKeyLength(String string2) {
        if (!("0.4.0.127.0.7.2.2.4.1.1".equals(string2) || "0.4.0.127.0.7.2.2.4.3.1".equals(string2) || "0.4.0.127.0.7.2.2.4.2.1".equals(string2) || "0.4.0.127.0.7.2.2.4.4.1".equals(string2) || "0.4.0.127.0.7.2.2.4.1.2".equals(string2) || "0.4.0.127.0.7.2.2.4.3.2".equals(string2) || "0.4.0.127.0.7.2.2.4.2.2".equals(string2) || "0.4.0.127.0.7.2.2.4.4.2".equals(string2) || "0.4.0.127.0.7.2.2.4.6.2".equals(string2))) {
            if (!("0.4.0.127.0.7.2.2.4.1.3".equals(string2) || "0.4.0.127.0.7.2.2.4.2.3".equals(string2) || "0.4.0.127.0.7.2.2.4.3.3".equals(string2) || "0.4.0.127.0.7.2.2.4.4.3".equals(string2) || "0.4.0.127.0.7.2.2.4.6.3".equals(string2))) {
                if (!("0.4.0.127.0.7.2.2.4.1.4".equals(string2) || "0.4.0.127.0.7.2.2.4.3.4".equals(string2) || "0.4.0.127.0.7.2.2.4.2.4".equals(string2) || "0.4.0.127.0.7.2.2.4.4.4".equals(string2) || "0.4.0.127.0.7.2.2.4.6.4".equals(string2))) {
                    throw new NumberFormatException(g.a("Unknown OID: \"", string2, "\""));
                }
                return 256;
            }
            return 192;
        }
        return 128;
    }

    public static AlgorithmParameterSpec toParameterSpec(BigInteger bigInteger) {
        return PACEInfo.toParameterSpec(bigInteger.intValue());
    }

    public static AlgorithmParameterSpec toParameterSpec(int n3) {
        if (n3 != 0) {
            if (n3 != 1) {
                if (n3 != 2) {
                    switch (n3) {
                        default: {
                            throw new NumberFormatException(a.a("Unknown standardized domain parameters ", n3));
                        }
                        case 18: {
                            return PARAMS_ECP_NIST_P521_R1;
                        }
                        case 17: {
                            return PARAMS_ECP_BRAINPOOL_P512_R1;
                        }
                        case 16: {
                            return PARAMS_ECP_BRAINPOOL_P384_R1;
                        }
                        case 15: {
                            return PARAMS_ECP_NIST_P384_R1;
                        }
                        case 14: {
                            return PARAMS_ECP_BRAINPOOL_P320_R1;
                        }
                        case 13: {
                            return PARAMS_ECP_BRAINPOOL_P256_R1;
                        }
                        case 12: {
                            return PARAMS_ECP_NIST_P256_R1;
                        }
                        case 11: {
                            return PARAMS_ECP_BRAINPOOL_P224_R1;
                        }
                        case 10: {
                            return PARAMS_ECP_NIST_P224_R1;
                        }
                        case 9: {
                            return PARAMS_ECP_BRAINPOOL_P192_R1;
                        }
                        case 8: 
                    }
                    return PARAMS_ECP_NIST_P192_R1;
                }
                return PARAMS_GFP_2048_256;
            }
            return PARAMS_GFP_2048_224;
        }
        return PARAMS_GFP_1024_160;
    }

    public static String toStandardizedParamIdString(BigInteger bigInteger) {
        if (bigInteger == null) {
            return "null";
        }
        int n3 = bigInteger.intValue();
        if (n3 != 0) {
            if (n3 != 1) {
                if (n3 != 2) {
                    switch (n3) {
                        default: {
                            return bigInteger.toString();
                        }
                        case 18: {
                            return "NIST P-521 (secp521r1)";
                        }
                        case 17: {
                            return "BrainpoolP512r1";
                        }
                        case 16: {
                            return "BrainpoolP384r1";
                        }
                        case 15: {
                            return "NIST P-384 (secp384r1)";
                        }
                        case 14: {
                            return "BrainpoolP320r1";
                        }
                        case 13: {
                            return "BrainpoolP256r1";
                        }
                        case 12: {
                            return "NIST P-256 (secp256r1)";
                        }
                        case 11: {
                            return "BrainpoolP224r1";
                        }
                        case 10: {
                            return "NIST P-224 (secp224r1)";
                        }
                        case 9: {
                            return "BrainpoolP192r1";
                        }
                        case 8: 
                    }
                    return "NIST P-192 (secp192r1)";
                }
                return "2048-bit MODP Group with 256-bit Prime Order Subgroup";
            }
            return "2048-bit MODP Group with 224-bit Prime Order Subgroup";
        }
        return "1024-bit MODP Group with 160-bit Prime Order Subgroup";
    }

    private String toProtocolOIDString(String string2) {
        if ("0.4.0.127.0.7.2.2.4.1.1".equals(string2)) {
            return "id-PACE-DH-GM-3DES-CBC-CBC";
        }
        if ("0.4.0.127.0.7.2.2.4.1.2".equals(string2)) {
            return "id-PACE-DH-GM-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.4.1.3".equals(string2)) {
            return "id-PACE-DH-GM-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.4.1.4".equals(string2)) {
            return "id-PACE-DH-GM-AES-CBC-CMAC-256";
        }
        if ("0.4.0.127.0.7.2.2.4.3.1".equals(string2)) {
            return "id-PACE-DH-IM-3DES-CBC-CBC";
        }
        if ("0.4.0.127.0.7.2.2.4.3.2".equals(string2)) {
            return "id-PACE-DH-IM-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.4.3.3".equals(string2)) {
            return "id-PACE-DH-IM-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.4.3.4".equals(string2)) {
            return "id-PACE-DH-IM-AES-CBC-CMAC-256";
        }
        if ("0.4.0.127.0.7.2.2.4.2.1".equals(string2)) {
            return "id-PACE-ECDH-GM-3DES-CBC-CBC";
        }
        if ("0.4.0.127.0.7.2.2.4.2.2".equals(string2)) {
            return "id-PACE-ECDH-GM-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.4.2.3".equals(string2)) {
            return "id-PACE-ECDH-GM-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.4.2.4".equals(string2)) {
            return "id-PACE-ECDH-GM-AES-CBC-CMAC-256";
        }
        if ("0.4.0.127.0.7.2.2.4.4.1".equals(string2)) {
            return "id-PACE-ECDH-IM-3DES-CBC-CBC";
        }
        if ("0.4.0.127.0.7.2.2.4.4.2".equals(string2)) {
            return "id-PACE-ECDH-IM-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.4.4.3".equals(string2)) {
            return "id-PACE-ECDH-IM-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.4.4.4".equals(string2)) {
            return "id-PACE-ECDH-IM-AES-CBC-CMAC-256";
        }
        if ("0.4.0.127.0.7.2.2.4.6.2".equals(string2)) {
            return "id-PACE-ECDH-CAM-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.4.6.3".equals(string2)) {
            return "id-PACE-ECDH-CAM-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.4.6.4".equals(string2)) {
            string2 = "id-PACE-ECDH-CAM-AES-CBC-CMAC-256";
        }
        return string2;
    }

    @Override
    public String getObjectIdentifier() {
        return this.protocolOID;
    }

    @Override
    public String getProtocolOIDString() {
        PACEInfo pACEInfo = this;
        return pACEInfo.toProtocolOIDString(pACEInfo.protocolOID);
    }

    public int getVersion() {
        return this.version;
    }

    public BigInteger getParameterId() {
        return this.parameterId;
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector().add(new ASN1ObjectIdentifier(serializable.protocolOID));
        aSN1EncodableVector2.add(new ASN1Integer(serializable.version));
        Serializable serializable = serializable.parameterId;
        if (serializable != null) {
            ASN1Integer aSN1Integer;
            ASN1Integer aSN1Integer2 = aSN1Integer;
            aSN1Integer = new ASN1Integer((BigInteger)serializable);
            aSN1EncodableVector2.add(aSN1Integer2);
        }
        return new DLSequence(aSN1EncodableVector2);
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append("PACEInfo [");
        PACEInfo pACEInfo = this;
        stringBuilder2.append("protocol: ").append(pACEInfo.toProtocolOIDString(pACEInfo.protocolOID));
        stringBuilder2.append(", version: ").append(this.version);
        if (this.parameterId != null) {
            stringBuilder2.append(", parameterId: ").append(PACEInfo.toStandardizedParamIdString(this.parameterId));
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append("]");
        return stringBuilder3.toString();
    }

    public int hashCode() {
        PACEInfo pACEInfo = this;
        int n3 = pACEInfo.protocolOID.hashCode() * 7 + 1234567891;
        n3 = pACEInfo.version * 5 + n3;
        int n4 = 3;
        BigInteger bigInteger = pACEInfo.parameterId;
        return (bigInteger == null ? 1991 : bigInteger.hashCode()) * n4 + n3;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == serializable) {
            return true;
        }
        if (!PACEInfo.class.equals(object.getClass())) {
            return false;
        }
        object = (PACEInfo)object;
        String string2 = ((PACEInfo)serializable).protocolOID;
        if (string2 == null && ((PACEInfo)object).protocolOID != null) {
            return false;
        }
        if (string2 != null && !string2.equals(((PACEInfo)object).protocolOID)) {
            return false;
        }
        if (((PACEInfo)serializable).version != ((PACEInfo)object).version) {
            return false;
        }
        Serializable serializable = ((PACEInfo)serializable).parameterId;
        if (serializable == null && ((PACEInfo)object).parameterId != null) {
            return false;
        }
        return serializable == null || ((BigInteger)serializable).equals(((PACEInfo)object).parameterId);
    }

    public static class DHCParameterSpec
    extends DHParameterSpec {
        private BigInteger q;

        public DHCParameterSpec(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            super(bigInteger, bigInteger2);
            this.q = bigInteger3;
        }

        public BigInteger getQ() {
            return this.q;
        }
    }

    public static final class MappingType
    extends Enum<MappingType> {
        public static final /* enum */ MappingType GM;
        public static final /* enum */ MappingType IM;
        public static final /* enum */ MappingType CAM;
        private static final /* synthetic */ MappingType[] $VALUES;

        public static MappingType[] values() {
            return (MappingType[])$VALUES.clone();
        }

        public static MappingType valueOf(String string2) {
            return Enum.valueOf(MappingType.class, string2);
        }

        static {
            MappingType mappingType;
            MappingType mappingType2;
            MappingType mappingType3;
            MappingType mappingType4 = mappingType3;
            GM = new MappingType();
            MappingType mappingType5 = mappingType2;
            IM = new MappingType();
            MappingType mappingType6 = mappingType;
            CAM = new MappingType();
            $VALUES = new MappingType[]{mappingType4, mappingType5, mappingType6};
        }
    }
}

