/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.EACObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.eidparser.Util;
import com.fis.ekyc.nfc.build_in.eidparser.lds.AbstractLDSInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.ActiveAuthenticationInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.ChipAuthenticationInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.ChipAuthenticationPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.PACEDomainParameterInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.PACEInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.TerminalAuthenticationInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SecurityInfo
extends AbstractLDSInfo {
    private static final long serialVersionUID = -7919854443619069808L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    public static final String ID_AA = "2.23.136.1.1.5";
    public static final String ID_PK_DH = EACObjectIdentifiers.id_PK_DH.getId();
    public static final String ID_PK_ECDH = EACObjectIdentifiers.id_PK_ECDH.getId();
    public static final String ID_CA_DH_3DES_CBC_CBC = EACObjectIdentifiers.id_CA_DH_3DES_CBC_CBC.getId();
    public static final String ID_CA_ECDH_3DES_CBC_CBC = EACObjectIdentifiers.id_CA_ECDH_3DES_CBC_CBC.getId();
    public static final String ID_CA_DH_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.3.1.2";
    public static final String ID_CA_DH_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.3.1.3";
    public static final String ID_CA_DH_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.3.1.4";
    public static final String ID_CA_ECDH_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.3.2.2";
    public static final String ID_CA_ECDH_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.3.2.3";
    public static final String ID_CA_ECDH_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.3.2.4";
    public static final String ID_TA = EACObjectIdentifiers.id_TA.getId();
    public static final String ID_TA_RSA = EACObjectIdentifiers.id_TA_RSA.getId();
    public static final String ID_TA_RSA_V1_5_SHA_1 = EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_1.getId();
    public static final String ID_TA_RSA_V1_5_SHA_256 = EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_256.getId();
    public static final String ID_TA_RSA_PSS_SHA_1 = EACObjectIdentifiers.id_TA_RSA_PSS_SHA_1.getId();
    public static final String ID_TA_RSA_PSS_SHA_256 = EACObjectIdentifiers.id_TA_RSA_PSS_SHA_256.getId();
    public static final String ID_TA_ECDSA = EACObjectIdentifiers.id_TA_ECDSA.getId();
    public static final String ID_TA_ECDSA_SHA_1 = EACObjectIdentifiers.id_TA_ECDSA_SHA_1.getId();
    public static final String ID_TA_ECDSA_SHA_224 = EACObjectIdentifiers.id_TA_ECDSA_SHA_224.getId();
    public static final String ID_TA_ECDSA_SHA_256 = EACObjectIdentifiers.id_TA_ECDSA_SHA_256.getId();
    public static final String ID_EC_PUBLIC_KEY_TYPE = X9ObjectIdentifiers.id_publicKeyType.getId();
    public static final String ID_EC_PUBLIC_KEY = X9ObjectIdentifiers.id_ecPublicKey.getId();
    private static final String ID_BSI = "0.4.0.127.0.7";
    public static final String ID_PACE = "0.4.0.127.0.7.2.2.4";
    public static final String ID_PACE_DH_GM = "0.4.0.127.0.7.2.2.4.1";
    public static final String ID_PACE_DH_GM_3DES_CBC_CBC = "0.4.0.127.0.7.2.2.4.1.1";
    public static final String ID_PACE_DH_GM_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.4.1.2";
    public static final String ID_PACE_DH_GM_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.4.1.3";
    public static final String ID_PACE_DH_GM_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.4.1.4";
    public static final String ID_PACE_ECDH_GM = "0.4.0.127.0.7.2.2.4.2";
    public static final String ID_PACE_ECDH_GM_3DES_CBC_CBC = "0.4.0.127.0.7.2.2.4.2.1";
    public static final String ID_PACE_ECDH_GM_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.4.2.2";
    public static final String ID_PACE_ECDH_GM_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.4.2.3";
    public static final String ID_PACE_ECDH_GM_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.4.2.4";
    public static final String ID_PACE_DH_IM = "0.4.0.127.0.7.2.2.4.3";
    public static final String ID_PACE_DH_IM_3DES_CBC_CBC = "0.4.0.127.0.7.2.2.4.3.1";
    public static final String ID_PACE_DH_IM_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.4.3.2";
    public static final String ID_PACE_DH_IM_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.4.3.3";
    public static final String ID_PACE_DH_IM_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.4.3.4";
    public static final String ID_PACE_ECDH_IM = "0.4.0.127.0.7.2.2.4.4";
    public static final String ID_PACE_ECDH_IM_3DES_CBC_CBC = "0.4.0.127.0.7.2.2.4.4.1";
    public static final String ID_PACE_ECDH_IM_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.4.4.2";
    public static final String ID_PACE_ECDH_IM_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.4.4.3";
    public static final String ID_PACE_ECDH_IM_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.4.4.4";
    public static final String ID_PACE_ECDH_CAM = "0.4.0.127.0.7.2.2.4.6";
    public static final String ID_PACE_ECDH_CAM_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.4.6.2";
    public static final String ID_PACE_ECDH_CAM_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.4.6.3";
    public static final String ID_PACE_ECDH_CAM_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.4.6.4";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SecurityInfo getInstance(ASN1Primitive aSN1Object) {
        try {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Object;
            String string2 = ((ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0)).getId();
            Object object = aSN1Sequence.getObjectAt(1).toASN1Primitive();
            ASN1Primitive aSN1Primitive = null;
            if (aSN1Sequence.size() == 3) {
                aSN1Primitive = aSN1Sequence.getObjectAt(2).toASN1Primitive();
            }
            if (ActiveAuthenticationInfo.checkRequiredIdentifier(string2)) {
                int n3 = ((ASN1Integer)object).getValue().intValue();
                if (aSN1Primitive == null) {
                    object = null;
                    return new ActiveAuthenticationInfo(string2, n3, (String)object);
                }
                object = ((ASN1ObjectIdentifier)aSN1Primitive).getId();
                return new ActiveAuthenticationInfo(string2, n3, (String)object);
            }
            if (ChipAuthenticationPublicKeyInfo.checkRequiredIdentifier(string2)) {
                SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(object);
                if (aSN1Primitive == null) {
                    return new ChipAuthenticationPublicKeyInfo(string2, Util.toPublicKey(subjectPublicKeyInfo));
                }
                object = ((ASN1Integer)aSN1Primitive).getValue();
                return new ChipAuthenticationPublicKeyInfo(string2, Util.toPublicKey(subjectPublicKeyInfo), (BigInteger)object);
            }
            if (ChipAuthenticationInfo.checkRequiredIdentifier(string2)) {
                int n4 = ((ASN1Integer)object).getValue().intValue();
                if (aSN1Primitive == null) {
                    return new ChipAuthenticationInfo(string2, n4);
                }
                object = ((ASN1Integer)aSN1Primitive).getValue();
                return new ChipAuthenticationInfo(string2, n4, (BigInteger)object);
            }
            if (TerminalAuthenticationInfo.checkRequiredIdentifier(string2)) {
                int n5 = ((ASN1Integer)object).getValue().intValue();
                if (aSN1Primitive == null) {
                    return new TerminalAuthenticationInfo(string2, n5);
                }
                object = (ASN1Sequence)aSN1Primitive;
                return new TerminalAuthenticationInfo(string2, n5, (ASN1Sequence)object);
            }
            if (PACEInfo.checkRequiredIdentifier(string2)) {
                int n6 = ((ASN1Integer)object).getValue().intValue();
                int n7 = -1;
                if (aSN1Primitive != null) {
                    n7 = ((ASN1Integer)aSN1Primitive).getValue().intValue();
                }
                return new PACEInfo(string2, n6, n7);
            }
            if (!PACEDomainParameterInfo.checkRequiredIdentifier(string2)) {
                LOGGER.warning("Unsupported SecurityInfo, oid = " + string2);
                return null;
            }
            AlgorithmIdentifier algorithmIdentifier = AlgorithmIdentifier.getInstance(object);
            if (aSN1Primitive != null) {
                object = ((ASN1Integer)aSN1Primitive).getValue();
                return new PACEDomainParameterInfo(string2, algorithmIdentifier, (BigInteger)object);
            }
            return new PACEDomainParameterInfo(string2, algorithmIdentifier);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Unexpected exception", exception);
            throw new IllegalArgumentException("Malformed input stream.");
        }
    }

    @Deprecated
    public abstract ASN1Primitive getDERObject();

    @Override
    public void writeObject(OutputStream outputStream) {
        if ((object = ((SecurityInfo)object).getDERObject()) != null) {
            byte[] byArray = ((ASN1Object)object).getEncoded("DER");
            Object object = byArray;
            if (byArray != null) {
                outputStream.write((byte[])object);
                return;
            }
            throw new IOException("Could not decode from DER.");
        }
        throw new IOException("Could not decode from DER.");
    }

    public abstract String getObjectIdentifier();

    public abstract String getProtocolOIDString();
}

