/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.icao;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLSet;
import com.fis.ekyc.nfc.build_in.eidparser.lds.ActiveAuthenticationInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.ChipAuthenticationInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.ChipAuthenticationPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.DataGroup;
import com.fis.ekyc.nfc.build_in.eidparser.lds.SecurityInfo;
import com.fis.ekyc.nfc.build_in.eidparser.lds.TerminalAuthenticationInfo;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DG14File
extends DataGroup {
    private static final long serialVersionUID = -3536507558193769953L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private Set<SecurityInfo> securityInfos;

    public DG14File(Collection<SecurityInfo> collection) {
        super(110);
        if (collection != null) {
            HashSet<SecurityInfo> hashSet;
            DG14File dG14File = serializable;
            Serializable serializable = hashSet;
            hashSet = new HashSet<SecurityInfo>(collection);
            dG14File.securityInfos = serializable;
            return;
        }
        throw new IllegalArgumentException("Null securityInfos");
    }

    public DG14File(InputStream inputStream) {
        super(110, inputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void readContent(InputStream object) {
        this.securityInfos = new HashSet<SecurityInfo>();
        object = (ASN1Set)new ASN1InputStream((InputStream)object).readObject();
        int n3 = 0;
        while (true) {
            block6: {
                if (n3 >= ((ASN1Set)object).size()) {
                    return;
                }
                try {
                    SecurityInfo securityInfo = SecurityInfo.getInstance(((ASN1Set)object).getObjectAt(n3).toASN1Primitive());
                    if (securityInfo == null) {
                        LOGGER.warning("Skipping this unsupported SecurityInfo");
                        break block6;
                    }
                    this.securityInfos.add(securityInfo);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Skipping Security Info", exception);
                }
            }
            ++n3;
        }
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        ASN1EncodableVector aSN1EncodableVector;
        DG14File dG14File = aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector();
        for (SecurityInfo securityInfo : dG14File.securityInfos) {
            if (securityInfo == null) continue;
            aSN1EncodableVector2.add(securityInfo.getDERObject());
        }
        outputStream.write(new DLSet(aSN1EncodableVector2).getEncoded("DER"));
    }

    @Deprecated
    public List<TerminalAuthenticationInfo> getTerminalAuthenticationInfos() {
        ArrayList arrayList;
        DG14File dG14File = serializable;
        Serializable serializable = arrayList;
        arrayList = new ArrayList();
        for (SecurityInfo securityInfo : dG14File.securityInfos) {
            if (!(securityInfo instanceof TerminalAuthenticationInfo)) continue;
            ((ArrayList)serializable).add((TerminalAuthenticationInfo)securityInfo);
        }
        return serializable;
    }

    @Deprecated
    public List<ChipAuthenticationInfo> getChipAuthenticationInfos() {
        ArrayList arrayList;
        DG14File dG14File = serializable;
        Serializable serializable = arrayList;
        arrayList = new ArrayList();
        for (SecurityInfo securityInfo : dG14File.securityInfos) {
            if (!(securityInfo instanceof ChipAuthenticationInfo)) continue;
            securityInfo = (ChipAuthenticationInfo)securityInfo;
            ((ArrayList)serializable).add(securityInfo);
            if (((ChipAuthenticationInfo)securityInfo).getKeyId() != null) continue;
            return serializable;
        }
        return serializable;
    }

    @Deprecated
    public List<ChipAuthenticationPublicKeyInfo> getChipAuthenticationPublicKeyInfos() {
        ArrayList arrayList;
        DG14File dG14File = serializable;
        Serializable serializable = arrayList;
        arrayList = new ArrayList();
        for (SecurityInfo securityInfo : dG14File.securityInfos) {
            if (!(securityInfo instanceof ChipAuthenticationPublicKeyInfo)) continue;
            ((ArrayList)serializable).add((ChipAuthenticationPublicKeyInfo)securityInfo);
        }
        return serializable;
    }

    @Deprecated
    public List<ActiveAuthenticationInfo> getActiveAuthenticationInfos() {
        ArrayList arrayList;
        DG14File dG14File = serializable;
        Serializable serializable = arrayList;
        arrayList = new ArrayList();
        for (SecurityInfo securityInfo : dG14File.securityInfos) {
            if (!(securityInfo instanceof ActiveAuthenticationInfo)) continue;
            ((ArrayList)serializable).add((ActiveAuthenticationInfo)securityInfo);
        }
        return serializable;
    }

    public Collection<SecurityInfo> getSecurityInfos() {
        return this.securityInfos;
    }

    @Override
    public String toString() {
        return b.a("DG14File [").append(this.securityInfos.toString()).append("]").toString();
    }

    public boolean equals(Object set) {
        if (set == null) {
            return false;
        }
        if (!set.getClass().equals(set2.getClass())) {
            return false;
        }
        DG14File dG14File = set2;
        Set<SecurityInfo> set2 = (DG14File)((Object)set);
        set = dG14File.securityInfos;
        if (set == null) {
            return ((DG14File)((Object)set2)).securityInfos == null;
        }
        set2 = ((DG14File)((Object)set2)).securityInfos;
        if (set2 == null) {
            return set == null;
        }
        return set.equals(set2);
    }

    public int hashCode() {
        return this.securityInfos.hashCode() * 5 + 41;
    }
}

