/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.icao;

import b.b;
import com.fis.ekyc.nfc.build_in.eidparser.Util;
import com.fis.ekyc.nfc.build_in.eidparser.lds.AbstractTaggedLDSFile;
import com.fis.ekyc.nfc.build_in.eidparser.lds.DataGroup;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DG15File
extends DataGroup {
    private static final long serialVersionUID = 3834304239673755744L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private static final String[] PUBLIC_KEY_ALGORITHMS = new String[]{"RSA", "EC"};
    private PublicKey publicKey;

    public DG15File(PublicKey publicKey) {
        super(111);
        this.publicKey = publicKey;
    }

    public DG15File(InputStream inputStream) {
        super(111, inputStream);
    }

    private static PublicKey getPublicKey(byte[] objectArray) {
        X509EncodedKeySpec x509EncodedKeySpec;
        X509EncodedKeySpec x509EncodedKeySpec2 = x509EncodedKeySpec;
        x509EncodedKeySpec = new X509EncodedKeySpec((byte[])objectArray);
        objectArray = PUBLIC_KEY_ALGORITHMS;
        int n3 = PUBLIC_KEY_ALGORITHMS.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            try {
                return Util.getPublicKey((String)objectArray[i3], x509EncodedKeySpec2);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                LOGGER.log(Level.FINE, "Ignore, try next algorithm", invalidKeySpecException);
                continue;
            }
        }
        throw new InvalidAlgorithmParameterException();
    }

    @Override
    public void readContent(InputStream inputStream) {
        if (inputStream instanceof DataInputStream) {
            inputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream;
            DataInputStream dataInputStream2 = dataInputStream;
            dataInputStream = new DataInputStream(inputStream);
            inputStream = dataInputStream2;
        }
        DG15File dG15File = object;
        InputStream inputStream2 = inputStream;
        byte[] byArray = new byte[((AbstractTaggedLDSFile)object).getLength()];
        Object object = byArray;
        try {
            ((DataInputStream)inputStream2).readFully(byArray);
            dG15File.publicKey = DG15File.getPublicKey((byte[])object);
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOGGER.log(Level.WARNING, "Unexpected exception while reading DG15 content", generalSecurityException);
        }
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        outputStream.write(this.publicKey.getEncoded());
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != dG15File2.getClass()) {
            return false;
        }
        DG15File dG15File = dG15File2;
        DG15File dG15File2 = (DG15File)object;
        return dG15File.publicKey.equals(dG15File2.publicKey);
    }

    public int hashCode() {
        return this.publicKey.hashCode() * 5 + 61;
    }

    @Override
    public String toString() {
        return b.a("DG15File [").append(Util.getDetailedPublicKeyAlgorithm(this.publicKey)).append("]").toString();
    }
}

