/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.icao;

import b.b;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.BiometricDataBlockDecoder;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.BiometricDataBlockEncoder;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.CBEFFInfo;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.ComplexCBEFFInfo;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.ISO781611Decoder;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.ISO781611Encoder;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.SimpleCBEFFInfo;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.StandardBiometricHeader;
import com.fis.ekyc.nfc.build_in.eidparser.lds.CBEFFDataGroup;
import com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794.FaceInfo;
import d.a;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class DG2File
extends CBEFFDataGroup<FaceInfo> {
    private static final long serialVersionUID = 414300652684010416L;
    private static final ISO781611Decoder DECODER;
    private static final ISO781611Encoder<FaceInfo> ENCODER;

    public DG2File(List<FaceInfo> list) {
        super(117, list);
    }

    public DG2File(InputStream inputStream) {
        super(117, inputStream);
    }

    static {
        BiometricDataBlockEncoder<FaceInfo> biometricDataBlockEncoder;
        BiometricDataBlockDecoder<FaceInfo> biometricDataBlockDecoder;
        Object object = biometricDataBlockDecoder;
        biometricDataBlockDecoder = new BiometricDataBlockDecoder<FaceInfo>(){

            @Override
            public FaceInfo decode(InputStream inputStream, StandardBiometricHeader standardBiometricHeader, int n3, int n4) {
                return new FaceInfo(standardBiometricHeader, inputStream);
            }
        };
        DECODER = new ISO781611Decoder((BiometricDataBlockDecoder<?>)object);
        object = biometricDataBlockEncoder;
        biometricDataBlockEncoder = new BiometricDataBlockEncoder<FaceInfo>(){

            @Override
            public void encode(FaceInfo faceInfo, OutputStream outputStream) {
                faceInfo.writeObject(outputStream);
            }
        };
        ENCODER = new ISO781611Encoder(object);
    }

    @Override
    public void readContent(InputStream object) {
        for (CBEFFInfo cBEFFInfo : DECODER.decode((InputStream)object).getSubRecords()) {
            if (cBEFFInfo instanceof SimpleCBEFFInfo) {
                if ((cBEFFInfo = ((SimpleCBEFFInfo)cBEFFInfo).getBiometricDataBlock()) instanceof FaceInfo) {
                    this.add((FaceInfo)((Object)cBEFFInfo));
                    continue;
                }
                throw new IOException(b.a("Was expecting a FaceInfo, found ").append(cBEFFInfo.getClass().getSimpleName()).toString());
            }
            throw new IOException(b.a("Was expecting a SimpleCBEFFInfo, found ").append(cBEFFInfo.getClass().getSimpleName()).toString());
        }
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        ComplexCBEFFInfo complexCBEFFInfo;
        DG2File dG2File = complexCBEFFInfo2;
        ComplexCBEFFInfo complexCBEFFInfo2 = complexCBEFFInfo;
        complexCBEFFInfo = new ComplexCBEFFInfo();
        for (FaceInfo faceInfo : dG2File.getSubRecords()) {
            complexCBEFFInfo2.add(new SimpleCBEFFInfo<FaceInfo>(faceInfo));
        }
        ENCODER.encode(complexCBEFFInfo2, outputStream);
    }

    @Override
    public String toString() {
        return a.a(b.a("DG2File ["), super.toString(), "]");
    }

    public List<FaceInfo> getFaceInfos() {
        return this.getSubRecords();
    }

    public void addFaceInfo(FaceInfo faceInfo) {
        this.add(faceInfo);
    }

    public void removeFaceInfo(int n3) {
        this.remove(n3);
    }
}

