/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.icao;

import b.b;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.BiometricDataBlockDecoder;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.BiometricDataBlockEncoder;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.CBEFFInfo;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.ComplexCBEFFInfo;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.ISO781611Decoder;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.ISO781611Encoder;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.SimpleCBEFFInfo;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.StandardBiometricHeader;
import com.fis.ekyc.nfc.build_in.eidparser.lds.CBEFFDataGroup;
import com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794.FingerInfo;
import d.a;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class DG3File
extends CBEFFDataGroup<FingerInfo> {
    private static final long serialVersionUID = -1037522331623814528L;
    private static final ISO781611Decoder DECODER;
    private static final ISO781611Encoder<FingerInfo> ENCODER;
    private boolean shouldAddRandomDataIfEmpty;

    public DG3File(List<FingerInfo> list) {
        this(list, true);
    }

    public DG3File(List<FingerInfo> list, boolean bl) {
        super(99, list);
        this.shouldAddRandomDataIfEmpty = bl;
    }

    public DG3File(InputStream inputStream) {
        super(99, inputStream);
    }

    static {
        BiometricDataBlockEncoder<FingerInfo> biometricDataBlockEncoder;
        BiometricDataBlockDecoder<FingerInfo> biometricDataBlockDecoder;
        Object object = biometricDataBlockDecoder;
        biometricDataBlockDecoder = new BiometricDataBlockDecoder<FingerInfo>(){

            @Override
            public FingerInfo decode(InputStream inputStream, StandardBiometricHeader standardBiometricHeader, int n3, int n4) {
                return new FingerInfo(standardBiometricHeader, inputStream);
            }
        };
        DECODER = new ISO781611Decoder((BiometricDataBlockDecoder<?>)object);
        object = biometricDataBlockEncoder;
        biometricDataBlockEncoder = new BiometricDataBlockEncoder<FingerInfo>(){

            @Override
            public void encode(FingerInfo fingerInfo, OutputStream outputStream) {
                fingerInfo.writeObject(outputStream);
            }
        };
        ENCODER = new ISO781611Encoder(object);
    }

    @Override
    public void readContent(InputStream object) {
        for (CBEFFInfo cBEFFInfo : DECODER.decode((InputStream)object).getSubRecords()) {
            if (cBEFFInfo instanceof SimpleCBEFFInfo) {
                if ((cBEFFInfo = ((SimpleCBEFFInfo)cBEFFInfo).getBiometricDataBlock()) instanceof FingerInfo) {
                    this.add((FingerInfo)((Object)cBEFFInfo));
                    continue;
                }
                throw new IOException(b.a("Was expecting a FingerInfo, found ").append(cBEFFInfo.getClass().getSimpleName()).toString());
            }
            throw new IOException(b.a("Was expecting a SimpleCBEFFInfo, found ").append(cBEFFInfo.getClass().getSimpleName()).toString());
        }
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        ComplexCBEFFInfo complexCBEFFInfo;
        ComplexCBEFFInfo complexCBEFFInfo2 = complexCBEFFInfo;
        complexCBEFFInfo = new ComplexCBEFFInfo();
        for (FingerInfo fingerInfo : this.getSubRecords()) {
            complexCBEFFInfo2.add(new SimpleCBEFFInfo<FingerInfo>(fingerInfo));
        }
        ENCODER.encode(complexCBEFFInfo2, outputStream);
        if (this.shouldAddRandomDataIfEmpty) {
            this.writeOptionalRandomData(outputStream);
        }
    }

    @Override
    public String toString() {
        return a.a(b.a("DG3File ["), super.toString(), "]");
    }

    public List<FingerInfo> getFingerInfos() {
        return this.getSubRecords();
    }

    public void addFingerInfo(FingerInfo fingerInfo) {
        this.add(fingerInfo);
    }

    public void removeFingerInfo(int n3) {
        this.remove(n3);
    }

    @Override
    public int hashCode() {
        DG3File dG3File = this;
        int n3 = super.hashCode() * 31;
        int n4 = dG3File.shouldAddRandomDataIfEmpty ? 1231 : 1237;
        return n3 + n4;
    }

    @Override
    public boolean equals(Object object) {
        if (dG3File2 == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (dG3File2.getClass() != object.getClass()) {
            return false;
        }
        DG3File dG3File = dG3File2;
        DG3File dG3File2 = (DG3File)object;
        return dG3File.shouldAddRandomDataIfEmpty == dG3File2.shouldAddRandomDataIfEmpty;
    }
}

