/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.icao;

import b.b;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.BiometricDataBlockDecoder;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.BiometricDataBlockEncoder;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.CBEFFInfo;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.ComplexCBEFFInfo;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.ISO781611Decoder;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.ISO781611Encoder;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.SimpleCBEFFInfo;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.StandardBiometricHeader;
import com.fis.ekyc.nfc.build_in.eidparser.lds.CBEFFDataGroup;
import com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794.IrisInfo;
import d.a;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class DG4File
extends CBEFFDataGroup<IrisInfo> {
    private static final long serialVersionUID = -1290365855823447586L;
    private static final ISO781611Decoder DECODER;
    private static final ISO781611Encoder<IrisInfo> ENCODER;
    private boolean shouldAddRandomDataIfEmpty;

    public DG4File(List<IrisInfo> list) {
        this(list, true);
    }

    public DG4File(List<IrisInfo> list, boolean bl) {
        super(118, list);
        this.shouldAddRandomDataIfEmpty = bl;
    }

    public DG4File(InputStream inputStream) {
        super(118, inputStream);
    }

    static {
        BiometricDataBlockEncoder<IrisInfo> biometricDataBlockEncoder;
        BiometricDataBlockDecoder<IrisInfo> biometricDataBlockDecoder;
        Object object = biometricDataBlockDecoder;
        biometricDataBlockDecoder = new BiometricDataBlockDecoder<IrisInfo>(){

            @Override
            public IrisInfo decode(InputStream inputStream, StandardBiometricHeader standardBiometricHeader, int n3, int n4) {
                return new IrisInfo(standardBiometricHeader, inputStream);
            }
        };
        DECODER = new ISO781611Decoder((BiometricDataBlockDecoder<?>)object);
        object = biometricDataBlockEncoder;
        biometricDataBlockEncoder = new BiometricDataBlockEncoder<IrisInfo>(){

            @Override
            public void encode(IrisInfo irisInfo, OutputStream outputStream) {
                irisInfo.writeObject(outputStream);
            }
        };
        ENCODER = new ISO781611Encoder(object);
    }

    @Override
    public void readContent(InputStream object) {
        for (CBEFFInfo cBEFFInfo : DECODER.decode((InputStream)object).getSubRecords()) {
            if (cBEFFInfo instanceof SimpleCBEFFInfo) {
                if ((cBEFFInfo = ((SimpleCBEFFInfo)cBEFFInfo).getBiometricDataBlock()) instanceof IrisInfo) {
                    this.add((IrisInfo)((Object)cBEFFInfo));
                    continue;
                }
                throw new IOException(b.a("Was expecting an IrisInfo, found ").append(cBEFFInfo.getClass().getSimpleName()).toString());
            }
            throw new IOException(b.a("Was expecting a SimpleCBEFFInfo, found ").append(cBEFFInfo.getClass().getSimpleName()).toString());
        }
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        ComplexCBEFFInfo complexCBEFFInfo;
        ComplexCBEFFInfo complexCBEFFInfo2 = complexCBEFFInfo;
        complexCBEFFInfo = new ComplexCBEFFInfo();
        for (IrisInfo irisInfo : this.getSubRecords()) {
            complexCBEFFInfo2.add(new SimpleCBEFFInfo<IrisInfo>(irisInfo));
        }
        ENCODER.encode(complexCBEFFInfo2, outputStream);
        if (this.shouldAddRandomDataIfEmpty) {
            this.writeOptionalRandomData(outputStream);
        }
    }

    @Override
    public String toString() {
        return a.a(b.a("DG4File ["), super.toString(), "]");
    }

    public List<IrisInfo> getIrisInfos() {
        return this.getSubRecords();
    }

    public void addIrisInfo(IrisInfo irisInfo) {
        this.add(irisInfo);
    }

    public void removeIrisInfo(int n3) {
        this.remove(n3);
    }

    @Override
    public int hashCode() {
        DG4File dG4File = this;
        int n3 = super.hashCode() * 31;
        int n4 = dG4File.shouldAddRandomDataIfEmpty ? 1231 : 1237;
        return n3 + n4;
    }

    @Override
    public boolean equals(Object object) {
        if (dG4File2 == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (dG4File2.getClass() != object.getClass()) {
            return false;
        }
        DG4File dG4File = dG4File2;
        DG4File dG4File2 = (DG4File)object;
        return dG4File.shouldAddRandomDataIfEmpty == dG4File2.shouldAddRandomDataIfEmpty;
    }
}

